/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.config.client.util.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;

public class StockAgeRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static String INVAGEGROUP = "invagegroup";
    private static String INTERVALDAYS = "intervaldays";
    private static String ENDDATE = "enddate";
    private static String BILLTYPEENTRY = "billtypeentry";
    private static String BIZTYPEENTRY = "biztypeentry";
    private static String INVSCHEMEENTRY = "invschemeentry";
    private static String ENTRYONE = "entry1";
    private static String ENTRYTWO = "entry2";
    private static long CHANGEBILLId = 721675267608688640L;
    private static long BATCHCHANGEID = 688869647461968896L;
    private static long INVSTATUSCHANGEID = 688869765229636608L;
    private static long INDEXCHANGE = 726537661078051840L;
    private static long UNITCHANGE = 726537973494979584L;
    private static long OTHERCHANGE = 688869896687512576L;
    private static final LocaleString locale_qty = new LocaleString(StockAgeRptFormPlugin.getLocale_qty());
    private static final LocaleString locale_amount = new LocaleString(StockAgeRptFormPlugin.getLocale_amount());
    private static final LocaleString width = new LocaleString("100px");

    private static String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockAgeRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public static String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockAgeRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        this.addF7Listener(this, "calorg", "costaccount", "mulowner", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", BIZTYPEENTRY, INVSCHEMEENTRY, "multracknum");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Owner(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        } else if (BIZTYPEENTRY.equals(key)) {
            this.beforeF7BiztypeEntry(e, rowIndex);
        } else if (INVSCHEMEENTRY.equals(key)) {
            this.beforeF7InvschemeEntry(e, rowIndex);
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockagerpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8d27\u4e3b", (String)"StockGatherRptQueryPlugin_38", (String)"fi-cal-report", (Object[])new Object[0]));
    }

    private void beforeF7BiztypeEntry(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue(BILLTYPEENTRY, rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billentity.billform", "=", (Object)billTypeEntity.getString("billformid.number"));
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<Object> idList = new ArrayList<Object>(bizTypes.size());
        for (DynamicObject bizType : bizTypes) {
            idList.add(bizType.get("id"));
        }
        QFilter idf = new QFilter("id", "in", idList);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(idf.toArray()));
    }

    private void beforeF7InvschemeEntry(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue(BILLTYPEENTRY, rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        DynamicObject bizTypeEntity = (DynamicObject)this.getModel().getValue(BIZTYPEENTRY, rowIndex);
        if (null == bizTypeEntity) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billform", "=", (Object)billTypeEntity.getString("billformid.number"));
        qFilter.and("bitypeentry.biztype", "=", bizTypeEntity.getPkValue());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.toArray()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("calorg".equals(key)) {
            ReportUtil.calOrgChanged((IDataModel)this.getModel());
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if (INTERVALDAYS.equals(key)) {
            this.intervalDaysChanged(rowIndex, oldValue, newValue);
        } else if (BILLTYPEENTRY.equals(key)) {
            this.billTypeEntryChanged(rowIndex);
        } else if (BIZTYPEENTRY.equals(key)) {
            this.bizTypeEntryChanged(rowIndex);
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        }
    }

    private void bizTypeEntryChanged(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(INVSCHEMEENTRY, null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(INVSCHEMEENTRY, rowIndex);
    }

    private void billTypeEntryChanged(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(BIZTYPEENTRY, null, rowIndex);
        this.getModel().setValue(INVSCHEMEENTRY, null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(BIZTYPEENTRY, rowIndex);
        this.getView().updateView(INVSCHEMEENTRY, rowIndex);
    }

    private void intervalDaysChanged(int rowIndex, Object oldValue, Object newValue) {
        IReportView view = this.getView();
        if ((Integer)newValue == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u95f4\u9694\u5929\u6570\u3002", (String)"StockAgeRptFormPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(INTERVALDAYS, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(INTERVALDAYS, rowIndex);
            return;
        }
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
        if (entry2Entity == null || entry2Entity.isEmpty()) {
            return;
        }
        int size = entry2Entity.size();
        int sum = 0;
        for (int i = 0; i < size; ++i) {
            int day = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS);
            if (i == rowIndex) {
                sum += ((Integer)newValue).intValue();
                continue;
            }
            sum += day;
        }
        if (sum > 36500) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u95f4\u9694\u5929\u6570\u7d2f\u8ba1\u4e0d\u80fd\u5927\u4e8e36500\u5929\u3002", (String)"StockAgeRptFormPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(INTERVALDAYS, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(INTERVALDAYS, rowIndex);
            return;
        }
        String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"StockAgeRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
        String secondString = sbFirst.substring(1, 2);
        String fourString = sbFirst.substring(sbFirst.length() - 1);
        if (sbFirst.toLowerCase().contains("to")) {
            StringBuffer sb = new StringBuffer(sbFirst.trim());
            sb.replace(1, 4, " to X ");
            sbFirst = sb.toString();
            secondString = "to";
            fourString = sbFirst.substring(sbFirst.indexOf("X ") + 2);
        }
        String sbSuffix = null;
        if (rowIndex == size - 1) {
            if (size == 2 && ((DynamicObject)entry2Entity.get(1)).getInt(INTERVALDAYS) != 0) {
                view.invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("entry2");
                size = entry2Entity.size();
            } else if (size != 2) {
                view.invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("entry2");
                size = entry2Entity.size();
            }
        }
        for (int i = 0; i < size; ++i) {
            String lastValue;
            int invagegroup = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS);
            if (i == 0) {
                if (sbFirst == null) continue;
                sbFirst = sbFirst.replaceAll("X", String.valueOf(invagegroup - 1));
                this.getModel().setValue(INVAGEGROUP, (Object)sbFirst, i);
                sbSuffix = sbFirst;
                continue;
            }
            if (i != size - 1) {
                lastValue = null;
                if (sbSuffix != null) {
                    lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                }
                String tmp = null;
                if (lastValue != null) {
                    tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invagegroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invagegroup) + fourString;
                }
                this.getModel().setValue(INVAGEGROUP, tmp, i);
                sbSuffix = tmp;
                continue;
            }
            lastValue = null;
            if (sbSuffix != null) {
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
            }
            int day = (lastValue == null ? 0 : Integer.parseInt(lastValue)) + 1;
            String tmp = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_20", (String)"fi-cal-report", (Object[])new Object[0]), day);
            this.getModel().setValue(INVAGEGROUP, (Object)tmp, i);
            sbSuffix = tmp;
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockagerpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"calorg");
        this.initDate();
        this.initInvageGroup();
        this.setNoStatisticalFilter();
    }

    private void initDate() {
        this.getModel().setValue("enddate", (Object)DateUtils.getCurrentSystemDate());
    }

    private void initInvageGroup() {
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{INVAGEGROUP});
        this.getModel().setValue(INVAGEGROUP, (Object)ResManager.loadKDString((String)"0\u523030\u5929", (String)"StockAgeRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]), 0);
        this.getModel().setValue(INVAGEGROUP, (Object)ResManager.loadKDString((String)"31\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]), 1);
        this.getModel().setValue(INTERVALDAYS, (Object)31, 0);
        this.getModel().setValue(INTERVALDAYS, null, 1);
    }

    private void setNoStatisticalFilter() {
        IDataModel model = this.getModel();
        this.getModel().getEntryEntity("entry1").addNew();
        this.getModel().getEntryEntity("entry1").addNew();
        this.getModel().getEntryEntity("entry1").addNew();
        this.getModel().getEntryEntity("entry1").addNew();
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 0);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 1);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 2);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 3);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 4);
        model.setValue("biztypeentry", (Object)BATCHCHANGEID, 0);
        model.setValue("biztypeentry", (Object)INVSTATUSCHANGEID, 1);
        model.setValue("biztypeentry", (Object)INDEXCHANGE, 2);
        model.setValue("biztypeentry", (Object)UNITCHANGE, 3);
        model.setValue("biztypeentry", (Object)OTHERCHANGE, 4);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("entry2".equals(e.getEntryProp().getName())) {
            int rowIndex = this.getModel().getEntryRowCount("entry2") - 1;
            String prefixString = (String)this.getModel().getValue(INVAGEGROUP, rowIndex - 1);
            if (StringUtils.isEmpty((String)prefixString)) {
                return;
            }
            String lastValue = null;
            lastValue = prefixString.contains("days") ? prefixString.substring(prefixString.indexOf("to") + 1, prefixString.indexOf("days")).trim() : prefixString.substring(prefixString.indexOf(ResManager.loadKDString((String)"\u5230", (String)"StockAgeRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0])) + 1, prefixString.indexOf(ResManager.loadKDString((String)"\u5929", (String)"StockAgeRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0])));
            Integer prefixRowIntervaldaysValue = (Integer)this.getModel().getValue(INTERVALDAYS, rowIndex - 1);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{INVAGEGROUP});
            int day = Integer.parseInt(lastValue) + prefixRowIntervaldaysValue;
            String content = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_20", (String)"fi-cal-report", (Object[])new Object[0]), day);
            this.getModel().setValue(INVAGEGROUP, (Object)content, rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("entry1".equals(e.getEntryProp().getName())) {
            DynamicObjectCollection entry1Entity = this.getModel().getEntryEntity("entry1");
            int reffectedRows = e.getRowIndexs().length;
            if (entry1Entity.size() == reffectedRows) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u5982\u82e5\u8981\u5220\u9664\uff0c\u8bf7\u624b\u5de5\u5220\u9664\u8be5\u884c\u6570\u636e\u3002", (String)"StockAgeRptFormPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]));
            }
        }
        if ("entry2".equals(e.getEntryProp().getName())) {
            int[] rowIndexs = e.getRowIndexs();
            if (rowIndexs.length != 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e00\u6b21\u6027\u5220\u9664\u591a\u884c\uff0c\u8bf7\u4e00\u884c\u884c\u5220\u9664\u3002", (String)"StockAgeRptFormPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]));
            }
            if (rowIndexs[0] == 0 || rowIndexs[0] == 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u548c\u7b2c\u4e8c\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"StockAgeRptFormPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]));
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("entry2".equals(e.getEntryProp().getName())) {
            String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"StockAgeRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            String secondString = sbFirst.substring(1, 2);
            String fourString = sbFirst.substring(sbFirst.length() - 1);
            if (sbFirst.toLowerCase().contains("to")) {
                secondString = "to";
                StringBuffer sb = new StringBuffer(sbFirst.trim());
                sb.replace(1, 4, " to X ");
                sbFirst = sb.toString();
                fourString = sbFirst.substring(sbFirst.indexOf("X ") + 2);
            }
            String sbSuffix = null;
            DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
            if (entry2Entity == null || entry2Entity.isEmpty()) {
                return;
            }
            int size = entry2Entity.size();
            for (int i = 0; i < size; ++i) {
                String lastValue;
                int invagegroup = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS);
                if (i == 0) {
                    if (sbFirst != null) {
                        sbFirst = sbFirst.replaceAll("X", String.valueOf(invagegroup - 1));
                    }
                    this.getModel().setValue(INVAGEGROUP, (Object)sbFirst, i);
                    sbSuffix = sbFirst;
                    continue;
                }
                if (i == size - 1) {
                    lastValue = null;
                    if (sbSuffix != null) {
                        lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                        int day = Integer.parseInt(lastValue) + 1;
                        String content = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_20", (String)"fi-cal-report", (Object[])new Object[0]), day);
                        this.getModel().setValue(INVAGEGROUP, (Object)content, i);
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue(INTERVALDAYS, null, i);
                    this.getModel().endInit();
                    this.getView().updateView(INTERVALDAYS, i);
                    continue;
                }
                lastValue = null;
                if (sbSuffix == null) continue;
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                String tmp = null;
                tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invagegroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invagegroup) + fourString;
                this.getModel().setValue(INVAGEGROUP, (Object)tmp, i);
                sbSuffix = tmp;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        return this.verifyBeforeQuery(queryParam);
    }

    private boolean verifyBeforeQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date enddate = (Date)filter.getValue(ENDDATE);
        if (enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u622a\u6b62\u65e5\u671f\u3002", (String)"StockAgeRptFormPlugin_15", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (calorg == null || costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        QFilter q = new QFilter("entry.costaccount.id", "=", (Object)filter.getLong("costaccount"));
        DynamicObject systemctlObj = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.startperiod.begindate as begindate", (QFilter[])new QFilter[]{q});
        if (systemctlObj == null || systemctlObj.getDate("begindate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockAgeRptFormPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Date beginDate = systemctlObj.getDate("begindate");
        if (beginDate.compareTo(enddate) > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String content = String.format(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u9700\u8981\u5927\u4e8e\u7b49\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f%1$s\u3002", (String)"StockAgeRptFormPlugin_21", (String)"fi-cal-report", (Object[])new Object[0]), sdf.format(beginDate));
            this.getView().showTipNotification(content);
            return false;
        }
        return true;
    }

    private void addNoStatisticalBillParams(ReportQueryParam queryParam) {
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry1");
        if (entry2Entity != null && !entry2Entity.isEmpty()) {
            int size = entry2Entity.size();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                DynamicObject billtypeentry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("billtypeentry");
                DynamicObject biztypeentry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("biztypeentry");
                DynamicObject invschemeentry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("invschemeentry");
                StringBuilder billInvScheme = new StringBuilder();
                if (billtypeentry != null) {
                    Long billtypeId = (Long)billtypeentry.getPkValue();
                    billInvScheme.append(billtypeId);
                    if (biztypeentry != null) {
                        Long biztypeentryId = (Long)biztypeentry.getPkValue();
                        billInvScheme.append(":");
                        billInvScheme.append(biztypeentryId);
                    }
                    if (invschemeentry != null) {
                        Long invschemeId = (Long)invschemeentry.getPkValue();
                        billInvScheme.append(":");
                        billInvScheme.append(invschemeId);
                    }
                }
                sb.append((CharSequence)billInvScheme);
                sb.append(",");
            }
            String string = sb.toString();
            if (string.isEmpty()) {
                return;
            }
            queryParam.getFilter().addFilterItem("nostatistical", (Object)string.substring(0, string.lastIndexOf(44)));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.addNoStatisticalBillParams(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        this.setNeedHiddenColumn(columns, this.dynamicSetCloumns(queryParam, columns));
    }

    private void setNeedHiddenColumn(List<AbstractReportColumn> columns, Set<String> hiddenColumn) {
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn column;
            if (!(abstractReportColumn instanceof ReportColumn) || !hiddenColumn.contains((column = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            column.setHide(true);
        }
    }

    private Set<String> dynamicSetCloumns(ReportQueryParam queryParam, List<AbstractReportColumn> columns) {
        StringBuffer sbInvageGroup = null;
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
        if (entry2Entity != null && !entry2Entity.isEmpty()) {
            int size = entry2Entity.size();
            if (((DynamicObject)entry2Entity.get(0)).getInt(INTERVALDAYS) != 0) {
                StringBuffer sbIntervaldays = new StringBuffer();
                sbInvageGroup = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    String intervalStr = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS) + ",";
                    sbIntervaldays.append(intervalStr);
                    String ageGroup = ((DynamicObject)entry2Entity.get(i)).getString(INVAGEGROUP) + ",";
                    sbInvageGroup.append(ageGroup);
                }
                sbIntervaldays = sbIntervaldays.delete(sbIntervaldays.lastIndexOf(","), sbIntervaldays.length());
                sbInvageGroup = sbInvageGroup.delete(sbInvageGroup.lastIndexOf(","), sbInvageGroup.length());
                queryParam.getFilter().addFilterItem(INTERVALDAYS, (Object)sbIntervaldays.toString());
            }
        }
        HashSet<String> hiddenColumn = new HashSet<String>();
        Map<String, String> rangeColumns = this.getFieldKey(sbInvageGroup, "range");
        this.addColums(columns, rangeColumns);
        if (rangeColumns != null) {
            hiddenColumn.addAll(rangeColumns.keySet());
        }
        return hiddenColumn;
    }

    private List<AbstractReportColumn> addColums(List<AbstractReportColumn> columns, Map<String, String> fieldKeyAndNameMap) {
        if (fieldKeyAndNameMap != null) {
            String prefix = "range";
            for (int i = 0; i < fieldKeyAndNameMap.size(); ++i) {
                String entryKey = prefix + i;
                String entryVal = fieldKeyAndNameMap.get(entryKey);
                ReportColumnGroup groupCol = new ReportColumnGroup();
                groupCol.setCaption(new LocaleString(entryVal));
                groupCol.setFieldKey(entryKey);
                columns.add((AbstractReportColumn)groupCol);
                ReportColumn qty = new ReportColumn();
                qty.setCaption(locale_qty);
                qty.setWidth(width);
                qty.setFieldKey(entryKey + "qty");
                qty.setFieldType("qty");
                qty.setZeroShow(true);
                qty.setMeasureUnitField("baseunit");
                ReportColumn actualAmount = new ReportColumn();
                actualAmount.setCaption(locale_amount);
                actualAmount.setWidth(width);
                actualAmount.setFieldKey(entryKey + "amount");
                actualAmount.setFieldType("amount");
                actualAmount.setZeroShow(true);
                actualAmount.setCurrencyField("currencyid");
                groupCol.getChildren().add(qty);
                groupCol.getChildren().add(actualAmount);
            }
        }
        return columns;
    }

    private Map<String, String> getFieldKey(StringBuffer sbInvageGroup, String setFieldKeyPrefix) {
        if (sbInvageGroup == null) {
            return null;
        }
        String[] captions = sbInvageGroup.toString().split(",");
        if (captions.length == 0) {
            return null;
        }
        int length = captions.length;
        TreeMap<String, String> fieldKeyAndNameMap = new TreeMap<String, String>();
        for (int i = 0; i < length; ++i) {
            fieldKeyAndNameMap.put(setFieldKeyPrefix + i, captions[i]);
        }
        return fieldKeyAndNameMap;
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryOne = scheme.getDynamicObjectCollection(ENTRYONE);
        DynamicObjectCollection entryTwo = scheme.getDynamicObjectCollection(ENTRYTWO);
        if (entryOne == null || entryOne.size() == 0 || entryTwo == null || entryTwo.size() == 0) {
            return;
        }
        dataModel.deleteEntryData(ENTRYONE);
        dataModel.deleteEntryData(ENTRYTWO);
        dataModel.batchCreateNewEntryRow(ENTRYONE, entryOne.size());
        dataModel.batchCreateNewEntryRow(ENTRYTWO, entryTwo.size());
        this.setF7Filter(dataModel, entryOne, BILLTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, BIZTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, INVSCHEMEENTRY);
        this.setBasicFilter(dataModel, entryTwo, INVAGEGROUP);
        this.setBasicFilter(dataModel, entryTwo, INTERVALDAYS);
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryOne = dataModel.getEntryEntity(ENTRYONE);
        DynamicObjectCollection entryTwo = dataModel.getEntryEntity(ENTRYTWO);
        this.setF7Filter(dataModel, entryOne, BILLTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, BIZTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, INVSCHEMEENTRY);
        this.setBasicFilter(dataModel, entryTwo, INVAGEGROUP);
        this.setBasicFilter(dataModel, entryTwo, INTERVALDAYS);
    }

    private void setF7Filter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            DynamicObject billTypeObj = entryObj.getDynamicObject(entryField);
            if (billTypeObj == null) continue;
            Long billType = billTypeObj.getLong("id");
            dataModel.setValue(entryField, (Object)billType, i);
        }
    }

    private void setBasicFilter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            Object entryFieldObj = entryObj.get(entryField);
            if (entryFieldObj == null) continue;
            dataModel.setValue(entryField, entryFieldObj, i);
        }
    }
}

