/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;

public class StockCostGatherRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static int EXCEL_BASECOLUMN_NUM = 6;
    private static int EXCEL_BASEITEM_NUM = 4;
    private static String COSTADJUST_REC = "costadjustbillrec";
    private static String COSTADJUST_SED = "costadjustbillsed";

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Owner(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("materialto".equals(key)) {
            this.beforeF7SelectToValidate(e);
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.beforeMaterialgroupstandard((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.beforeF7SelectMaterialGroup((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("mulstorageorg");
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg);
        if (set.size() > 0) {
            q = new QFilter("id", "in", (Object)set);
        }
        DynamicObjectCollection mulwarehsgroup = (DynamicObjectCollection)this.getModel().getValue("mulwarehsgroup");
        HashSet<Long> warehsgroupIds = new HashSet<Long>(8);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            warehsgroupIds.add(warehsgroup.getDynamicObject("fbasedataid").getLong("id"));
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8d27\u4e3b", (String)"StockGatherRptQueryPlugin_38", (String)"fi-cal-report", (Object[])new Object[0]));
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockcostgatherrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "calorg", "costaccount", "mulcalrange", "mulowner", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "materialgroupstandard", "mulmaterialgroup", "multracknum");
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("material".equals(key)) {
                    StockCostGatherRptFormPlugin.this.hyperLinkMaterialNameClick(evt);
                }
            }
        });
    }

    private void hyperLinkMaterialNameClick(HyperLinkClickEvent evt) {
        DynamicObjectCollection coll;
        DynamicObject info;
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = this.getView().getQueryParam().getFilter().clone();
        DynamicObject row = evt.getRowData();
        String groupType = filter.getString("mulgrouptype");
        if (groupType == null) {
            groupType = "A";
        }
        if (this.hasGroup(groupType, "B")) {
            // empty if block
        }
        if (this.hasGroup(groupType, "D")) {
            info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
            info.set("id", (Object)row.getString("storageorg.id"));
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            filter.getFilterItem("mulstorageorg").setValue((Object)coll);
        }
        if (this.hasGroup(groupType, "J")) {
            String warehsgroupid = row.getString("warehsgroup.id");
            if ("0".equals(warehsgroupid)) {
                filter.addFilterItem("onlyqueryemptygroup", (Object)true);
            } else {
                DynamicObject info2 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_warehousegroup"));
                info2.set("id", (Object)warehsgroupid);
                DynamicObjectCollection coll2 = new DynamicObjectCollection();
                coll2.add((Object)info2);
                filter.getFilterItem("mulwarehsgroup").setValue((Object)coll2);
            }
        }
        if (this.hasGroup(groupType, "E")) {
            info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_warehouse"));
            info.set("id", (Object)row.getString("warehs.id"));
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            filter.getFilterItem("mulwarehouse").setValue((Object)coll);
        }
        if (this.hasGroup(groupType, "F") && row.getString("location.id") != null && StringUtils.isNotEmpty((CharSequence)row.getString("location.id").trim())) {
            info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_location"));
            info.set("id", (Object)row.getString("location.id"));
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            filter.getFilterItem("mullocation").setValue((Object)coll);
        }
        if (this.hasGroup(groupType, "G") && row.getString("lot") != null && StringUtils.isNotEmpty((CharSequence)row.getString("lot").trim())) {
            filter.getFilterItem("lotnumber").setValue((Object)row.getString("lot"));
        }
        if (this.hasGroup(groupType, "I") && row.getString("project.id") != null && StringUtils.isNotEmpty((CharSequence)row.getString("project.id").trim())) {
            info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_project"));
            info.set("id", (Object)row.getString("project.id"));
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            filter.getFilterItem("mulproject").setValue((Object)coll);
        }
        if (this.hasGroup(groupType, "M") && row.getString("tracknumber") != null && StringUtils.isNotEmpty((CharSequence)row.getString("tracknumber").trim())) {
            filter.getFilterItem("multracknum").setValue((Object)row.getDynamicObject("tracknumber"));
        }
        info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_material"));
        info.set("id", row.getDynamicObject("material").get("id"));
        coll = new DynamicObjectCollection();
        coll.add((Object)info);
        filter.getFilterItem("mulmaterial").setValue((Object)coll);
        filter.getFilterItem("materialto").setValue((Object)info);
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        Date finalendDate = new Date(endDate.getTime() - 999L);
        filter.getFilterItem("startdate").setValue((Object)startDate);
        filter.getFilterItem("enddate").setValue((Object)finalendDate);
        filter.getFilterItem("noshowzeroinout").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("onlyshowsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("topsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItems().remove(filter.getFilterItem("mulgrouptype"));
        filter.getFilterItems().remove(filter.getFilterItem("groupbyperiod"));
        queryParam.setFilter(filter);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_stockcostdetailrpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("exportexcel".equals(evt.getItemKey())) {
            this.verifyColumnNum(evt);
        }
    }

    private void verifyColumnNum(BeforeItemClickEvent evt) {
        int groupTypeSize;
        String[] specialBillCol;
        int specialBillSize;
        boolean displayqty2nd = (Boolean)this.getModel().getValue("displayqty2nd");
        DynamicObjectCollection receivers = (DynamicObjectCollection)this.getModel().getValue("showreceiver");
        int columnNum = 0;
        String specialBillStr = (String)this.getModel().getValue("showspecialbill");
        if (specialBillStr == null) {
            specialBillStr = ",";
        }
        if ((specialBillSize = (specialBillCol = specialBillStr.split(",")).length) > 0) {
            --specialBillSize;
            if (specialBillStr.contains(COSTADJUST_REC)) {
                ++columnNum;
                --specialBillSize;
            }
            if (specialBillStr.contains(COSTADJUST_SED)) {
                ++columnNum;
                --specialBillSize;
            }
            specialBillSize = specialBillSize < 0 ? 0 : specialBillSize;
        }
        int receiverSize = receivers.size();
        for (DynamicObject receiver : receivers) {
            if (!"2".equals(receiver.getDynamicObject("fbasedataid").getString("transceiver"))) continue;
            ++receiverSize;
        }
        String groupType = (String)this.getModel().getValue("mulgrouptype");
        if (StringUtils.isEmpty((CharSequence)groupType)) {
            groupTypeSize = 1;
        } else {
            String[] groupTypeCol = groupType.split(",");
            groupTypeSize = groupTypeCol.length - 1;
            if (groupType.contains("A")) {
                --groupTypeSize;
            }
        }
        columnNum = displayqty2nd ? columnNum + EXCEL_BASECOLUMN_NUM + (EXCEL_BASEITEM_NUM + specialBillSize + receiverSize) * 5 + groupTypeSize : columnNum + EXCEL_BASECOLUMN_NUM + (EXCEL_BASEITEM_NUM + specialBillSize + receiverSize) * 3 + groupTypeSize;
        if (columnNum > 256) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8981\u5bfc\u51fa\u7684\u5217\u6570\u8d85\u8fc7256\u5217\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff0c\u8bf7\u51cf\u5c11\u663e\u793a\u6536\u53d1\u7c7b\u578b\u7684\u52fe\u9009\u9879\u6216\u91cd\u65b0\u8bbe\u7f6e\u5176\u4ed6\u67e5\u8be2\u6761\u4ef6\u3002", (String)"StockCostGatherRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("calorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void calOrgChanged() {
        this.getModel().setValue("mulstorageorg", null);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getModel().setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
            }
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.getModel().setValue("mulowner", null);
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period != null) {
            this.getModel().setValue("startdate", (Object)period.getDate("begindate"));
            this.getModel().setValue("enddate", (Object)period.getDate("enddate"));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        if (calorg == null || costAccount == null || startdate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject periodDyc = this.getYearPeriodByDate(costAccount.getPkValue(), startdate);
        if (periodDyc == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"StockGatherDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockcostgatherrpt", (String)"47150e89000000ac", (Long)calorg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (enddate.before(startdate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"StockGatherRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        LocalDateTime startDateTime = startdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime endDateTime = enddate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (startDateTime.plusYears(1L).isBefore(endDateTime)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0e\u5f00\u59cb\u65e5\u671f\u95f4\u9694\u8d85\u8fc7\u4e00\u5e74\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u67e5\u8be2\u3002", (String)"StockGatherRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int periodDycNum = periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
        int periodNum = StockCostGatherRptFormPlugin.getBeginPeriod(costAccount);
        if (periodNum > periodDycNum) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u5fc5\u987b\u5728\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u4e4b\u540e\u3002", (String)"StockCostDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        this.getModel().setValue("startdate", (Object)DateUtils.getDayStartTime((Date)startdate));
        this.getModel().setValue("enddate", (Object)DateUtils.getDayEndTime((Date)enddate));
        return super.verifyQuery(queryParam);
    }

    public DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockcostgatherrpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
        }
    }

    private void beforeF7SelectToValidate(BeforeF7SelectEvent e) {
        if (((DynamicObjectCollection)this.getModel().getValue("mulmaterial")).size() != 0) {
            Object selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)this.getModel().getValue("mulmaterial")).get(0)).getDynamicObject(1).get("number");
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
        }
        ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
    }

    private DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    private static int getBeginPeriod(DynamicObject costAccount) {
        if (costAccount == null) {
            return 0;
        }
        DynamicObject startPeriod = PeriodHelper.getSysCtrlEntity((Long)costAccount.getLong("id"));
        int peridNumber = 0;
        if (startPeriod != null) {
            Long startPeriodId = startPeriod.getLong("startperiod.id");
            DynamicObject peirod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)startPeriodId).toArray());
            peridNumber = peirod.getInt("periodyear") * 100 + peirod.getInt("periodnumber");
        }
        return peridNumber;
    }
}

