/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.PrintHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockDetailRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private String queryType = null;
    private boolean isQueryByFilter = true;
    private static final Log logger = LogFactory.getLog(StockDetailRptFormPlugin.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private MaterialCategoryHelper materialCategoryHelper = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        this.addF7Listener(this, "calorg", "costaccount", "mulcalrange", "mulowner", "mulstorageorg", "mulwarehouse", "mullocation", "startperiod", "endperiod", "mulmaterial", "mulowner", "materialgroupstandard", "mulmaterialgroup", "materialto", "multracknum");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    StockDetailRptFormPlugin.this.hyperLinkBillNoClick(evt);
                }
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("calorg".equals(key)) {
            ReportUtil.calOrgChanged((IDataModel)this.getModel());
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulcalrange".equals(key)) {
            this.beforeF7Select4MulCalrange(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            ReportUtil.beforeF7Select4Mulcalorgowner((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("ownerto".equals(key)) {
            ReportUtil.beforeF7Select4ownerto((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.beforeMaterialgroupstandard((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.beforeF7SelectMaterialGroup((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String key = evt.getItemKey();
        this.isQueryByFilter = true;
        if ("bar_first".equals(key)) {
            this.queryType = "first";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_previous".equals(key)) {
            this.queryType = "previous";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_next".equals(key)) {
            this.queryType = "next";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_last".equals(key)) {
            this.queryType = "last";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_viewbill".equals(key)) {
            this.viewBill();
        } else if ("refresh".equals(key)) {
            this.isQueryByFilter = false;
        }
    }

    private void hideMaterialInfoAndPrintButton() {
        boolean showPartition = (Boolean)this.getModel().getValue("showpartition");
        if (showPartition) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap9"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"printview"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_previous"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_next"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_first"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_last"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"printview"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_previous"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_next"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_first"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_last"});
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        Boolean showPartition = this.getModel().getDataEntity().getBoolean("showpartition");
        ArrayList<String> complexColumns = new ArrayList<String>(16);
        complexColumns.add("head_materialnumber");
        complexColumns.add("head_materialname");
        complexColumns.add("head_baseunit");
        complexColumns.add("head_model");
        complexColumns.add("head_group");
        complexColumns.add("materialcategory");
        complexColumns.add("materialcategoryname");
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)obj;
            String key = reportColumn.getFieldKey();
            if (showPartition.booleanValue() || !complexColumns.contains(key)) continue;
            reportColumn.setHide(false);
        }
        complexColumns.clear();
        this.hideMaterialInfoAndPrintButton();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("printview".equals(key)) {
            boolean showPartition = (Boolean)this.getModel().getValue("showpartition");
            if (!showPartition) {
                this.getView().invokeOperation("printpreview");
            } else {
                this.printOperation("single");
            }
        } else if ("printbar".equals(key)) {
            this.printOperation("all");
        }
    }

    private void printOperation(String allFlag) {
        try {
            String templeteId;
            long jobStartTime = System.currentTimeMillis();
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
            HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)this.getView().getEntityId(), (String)"4730fc9e000000ac");
            boolean hasAll = rs.hasAllOrgPerm();
            List hasPermOrgs = rs.getHasPermOrgs();
            Object calOrg = this.getModel().getValue("calorg") == null ? null : this.getModel().getValue("calorg");
            Long id = calOrg == null ? 0L : ((DynamicObject)calOrg).getLong("masterid");
            if (!hasAll && hasPermOrgs != null && !hasPermOrgs.contains(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u6253\u5370\u6743\u9650\u3002", (String)"StockDetailRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportView rptFormView = (ReportView)this.getExportAllView(allFlag);
            if (rptFormView == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
            ThreadCache.put((Object)"stockDetailRptPrinter", (Object)listModel);
            int rowCount = listModel.getRowCount();
            if (rowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String formId = "cal_stockdetailrpt";
            Object defaultTemplateId = PrintHelper.getDefaultTemplateId((String)formId);
            if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"StockDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String printName = formId + "_printsetting";
            String curPrintPattern = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)printName);
            Map printSetting = null;
            if (!kd.bos.util.StringUtils.isEmpty((String)curPrintPattern)) {
                printSetting = (Map)SerializationUtils.fromJsonString((String)curPrintPattern, Map.class);
            }
            if (defaultTemplateId == null && (printSetting == null || printSetting.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String string = printSetting == null || kd.bos.util.StringUtils.isEmpty((String)((String)printSetting.get("templateid"))) ? (defaultTemplateId == null ? null : defaultTemplateId.toString()) : (templeteId = (String)printSetting.get("templateid"));
            if (kd.bos.util.StringUtils.isEmpty((String)templeteId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            PrintMetadata pMeta = (PrintMetadata)MetadataDao.readMeta((String)templeteId, (MetaCategory)MetaCategory.Form);
            if (pMeta == null) {
                PrintWork work = new PrintWork();
                String pageId = listModel.getPageId();
                work.setPageId(pageId);
                work.setPrintLang(RequestContext.get().getLang().getLangTag());
                PrintTask task = new PrintTask();
                task.setTplId(templeteId);
                task.setPageId(pageId);
                task.setFormId("cal_stockdetailrpt");
                task.setPrintType("report");
                ArrayList<PrintTask> tasks = new ArrayList<PrintTask>(16);
                tasks.add(task);
                work.setTaskList(tasks);
                work.setPageNumType(PrintHelper.getPageNumType((String)formId));
                PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
                String url = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
                url = String.format(url, prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
                this.getView().openUrl(url);
            } else {
                long cur = System.currentTimeMillis();
                long printJob = cur - jobStartTime;
                logger.info("------------------printJob----------------" + printJob + "-------------------------------------");
                String pageId = rptFormView.getPageId();
                ReportDataProvider provider = PrintHelper.createReportDataProvider((String)pageId, (String)formId, (PrintMetadata)pMeta);
                provider.setQueryParam(rptFormView.getQueryParam());
                String pdfUrl = PrintServiceHelper.createPdfUrl((String)pageId, (String)"cal_stockdetailrpt", (String)pMeta.getKey(), null, (IPrintDataProvider)provider);
                long printJob1 = System.currentTimeMillis() - cur;
                logger.info("------------------printJob1----------------" + printJob1 + "-------------------------------------");
                if (!StringUtils.isBlank((CharSequence)pdfUrl)) {
                    IFormView mainView = this.getView().getMainView();
                    if (mainView == null) {
                        this.getView().openUrl(pdfUrl);
                    } else {
                        FormShowParameter parm = PrintHelper.buildParameter((String)pdfUrl);
                        this.getView().getParentView().showForm(parm);
                        this.getView().sendFormAction(this.getView().getParentView());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("StockDetailRptFormPlugin printOperation", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u53ef\u80fd\u8d85\u65f6\u4e86\uff0c\u8bf7\u8bd5\u7740\u70b9\u4e0b\u5237\u65b0\u6309\u94ae\u3002", (String)"StockDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
    }

    public IFormView getExportAllView(String flag) {
        ReportQueryParam queryParam = this.getQueryParam();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        String materialIds = "all".equals(flag) ? this.getPageCache().get("materialIds") : this.getPageCache().get("currentMateiralId");
        if (materialIds == null) {
            return null;
        }
        ThreadCache.put((Object)"self_print_value", (Object)materialIds);
        this.asyncQuery(queryParam, reportList, null);
        return reportList.getView();
    }

    private void asyncQuery(ReportQueryParam queryParam, ReportList reportList, String materialIds) {
        IReportCache var13 = ReportCacheManager.getInstance().getCache();
        var13.setReportQueryParam(this.getView().getPageId(), queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)reportList.getReportModel();
        reportModel.setPageId(this.getView().getPageId());
        reportList.setAsynQuery(true);
        reportList.submitTask(queryParam, (Object)materialIds);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calorg == null || costAccount == null || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockdetailrpt", (String)"47150e89000000ac", (Long)calorg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockDetailRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String firstQuery = this.getPageCache().get("firstQuery");
        if (kd.bos.util.StringUtils.isEmpty((String)firstQuery) || this.isQueryByFilter) {
            StringBuilder materialIdStr = new StringBuilder();
            DynamicObjectCollection balCol = this.getBalMaterialDycs(queryParam);
            if (balCol.size() == 0) {
                String currentMateiralId = String.valueOf(-1L);
                this.setMaterialFilter(queryParam, currentMateiralId, "currentMateiralId");
                this.getPageCache().put("currentMateiralId", currentMateiralId);
                this.getPageCache().put("firstQuery", "false");
                this.getPageCache().put("index", "-1");
                return;
            }
            HashSet<String> idSet = new HashSet<String>(balCol.size());
            for (DynamicObject balInfo : balCol) {
                String id = String.valueOf(balInfo.getLong("material.id"));
                if (!idSet.add(id)) continue;
                materialIdStr.append(id).append(',');
            }
            String currentMateiralId = String.valueOf(((DynamicObject)balCol.get(0)).getLong("material.id"));
            this.getPageCache().put("materialIds", materialIdStr.substring(0, materialIdStr.length() - 1));
            this.getPageCache().put("firstQuery", "false");
            this.getPageCache().put("index", "0");
            this.getPageCache().put("currentMateiralId", currentMateiralId);
            String materialIds = this.getPageCache().get("materialIds");
            this.setMaterialFilter(queryParam, currentMateiralId, "currentMateiralId");
            this.setMaterialFilter(queryParam, materialIds, "materialIds");
        } else if (this.queryType == null) {
            String currentMateiralId = this.getPageCache().get("currentMateiralId");
            String materialIds = this.getPageCache().get("materialIds");
            this.setMaterialFilter(queryParam, currentMateiralId, "currentMateiralId");
            this.setMaterialFilter(queryParam, materialIds, "materialIds");
        } else {
            String index = this.getPageCache().get("index");
            String materialIds = this.getPageCache().get("materialIds");
            String[] materialIdArray = materialIds.split(",");
            int indexInt = 0;
            if ("first".equals(this.queryType)) {
                indexInt = 0;
            } else if ("previous".equals(this.queryType)) {
                indexInt = Integer.parseInt(index) - 1;
            } else if ("next".equals(this.queryType)) {
                indexInt = Integer.parseInt(index) + 1;
            } else if ("last".equals(this.queryType)) {
                indexInt = materialIdArray.length - 1;
            }
            String currentMateiralId = materialIdArray[indexInt];
            this.getPageCache().put("index", String.valueOf(indexInt));
            this.getPageCache().put("currentMateiralId", currentMateiralId);
            this.setMaterialFilter(queryParam, currentMateiralId, "currentMateiralId");
            this.setMaterialFilter(queryParam, materialIds, "materialIds");
        }
    }

    private void setMaterialFilter(ReportQueryParam queryParam, String filterValue, String filterName) {
        if (queryParam.getFilter().getFilterItem(filterName) != null) {
            if (!"materialIds".equals(filterName)) {
                queryParam.getFilter().getFilterItem(filterName).setValue((Object)filterValue);
            }
        } else {
            queryParam.getFilter().addFilterItem(filterName, (Object)filterValue);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String index = this.getPageCache().get("index");
        int indexInt = Integer.parseInt(index);
        if (indexInt == -1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_first", "bar_previous", "bar_last", "bar_next"});
        } else {
            String materialIds = this.getPageCache().get("materialIds");
            String[] materialIdArray = materialIds.split(",");
            if (indexInt == 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_first", "bar_previous"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_first", "bar_previous"});
            }
            if (indexInt == materialIdArray.length - 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_last", "bar_next"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_last", "bar_next"});
            }
        }
        this.getModel().setValue("head_costaccount", this.getModel().getValue("costaccount"));
        if (String.valueOf(-1L).equals(this.getPageCache().get("currentMateiralId"))) {
            this.getModel().setValue("head_material", null);
            this.getModel().setValue("head_materialcategory", null);
        } else {
            this.getModel().setValue("head_material", (Object)this.getPageCache().get("currentMateiralId"));
            Long orgid = ((DynamicObject)this.getModel().getValue("calorg")).getLong("id");
            Long materialid = Long.valueOf(this.getPageCache().get("currentMateiralId"));
            this.getModel().setValue("head_materialcategory", (Object)MaterialCategoryHelper.getMaterialCategory((Long)orgid, (Long)materialid));
        }
        this.getModel().setValue("head_period", (Object)(((DynamicObject)this.getModel().getValue("startperiod")).getString("name") + "-" + ((DynamicObject)this.getModel().getValue("endperiod")).getString("name")));
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4MulCalrange(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("costaccount", "=", costAccount.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockdetailrpt", (String)"47150e89000000ac");
        if (list != null) {
            logger.info("List \u4e0d\u4e3anull,\u5b58\u8d27\u6536\u53d1\u5b58\u660e\u7ec6\u8868-\u6838\u7b97\u7ec4\u7ec7List: " + list + " size: " + list.size());
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else {
            logger.info("List\u4e3anull,\u5b58\u8d27\u6536\u53d1\u5b58\u660e\u7ec6\u8868-\u6838\u7b97\u7ec4\u7ec7");
        }
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private QFilter getCostRecordAndAdjustFilter(ReportQueryParam queryParam, String tableName) {
        HashSet<Object> set;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        DynamicObjectCollection filter_owner = filterInfo.getDynamicObjectCollection("mulowner");
        DynamicObjectCollection filter_mulcalrange = filterInfo.getDynamicObjectCollection("mulcalrange");
        DynamicObjectCollection filter_storageOrg = filterInfo.getDynamicObjectCollection("mulstorageorg");
        DynamicObjectCollection filter_warehouse = filterInfo.getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection filter_location = filterInfo.getDynamicObjectCollection("mullocation");
        DynamicObjectCollection filter_materialFrom = filterInfo.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filterInfo.getDynamicObject("materialto");
        DynamicObjectCollection filter_mulMaterialCategory = filterInfo.getDynamicObjectCollection("mulmatcategory");
        String filter_mulaccounttype = filterInfo.getString("mulaccounttype");
        String[] filter_lot = null;
        String lotnumber = filterInfo.getString("lotnumber");
        Set warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)filterInfo);
        if (kd.bos.util.StringUtils.isNotEmpty((String)lotnumber)) {
            filter_lot = lotnumber.split(";");
        }
        DynamicObjectCollection filter_project = queryParam.getFilter().getDynamicObjectCollection("mulproject");
        DynamicObjectCollection filter_invType = queryParam.getFilter().getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection filter_invStatus = queryParam.getFilter().getDynamicObjectCollection("mulinvstatus");
        String prefix = "";
        if ("cal_costrecord".equals(tableName)) {
            prefix = "entry.";
        } else if ("cal_costadjustbill".equals(tableName)) {
            prefix = "entryentity.";
        }
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        if (filter_owner != null) {
            set = new HashSet<Object>(filter_owner.size());
            for (DynamicObject info : filter_owner) {
                set.add(info.getPkValue());
            }
            q.and(prefix.concat("owner"), "in", set);
        }
        if (filter_storageOrg != null) {
            set = new HashSet(filter_storageOrg.size());
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getPkValue());
            }
            String sp_prefix = "";
            if ("cal_costadjustbill".equals(tableName)) {
                sp_prefix = "entryentity.";
            }
            q.and(sp_prefix.concat("storageorgunit"), "in", set);
        }
        if (!warehsGroupSet.isEmpty()) {
            q.and(prefix.concat("warehouse.group"), "in", (Object)warehsGroupSet);
        }
        if (filter_warehouse != null) {
            set = new HashSet(filter_warehouse.size());
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and(prefix.concat("warehouse"), "in", set);
        }
        if (filter_location != null) {
            set = new HashSet(filter_location.size());
            for (DynamicObject info : filter_location) {
                set.add(info.getPkValue());
            }
            q.and(prefix.concat("location"), "in", set);
        }
        if (filter_lot != null) {
            q.and(prefix.concat("lot"), "in", (Object)filter_lot);
        }
        if (filter_project != null) {
            set = new HashSet(filter_project.size());
            for (DynamicObject info : filter_project) {
                set.add(info.getPkValue());
            }
            q.and(prefix.concat("project"), "in", set);
        }
        if (filter_invType != null) {
            set = new HashSet(filter_invType.size());
            for (DynamicObject info : filter_invType) {
                set.add(info.getPkValue());
            }
            q.and(prefix.concat("invtype"), "in", set);
        }
        if (filter_invStatus != null) {
            set = new HashSet(filter_invStatus.size());
            for (DynamicObject info : filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and(prefix.concat("invstatus"), "in", set);
        }
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                set = new HashSet(filter_materialFrom.size());
                for (DynamicObject info : filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and(prefix.concat("material"), "in", set);
            } else {
                q.and(prefix.concat("material.number"), ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and(prefix.concat("material.number"), "<=", (Object)filter_materialTo.getString("number"));
        }
        if (filter_mulMaterialCategory != null) {
            set = new HashSet(filter_mulMaterialCategory.size());
            for (DynamicObject info : filter_mulMaterialCategory) {
                set.add(info.getPkValue());
            }
            q.and(prefix.concat("stocktype"), "in", set);
        }
        if (filter_mulcalrange != null) {
            set = new HashSet(filter_mulcalrange.size());
            for (DynamicObject dynamicObject : filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            q.and(prefix.concat("calrange"), "in", set);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)filter_mulaccounttype)) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : filter_mulaccounttype.split(",")) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and(prefix.concat("accounttype"), "in", accounttypes);
            }
        }
        return q;
    }

    private QFilter getBalFilter(ReportQueryParam queryParam) {
        HashSet<Object> set;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        DynamicObjectCollection filter_owner = filterInfo.getDynamicObjectCollection("mulowner");
        DynamicObjectCollection filter_mulcalrange = filterInfo.getDynamicObjectCollection("mulcalrange");
        DynamicObjectCollection filter_storageOrg = filterInfo.getDynamicObjectCollection("mulstorageorg");
        DynamicObjectCollection filter_warehouse = filterInfo.getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection filter_location = filterInfo.getDynamicObjectCollection("mullocation");
        DynamicObjectCollection filter_materialFrom = filterInfo.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filterInfo.getDynamicObject("materialto");
        DynamicObjectCollection filter_mulMaterialCategory = filterInfo.getDynamicObjectCollection("mulmatcategory");
        String filter_mulaccounttype = filterInfo.getString("mulaccounttype");
        String[] filter_lot = null;
        String lotnumber = filterInfo.getString("lotnumber");
        Set warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)filterInfo);
        if (kd.bos.util.StringUtils.isNotEmpty((String)lotnumber)) {
            filter_lot = lotnumber.split(";");
        }
        DynamicObjectCollection filter_project = queryParam.getFilter().getDynamicObjectCollection("mulproject");
        DynamicObjectCollection filter_invType = queryParam.getFilter().getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection filter_invStatus = queryParam.getFilter().getDynamicObjectCollection("mulinvstatus");
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        if (filter_owner != null) {
            set = new HashSet<Object>(filter_owner.size());
            for (DynamicObject info : filter_owner) {
                set.add(info.getPkValue());
            }
            q.and("owner", "in", set);
        }
        if (filter_storageOrg != null) {
            set = new HashSet(filter_storageOrg.size());
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", (Object)warehsGroupSet);
        }
        if (filter_warehouse != null) {
            set = new HashSet(filter_warehouse.size());
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (filter_location != null) {
            set = new HashSet(filter_location.size());
            for (DynamicObject info : filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (filter_lot != null) {
            q.and("lot", "in", (Object)filter_lot);
        }
        if (filter_project != null) {
            set = new HashSet(filter_project.size());
            for (DynamicObject info : filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (filter_invType != null) {
            set = new HashSet(filter_invType.size());
            for (DynamicObject info : filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (filter_invStatus != null) {
            set = new HashSet(filter_invStatus.size());
            for (DynamicObject info : filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                set = new HashSet(filter_materialFrom.size());
                for (DynamicObject info : filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("material", "in", set);
            } else {
                q.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
        }
        if (filter_mulMaterialCategory != null) {
            set = new HashSet(filter_mulMaterialCategory.size());
            for (DynamicObject info : filter_mulMaterialCategory) {
                set.add(info.getPkValue());
            }
            q.and("stocktype", "in", set);
        }
        if (filter_mulcalrange != null) {
            set = new HashSet(filter_mulcalrange.size());
            for (DynamicObject dynamicObject : filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)filter_mulaccounttype)) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : filter_mulaccounttype.split(",")) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and("accounttype", "in", accounttypes);
            }
        }
        return q;
    }

    private void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject row = evt.getRowData();
        String billId = row.getString("billid");
        if ("0".equals(billId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String bizEntityObject = row.getString("bizentityobject");
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewBill() {
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.getModel().setValue("mulcalrange", null);
        this.getModel().setValue("mulowner", null);
        this.getModel().setValue("mulsupplierownerfrom", null);
        this.getModel().setValue("mulcustomerownerfrom", null);
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        this.getModel().setValue("startperiod", period == null ? period : period.getPkValue());
        this.getModel().setValue("endperiod", period == null ? period : period.getPkValue());
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockdetailrpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"calorg");
    }

    private DataSet filterByQtyCondition(DataSet balDs, String qtyShowCondition) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)qtyShowCondition)) {
            String sign = "";
            if ("A".equals(qtyShowCondition)) {
                sign = "=";
            } else if ("B".equals(qtyShowCondition)) {
                sign = "<>";
            } else if ("C".equals(qtyShowCondition)) {
                sign = ">";
            } else if ("D".equals(qtyShowCondition)) {
                sign = "<";
            }
            balDs = balDs.filter("periodendqty " + sign + " 0");
        }
        return balDs;
    }

    private DataSet filterByAmountCondition(DataSet balDs, String amountShowCondition) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)amountShowCondition)) {
            String sign = "";
            if ("A".equals(amountShowCondition)) {
                sign = "=";
            } else if ("B".equals(amountShowCondition)) {
                sign = "<>";
            } else if ("C".equals(amountShowCondition)) {
                sign = ">";
            } else if ("D".equals(amountShowCondition)) {
                sign = "<";
            }
            balDs = balDs.filter("periodendactualcost " + sign + " 0");
        }
        return balDs;
    }

    private DynamicObjectCollection getBalMaterialDycs(ReportQueryParam queryParam) {
        DynamicObject startPeriod = queryParam.getFilter().getDynamicObject("startperiod");
        DynamicObject endPeriod = queryParam.getFilter().getDynamicObject("endperiod");
        DynamicObject costAccount = queryParam.getFilter().getDynamicObject("costaccount");
        Long costAccountId = costAccount.getLong("id");
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        Date filter_startDate = startPeriod.getDate("begindate");
        Date filter_endDate = endPeriod.getDate("enddate");
        String balEntity = "cal_balance";
        if (this.isNewBalance) {
            balEntity = "cal_bal";
        }
        if (queryParam.getFilter().getBoolean("noshowzeroinout")) {
            Set<Long> inOutMaterialIds = this.getInOutMaterialIds(queryParam, filter_startDate, filter_endDate);
            QFilter q = new QFilter("material.id", "in", inOutMaterialIds);
            q.and("period", "<=", (Object)endPeriodNumber);
            q.and("endperiod", ">", (Object)endPeriodNumber);
            QFilter q1 = new QFilter("costaccount", "=", (Object)costAccountId);
            QFilter[] qFilters = new QFilter[]{q, q1};
            return this.filterQtyAndAmount(qFilters, queryParam);
        }
        QFilter periodFilter = new QFilter("period", "<=", (Object)endPeriodNumber);
        periodFilter.and("endperiod", ">=", (Object)endPeriodNumber);
        DataSet materialsDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), periodFilter}, null).groupBy(new String[]{"material.id"}).finish();
        DynamicObjectCollection materials = ORM.create().toPlainDynamicObjectCollection(materialsDataSet);
        HashSet<Long> materialIds = new HashSet<Long>(materials.size());
        for (DynamicObject material : materials) {
            Long materialId = material.getLong("material.id");
            materialIds.add(materialId);
        }
        Set<Long> inOutMaterialIds = this.getInOutMaterialIds(queryParam, filter_startDate, filter_endDate);
        HashSet noInOutMaterials = new HashSet(materialIds);
        noInOutMaterials.removeAll(inOutMaterialIds);
        QFilter q1 = new QFilter("material.id", "in", noInOutMaterials);
        q1.and("period", "<", (Object)startPeriodNumber);
        q1.and("endperiod", ">=", (Object)startPeriodNumber);
        if (this.isNewBalance) {
            q1.and(QFilter.of((String)"baseqty_bal <> 0 or actualcost_bal <> 0", (Object[])new Object[0]));
        } else {
            q1.and(QFilter.of((String)"periodendqty <> 0 or periodendactualcost <> 0", (Object[])new Object[0]));
        }
        DataSet hasEndMaterialsDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{q1, this.getBalFilter(queryParam)}, null).groupBy(new String[]{"material.id"}).finish();
        DynamicObjectCollection hasEndMaterials = ORM.create().toPlainDynamicObjectCollection(hasEndMaterialsDataSet);
        HashSet<Long> hasBeginEndMaterialIds = new HashSet<Long>(inOutMaterialIds.size());
        for (DynamicObject hasBeginMaterial : hasEndMaterials) {
            Long materialId = hasBeginMaterial.getLong("material.id");
            hasBeginEndMaterialIds.add(materialId);
        }
        QFilter q2 = QFilter.of((String)"period != 0", (Object[])new Object[0]).and("period", "<=", (Object)startPeriodNumber);
        if (this.isNewBalance) {
            q2.and(QFilter.of((String)"baseqty <> 0 or actualcost <> 0 ", (Object[])new Object[0]));
            q2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"baseqty <> 0 or actualcost <> 0 ", (Object[])new Object[0])));
        } else {
            q2.and(QFilter.of((String)"periodbeginqty <> 0 or periodbeginactualcost <> 0 ", (Object[])new Object[0]));
            q2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"periodbeginqty <> 0 or periodbeginactualcost <> 0 ", (Object[])new Object[0])));
        }
        DataSet hasBeginMaterialsDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{q2, this.getBalFilter(queryParam)}, null).groupBy(new String[]{"material.id"}).finish();
        DynamicObjectCollection hasBeginMaterials = ORM.create().toPlainDynamicObjectCollection(hasBeginMaterialsDataSet);
        for (DynamicObject hasBeginMaterial : hasBeginMaterials) {
            Long materialId = hasBeginMaterial.getLong("material.id");
            hasBeginEndMaterialIds.add(materialId);
        }
        hasBeginEndMaterialIds.addAll(inOutMaterialIds);
        QFilter q3 = new QFilter("material.id", "in", hasBeginEndMaterialIds);
        q3.and("period", "<=", (Object)endPeriodNumber);
        q3.and("endperiod", ">", (Object)endPeriodNumber);
        QFilter[] qFilters = new QFilter[]{q3};
        return this.filterQtyAndAmount(qFilters, queryParam);
    }

    private DynamicObjectCollection filterQtyAndAmount(QFilter[] qFilters, ReportQueryParam queryParam) {
        DataSet balDs = null;
        if (this.isNewBalance) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)(CalBalanceModelHelper.getDimFields((boolean)true) + ",material.id,material.number,baseqty_in as periodinqty,actualcost_in as periodinactualcost,baseqty_out as periodissueqty,actualcost_out as periodissueactualcost,baseqty_bal as periodendqty,actualcost_bal as periodendactualcost"), (QFilter[])qFilters, null);
            balDs = dataSet.groupBy((CalBalanceModelHelper.getDimFields((boolean)false) + ",material.id,material.number").split(",")).max("periodinqty").sum("periodinactualcost").max("periodissueqty").sum("periodissueactualcost").max("periodendqty").sum("periodendactualcost").finish().orderBy(new String[]{"material.number"});
        } else {
            balDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"material.id,material.number,periodinqty,periodinactualcost,periodissueqty,periodissueactualcost,periodendqty,periodendactualcost", (QFilter[])qFilters, (String)"material.number");
        }
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        DynamicObjectCollection filter_materialgroupfrom = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        boolean notShowMaterialGroup = materialgroupstandard == null && (filter_materialgroupfrom == null || filter_materialgroupfrom.size() < 1);
        DataSet materialGroupDs = ReportUtil.getClassifiedMaterialDataSet((FilterInfo)filterInfo, (boolean)notShowMaterialGroup, (DynamicObject)materialgroupstandard);
        balDs = this.filterByMaterialGroup(balDs, materialGroupDs);
        DataSet balFilterQtyAmountDs = balDs.groupBy(new String[]{"material.id", "material.number"}).sum("periodinqty").sum("periodinactualcost").sum("periodissueqty").sum("periodissueactualcost").sum("periodendqty").sum("periodendactualcost").finish();
        balFilterQtyAmountDs = this.filterByQtyCondition(balFilterQtyAmountDs, queryParam.getFilter().getString("qtyshowcondition"));
        balFilterQtyAmountDs = this.filterByAmountCondition(balFilterQtyAmountDs, queryParam.getFilter().getString("amountshowcondition"));
        balFilterQtyAmountDs = balFilterQtyAmountDs.orderBy(new String[]{"material.number"});
        DynamicObjectCollection balCol = ORM.create().toPlainDynamicObjectCollection(balFilterQtyAmountDs);
        return balCol;
    }

    private DataSet filterByMaterialGroup(DataSet balDs, DataSet materialGroupDs) {
        if (balDs.copy().isEmpty() || materialGroupDs == null || materialGroupDs.isEmpty()) {
            return balDs;
        }
        return balDs.join(materialGroupDs).on("material.id", "material").select(balDs.getRowMeta().getFieldNames(), new String[]{"group"}).finish();
    }

    private Set<Long> getInOutMaterialIds(ReportQueryParam queryParam, Date filter_startDate, Date filter_endDate) {
        HashSet<Long> recordAndAdjustMaterialIds = new HashSet<Long>(16);
        QFilter costRecordQ = new QFilter("issplitcreate", "=", (Object)false);
        costRecordQ.and("isinitbill", "=", (Object)false);
        costRecordQ.and("bookdate", ">=", (Object)filter_startDate);
        costRecordQ.and("bookdate", "<=", (Object)filter_endDate);
        costRecordQ.and("billstatus", "=", (Object)"C");
        costRecordQ.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.material", (QFilter[])new QFilter[]{costRecordQ, this.getCostRecordAndAdjustFilter(queryParam, "cal_costrecord")}, null);
        QFilter costAjustQ = new QFilter("billstatus", "=", (Object)"C");
        costAjustQ.and("bookdate", ">=", (Object)filter_startDate);
        costAjustQ.and("bookdate", "<=", (Object)filter_endDate);
        DataSet costAdjustDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)"entryentity.material", (QFilter[])new QFilter[]{costAjustQ, this.getCostRecordAndAdjustFilter(queryParam, "cal_costadjustbill")}, null);
        for (Row row : costRecordDataSet) {
            recordAndAdjustMaterialIds.add(row.getLong("entry.material"));
        }
        for (Row row : costAdjustDataSet) {
            recordAndAdjustMaterialIds.add(row.getLong("entryentity.material"));
        }
        return recordAndAdjustMaterialIds;
    }
}

