/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockDifferDetailRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private String queryType = null;
    private boolean isQueryByFilter = true;
    private static final Log logger = LogFactory.getLog(StockDifferDetailRptFormPlugin.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private MaterialCategoryHelper materialCategoryHelper = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        this.addF7Listener(this, "calorg", "costaccount", "mulcalrange", "mulstorageorg", "mulwarehouse", "mullocation", "startperiod", "endperiod", "mulmaterial", "materialto", "mulowner", "multracknum");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    StockDifferDetailRptFormPlugin.this.hyperLinkBillNoClick(evt);
                }
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("calorg".equals(key)) {
            ReportUtil.calOrgChanged((IDataModel)this.getModel());
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulcalrange".equals(key)) {
            this.beforeF7Select4MulCalrange(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            ReportUtil.beforeF7Select4Mulcalorgowner((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("ownerto".equals(key)) {
            ReportUtil.beforeF7Select4ownerto((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String key = evt.getItemKey();
        this.isQueryByFilter = true;
        if ("bar_first".equals(key)) {
            this.queryType = "first";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_previous".equals(key)) {
            this.queryType = "previous";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_next".equals(key)) {
            this.queryType = "next";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_last".equals(key)) {
            this.queryType = "last";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_viewbill".equals(key)) {
            this.viewBill();
        } else if ("refresh".equals(key)) {
            this.isQueryByFilter = false;
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calorg == null || costAccount == null || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockdifferdetailrpt", (String)"47150e89000000ac", (Long)calorg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockDetailRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String firstQuery = this.getPageCache().get("firstQuery");
        if (StringUtils.isEmpty((String)firstQuery) || this.isQueryByFilter) {
            StringBuilder materialIdStr = new StringBuilder();
            DynamicObjectCollection balCol = this.getBalMaterialDycs(queryParam);
            if (balCol.size() == 0) {
                String currentMateiralId = String.valueOf(-1L);
                if (queryParam.getFilter().getFilterItem("currentMateiralId") != null) {
                    queryParam.getFilter().getFilterItem("currentMateiralId").setValue((Object)currentMateiralId);
                } else {
                    queryParam.getFilter().addFilterItem("currentMateiralId", (Object)currentMateiralId);
                }
                this.getPageCache().put("currentMateiralId", currentMateiralId);
                this.getPageCache().put("firstQuery", "false");
                this.getPageCache().put("index", "-1");
                return;
            }
            HashSet<String> idSet = new HashSet<String>(balCol.size());
            for (DynamicObject balInfo : balCol) {
                String id = String.valueOf(balInfo.getLong("material.id"));
                if (!idSet.add(id)) continue;
                materialIdStr.append(id).append(',');
            }
            String billno = queryParam.getFilter().getString("fbillno");
            HashSet<Long> billnoMatIds = new HashSet<Long>(16);
            if (!StringUtils.isEmpty((String)billno)) {
                QFilter costRecordQ = new QFilter("billno", "=", (Object)billno);
                DataSet costRecordMaterials = QueryServiceHelper.queryDataSet((String)StockDifferDetailRptFormPlugin.class.getName(), (String)"cal_costrecord", (String)"entry.material.id", (QFilter[])costRecordQ.toArray(), null);
                for (Object costRecord : costRecordMaterials) {
                    billnoMatIds.add(costRecord.getLong("entry.material.id"));
                }
                DataSet costAdjustMaterials = QueryServiceHelper.queryDataSet((String)StockDifferDetailRptFormPlugin.class.getName(), (String)"cal_costadjustbill", (String)"entryentity.material.id", (QFilter[])costRecordQ.toArray(), null);
                for (Row costAdjust : costAdjustMaterials) {
                    billnoMatIds.add(costAdjust.getLong("entryentity.material.id"));
                }
                DataSet stdCostDiffMaterials = QueryServiceHelper.queryDataSet((String)StockDifferDetailRptFormPlugin.class.getName(), (String)"cal_stdcostdiffbill", (String)"entryentity.material.id", (QFilter[])costRecordQ.toArray(), null);
                for (Row stdCostDiff : stdCostDiffMaterials) {
                    billnoMatIds.add(stdCostDiff.getLong("entryentity.material.id"));
                }
            }
            String currentMateiralId = String.valueOf(((DynamicObject)balCol.get(0)).getLong("material.id"));
            if (!billnoMatIds.isEmpty()) {
                StringBuilder billnoMaterialIdStr = new StringBuilder();
                for (Long id : billnoMatIds) {
                    billnoMaterialIdStr.append(id).append(',');
                    currentMateiralId = String.valueOf(id);
                }
                this.getPageCache().put("materialIds", billnoMaterialIdStr.substring(0, billnoMaterialIdStr.length() - 1));
            } else {
                this.getPageCache().put("materialIds", materialIdStr.substring(0, materialIdStr.length() - 1));
            }
            this.getPageCache().put("firstQuery", "false");
            this.getPageCache().put("index", "0");
            this.getPageCache().put("currentMateiralId", currentMateiralId);
            if (queryParam.getFilter().getFilterItem("currentMateiralId") != null) {
                queryParam.getFilter().getFilterItem("currentMateiralId").setValue((Object)currentMateiralId);
            } else {
                queryParam.getFilter().addFilterItem("currentMateiralId", (Object)currentMateiralId);
            }
        } else if (this.queryType == null) {
            String currentMateiralId = this.getPageCache().get("currentMateiralId");
            if (queryParam.getFilter().getFilterItem("currentMateiralId") != null) {
                queryParam.getFilter().getFilterItem("currentMateiralId").setValue((Object)currentMateiralId);
            } else {
                queryParam.getFilter().addFilterItem("currentMateiralId", (Object)currentMateiralId);
            }
        } else {
            String index = this.getPageCache().get("index");
            String materialIds = this.getPageCache().get("materialIds");
            String[] materialIdArray = materialIds.split(",");
            int indexInt = 0;
            if ("first".equals(this.queryType)) {
                indexInt = 0;
            } else if ("previous".equals(this.queryType)) {
                indexInt = Integer.parseInt(index) - 1;
            } else if ("next".equals(this.queryType)) {
                indexInt = Integer.parseInt(index) + 1;
            } else if ("last".equals(this.queryType)) {
                indexInt = materialIdArray.length - 1;
            }
            String currentMateiralId = materialIdArray[indexInt];
            this.getPageCache().put("index", String.valueOf(indexInt));
            this.getPageCache().put("currentMateiralId", currentMateiralId);
            if (queryParam.getFilter().getFilterItem("currentMateiralId") != null) {
                queryParam.getFilter().getFilterItem("currentMateiralId").setValue((Object)currentMateiralId);
            } else {
                queryParam.getFilter().addFilterItem("currentMateiralId", (Object)currentMateiralId);
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String index = this.getPageCache().get("index");
        int indexInt = Integer.parseInt(index);
        if (indexInt == -1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_first", "bar_previous", "bar_last", "bar_next"});
        } else {
            String materialIds = this.getPageCache().get("materialIds");
            String[] materialIdArray = materialIds.split(",");
            if (indexInt == 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_first", "bar_previous"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_first", "bar_previous"});
            }
            if (indexInt == materialIdArray.length - 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_last", "bar_next"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_last", "bar_next"});
            }
        }
        this.getModel().setValue("head_costaccount", this.getModel().getValue("costaccount"));
        if (String.valueOf(-1L).equals(this.getPageCache().get("currentMateiralId"))) {
            this.getModel().setValue("head_material", null);
            this.getModel().setValue("head_materialcategory", null);
        } else {
            this.getModel().setValue("head_material", (Object)this.getPageCache().get("currentMateiralId"));
            Long orgid = ((DynamicObject)this.getModel().getValue("calorg")).getLong("id");
            Long materialid = Long.valueOf(this.getPageCache().get("currentMateiralId"));
            this.getModel().setValue("head_materialcategory", (Object)MaterialCategoryHelper.getMaterialCategory((Long)orgid, (Long)materialid));
        }
        this.getModel().setValue("head_period", (Object)(((DynamicObject)this.getModel().getValue("startperiod")).getString("name") + "-" + ((DynamicObject)this.getModel().getValue("endperiod")).getString("name")));
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4MulCalrange(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("costaccount", "=", costAccount.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockdifferdetailrpt", (String)"47150e89000000ac");
        if (list != null) {
            logger.info("List \u4e0d\u4e3anull,\u5b58\u8d27\u6210\u672c\u5dee\u5f02\u660e\u7ec6\u8868-\u6838\u7b97\u7ec4\u7ec7List: " + list + " size: " + list.size());
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else {
            logger.info("List\u4e3anull,\u5b58\u8d27\u6210\u672c\u5dee\u5f02\u660e\u7ec6\u8868-\u6838\u7b97\u7ec4\u7ec7");
        }
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        if (null == q) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private QFilter getBalFilter(ReportQueryParam queryParam) {
        HashSet<Object> set;
        DynamicObject costAccount = queryParam.getFilter().getDynamicObject("costaccount");
        String filter_ownertype = queryParam.getFilter().getString("ownertypehead");
        DynamicObjectCollection filter_owner = null;
        if (StringUtils.isNotEmpty((String)filter_ownertype)) {
            if ("bos_org".equals(filter_ownertype)) {
                filter_owner = queryParam.getFilter().getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(filter_ownertype)) {
                filter_owner = queryParam.getFilter().getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(filter_ownertype)) {
                filter_owner = queryParam.getFilter().getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        DynamicObjectCollection filter_calrange = queryParam.getFilter().getDynamicObjectCollection("mulcalrange");
        DynamicObjectCollection filter_storageOrg = queryParam.getFilter().getDynamicObjectCollection("mulstorageorg");
        DynamicObjectCollection filter_warehouse = queryParam.getFilter().getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection filter_location = queryParam.getFilter().getDynamicObjectCollection("mullocation");
        DynamicObjectCollection filter_materialFrom = queryParam.getFilter().getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = queryParam.getFilter().getDynamicObject("materialto");
        DynamicObjectCollection filter_mulMaterialCategory = queryParam.getFilter().getDynamicObjectCollection("mulmatcategory");
        String[] filter_lot = null;
        String lotnumber = queryParam.getFilter().getString("lotnumber");
        if (StringUtils.isNotEmpty((String)lotnumber)) {
            filter_lot = lotnumber.split(";");
        }
        DynamicObjectCollection filter_project = queryParam.getFilter().getDynamicObjectCollection("mulproject");
        DynamicObjectCollection filter_invType = queryParam.getFilter().getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection filter_invStatus = queryParam.getFilter().getDynamicObjectCollection("mulinvstatus");
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        ReportUtil.getOwnerFilter((QFilter)q, (String)filter_ownertype, (DynamicObjectCollection)filter_owner, (String)"cal_balance");
        if (filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        if (filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (filter_lot != null) {
            q.and("lot", "in", (Object)filter_lot);
        }
        if (filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("material", "in", set);
            } else {
                q.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
        }
        if (filter_mulMaterialCategory != null && filter_mulMaterialCategory.size() > 0) {
            set = new HashSet();
            for (DynamicObject info : filter_mulMaterialCategory) {
                set.add(info.getPkValue());
            }
            q.and("stocktype", "in", set);
        }
        q.and("invtype.isforwardamount", "=", (Object)true);
        return q;
    }

    private void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject row = evt.getRowData();
        String billId = row.getString("billid");
        if ("0".equals(billId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String bizEntityObject = row.getString("bizentityobject");
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewBill() {
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void costAccountChanged() {
        this.getModel().setValue("mulcalrange", null);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        this.getModel().setValue("startperiod", period == null ? period : period.getPkValue());
        this.getModel().setValue("endperiod", period == null ? period : period.getPkValue());
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockdifferdetailrpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"calorg");
    }

    private DynamicObjectCollection getBalMaterialDycs(ReportQueryParam queryParam) {
        DynamicObject startPeriod = queryParam.getFilter().getDynamicObject("startperiod");
        DynamicObject endPeriod = queryParam.getFilter().getDynamicObject("endperiod");
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        QFilter inOutFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (queryParam.getFilter().getBoolean("noshowzeroinout")) {
            DynamicObjectCollection inOutMaterials;
            inOutFilter.and("period", ">=", (Object)startPeriodNumber);
            inOutFilter.and("period", "<=", (Object)endPeriodNumber);
            inOutFilter.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
            if (this.isNewBalance) {
                inOutFilter.and(QFilter.of((String)"baseqty_in <> 0 or standardcost_in <> 0 or costdiff_in <> 0 or baseqty_out <> 0 or standardcost_out <> 0 or costdiff_out <> 0", (Object[])new Object[0]));
                inOutMaterials = QueryServiceHelper.query((String)"cal_bal", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number");
            } else {
                inOutFilter.and(QFilter.of((String)"periodinqty <> 0 or periodinstandardcost <> 0 or periodincostdiff <> 0 or periodissueqty <> 0 or periodissuestandardcost <> 0 or periodissuecostdiff <> 0", (Object[])new Object[0]));
                inOutMaterials = QueryServiceHelper.query((String)"cal_balance", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number");
            }
            return inOutMaterials;
        }
        DynamicObjectCollection materials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam)}) : QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam)});
        HashSet<Long> materialIds = new HashSet<Long>(materials.size());
        for (DynamicObject material : materials) {
            Long materialId = material.getLong("material.id");
            materialIds.add(materialId);
        }
        inOutFilter.and("period", ">=", (Object)startPeriodNumber);
        inOutFilter.and("period", "<=", (Object)endPeriodNumber);
        inOutFilter.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        if (this.isNewBalance) {
            inOutFilter.and(QFilter.of((String)"baseqty_in <> 0 or standardcost_in <> 0 or costdiff_in <> 0 or baseqty_out <> 0 or standardcost_out <> 0 or costdiff_out <> 0", (Object[])new Object[0]));
        } else {
            inOutFilter.and(QFilter.of((String)"periodinqty <> 0 or periodissueqty <> 0 or periodinstandardcost <> 0 or periodincostdiff <> 0 or periodissuestandardcost <> 0 or periodissuecostdiff <> 0", (Object[])new Object[0]));
        }
        DynamicObjectCollection inOutMaterials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number") : QueryServiceHelper.query((String)"cal_balance", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number");
        HashSet<Long> inOutMaterialIds = new HashSet<Long>(inOutMaterials.size());
        for (DynamicObject inOutMaterial : inOutMaterials) {
            Long materialId = inOutMaterial.getLong("material.id");
            inOutMaterialIds.add(materialId);
        }
        HashSet noInOutMaterials = new HashSet(materialIds);
        noInOutMaterials.removeAll(inOutMaterialIds);
        QFilter q1 = new QFilter("material.id", "in", noInOutMaterials);
        q1.and("period", "<", (Object)startPeriodNumber);
        q1.and("endperiod", ">=", (Object)startPeriodNumber);
        q1.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        if (this.isNewBalance) {
            q1.and(QFilter.of((String)"baseqty_bal <> 0 or standardcost_bal <> 0 or costdiff_bal <> 0", (Object[])new Object[0]));
        } else {
            q1.and(QFilter.of((String)"periodendqty <> 0 or periodendstandardcost <> 0 or periodendcostdiff <> 0", (Object[])new Object[0]));
        }
        QFilter q2 = QFilter.of((String)"period != 0", (Object[])new Object[0]).and("period", "<=", (Object)startPeriodNumber).and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        q2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0])));
        DynamicObjectCollection hasBeginMaterials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{q1, q2, this.getBalFilter(queryParam)}) : QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{q1, q2, this.getBalFilter(queryParam)});
        HashSet<Long> hasBeginMaterialIds = new HashSet<Long>();
        for (DynamicObject hasBeginMaterial : hasBeginMaterials) {
            Long materialId = hasBeginMaterial.getLong("material.id");
            hasBeginMaterialIds.add(materialId);
        }
        hasBeginMaterialIds.addAll(inOutMaterialIds);
        DynamicObjectCollection resultMaterials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("material.id", "in", hasBeginMaterialIds)}) : QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("material.id", "in", hasBeginMaterialIds)});
        return resultMaterials;
    }
}

