/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.cal.common.helper.MulSelectBasisHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.PrintHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockEstimateGroupRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(StockEstimateGroupRptFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockestimatesumrpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            this.setCostAccountByCalOrg(calOrgId);
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"calorg");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"calorg");
        this.getView().setVisible(Boolean.FALSE, new String[]{"level"});
        this.groupTypeChanged();
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg);
        if (costAccount != null) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", (Object)costAccount.getLong("calpolicy")).toArray());
            this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
            this.getModel().setValue("calsystem", costAccount.get("calsystem"));
            this.getModel().setValue("calpolicy", costAccount.get("calpolicy"));
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("startperiod", (Object)period.getLong("id"));
                this.getModel().setValue("endperiod", (Object)period.getLong("id"));
            }
            this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
        } else {
            this.getModel().setValue("costaccount", null);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        int endPeriodNumber;
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        String errMsg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879\uff1a%1$s\u3002", (String)"SalesEstimateDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
        boolean isLack = false;
        HashSet<String> lackFields = new HashSet<String>(4);
        if (calOrg == null) {
            lackFields.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"SalesEstimateDetailRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (costAccount == null) {
            lackFields.add(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"SalesEstimateDetailRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (startPeriod == null) {
            lackFields.add(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4", (String)"SalesEstimateDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (endPeriod == null) {
            lackFields.add(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4", (String)"SalesEstimateDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            isLack = true;
        }
        if (isLack) {
            this.getView().showTipNotification(String.format(errMsg, String.join((CharSequence)", ", lackFields)));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockestimatesumrpt", (String)"47150e89000000ac", (Long)calOrg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        if (startPeriodNumber > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockEstimateGroupRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4CalOrg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            ReportUtil.beforeF7Select4Mulcalorgowner((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("ownerto".equals(key)) {
            ReportUtil.beforeF7Select4ownerto((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.beforeF7SelectMaterialGroup((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mulsupplier".equals(key)) {
            ReportUtil.beforeF7SelectMulSupplier((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4Mulmaterial(BeforeF7SelectEvent e) {
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(MulSelectBasisHelper.auditFilter());
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("mulstorageorg");
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        } else if (storageOrgs != null && storageOrgs.size() > 0) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : storageOrgs) {
                Object[] warehouseIds = SCMHelper.getAllWarehouseIDs((String)info.getDynamicObject("fbasedataid").getString("number"));
                Long[] locationIds = SCMHelper.getAllLocationIDs((Object[])warehouseIds);
                if (locationIds == null) continue;
                for (Object id : warehouseIds) {
                    set.add(id);
                }
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        } else if (calOrg != null) {
            List storageOrgIds = OrgServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrg.getLong("id"), (Long)0L);
            Object[] warehouseIds = SCMHelper.getAllWarehouseIDs((Object[])storageOrgIds.toArray(new Long[0]));
            Long[] locationIds = SCMHelper.getAllLocationIDs((Object[])warehouseIds);
            q = new QFilter("id", "in", (Object)locationIds);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StockEstimateGroupRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StockEstimateGroupRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        List list = OrgServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrg.getLong("id"), (Long)0L);
        QFilter q = new QFilter("id", "in", (Object)list);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StockEstimateGroupRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        q = new QFilter("calorg", "=", calOrg.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CalOrg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockestimatesumrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, "calorg", "costaccount", "startperiod", "endperiod", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "mulsupplier", "supplierto", "mulowner", "multracknum");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("materialname".equals(key)) {
                    StockEstimateGroupRptFormPlugin.this.hyperLinkMaterialNameClick(evt);
                }
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("print".equals(key)) {
            this.printOperation();
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Names) {
        BasedataEdit f7 = null;
        for (String f7Name : f7Names) {
            f7 = (BasedataEdit)this.getControl(f7Name);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            ReportUtil.calOrgChanged((IDataModel)this.getModel());
        } else if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulsupplier".equals(key)) {
            this.mulSupplierChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.mulStorageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.mulWarehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("grouptype".equals(key)) {
            this.groupTypeChanged();
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        }
    }

    private void groupTypeChanged() {
        String groupType = (String)this.getModel().getValue("grouptype");
        if ("H".equals(groupType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"level"});
        } else {
            this.getModel().setValue("level", (Object)1);
            this.getView().setVisible(Boolean.FALSE, new String[]{"level"});
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void mulWarehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void mulStorageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void mulSupplierChanged() {
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getModel().getValue("mulsupplier");
        if (coll != null && coll.size() <= 1) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"supplierto"});
        } else {
            this.getModel().setValue("supplierto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"supplierto"});
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("calsystem", null);
            this.getModel().setValue("calpolicy", null);
            return;
        }
        this.getModel().setValue("calsystem", costAccount.get("calsystem"));
        this.getModel().setValue("calpolicy", costAccount.get("calpolicy"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue()).toArray());
        if (coll == null) {
            return;
        }
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period == null) {
            return;
        }
        this.getModel().setValue("startperiod", (Object)period.getLong("id"));
        this.getModel().setValue("endperiod", (Object)period.getLong("id"));
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private void hyperLinkMaterialNameClick(HyperLinkClickEvent evt) {
        DynamicObject tracknumber;
        String trackNumber;
        DynamicObjectCollection coll;
        DynamicObject info;
        DynamicObjectCollection coll2;
        DynamicObject info2;
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = this.getView().getQueryParam().getFilter().clone();
        DynamicObject row = evt.getRowData();
        String groupType = filter.getString("grouptype");
        if (this.hasGroup(groupType, "E")) {
            String ownerType = row.getString("ownertype");
            info2 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ownerType));
            info2.set("id", (Object)row.getLong("owner_id"));
            coll2 = new DynamicObjectCollection();
            coll2.add((Object)info2);
            if ("bos_org".equals(ownerType)) {
                filter.getFilterItem("mulowner").setValue((Object)coll2);
            } else if ("bd_supplier".equals(ownerType)) {
                filter.getFilterItem("mulsupplierownerfrom").setValue((Object)coll2);
            } else if ("bd_customer".equals(ownerType)) {
                filter.getFilterItem("mulcustomerownerfrom").setValue((Object)coll2);
            }
            filter.getFilterItem("ownertypehead").setValue((Object)ownerType);
        }
        if (this.hasGroup(groupType, "B")) {
            info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
            info.set("id", (Object)row.getString("storageorgid"));
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            filter.getFilterItem("mulstorageorg").setValue((Object)coll);
        }
        if (this.hasGroup(groupType, "G")) {
            String warehsgroupid = row.getString("warehsgroupid");
            if ("0".equals(warehsgroupid)) {
                filter.addFilterItem("onlyqueryemptygroup", (Object)true);
            } else {
                info2 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_warehousegroup"));
                info2.set("id", (Object)warehsgroupid);
                coll2 = new DynamicObjectCollection();
                coll2.add((Object)info2);
                filter.getFilterItem("mulwarehsgroup").setValue((Object)coll2);
            }
        }
        if (this.hasGroup(groupType, "C")) {
            info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_warehouse"));
            info.set("id", (Object)row.getString("warehouseid"));
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            filter.getFilterItem("mulwarehouse").setValue((Object)coll);
        }
        if (this.hasGroup(groupType, "D")) {
            info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_supplier"));
            DynamicObject supplier = row.getDynamicObject("supplierid");
            if (supplier != null) {
                info.set("id", supplier.getPkValue());
                coll2 = new DynamicObjectCollection();
                coll2.add((Object)info);
                filter.addFilterItem("mulsupplier", (Object)coll2);
                filter.addFilterItem("supplierto", (Object)info);
            }
        }
        if (this.hasGroup(groupType, "F") && row.getString("lot") != null && kd.bos.util.StringUtils.isNotEmpty((String)row.getString("lot").trim())) {
            filter.addFilterItem("mullot", (Object)row.getString("lot"));
        }
        if (this.hasGroup(groupType, "I") && (trackNumber = row.getString("tracknumber")) != null && (tracknumber = QueryServiceHelper.queryOne((String)"bd_tracknumber", (String)"id", (QFilter[])new QFilter("number", "=", (Object)trackNumber).toArray())) != null) {
            DynamicObject info3 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_tracknumber"));
            info3.set("id", (Object)tracknumber.getLong("id"));
            DynamicObjectCollection coll3 = new DynamicObjectCollection();
            coll3.add((Object)info3);
            filter.getFilterItem("multracknum").setValue((Object)coll3);
        }
        info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_material"));
        info.set("id", row.getDynamicObject("materialid").get("id"));
        coll = new DynamicObjectCollection();
        coll.add((Object)info);
        filter.getFilterItem("mulmaterial").setValue((Object)coll);
        filter.getFilterItem("materialto").setValue((Object)info);
        long periodid = row.getLong("periodid");
        filter.getFilterItem("startperiod").setValue((Object)periodid);
        filter.getFilterItem("endperiod").setValue((Object)periodid);
        filter.getFilterItems().remove(filter.getFilterItem("grouptype"));
        filter.getFilterItems().remove(filter.getFilterItem("groupbyperiod"));
        queryParam.setFilter(filter);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_stockestimatedetairpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void printOperation() {
        try {
            String templeteId;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
            HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)this.getView().getEntityId(), (String)"4730fc9e000000ac");
            boolean hasAll = rs.hasAllOrgPerm();
            List hasPermOrgs = rs.getHasPermOrgs();
            Object calOrg = this.getModel().getValue("calorg") == null ? null : this.getModel().getValue("calorg");
            Long id = calOrg == null ? 0L : ((DynamicObject)calOrg).getLong("masterid");
            if (!hasAll && hasPermOrgs != null && !hasPermOrgs.contains(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u6253\u5370\u6743\u9650\u3002", (String)"StockDetailRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportView rptFormView = (ReportView)this.getExportAllView();
            if (rptFormView == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
            ThreadCache.put((Object)"stockEstimateGroupRptPrinter", (Object)listModel);
            int rowCount = listModel.getRowCount();
            if (rowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String formId = "cal_stockestimatesumrpt";
            Object defaultTemplateId = PrintHelper.getDefaultTemplateId((String)formId);
            if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"StockDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String printName = formId + "_printsetting";
            String curPrintPattern = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)printName);
            Map printSetting = null;
            if (!kd.bos.util.StringUtils.isEmpty((String)curPrintPattern)) {
                printSetting = (Map)SerializationUtils.fromJsonString((String)curPrintPattern, Map.class);
            }
            if (defaultTemplateId == null && (printSetting == null || printSetting.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String string = printSetting == null || kd.bos.util.StringUtils.isEmpty((String)((String)printSetting.get("templateid"))) ? (defaultTemplateId == null ? null : defaultTemplateId.toString()) : (templeteId = (String)printSetting.get("templateid"));
            if (kd.bos.util.StringUtils.isEmpty((String)templeteId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            PrintMetadata pMeta = (PrintMetadata)MetadataDao.readMeta((String)templeteId, (MetaCategory)MetaCategory.Form);
            if (pMeta == null) {
                PrintWork work = new PrintWork();
                String pageId = listModel.getPageId();
                work.setPageId(pageId);
                work.setPrintLang(RequestContext.get().getLang().getLangTag());
                PrintTask task = new PrintTask();
                task.setTplId(templeteId);
                task.setPageId(pageId);
                task.setFormId("cal_stockestimatesumrpt");
                task.setPrintType("report");
                ArrayList<PrintTask> tasks = new ArrayList<PrintTask>(16);
                tasks.add(task);
                work.setTaskList(tasks);
                work.setPageNumType(PrintHelper.getPageNumType((String)formId));
                PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
                String url = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
                url = String.format(url, prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
                this.getView().openUrl(url);
            } else {
                String pageId = rptFormView.getPageId();
                ReportDataProvider provider = PrintHelper.createReportDataProvider((String)pageId, (String)formId, (PrintMetadata)pMeta);
                provider.setQueryParam(rptFormView.getQueryParam());
                String pdfUrl = PrintServiceHelper.createPdfUrl((String)pageId, (String)"cal_stockestimatesumrpt", (String)pMeta.getKey(), null, (IPrintDataProvider)provider);
                if (!StringUtils.isBlank((CharSequence)pdfUrl)) {
                    IFormView mainView = this.getView().getMainView();
                    if (mainView == null) {
                        this.getView().openUrl(pdfUrl);
                    } else {
                        FormShowParameter parm = PrintHelper.buildParameter((String)pdfUrl);
                        this.getView().getParentView().showForm(parm);
                        this.getView().sendFormAction(this.getView().getParentView());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("StockEstimateGroupRptFormPlugin printOperation", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u53ef\u80fd\u8d85\u65f6\u4e86\uff0c\u8bf7\u8bd5\u7740\u70b9\u4e0b\u5237\u65b0\u6309\u94ae\u3002", (String)"StockDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
    }

    public IFormView getExportAllView() {
        ReportQueryParam queryParam = this.getQueryParam();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        this.asyncQuery(queryParam, reportList);
        return reportList.getView();
    }

    private void asyncQuery(ReportQueryParam queryParam, ReportList reportList) {
        IReportCache var13 = ReportCacheManager.getInstance().getCache();
        var13.setReportQueryParam(this.getView().getPageId(), queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)reportList.getReportModel();
        reportModel.setPageId(this.getView().getPageId());
        reportList.setAsynQuery(true);
        reportList.submitTask(queryParam, null);
    }
}

