/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockGatherRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(StockGatherRptFormPlugin.class);
    private static final List<String> headFieldList = Arrays.asList("materialnumber", "material", "materialmodel", "baseunit");

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulcalrange".equals(key)) {
            this.beforeF7Select4MulCalrange(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            ReportUtil.beforeF7Select4Mulcalorgowner((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("ownerto".equals(key)) {
            ReportUtil.beforeF7Select4ownerto((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.beforeMaterialgroupstandard((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.beforeF7SelectMaterialGroup((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4MulCalrange(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("costaccount", "=", costAccount.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockgatherrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "calorg", "costaccount", "mulcalrange", "mulstorageorg", "mulwarehouse", "mullocation", "startperiod", "endperiod", "mulmaterial", "mulowner", "materialgroupstandard", "mulmaterialgroup", "materialto", "multracknum");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if (key != null && key.contains("material")) {
                    StockGatherRptFormPlugin.this.hyperLinkMaterialNameClick(evt);
                }
            }
        });
    }

    private void hyperLinkMaterialNameClick(HyperLinkClickEvent evt) {
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = this.getView().getQueryParam().getFilter().clone();
        DynamicObject row = evt.getRowData();
        String groupType = filter.getString("mulgrouptype");
        if (groupType == null) {
            groupType = "A";
        }
        if (this.hasGroup(groupType, "B")) {
            // empty if block
        }
        if (this.hasGroup(groupType, "C")) {
            String ownerType = row.getString("ownertype");
            DynamicObject info = row.getDynamicObject("owner");
            if ("bos_org".equals(ownerType)) {
                filter.getFilterItem("mulowner").setValue((Object)info);
            } else if ("bd_supplier".equals(ownerType)) {
                filter.getFilterItem("mulsupplierownerfrom").setValue((Object)info);
            } else if ("bd_customer".equals(ownerType)) {
                filter.getFilterItem("mulcustomerownerfrom").setValue((Object)info);
            }
            filter.getFilterItem("ownertypehead").setValue((Object)ownerType);
        }
        if (this.hasGroup(groupType, "D")) {
            filter.getFilterItem("mulstorageorg").setValue((Object)row.getDynamicObject("storageorgunit"));
        }
        if (this.hasGroup(groupType, "J")) {
            DynamicObject warehsgroup = row.getDynamicObject("warehsgroup");
            if (warehsgroup == null) {
                filter.addFilterItem("onlyqueryemptygroup", (Object)true);
            } else {
                filter.getFilterItem("mulwarehsgroup").setValue((Object)warehsgroup);
            }
        }
        if (this.hasGroup(groupType, "E")) {
            filter.getFilterItem("mulwarehouse").setValue((Object)row.getDynamicObject("warehouse"));
        }
        if (this.hasGroup(groupType, "F") && row.getString("location") != null && StringUtils.isNotEmpty((String)row.getString("location").trim())) {
            filter.getFilterItem("mullocation").setValue((Object)row.getDynamicObject("location"));
        }
        if (this.hasGroup(groupType, "G") && row.getString("lot") != null && StringUtils.isNotEmpty((String)row.getString("lot").trim())) {
            filter.getFilterItem("lotnumber").setValue((Object)row.getString("lot"));
        }
        if (this.hasGroup(groupType, "I") && row.getString("project") != null && StringUtils.isNotEmpty((String)row.getString("project").trim())) {
            filter.getFilterItem("mulproject").setValue((Object)row.getDynamicObject("project"));
        }
        if (this.hasGroup(groupType, "L") && row.getString("materialcategory") != null && StringUtils.isNotEmpty((String)row.getString("materialcategory").trim())) {
            filter.getFilterItem("mulmatcategory").setValue((Object)row.getDynamicObject("materialcategory"));
        }
        if (this.hasGroup(groupType, "M") && row.getString("tracknumber") != null && StringUtils.isNotEmpty((String)row.getString("tracknumber").trim())) {
            filter.getFilterItem("multracknum").setValue((Object)row.getDynamicObject("tracknumber"));
        }
        DynamicObject info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_material"));
        info.set("id", row.getDynamicObject("material").get("id"));
        DynamicObjectCollection coll = new DynamicObjectCollection();
        coll.add((Object)info);
        filter.getFilterItem("mulmaterial").setValue((Object)coll);
        filter.getFilterItem("materialto").setValue((Object)info);
        boolean groupByPeriod = filter.getFilterItem("groupbyperiod").getBoolean();
        if (groupByPeriod) {
            String periodnumber = row.getString("periodnumber");
            int startYearNumber = Integer.parseInt(periodnumber.split("-")[0]);
            int endYearNumber = Integer.parseInt(periodnumber.split("-")[1]);
            DynamicObject startPeriod = this.getPeriodByYearMonth(filter.getDynamicObject("costaccount").getLong("id"), null, startYearNumber / 100, startYearNumber % 100);
            DynamicObject endPeriod = this.getPeriodByYearMonth(filter.getDynamicObject("costaccount").getLong("id"), null, endYearNumber / 100, endYearNumber % 100);
            filter.getFilterItem("startperiod").setValue((Object)startPeriod);
            filter.getFilterItem("endperiod").setValue((Object)endPeriod);
        } else {
            DynamicObject period = this.getPeriodByYearMonth(filter.getDynamicObject("costaccount").getLong("id"), null, row.getInt("year"), row.getInt("month"));
            filter.getFilterItem("startperiod").setValue((Object)period);
            filter.getFilterItem("endperiod").setValue((Object)period);
        }
        filter.addFilterItem("ordertype", (Object)"A");
        filter.getFilterItem("qtyshowcondition").setValue(null);
        filter.getFilterItem("amountshowcondition").setValue(null);
        filter.getFilterItem("noshowzeroinout").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("onlyshowsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("topsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItems().remove(filter.getFilterItem("mulgrouptype"));
        filter.getFilterItems().remove(filter.getFilterItem("groupbyperiod"));
        queryParam.setFilter(filter);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_stockdetailrpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("calorg".equals(key)) {
            ReportUtil.calOrgChanged((IDataModel)this.getModel());
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.getModel().setValue("mulcalrange", null);
        this.getModel().setValue("mulowner", null);
        this.getModel().setValue("mulsupplierownerfrom", null);
        this.getModel().setValue("mulcustomerownerfrom", null);
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        this.getModel().setValue("startperiod", period == null ? period : period.getPkValue());
        this.getModel().setValue("endperiod", period == null ? period : period.getPkValue());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calorg == null || costAccount == null || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockgatherrpt", (String)"47150e89000000ac", (Long)calorg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        String groupType = (String)this.getModel().getValue("mulgrouptype");
        if (groupType != null && groupType.contains("K") && StringUtils.isNotEmpty((String)groupType) && (groupType.contains("C") || groupType.contains("D") || groupType.contains("E") || groupType.contains("F") || groupType.contains("G") || groupType.contains("H") || groupType.contains("I") || groupType.contains("J") || groupType.contains("L"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u603b\u4f9d\u636e\u52fe\u9009\u7269\u6599\u5206\u7c7b\u65f6\uff0c\u8bf7\u52ff\u52fe\u9009\u9664\u5b58\u8d27\u3001\u7269\u6599\u5206\u7c7b\u4e4b\u5916\u7684\u503c\u3002", (String)"StockGatherRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockgatherrpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"calorg");
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            String columnName = event.getColumnName();
            if (!headFieldList.contains(columnName)) continue;
            event.setFilter(true);
        }
    }
}

