/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.formplugin;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.CostRecordQFilterHelper;
import kd.fi.cal.common.helper.EntityParseHelper;
import kd.fi.cal.common.helper.MulSelectBasisHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;

public class TransactionDetailRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String[] otherFields = new String[]{"mulaccount", "mulbiztype", "mulbilltype", "mulinvscheme", "billnoid", "billnumberid", "mulstorageorg", "mulwarehsgroup", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "mulproject"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_transactiondetailrpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
        }
        this.setQueryScheme();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billfilterdesc"});
        this.addF7Listener(this, "calorg", "costaccount", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "mulbilltype", "mulproject", "mulbiztype", "mulinvscheme", "mulaccount");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    TransactionDetailRptFormPlugin.this.hyperLinkNumberClick(evt, "id", "billentitytype");
                } else if ("billnumber".equals(key)) {
                    TransactionDetailRptFormPlugin.this.hyperLinkNumberClick(evt, "bizbillid", "bizentityobject");
                } else if ("fivouchernum".equals(key)) {
                    TransactionDetailRptFormPlugin.this.hyperLinkNumberClick(evt, "glvoucherid", "vouchertype");
                } else if ("carryovervouchernum".equals(key)) {
                    TransactionDetailRptFormPlugin.this.hyperLinkNumberClick(evt, "carryovervoucherid", "vouchertype");
                } else if ("tempvouchernum".equals(key)) {
                    TransactionDetailRptFormPlugin.this.hyperLinkNumberClick(evt, "tempvoucherid", "vouchertype");
                } else if ("dischargevouchernum".equals(key)) {
                    TransactionDetailRptFormPlugin.this.hyperLinkNumberClick(evt, "dischargevoucherid", "vouchertype");
                } else if ("feevouchernum".equals(key)) {
                    TransactionDetailRptFormPlugin.this.hyperLinkNumberClick(evt, "feevoucherid", "vouchertype");
                }
            }
        });
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("calorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("billfilterdesc".equals(key)) {
            this.billFilterdescChange(rowIndex, newValue);
        }
    }

    private void calOrgChanged() {
        this.getModel().setValue("mulstorageorg", null);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getModel().setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
            }
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period != null) {
            this.getModel().setValue("startdate", (Object)period.getDate("begindate"));
            this.getModel().setValue("enddate", (Object)period.getDate("enddate"));
        }
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void billFilterdescChange(int rowindex, Object newValue) {
        if ("".equals(newValue)) {
            this.getModel().setValue("billfilter_tag", null, rowindex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        } else if ("mulbilltype".equals(key)) {
            this.beforeF7Select4BillType(e);
        } else if ("mulproject".equals(key)) {
            this.beforeF7Select4MulProject(e);
        } else if ("mulaccount".equals(key)) {
            this.beforeF7Select4Account(e);
        }
    }

    private void beforeF7Select4Account(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            DynamicObject policy = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"id,accounttable", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue())});
            DynamicObject accountTable = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)policy.getLong("accounttable"))});
            QFilter accountQ = new QFilter("enable", "=", (Object)"1");
            accountQ.and("accounttable", "=", accountTable.get("id"));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id", (QFilter[])accountQ.toArray(), null);
            HashSet<Long> ids = new HashSet<Long>();
            for (Row row : dataSet) {
                ids.add(row.getLong(0));
            }
            q = new QFilter("id", "in", ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_transactiondetailrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            q = new QFilter("id", "in", (Object)list);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4BillType(BeforeF7SelectEvent e) {
        List numList = CostRecordQFilterHelper.getMatchBilltype((String)"billtypematch");
        QFilter qf = new QFilter("id", "in", (Object)numList);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(qf);
    }

    private void beforeF7Select4MulProject(BeforeF7SelectEvent e) {
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(MulSelectBasisHelper.auditFilter());
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("entry".equals(e.getEntryProp().getName())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            int selectedRows = e.getRowIndexs().length;
            if (entryEntity.size() == selectedRows) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TransactionDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("billfilterdesc".equals(key)) {
            this.doBillFilterClick(evt);
        }
    }

    private void doBillFilterClick(EventObject evt) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject", rowIndex);
        if (entityObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"TransactionDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        String entityObjectId = (String)entityObject.getPkValue();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityObjectId);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(true);
        TreeNode nodes = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
        String nodesJson = SerializationUtils.toJsonString((Object)nodes);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_condition");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entityNumber", entityObjectId);
        String conditionJson = (String)this.getModel().getValue("billfilter_tag", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("rowIndex", rowIndex);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billfilterdesc"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (returnData != null && "billfilterdesc".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            if (StringUtils.isBlank((CharSequence)returnData)) {
                this.getModel().setValue("billfilter_tag", (Object)"", rowIndex);
                this.getModel().setValue("billfilterdesc", (Object)"", rowIndex);
            } else {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
                this.getModel().setValue("billfilter_tag", (Object)returnData, rowIndex);
                this.getModel().setValue("billfilterdesc", (Object)condition.getExprTran(), rowIndex);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        if (calorg == null || costAccount == null || startdate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"TransactionDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject periodDyc = this.getYearPeriodByDate(costAccount.getPkValue(), startdate);
        if (periodDyc == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"TransactionDetailRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockcostgatherrpt", (String)"47150e89000000ac", (Long)calorg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u5148\u8fdb\u884c\u6388\u6743\u6216\u4fee\u6539\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TransactionDetailRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (enddate.before(startdate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"TransactionDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        LocalDateTime startDateTime = startdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime endDateTime = enddate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (startDateTime.plusYears(1L).isBefore(endDateTime)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0e\u5f00\u59cb\u65e5\u671f\u95f4\u9694\u8d85\u8fc7\u4e00\u5e74\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u67e5\u8be2\u3002", (String)"TransactionDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        this.getModel().setValue("startdate", (Object)DateUtils.getDayStartTime((Date)startdate));
        this.getModel().setValue("enddate", (Object)DateUtils.getDayEndTime((Date)enddate));
        if (this.getIsAllEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5fc5\u5f55\u5b57\u6bb5\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"TransactionDetailRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (entry != null && !entry.isEmpty()) {
            int size = entry.size();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                DynamicObject entityobject = (DynamicObject)((DynamicObject)entry.get(i)).get("entityobject");
                String billfilter = (String)((DynamicObject)entry.get(i)).get("billfilter_tag");
                StringBuilder queryScheme = new StringBuilder();
                if (entityobject == null || billfilter.isEmpty() || "".equals(billfilter)) continue;
                String entityobjectId = String.valueOf(entityobject.getPkValue());
                queryScheme.append(entityobjectId);
                queryScheme.append("::");
                queryScheme.append(billfilter);
                sb.append((CharSequence)queryScheme);
                sb.append(",,");
            }
            String string = sb.toString();
            if (string.isEmpty()) {
                return;
            }
            queryParam.getFilter().addFilterItem("entry", (Object)string.substring(0, string.lastIndexOf(44) - 1));
        }
    }

    private DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    private boolean getIsAllEmpty() {
        boolean isAllEmpty = true;
        for (int i = 0; i < otherFields.length; ++i) {
            Object fieldObject = this.getModel().getValue(otherFields[i]);
            if (fieldObject instanceof DynamicObjectCollection) {
                DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)fieldObject;
                if (dynamicObjectCollection == null || "[]".equals(dynamicObjectCollection.toString())) continue;
                isAllEmpty = false;
                break;
            }
            if (fieldObject == null || "[]".equals(fieldObject) || "".equals(String.valueOf(fieldObject).trim())) continue;
            isAllEmpty = false;
            break;
        }
        int rows = this.getModel().getEntryEntity("entry").getRowCount();
        for (int i = 0; i < rows; ++i) {
            String s = (String)this.getModel().getValue("billfilterdesc", i);
            if (s == null || "".equals(s)) continue;
            isAllEmpty = false;
            break;
        }
        return isAllEmpty;
    }

    private void setQueryScheme() {
        IDataModel model = this.getModel();
        model.setValue("entityobject", (Object)"cal_costrecord_subentity", 0);
        model.setValue("billfilterdesc", (Object)ResManager.loadKDString((String)"\u201c\u662f\u5426\u62c6\u5355\u751f\u6210\u201d\u7b49\u4e8e\u201c\u5426\u201d\u3002", (String)"TransactionDetailRptFormPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]), 0);
        model.setValue("billfilter_tag", (Object)"{\"expression\":\"\",\"exprTran\":\"\u662f\u5426\u62c6\u5355\u751f\u6210 \u7b49\u4e8e \u5426\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"1=A0IEE8M1CF\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"issplitcreate\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1=A0IEEB6DS6\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"1=A0IEE8M1CF\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"issplitcreate\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"1=A0IEEB6DS6\\\",\\\"value\\\":\\\"0\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"\u662f\u5426\u62c6\u5355\u751f\u6210 \u7b49\u4e8e \u5426\",\"localeExprTran\":{\"zh_CN\":\"\u662f\u5426\u62c6\u5355\u751f\u6210 \u7b49\u4e8e \u5426\"}}", 0);
        this.getModel().getEntryEntity("entry").addNew();
        model.setValue("entityobject", (Object)"cal_costadjust_subentity", 1);
        model.setValue("billfilterdesc", (Object)ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"TransactionDetailRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]), 1);
        model.setValue("billfilter_tag", (Object)"{\"expression\":\"\",\"exprTran\":\"\u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"1=A0JNFHWELR\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"1=A0JNFHUBU+\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"1=A0JNFHWELR\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"billstatus\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"1=A0JNFHUBU+\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"\u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838\",\"localeExprTran\":{\"zh_CN\":\"\u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838\"}}", 1);
        this.getModel().getEntryEntity("entry").addNew();
        model.setValue("entityobject", (Object)"cal_stdcostdiffbill", 2);
        model.setValue("billfilterdesc", (Object)ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"TransactionDetailRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]), 2);
        model.setValue("billfilter_tag", (Object)"{\"expression\":\"\",\"exprTran\":\"\u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"310+7G75W+XG\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"310+7G7C3TM8\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"310+7G75W+XG\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"billstatus\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"310+7G7C3TM8\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838\"},\"exprDesc\":\"\u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838\"}", 2);
    }

    private void hyperLinkNumberClick(HyperLinkClickEvent evt, String id, String EntityNumber) {
        DynamicObject row = evt.getRowData();
        String billId = row.getString(id);
        if ("0".equals(billId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String bizEntityObject = row.getDynamicObject(EntityNumber).getString("number");
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entry = scheme.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() == 0) {
            return;
        }
        dataModel.deleteEntryData("entry");
        dataModel.batchCreateNewEntryRow("entry", entry.size());
        this.setF7Filter(dataModel, entry, "entityobject");
        this.setBasicFilter(dataModel, entry, "billfilterdesc");
        this.setBasicFilter(dataModel, entry, "billfilter_tag");
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entry = dataModel.getEntryEntity("entry");
        this.setF7Filter(dataModel, entry, "entityobject");
        this.setBasicFilter(dataModel, entry, "billfilterdesc");
        this.setBasicFilter(dataModel, entry, "billfilter_tag");
    }

    private void setF7Filter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            DynamicObject billTypeObj = entryObj.getDynamicObject(entryField);
            if (billTypeObj == null) continue;
            String billType = billTypeObj.getString("number");
            dataModel.setValue(entryField, (Object)billType, i);
        }
    }

    private void setBasicFilter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            Object entryFieldObj = entryObj.get(entryField);
            if (entryFieldObj == null) continue;
            dataModel.setValue(entryField, entryFieldObj, i);
        }
    }
}

