/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlConsts;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptParam;

public class EstimateDtlRptHelper {
    public static QFilter getPeriodInFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("bookdate", "<=", (Object)rptParam.getEndDate());
        q.and("bookdate", ">=", (Object)rptParam.getStartDate());
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{rptParam.getEndPeriodNumber()}));
        q.and("isinitbill", "=", (Object)false);
        q.and("issplitcreate", "=", (Object)false);
        return q;
    }

    public static QFilter getPeriodOutFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("bookdate", "<=", (Object)rptParam.getEndDate());
        q.and(QFilter.of((String)"period >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        q.and(QFilter.of((String)"period <= ?", (Object[])new Object[]{rptParam.getEndPeriodId()}));
        q.and("isinitbill", "=", (Object)false);
        q.and("issplitcreate", "=", (Object)false);
        return q;
    }

    public static QFilter getPeriodWFFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        q.and(QFilter.of((String)"writeoffperiod <= ?", (Object[])new Object[]{rptParam.getEndPeriodId()}));
        return q;
    }

    public static QFilter getPeriodNotWFFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("writeoffperiod", "<=", (Object)rptParam.getEndPeriodId());
        q.and("issplitcreate", "=", (Object)false);
        q.and(new QFilter("writeoffendperiod", "=", (Object)0L).or("writeoffendperiod", ">", (Object)rptParam.getStartPeriodId()));
        return q;
    }

    public static QFilter getPeriodNotWFFilter(QFilter q, EstimateDtlRptParam rptParam, boolean wfEndPeriodZero) {
        q.and("writeoffperiod", "<=", (Object)rptParam.getEndPeriodId());
        q.and("issplitcreate", "=", (Object)false);
        if (wfEndPeriodZero) {
            q.and(QFilter.of((String)"writeoffendperiod = ?", (Object[])new Object[]{0L}));
        } else {
            q.and(QFilter.of((String)"writeoffendperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        }
        return q;
    }

    public static QFilter getPeriodSonWFFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("issplitcreate", "=", (Object)true);
        q.and("writeoffperiod", "<=", (Object)rptParam.getEndPeriodId());
        return q;
    }

    public static QFilter getPeriodSonWFFilter(QFilter q, EstimateDtlRptParam rptParam, boolean wfEndPeriodZero) {
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("issplitcreate", "=", (Object)true);
        q.and("writeoffperiod", "<=", (Object)rptParam.getEndPeriodId());
        if (wfEndPeriodZero) {
            q.and(QFilter.of((String)"writeoffendperiod = ?", (Object[])new Object[]{0L}));
        } else {
            q.and(QFilter.of((String)"writeoffendperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        }
        return q;
    }

    public static QFilter getBeforePeriodOutAFilter(QFilter q, EstimateDtlRptParam rptParam, boolean wfEndPeriodZero) {
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period < ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        if (wfEndPeriodZero) {
            q.and(QFilter.of((String)"writeoffendperiod = ?", (Object[])new Object[]{0L}));
        } else {
            q.and(QFilter.of((String)"writeoffendperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        }
        return q;
    }

    public static QFilter getBeforePeriodInAFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("issplitcreate", "=", (Object)false);
        q.and("bookdate", "<", (Object)rptParam.getStartDate());
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and("writeoffendperiod", "=", (Object)0);
        return q;
    }

    public static QFilter getBeforePeriodOutBFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and(QFilter.of((String)"writeoffendperiod.periodyear*100+writeoffendperiod.periodnumber >= ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        return q;
    }

    public static QFilter getBeforePeriodInBFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("issplitcreate", "=", (Object)false);
        q.and("bookdate", "<", (Object)rptParam.getStartDate());
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and(QFilter.of((String)"writeoffendperiod.periodyear*100+writeoffendperiod.periodnumber >= ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        return q;
    }

    public static QFilter getBeforePeriodWFAFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and("writeoffendperiod", "=", (Object)0);
        q.and("writeoffstatus", "=", (Object)"A");
        return q;
    }

    public static QFilter getBeforePeriodWFAFilter(QFilter q, EstimateDtlRptParam rptParam, boolean wfEndPeriodZero) {
        q.and(QFilter.of((String)"period < ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        q.and(QFilter.of((String)"writeoffperiod < ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        if (wfEndPeriodZero) {
            q.and(QFilter.of((String)"writeoffendperiod = ?", (Object[])new Object[]{0L}));
        } else {
            q.and(QFilter.of((String)"writeoffendperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        }
        q.and("writeoffstatus", "=", (Object)"A");
        return q;
    }

    public static QFilter getBeforePeriodWFBFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and(QFilter.of((String)"writeoffendperiod.periodyear*100+writeoffendperiod.periodnumber >= ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and("writeoffstatus", "=", (Object)"A");
        return q;
    }

    public static QFilter getInitFilter(QFilter q, EstimateDtlRptParam rptParam) {
        q.and("bookdate", "<=", (Object)rptParam.getEndDate());
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)true);
        q.and(QFilter.of((String)"period >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        q.and(QFilter.of((String)"period <= ?", (Object[])new Object[]{rptParam.getEndPeriodId()}));
        return q;
    }

    public static QFilter getBaseFilter(EstimateDtlRptParam rptParam, boolean isRecord, boolean isSale) {
        HashSet<Object> set;
        Set<Long> costAccountIdSet = rptParam.getCostAccountIdSet();
        Set<Long> warehsGroupSet = rptParam.getWarehsGroupSet();
        String ownerType = rptParam.getOwnertype();
        DynamicObjectCollection owner = rptParam.getOwner();
        DynamicObjectCollection customer = rptParam.getCustomer();
        DynamicObjectCollection supplier = rptParam.getSupplier();
        DynamicObjectCollection storageOrg = rptParam.getStorageOrg();
        DynamicObjectCollection warehouse = rptParam.getWarehouse();
        DynamicObjectCollection location = rptParam.getLocation();
        DynamicObjectCollection billtype = rptParam.getBilltype();
        DynamicObjectCollection materialFrom = rptParam.getMaterialFrom();
        DynamicObjectCollection matcategory = rptParam.getMatcategory();
        DynamicObject materialTo = rptParam.getMaterialTo();
        Long trackNumberId = rptParam.getTrackNumberId();
        String lot = rptParam.getLot();
        String billno = rptParam.getBillno();
        String entryName = "entry";
        if (!isRecord) {
            entryName = "entryentity";
        }
        QFilter q = new QFilter("costaccount", "in", costAccountIdSet);
        q.and("billstatus", "=", (Object)"C");
        if (!"".equals(ownerType)) {
            q.and(entryName + ".ownertype", "=", (Object)ownerType);
        }
        if (owner != null && !owner.isEmpty()) {
            set = new HashSet<Object>(8);
            for (DynamicObject info : owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".owner", "in", set);
        }
        if (customer != null && !customer.isEmpty()) {
            set = new HashSet(8);
            for (DynamicObject info : customer) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (isRecord) {
                q.and(entryName + ".balancecustomer", "in", set);
            } else {
                q.and("customer", "in", set);
            }
        }
        if (supplier != null && !supplier.isEmpty()) {
            set = new HashSet(8);
            for (DynamicObject info : supplier) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (isRecord) {
                q.and(entryName + ".balancesupplier", "in", set);
            } else {
                q.and("custsupplier", "in", set);
            }
        }
        if (storageOrg != null && !storageOrg.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (isRecord) {
                q.and("storageorgunit", "in", set);
            } else {
                q.and(entryName + ".storageorgunit", "in", set);
            }
        }
        if (!warehsGroupSet.isEmpty()) {
            q.and(entryName + ".warehouse.group", "in", warehsGroupSet);
        }
        if (warehouse != null && !warehouse.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".warehouse", "in", set);
        }
        if (location != null && !location.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : location) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".location", "in", set);
        }
        if (trackNumberId != null && Long.compare(trackNumberId, 0L) != 0) {
            q.and(entryName + ".tracknumber", "=", (Object)trackNumberId);
        }
        if (matcategory != null && !matcategory.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : matcategory) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".stocktype", "in", set);
        }
        if (materialFrom != null && !materialFrom.isEmpty()) {
            if (materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject material : materialFrom) {
                    materialSet.add(material.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and(entryName + ".material.id", "in", materialSet);
            } else if (materialFrom.size() == 1) {
                q.and(entryName + ".material.number", ">=", (Object)((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (materialTo != null) {
            q.and(entryName + ".material.number", "<=", (Object)materialTo.getString("number"));
        }
        if (lot != null && !lot.equals("")) {
            q.and(entryName + ".lot", "=", (Object)lot);
        }
        if (isRecord) {
            Set notUpdBalBizType;
            if (billno != null && !billno.equals("")) {
                q.and("billnumber", "=", (Object)billno);
            }
            if (rptParam.getDischargeType() != null) {
                q.and("dischargetype", "in", (Object)rptParam.getDischargeType());
            }
            if ((notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType()) != null && !notUpdBalBizType.isEmpty()) {
                q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
            }
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            HashSet<Object> bizObjectSet = new HashSet<Object>(16);
            if (billtype != null && !billtype.isEmpty()) {
                HashSet<Object> set2 = new HashSet<Object>();
                for (DynamicObject info : billtype) {
                    set2.add(info.getDynamicObject("fbasedataid").getPkValue());
                }
                q.and("bizentityobject", "in", set2);
            } else {
                if (isSale) {
                    q.and("calbilltype", "=", (Object)"OUT");
                    DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("outsplitebiztype");
                    for (DynamicObject bizobject : bizobjects) {
                        bizObjectSet.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
                    }
                } else {
                    DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("purbiztype");
                    DynamicObjectCollection ominBizobjects = setting.getDynamicObjectCollection("ominbiztype");
                    bizobjects.addAll((Collection)ominBizobjects);
                    for (DynamicObject bizobject : bizobjects) {
                        bizObjectSet.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
                    }
                }
                q.and("bizentityobject", "in", bizObjectSet);
            }
        } else {
            q.and("entryentity.invbillnum", "like", (Object)(billno + "%"));
            q.and("biztype", "=", (Object)"A");
            q.and("createtype", "in", (Object)new String[]{"B", "U"});
            q.and(QFilter.of((String)"period >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
            q.and(QFilter.of((String)"period <= ?", (Object[])new Object[]{rptParam.getEndPeriodId()}));
        }
        return q;
    }

    public static EstimateDtlRptParam buildRptParam(IDataModel model) {
        String dischargeType;
        Set allFields = model.getDataEntityType().getAllFields().keySet();
        DynamicObject dataEntity = model.getDataEntity(true);
        EstimateDtlRptParam rptParam = new EstimateDtlRptParam();
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            rptParam.setCalOrgIdSet(calOrgIds);
        }
        DynamicObjectCollection costAccounts = new DynamicObjectCollection();
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        HashSet<Long> costaccountIdSet = new HashSet<Long>(costaccounts.size());
        for (DynamicObject costaccount : costaccounts) {
            DynamicObject costAccount = costaccount.getDynamicObject("fbasedataid");
            costaccountIdSet.add(costAccount.getLong("id"));
            costAccounts.add((Object)costAccount);
        }
        rptParam.setCostAccountIdSet(costaccountIdSet);
        DynamicObject startperiod = dataEntity.getDynamicObject("startperiod");
        rptParam.setStartPeriod(startperiod);
        rptParam.setStartPeriodId(startperiod.getLong("id"));
        rptParam.setStartPeriodNumber(startperiod.getInt("periodyear") * 100 + startperiod.getInt("periodnumber"));
        rptParam.setStartDate(startperiod.getDate("begindate"));
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        rptParam.setEndPeriod(endperiod);
        rptParam.setEndPeriodNumber(endperiod.getInt("periodyear") * 100 + endperiod.getInt("periodnumber"));
        rptParam.setEndPeriodId(endperiod.getLong("id"));
        rptParam.setEndDate(endperiod.getDate("enddate"));
        String ownerType = dataEntity.getString("ownertypehead");
        rptParam.setOwnertype(ownerType);
        if (StringUtils.isNotEmpty((String)ownerType)) {
            if ("bos_org".equals(ownerType)) {
                rptParam.setOwner(dataEntity.getDynamicObjectCollection("mulowner"));
            } else if ("bd_supplier".equals(ownerType)) {
                rptParam.setOwner(dataEntity.getDynamicObjectCollection("mulsupplierownerfrom"));
            } else if ("bd_customer".equals(ownerType)) {
                rptParam.setOwner(dataEntity.getDynamicObjectCollection("mulcustomerownerfrom"));
            }
        }
        if (allFields.contains("muldischargetype") && (dischargeType = dataEntity.getString("muldischargetype")) != null && !"".equals(CommonUtils.trimComma((String)dischargeType))) {
            rptParam.setDischargeType(CommonUtils.trimComma((String)dischargeType).split(","));
        }
        if (allFields.contains("containadjustbill")) {
            rptParam.setIscontainadjustbill(dataEntity.getBoolean("containadjustbill"));
        }
        if (allFields.contains("mulcustomer")) {
            rptParam.setCustomer(dataEntity.getDynamicObjectCollection("mulcustomer"));
        }
        if (allFields.contains("mulsupplier")) {
            rptParam.setSupplier(dataEntity.getDynamicObjectCollection("mulsupplier"));
        }
        rptParam.setStorageOrg(dataEntity.getDynamicObjectCollection("mulstorageorg"));
        rptParam.setWarehouse(dataEntity.getDynamicObjectCollection("mulwarehouse"));
        rptParam.setLocation(dataEntity.getDynamicObjectCollection("mullocation"));
        rptParam.setMaterialFrom(dataEntity.getDynamicObjectCollection("mulmaterial"));
        rptParam.setMaterialTo(dataEntity.getDynamicObject("materialto"));
        DynamicObject materialgroupstandard = dataEntity.getDynamicObject("materialgroupstandard");
        rptParam.setMaterialgroupstandard(materialgroupstandard);
        DynamicObjectCollection mulmaterialgroup = dataEntity.getDynamicObjectCollection("mulmaterialgroup");
        rptParam.setMulmaterialgroup(mulmaterialgroup);
        rptParam.setNotShowMaterialGroup(materialgroupstandard == null && mulmaterialgroup.isEmpty());
        rptParam.setBilltype(dataEntity.getDynamicObjectCollection("mulbilltype"));
        rptParam.setBillno(dataEntity.getString("billno"));
        rptParam.setNoShowZeroInOut(dataEntity.getBoolean("noshowzeroinout"));
        DynamicObjectCollection mulmatcategory = dataEntity.getDynamicObjectCollection("mulmatcategory");
        rptParam.setMatcategory(mulmatcategory);
        return rptParam;
    }

    public static void createBaseDataColumns(List<AbstractReportColumn> cols) {
        EstimateDtlRptHelper.createBaseDataColumn(cols, EstimateDtlConsts.GROUP_NAME, "group");
    }

    public static void createDecimalColumns(List<AbstractReportColumn> cols, boolean isSale) {
        if (isSale) {
            EstimateDtlRptHelper.createDecimalColumn(cols, EstimateDtlConsts.PERIOD_OUT_NAME, "periodin");
        } else {
            EstimateDtlRptHelper.createDecimalColumn(cols, EstimateDtlConsts.PERIOD_IN_NAME, "periodin");
        }
        EstimateDtlRptHelper.createDecimalColumn(cols, EstimateDtlConsts.PERIOD_WF_NAME, "periodwriteoff");
        EstimateDtlRptHelper.createDecimalColumn(cols, EstimateDtlConsts.PERIOD_NOTWF_NAME, "periodnotwriteoff");
        EstimateDtlRptHelper.createDecimalColumn(cols, EstimateDtlConsts.PERIOD_END_NAME, "beforeperiod");
    }

    public static void createHideColumns(List<AbstractReportColumn> cols) {
        for (AbstractReportColumn abstractReportColumn : cols) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            ReportColumn column = (ReportColumn)abstractReportColumn;
            String columnName = column.createColumn().get("dataIndex").toString();
            HashSet<String> hideFields = new HashSet<String>(16);
            hideFields.add("beforeperiodqty");
            hideFields.add("beforeperiodamount");
            hideFields.add("beforeperiodwfqty");
            hideFields.add("beforeperiodwfamount");
            hideFields.add("periodinqty");
            hideFields.add("periodinamount");
            hideFields.add("periodwriteoffqty");
            hideFields.add("periodwriteoffamount");
            hideFields.add("periodnotwriteoffqty");
            hideFields.add("periodnotwriteoffamount");
            hideFields.add("periodtype");
            hideFields.add("initqty");
            hideFields.add("initamount");
            hideFields.add("auditdate");
            hideFields.add("entryid");
            if (!hideFields.contains(columnName)) continue;
            column.setHide(true);
        }
    }

    public static void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(EstimateDtlConsts.QTY_NAME);
        qty.setWidth(EstimateDtlConsts.WIDTH);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunit");
        ReportColumn price = new ReportColumn();
        price.setCaption(EstimateDtlConsts.PRICE_NAME);
        price.setWidth(EstimateDtlConsts.WIDTH);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currency");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(EstimateDtlConsts.AMOUNT_NAME);
        amount.setWidth(EstimateDtlConsts.WIDTH);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currency");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
    }

    public static void createBaseDataColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumn matGroup = new ReportColumn();
        matGroup.setCaption(groupName);
        matGroup.setFieldKey(fieldKey);
        matGroup.setFieldType("basedata");
        cols.add((AbstractReportColumn)matGroup);
    }

    public static DataSet createDataSet(ReportDataCtx ctx, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        ctx.getCurrentJob().commit(60, TimeUnit.MINUTES);
        return ctx.getCurrentJob().readDataSet(resultId);
    }

    public static Set<Long> getRecordSonIdSet(EstimateDtlRptParam rptParam) {
        HashSet<Long> costRecordAIdSet = new HashSet<Long>(16);
        QFilter recordQ = EstimateDtlRptHelper.getBaseFilter(rptParam, true, false);
        recordQ.and("writeoffstatus", "=", (Object)"A");
        recordQ.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber >= ? ", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        recordQ.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber <= ?", (Object[])new Object[]{rptParam.getEndPeriodNumber()}));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-record", (String)"cal_costrecord_subentity", (String)"id", (QFilter[])new QFilter[]{recordQ}, null);
        for (Row row : dataSet) {
            costRecordAIdSet.add(row.getLong("id"));
        }
        return costRecordAIdSet;
    }
}

