/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.PrintHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptHelper;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptParam;

public class SaleEstimateDtlRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(SaleEstimateDtlRptForm.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = RequestContext.get().getCurrUserId();
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_saledetail_newrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
        this.resetFilterGrid();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        int endPeriodNumber;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        DynamicObjectCollection costaccountList = dataEntity.getDynamicObjectCollection("mulcostaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calOrgList == null || calOrgList.size() == 0 || costaccountList == null || costaccountList.size() == 0 || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d26\u7c3f\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        if (startPeriodNumber > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"SalesEstimateGroupRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        EstimateDtlRptParam rptParam = EstimateDtlRptHelper.buildRptParam(model);
        rptParam.setWarehsGroupSet(ReportUtil.getWarehsGroupSet((FilterInfo)this.getQueryParam().getFilter()));
        DynamicObject trackNumber = this.getQueryParam().getFilter().getDynamicObject("tracknumber");
        if (trackNumber != null) {
            rptParam.setTrackNumberId(trackNumber.getLong("id"));
        }
        this.getQueryParam().getCustomParam().put(EstimateDtlRptParam.class.getName(), rptParam);
        return super.verifyQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "startperiod", "endperiod", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "materialgroupstandard", "mulmaterialgroup", "mulcustomer", "customerto", "mulbilltype", "mulowner", "multracknum");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    SaleEstimateDtlRptForm.this.hyperLinkBillNoClick(evt);
                }
            }
        });
    }

    protected void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        String billid;
        DynamicObject row = evt.getRowData();
        String billnumber = row.getString("billno");
        DynamicObject costAccount = row.getDynamicObject("costaccount");
        Object costAccountId = costAccount.getPkValue();
        QFilter qFilter = new QFilter("billnumber", "=", (Object)billnumber);
        qFilter.and("costaccount", "=", costAccountId);
        qFilter.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and(billStatusf);
        qFilter.and("calbilltype", "=", (Object)"OUT");
        DynamicObject costRecordRow = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"id", (QFilter[])qFilter.toArray());
        if (costRecordRow != null) {
            billid = String.valueOf(costRecordRow.get("id"));
            if ("0".equals(billid)) {
                return;
            }
        } else {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billid);
        showParameter.setFormId("cal_costrecord_subentity");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Names) {
        BasedataEdit f7 = null;
        for (String f7Name : f7Names) {
            f7 = (BasedataEdit)this.getControl(f7Name);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4CalOrg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel(), (String)"mulcalorg");
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulbilltype".equals(key)) {
            this.beforeF7Select4BillType(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Mulcalorgowner(e);
        } else if ("materialgroupstandard".equals(key)) {
            this.beforeMaterialgroupstandard(e);
        } else if ("mulmaterialgroup".equals(key)) {
            this.beforeF7SelectMaterialGroup(e);
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4BillType(BeforeF7SelectEvent e) {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("outsplitebiztype");
        HashSet<Object> set = new HashSet<Object>();
        for (DynamicObject bizobject : bizobjects) {
            set.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
        }
        QFilter q = new QFilter("number", "in", set);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeMaterialgroupstandard(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        if (calOrgList == null || calOrgList.isEmpty()) {
            return;
        }
        HashSet materialIdSet = new HashSet(16);
        for (DynamicObject calOrg : calOrgList) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
            materialIdSet.addAll(ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", materialIdSet));
    }

    private void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter.and(serviceResponse));
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockGatherReportBplatForm_3", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        QFilter q = ReportUtil.getCostAccountNextPeriodOf((DynamicObjectCollection)costaccountList);
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CalOrg(BeforeF7SelectEvent e) {
        Long userId = RequestContext.get().getCurrUserId();
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_saledetail_newrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulstorageorg".equals(key)) {
            this.mulStorageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.mulWarehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void mulWarehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void mulStorageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccounts) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        HashSet<Long> periodIds = new HashSet<Long>();
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            periodIds.add(period.getLong("id"));
        }
        if (periodIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long maxid = (Long)Collections.max(periodIds);
        Long minid = (Long)Collections.min(periodIds);
        this.getModel().setValue("startperiod", (Object)(periodIds.size() == 0 ? null : minid));
        this.getModel().setValue("endperiod", (Object)(periodIds.size() == 0 ? null : maxid));
    }

    private void calOrgChanged() {
        IDataModel model = this.getModel();
        model.setValue("mulstorageorg", null);
        model.setValue("mulowner", null);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            model.setValue("mulcostaccount", null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue("mulcostaccount", (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue("mulcostaccount", null);
            }
            model.setValue("ownertypehead", (Object)"bos_org");
        }
    }

    private void resetFilterGrid() {
        FilterCondition filterCondition;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam("commonfs");
        if (openParamStr != null && !StringUtils.isEmpty((String)openParamStr) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)openParamStr, FilterCondition.class)) != null) {
            filterGrid.SetValue(filterCondition);
        }
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if ("configuredcode.desc".equals(fieldName) || !this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("calorg");
        removedPros.add("ownertype");
        removedPros.add("owner");
        removedPros.add("ownernum");
        removedPros.add("customer");
        removedPros.add("customernum");
        removedPros.add("material");
        removedPros.add("materialnum");
        removedPros.add("storageorgunit");
        removedPros.add("storageorgunitnum");
        removedPros.add("warehousenum");
        removedPros.add("warehouse");
        removedPros.add("warehousegroup");
        removedPros.add("warehousegroupnum");
        removedPros.add("location");
        removedPros.add("locationnum");
        removedPros.add("periodtype");
        removedPros.add("period");
        removedPros.add("blockflag");
        removedPros.add("writeoffstatus");
        removedPros.add("writeoffperiod");
        removedPros.add("baseunit");
        removedPros.add("currency");
        removedPros.add("bookdate");
        removedPros.add("bizdate");
        removedPros.add("billtype");
        removedPros.add("writeoffendperiod");
        removedPros.add("auditdate");
        removedPros.add("billno");
        removedPros.add("subentryid");
        removedPros.add("entryid");
        removedPros.add("assist");
        removedPros.add("matmodel");
        removedPros.add("group");
        removedPros.add("materialcategory");
        return !removedPros.contains(split[0]);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("printview".equals(key)) {
            this.printOperation();
        }
    }

    private void printOperation() {
        try {
            String templeteId;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
            HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)this.getView().getEntityId(), (String)"4730fc9e000000ac");
            boolean hasAll = rs.hasAllOrgPerm();
            List hasPermOrgs = rs.getHasPermOrgs();
            if (this.getModel().getValue("mulcalorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"StockDetailRptFormPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            Object calOrg = this.getModel().getValue("mulcalorg");
            DynamicObjectCollection calOrgs = (DynamicObjectCollection)calOrg;
            HashSet<Long> orgs = new HashSet<Long>();
            for (Object calOrgDynamic : calOrgs) {
                orgs.add(calOrgDynamic == null ? 0L : calOrgDynamic.getDynamicObject("fbasedataid").getLong("id"));
            }
            HashSet<Long> noPermOrgIds = new HashSet<Long>(16);
            for (Long id : orgs) {
                if (hasAll || hasPermOrgs == null || hasPermOrgs.contains(id)) continue;
                noPermOrgIds.add(id);
            }
            if (noPermOrgIds.size() > 0) {
                logger.info("print user has no permission==>{}", noPermOrgIds);
                return;
            }
            ReportView rptFormView = (ReportView)this.getExportAllView();
            if (rptFormView == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
            int rowCount = listModel.getRowCount();
            if (rowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String formId = "cal_saledetail_newrpt";
            Object defaultTemplateId = PrintHelper.getDefaultTemplateId((String)formId);
            if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"StockDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String printName = formId + "_printsetting";
            String curPrintPattern = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)printName);
            Map printSetting = null;
            if (!StringUtils.isEmpty((String)curPrintPattern)) {
                printSetting = (Map)SerializationUtils.fromJsonString((String)curPrintPattern, Map.class);
            }
            if (defaultTemplateId == null && (printSetting == null || printSetting.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String string = printSetting == null || StringUtils.isEmpty((String)((String)printSetting.get("templateid"))) ? (defaultTemplateId == null ? null : defaultTemplateId.toString()) : (templeteId = (String)printSetting.get("templateid"));
            if (StringUtils.isEmpty((String)templeteId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            PrintWork work = new PrintWork();
            PrintTask task = new PrintTask();
            task.setTplId(templeteId);
            task.setPageId(listModel.getPageId());
            task.setFormId("cal_saledetail_newrpt");
            task.setPrintType("report");
            task.setPkIds(null);
            work.setTaskList(Collections.singletonList(task));
            work.setPrintLang(RequestContext.get().getLang().getLangTag());
            work.setExpType("pdf");
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
            String url = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
            url = String.format(url, prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            logger.error("SaleDetailRptFormPlugin printOperation", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u53ef\u80fd\u8d85\u65f6\u4e86\uff0c\u8bf7\u8bd5\u7740\u70b9\u4e0b\u5237\u65b0\u6309\u94ae\u3002", (String)"StockDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
    }

    public IFormView getExportAllView() {
        ReportQueryParam queryParam = this.getQueryParam();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        this.asyncQuery(queryParam, reportList, null);
        return reportList.getView();
    }

    private void asyncQuery(ReportQueryParam queryParam, ReportList reportList, String materialIds) {
        IReportCache var13 = ReportCacheManager.getInstance().getCache();
        var13.setReportQueryParam(this.getView().getPageId(), queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)reportList.getReportModel();
        reportModel.setPageId(this.getView().getPageId());
        reportList.setAsynQuery(true);
        reportList.submitTask(queryParam, (Object)materialIds);
    }
}

