/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.function;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class CalPeriodEndGroupFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public CalPeriodEndGroupFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int periodInQtyIdx = this.rowMeta.getFieldIndex("periodinqty");
        int periodInAmountIdx = this.rowMeta.getFieldIndex("periodinamount");
        int periodWFQtyIdx = this.rowMeta.getFieldIndex("periodwriteoffqty");
        int periodWFAmountIdx = this.rowMeta.getFieldIndex("periodwriteoffamount");
        int beforePDQtyIdx = this.rowMeta.getFieldIndex("beforeperiodqty");
        int beforePDAmountIdx = this.rowMeta.getFieldIndex("beforeperiodamount");
        BigDecimal preRowQty = null;
        BigDecimal preRowAmount = null;
        DataSet dataSet = this.createDataSet(iterable, this.rowMeta);
        dataSet = dataSet.orderBy(new String[]{"period", "beginrow desc", "bookdate", "auditdate", "billno", "entryid"});
        for (Row row : dataSet) {
            RowX rowX = this.getRowx(row);
            preRowQty = preRowQty == null ? rowX.getBigDecimal(beforePDQtyIdx) : preRowQty.add(rowX.getBigDecimal(periodInQtyIdx)).subtract(rowX.getBigDecimal(periodWFQtyIdx));
            rowX.set(beforePDQtyIdx, (Object)preRowQty);
            preRowAmount = preRowAmount == null ? rowX.getBigDecimal(beforePDAmountIdx) : preRowAmount.add(rowX.getBigDecimal(periodInAmountIdx)).subtract(rowX.getBigDecimal(periodWFAmountIdx));
            rowX.set(beforePDAmountIdx, (Object)preRowAmount);
            collector.collect(rowX);
        }
    }

    public DataSet createDataSet(Iterable<RowX> iterable, RowMeta rowMeta) {
        Algo algo = Algo.create((String)"kd.fi.cal.report.newreport.saleestimatedtlrpt.function.CalPeriodEndGroupFunction");
        Iterator<RowX> funcIterator = iterable.iterator();
        return algo.createDataSet((Iterator)new RowXIterator(funcIterator), rowMeta);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }

    private static class RowXIterator
    implements Iterator<Object[]>,
    Serializable {
        private static final long serialVersionUID = -8990351274825611328L;
        private Iterator<RowX> iterable;

        RowXIterator(Iterator<RowX> iterable) {
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.iterable.hasNext();
        }

        @Override
        public Object[] next() {
            return this.iterable.next().values();
        }
    }
}

