/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptParam;

public class CalPriceMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public CalPriceMapFunction(RowMeta rowMeta, EstimateDtlRptParam reportParam) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int beforePDPriceIdx = this.rowMeta.getFieldIndex("beforeperiodprice");
        int periodInPriceIdx = this.rowMeta.getFieldIndex("periodinprice");
        int periodWFPriceIdx = this.rowMeta.getFieldIndex("periodwriteoffprice");
        int periodNotWFPriceIdx = this.rowMeta.getFieldIndex("periodnotwriteoffprice");
        int beforePDQtyIdx = this.rowMeta.getFieldIndex("beforeperiodqty");
        int periodInQtyIdx = this.rowMeta.getFieldIndex("periodinqty");
        int periodWFQtyIdx = this.rowMeta.getFieldIndex("periodwriteoffqty");
        int periodNotWFQtyIdx = this.rowMeta.getFieldIndex("periodnotwriteoffqty");
        int beforePDAmountIdx = this.rowMeta.getFieldIndex("beforeperiodamount");
        int periodInAmountIdx = this.rowMeta.getFieldIndex("periodinamount");
        int periodWFAmountIdx = this.rowMeta.getFieldIndex("periodwriteoffamount");
        int periodNotWFAmountIdx = this.rowMeta.getFieldIndex("periodnotwriteoffamount");
        BigDecimal beforePDQty = rowX.getBigDecimal(beforePDQtyIdx);
        BigDecimal periodInQty = rowX.getBigDecimal(periodInQtyIdx);
        BigDecimal periodWFQty = rowX.getBigDecimal(periodWFQtyIdx);
        BigDecimal periodNotWFQty = rowX.getBigDecimal(periodNotWFQtyIdx);
        BigDecimal beforePDAmount = rowX.getBigDecimal(beforePDAmountIdx);
        BigDecimal periodInAmount = rowX.getBigDecimal(periodInAmountIdx);
        BigDecimal periodWFAmount = rowX.getBigDecimal(periodWFAmountIdx);
        BigDecimal periodNotWFAmount = rowX.getBigDecimal(periodNotWFAmountIdx);
        if (beforePDQty.compareTo(BigDecimal.ZERO) != 0) {
            rowX.set(beforePDPriceIdx, (Object)beforePDAmount.divide(beforePDQty, 10, RoundingMode.HALF_UP));
        }
        if (periodInQty.compareTo(BigDecimal.ZERO) != 0) {
            rowX.set(periodInPriceIdx, (Object)periodInAmount.divide(periodInQty, 10, RoundingMode.HALF_UP));
        }
        if (periodWFQty.compareTo(BigDecimal.ZERO) != 0) {
            rowX.set(periodWFPriceIdx, (Object)periodWFAmount.divide(periodWFQty, 10, RoundingMode.HALF_UP));
        }
        if (periodNotWFQty.compareTo(BigDecimal.ZERO) != 0) {
            rowX.set(periodNotWFPriceIdx, (Object)periodNotWFAmount.divide(periodNotWFQty, 10, RoundingMode.HALF_UP));
        }
        return rowX;
    }
}

