/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.function;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class CalculateInitDataGroupFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public CalculateInitDataGroupFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int initqtyIdx = this.rowMeta.getFieldIndex("initqty");
        int initamountIdx = this.rowMeta.getFieldIndex("initamount");
        BigDecimal initQty = BigDecimal.ZERO;
        BigDecimal initAmount = BigDecimal.ZERO;
        DataSet dataSet = this.createDataSet(iterable, this.rowMeta);
        dataSet = dataSet.orderBy(new String[]{"allperiod"});
        for (Row row : dataSet) {
            RowX rowX = this.getRowx(row);
            BigDecimal rowInitQty = rowX.getBigDecimal(initqtyIdx);
            BigDecimal rowInitAmount = rowX.getBigDecimal(initamountIdx);
            if (rowInitQty == null) {
                rowInitQty = BigDecimal.ZERO;
            }
            if (rowInitAmount == null) {
                rowInitAmount = BigDecimal.ZERO;
            }
            initQty = rowInitQty.add(initQty);
            initAmount = rowInitAmount.add(initAmount);
            rowX.set(initqtyIdx, (Object)initQty);
            rowX.set(initamountIdx, (Object)initAmount);
            collector.collect(rowX);
        }
    }

    public DataSet createDataSet(Iterable<RowX> iterable, RowMeta rowMeta) {
        Algo algo = Algo.create((String)"kd.fi.cal.report.newreport.saleestimatedtlrpt.function.CalculateInitDataGroupFunction");
        Iterator<RowX> funcIterator = iterable.iterator();
        return algo.createDataSet((Iterator)new RowXIterator(funcIterator), rowMeta);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }

    private static class RowXIterator
    implements Iterator<Object[]>,
    Serializable {
        private static final long serialVersionUID = -8990351274825611328L;
        private Iterator<RowX> iterable;

        RowXIterator(Iterator<RowX> iterable) {
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.iterable.hasNext();
        }

        @Override
        public Object[] next() {
            return this.iterable.next().values();
        }
    }
}

