/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptHelper;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptParam;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.FinalDataOrderTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.transform.AddMaterialGroupTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.transform.AddSumRowDataxTransfrom;
import kd.fi.cal.report.newreport.estimatedtlrpt.transform.AllBolckDataXTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.transform.BeforePeriodAndInitDataxTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.transform.CalPriceDataXTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.transform.PeriodNotWFDataxTransform;

public class StockEstimateDtlRptHandle
implements IReportDataHandle {
    private EstimateDtlRptParam rptParam;
    private static final String[] order = new String[]{"calorg", "costaccount", "material", "sumrow", "period", "beginrow desc", "periodsumrow", "bookdate", "auditdate", "billno", "entryid"};

    public void setupCtx(ReportDataCtx ctx) {
        ctx.setSumKeyCols(null);
        ctx.setSumKeyCols(null);
        ctx.setSumKeyCols4Count(null);
        this.rptParam = (EstimateDtlRptParam)ctx.getParam(EstimateDtlRptParam.class.getName());
        Set dimFieldSet = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        StringBuilder fieldBuild = new StringBuilder();
        for (String dimField : dimFieldSet) {
            fieldBuild.append(dimField);
            fieldBuild.append(',');
        }
        String finalGroupFields = CommonUtils.trimComma((String)fieldBuild.toString());
        if (!this.rptParam.isNotShowMaterialGroup()) {
            finalGroupFields = finalGroupFields + ",group";
        }
        finalGroupFields = finalGroupFields + ",entryid";
        this.rptParam.setFinalGroupFields(finalGroupFields);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(this.getMatCategories());
            ctx.setFixedFs(list);
        } else {
            fixedFs.add(this.getMatCategories());
        }
    }

    private QFilter getMatCategories() {
        QFilter filter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (this.rptParam.getMatcategory() != null && this.rptParam.getMatcategory().size() > 0) {
            filter.and("material", "in", this.rptParam.getMaterialByMaterialCategory());
        }
        return filter;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        ArrayList<SrcBlockConf> resultBlocks = new ArrayList<SrcBlockConf>(16);
        for (SrcBlockConf blockConf : blockCollector) {
            Map repoColFullSrcColMap;
            srcEntity = blockConf.getSrcEntity();
            this.setMoreBlockField(srcEntity, blockConf);
            if ("cal_costrecord_subentity".equals(srcEntity)) {
                QFilter baseQ = EstimateDtlRptHelper.getBaseFilter(this.rptParam, true, false);
                QFilter periodInQ = EstimateDtlRptHelper.getPeriodInFilter(baseQ.copy(), this.rptParam);
                QFilter periodWFQ = EstimateDtlRptHelper.getPeriodWFFilter(baseQ.copy(), this.rptParam);
                QFilter periodNotWFQ = EstimateDtlRptHelper.getPeriodNotWFFilter(baseQ.copy(), this.rptParam);
                QFilter periodSonWFWFQ = EstimateDtlRptHelper.getPeriodSonWFFilter(baseQ.copy(), this.rptParam);
                QFilter beforePeriodInAQ = EstimateDtlRptHelper.getBeforePeriodInAFilter(baseQ.copy(), this.rptParam);
                QFilter beforePeriodInBQ = EstimateDtlRptHelper.getBeforePeriodInBFilter(baseQ.copy(), this.rptParam);
                QFilter beforePeriodWFAQ = EstimateDtlRptHelper.getBeforePeriodWFAFilter(baseQ.copy(), this.rptParam);
                QFilter beforePeriodWFBQ = EstimateDtlRptHelper.getBeforePeriodWFBFilter(baseQ.copy(), this.rptParam);
                QFilter initQ = EstimateDtlRptHelper.getInitFilter(baseQ.copy(), this.rptParam);
                Map srcColMap = blockConf.getRepoColSrcColMap();
                srcColMap.put("entryid", "entryid");
                blockConf.setRepoColSrcColMap(srcColMap);
                repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                repoColFullSrcColMap.put("entryid", "entry.id");
                blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                srcColMap = blockConf.getRepoColSrcColMap();
                srcColMap.put("billid", "billid");
                blockConf.setRepoColSrcColMap(srcColMap);
                repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                repoColFullSrcColMap.put("billid", "id");
                blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                this.addBlockConf(periodInQ, "periodOut", blockConf, resultBlocks, ctx);
                this.addBlockConf(periodWFQ, "periodWF", blockConf, resultBlocks, ctx);
                this.addBlockConf(periodNotWFQ, "periodNotWF", blockConf, resultBlocks, ctx);
                this.addBlockConf(periodSonWFWFQ, "periodSonWF", blockConf, resultBlocks, ctx);
                this.addBlockConf(beforePeriodInAQ, "beforePDOut", blockConf, resultBlocks, ctx);
                this.addBlockConf(beforePeriodInBQ, "beforePDOut", blockConf, resultBlocks, ctx);
                this.addBlockConf(beforePeriodWFAQ, "beforePDWF", blockConf, resultBlocks, ctx);
                this.addBlockConf(beforePeriodWFBQ, "beforePDWF", blockConf, resultBlocks, ctx);
                this.addBlockConf(initQ, "periodInit", blockConf, resultBlocks, ctx);
                continue;
            }
            if (!"cal_costadjust_subentity".equals(srcEntity) && !"cal_stdcostdiffbill".equals(srcEntity) || !this.rptParam.iscontainadjustbill()) continue;
            repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.put("supplier", "custsupplier");
            repoColFullSrcColMap.put("suppliernum", "custsupplier.number");
            blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
            QFilter adjustQ = EstimateDtlRptHelper.getBaseFilter(this.rptParam, false, false);
            if ("cal_costadjust_subentity".equals(srcEntity)) {
                adjustQ.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
            }
            this.addBlockConf(adjustQ, "adjustbill", blockConf, resultBlocks, ctx);
        }
        ctx.getReportConf().setSrcBlockConf(resultBlocks);
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new AddMaterialGroupTransform(this.rptParam, ctx));
        transCollector.add(new PeriodNotWFDataxTransform(this.rptParam, ctx));
        transCollector.add(new BeforePeriodAndInitDataxTransform(this.rptParam, ctx));
        transCollector.add(new AddSumRowDataxTransfrom(this.rptParam, ctx));
        transCollector.add(new CalPriceDataXTransform(this.rptParam, ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new FinalDataOrderTransform(order));
        this.rptParam.closeMaterialCategory();
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        for (AbstractReportColumn col : cols) {
            ReportColumn rptCol;
            if (!(col instanceof ReportColumn) || !(rptCol = (ReportColumn)col).getFieldKey().equals("billno")) continue;
            rptCol.setHyperlink(true);
        }
        EstimateDtlRptHelper.createDecimalColumns(cols, false);
        EstimateDtlRptHelper.createHideColumns(cols);
        return cols;
    }

    private void addBlockConf(QFilter q, String blockFlag, SrcBlockConf blockConf, List<SrcBlockConf> resultBlocks, ReportDataCtx ctx) {
        SrcBlockConf srcBlockConf = new SrcBlockConf();
        srcBlockConf.setDefVals(blockConf.getDefVals());
        srcBlockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        srcBlockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        srcBlockConf.setSrcEntity(blockConf.getSrcEntity());
        srcBlockConf.setType(blockConf.getType());
        QFilter uniondataFs = srcBlockConf.getDataFs();
        if (uniondataFs != null) {
            q.and(uniondataFs);
        }
        srcBlockConf.setDataFs(q);
        List periodOutTransForm = srcBlockConf.getDataTransform();
        if (periodOutTransForm != null) {
            periodOutTransForm.add(new AllBolckDataXTransform(this.rptParam, blockFlag, ctx));
        }
        srcBlockConf.setAllowNotMatch(true);
        resultBlocks.add(srcBlockConf);
    }

    private void setMoreBlockField(String entityNum, SrcBlockConf blockConf) {
        String adjustSupplierName = "custsupplier";
        if ("cal_costadjust_subentity".equals(entityNum)) {
            Map srcColMap = blockConf.getRepoColSrcColMap();
            srcColMap.put("supplier", "supplier");
            blockConf.setRepoColSrcColMap(srcColMap);
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.put("supplier", adjustSupplierName);
            blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        }
    }
}

