/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.transform;

import java.util.HashSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptParam;

public class AddMaterialGroupTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private EstimateDtlRptParam reportParam;

    public AddMaterialGroupTransform(EstimateDtlRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.reportParam.isNotShowMaterialGroup()) {
            return srcData;
        }
        Object pkValue = 730148448254487552L;
        DynamicObject materialgroupstandard = this.reportParam.getMaterialgroupstandard();
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        DynamicObjectCollection materialgroup = this.reportParam.getMulmaterialgroup();
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(ReportUtil.getGroupFilter((DynamicObjectCollection)materialgroup, (boolean)false, (String)"group.longnumber"));
        }
        OrmInput input = new OrmInput("handleMaterialGroup", "bd_materialgroupdetail", "group,group.number as groupnumber,material,material.number as materialnumber,material.materialtype as materialtype", filter.toArray());
        DataSetX groupData = this.ctx.getCurrentJob().fromInput((Input)input);
        QFilter materialNumberFilter = this.getMaterialFromToFilter();
        if (materialNumberFilter != null) {
            String materialNumberFilterStr = materialNumberFilter.toString();
            groupData = groupData.filter(materialNumberFilterStr);
        }
        HashSet<String> leftFieldSet = new HashSet<String>(16);
        for (String field : srcData.getRowMeta().getFieldNames()) {
            if ("group".equals(field)) continue;
            leftFieldSet.add(field);
        }
        srcData = srcData.join(groupData).on("material", "material").select(leftFieldSet.toArray(new String[0]), new String[]{"group"});
        return srcData;
    }

    private QFilter getMaterialFromToFilter() {
        DynamicObjectCollection materialfrom = this.reportParam.getMaterialFrom();
        if (materialfrom != null) {
            if (materialfrom.size() == 0) {
                return null;
            }
            if (materialfrom.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : materialfrom) {
                    idSet.add(from.getDynamicObject("fbasedataid").get("number"));
                }
                return new QFilter("materialNumber", "in", idSet);
            }
            DynamicObject from = ((DynamicObject)materialfrom.get(0)).getDynamicObject("fbasedataid");
            DynamicObject to = this.reportParam.getMaterialTo();
            QFilter filter = new QFilter("materialNumber", ">=", from.get("number"));
            if (to != null) {
                filter.and("materialNumber", "<=", to.get("number"));
            }
            return filter;
        }
        DynamicObject to = this.reportParam.getMaterialTo();
        QFilter filter = null;
        if (to != null) {
            filter = new QFilter("materialNumber", "<=", to.get("number"));
        }
        return filter;
    }
}

