/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.transform;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptParam;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.BeforePeriodSumRowGroupFunction;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.CalBeforePeriodMapFunction;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.CalInitDataMapFunction;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.CalPeriodEndGroupFunction;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.CalculateInitDataGroupFunction;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.NullToZeroMapFunction;

public class BeforePeriodAndInitDataxTransform
implements IDataXTransform {
    private EstimateDtlRptParam rptParam;
    private ReportDataCtx ctx;

    public BeforePeriodAndInitDataxTransform(EstimateDtlRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.rptParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSetX initSetX = srcData.filter("blockflag = 'periodInit'");
        DataSetX beforePDOutSetX = srcData.filter("blockflag = 'beforePDOut'");
        DataSetX beforePDWFSetX = srcData.filter("blockflag = 'beforePDWF'");
        DataSetX dataSetX = srcData.filter("blockflag != 'beforePDOut' and blockflag != 'beforePDWF' and blockflag != 'periodInit'");
        dataSetX = dataSetX.groupBy(this.rptParam.getFinalGroupFields().split(",")).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").min("auditdate");
        dataSetX = dataSetX.addFields(new Field[]{new Field("beginrow", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        beforePDOutSetX = beforePDOutSetX.groupBy(new String[]{"calorg", "costaccount", "material"}).sum("beforeperiodqty").sum("beforeperiodamount");
        beforePDWFSetX = beforePDWFSetX.groupBy(new String[]{"calorg", "costaccount", "material"}).sum("beforeperiodwfqty").sum("beforeperiodwfamount");
        JoinDataSetX beforeSetX = beforePDOutSetX.leftJoin(beforePDWFSetX).on("calorg", "calorg").on("costaccount", "costaccount").on("material", "material").select(new String[]{"calorg", "costaccount", "material", "beforeperiodqty", "beforeperiodamount"}, new String[]{"beforeperiodwfqty", "beforeperiodwfamount"});
        beforeSetX = beforeSetX.map((MapFunction)new NullToZeroMapFunction(beforeSetX.getRowMeta(), new String[]{"beforeperiodwfqty", "beforeperiodwfamount"}));
        beforeSetX = beforeSetX.map((MapFunction)new CalBeforePeriodMapFunction(beforeSetX.getRowMeta()));
        beforeSetX = beforeSetX.addFields(new Field[]{new Field("beginrow", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ONE});
        DataSetX beginDataSetX = dataSetX.filter("periodinqty <> 0 or periodinamount <>0 or periodwriteoffqty<>0 or periodwriteoffamount <> 0 or periodnotwriteoffqty <>0 or periodnotwriteoffamount<>0");
        beginDataSetX = beginDataSetX.groupBy(new String[]{"calorg", "costaccount", "material", "period"}).reduceGroup((GroupReduceFunction)new BeforePeriodSumRowGroupFunction(beginDataSetX.getRowMeta()));
        dataSetX = dataSetX.union(beginDataSetX);
        dataSetX = dataSetX.leftJoin((DataSetX)beforeSetX).on("calorg", "calorg").on("costaccount", "costaccount").on("material", "material").on("beginrow", "beginrow").select(dataSetX.getRowMeta().getFieldNames(), new String[]{"beforeperiodqty", "beforeperiodamount"});
        dataSetX = dataSetX.map((MapFunction)new NullToZeroMapFunction(dataSetX.getRowMeta(), new String[]{"periodinqty", "periodinamount", "periodwriteoffqty", "periodwriteoffamount", "periodnotwriteoffqty", "periodnotwriteoffamount", "beforeperiodqty", "beforeperiodamount"}));
        dataSetX = dataSetX.groupBy(new String[]{"calorg", "costaccount", "material"}).reduceGroup((GroupReduceFunction)new CalPeriodEndGroupFunction(dataSetX.getRowMeta()));
        initSetX = initSetX.groupBy(new String[]{"calorg", "costaccount", "material", "period", "periodtype"}).sum("initqty").sum("initamount");
        DataSetX allPeriodSetX = this.getAllPeriodDataSetX();
        allPeriodSetX = initSetX.leftJoin(allPeriodSetX).on("periodtype", "periodtype").select(new String[]{"calorg", "costaccount", "material", "periodtype"}, new String[]{"allperiod"});
        allPeriodSetX = allPeriodSetX.groupBy(new String[]{"calorg", "costaccount", "material", "allperiod"}).max("periodtype");
        initSetX = allPeriodSetX.leftJoin(initSetX).on("calorg", "calorg").on("costaccount", "costaccount").on("material", "material").on("allperiod", "period").select(new String[]{"calorg", "costaccount", "material", "allperiod"}, new String[]{"initqty", "initamount"});
        initSetX = initSetX.groupBy(new String[]{"calorg", "costaccount", "material"}).reduceGroup((GroupReduceFunction)new CalculateInitDataGroupFunction(initSetX.getRowMeta()));
        dataSetX = dataSetX.leftJoin(initSetX).on("calorg", "calorg").on("costaccount", "costaccount").on("material", "material").on("period", "allperiod").select(dataSetX.getRowMeta().getFieldNames(), new String[]{"initqty", "initamount"});
        dataSetX = dataSetX.map((MapFunction)new NullToZeroMapFunction(dataSetX.getRowMeta(), new String[]{"initqty", "initamount"}));
        dataSetX = dataSetX.map((MapFunction)new CalInitDataMapFunction(dataSetX.getRowMeta()));
        return dataSetX;
    }

    private DataSetX getAllPeriodDataSetX() {
        DataSet accountSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id as accountId,calpolicy.periodtype as periodType", (QFilter[])new QFilter("id", "in", this.rptParam.getCostAccountIdSet()).toArray(), null);
        HashSet<Long> periodTypeIdSet = new HashSet<Long>(16);
        for (Row account : accountSet.copy()) {
            periodTypeIdSet.add(account.getLong("periodType"));
        }
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.rptParam.getStartPeriodNumber()});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ?", (Object[])new Object[]{this.rptParam.getEndPeriodNumber()}));
        q.and("periodtype", "in", periodTypeIdSet);
        q.and("isadjustperiod", "=", (Object)false);
        OrmInput periodInput = new OrmInput(this.getClass().getName(), "bd_period", "id as allperiod,periodtype", q.toArray());
        return this.ctx.getCurrentJob().fromInput((Input)periodInput);
    }
}

