/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatedtlrpt.transform;

import java.util.Arrays;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptParam;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.AllPeriodToPeriodMapFunction;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.NullToZeroMapFunction;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.PeriodNotWriteOffMapFunction;

public class PeriodNotWFDataxTransform
implements IDataXTransform {
    private EstimateDtlRptParam rptParam;
    private ReportDataCtx ctx;

    public PeriodNotWFDataxTransform(EstimateDtlRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.rptParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSetX periodNotWFSetX = srcData.filter("blockflag = 'periodNotWF'");
        DataSetX periodSonWFSetX = srcData.filter("blockflag = 'periodSonWF'");
        DataSetX otherDataSetX = srcData.filter("blockflag != 'periodNotWF' and blockflag != 'periodSonWF'");
        periodSonWFSetX = periodSonWFSetX.join(periodNotWFSetX).on("subentryid", "entryid").select(periodSonWFSetX.getRowMeta().getFieldNames(), new String[0]);
        DataSetX allPeriodSetX = this.getAllPeriodDataSetX();
        JoinDataSetX allDataSetX = allPeriodSetX.leftJoin(periodNotWFSetX).on("periodtype", "periodtype").select(new String[]{"allperiod"}, periodNotWFSetX.getRowMeta().getFieldNames());
        allDataSetX = allDataSetX.filter("period <= allperiod and (writeoffendperiod = 0 or writeoffendperiod > allperiod)");
        allDataSetX = allDataSetX.map((MapFunction)new AllPeriodToPeriodMapFunction(allDataSetX.getRowMeta()));
        HashSet<String> selectFields = new HashSet<String>(Arrays.asList(allDataSetX.getRowMeta().getFieldNames()));
        selectFields.remove("writeoffperiod");
        selectFields.remove("periodwriteoffqty");
        selectFields.remove("periodwriteoffamount");
        JoinDataSetX joinDataSetX = allDataSetX.leftJoin(periodSonWFSetX).on("entryid", "subentryid").select(selectFields.toArray(new String[0]), new String[]{"writeoffperiod", "periodwriteoffqty", "periodwriteoffamount"});
        joinDataSetX = joinDataSetX.filter("writeoffperiod = null or writeoffperiod <= allperiod");
        joinDataSetX = joinDataSetX.map((MapFunction)new NullToZeroMapFunction(joinDataSetX.getRowMeta(), new String[]{"periodwriteoffqty", "periodwriteoffamount"}));
        allDataSetX = allDataSetX.union(joinDataSetX.select(allDataSetX.getRowMeta().getFieldNames())).select(otherDataSetX.getRowMeta().getFieldNames());
        selectFields = new HashSet<String>(Arrays.asList(allDataSetX.getRowMeta().getFieldNames()));
        selectFields.remove("writeoffperiod");
        selectFields.remove("periodinqty");
        selectFields.remove("periodinamount");
        selectFields.remove("periodwriteoffqty");
        selectFields.remove("periodwriteoffamount");
        selectFields.remove("auditdate");
        allDataSetX = allDataSetX.groupBy(selectFields.toArray(new String[0])).max("periodinqty").max("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").min("auditdate");
        allDataSetX = allDataSetX.map((MapFunction)new PeriodNotWriteOffMapFunction(allDataSetX.getRowMeta()));
        allDataSetX = allDataSetX.filter("periodnotwriteoffqty <> 0 or periodnotwriteoffamount <> 0");
        otherDataSetX = otherDataSetX.select(allDataSetX.getRowMeta().getFieldNames());
        otherDataSetX = allDataSetX.union(otherDataSetX);
        return otherDataSetX;
    }

    private DataSetX getAllPeriodDataSetX() {
        DataSet accountSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id as accountId,calpolicy.periodtype as periodType", (QFilter[])new QFilter("id", "in", this.rptParam.getCostAccountIdSet()).toArray(), null);
        HashSet<Long> periodTypeIdSet = new HashSet<Long>(16);
        for (Row account : accountSet) {
            periodTypeIdSet.add(account.getLong("periodType"));
        }
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.rptParam.getStartPeriodNumber()});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ?", (Object[])new Object[]{this.rptParam.getEndPeriodNumber()}));
        q.and("periodtype", "in", periodTypeIdSet);
        q.and("isadjustperiod", "=", (Object)false);
        OrmInput periodInput = new OrmInput(this.getClass().getName(), "bd_period", "id as allperiod,periodtype", q.toArray());
        return this.ctx.getCurrentJob().fromInput((Input)periodInput);
    }
}

