/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumConsts;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;

public class EstimateSumRptHelper {
    private static final LocaleString width = new LocaleString("100px");

    public static String[] getSumFields(EstimateSumRptParam rptParam) {
        HashSet<String> sumFileds = new HashSet<String>(16);
        for (String keyCol : rptParam.getShowKeyCols().split(",")) {
            sumFileds.add(keyCol);
        }
        if (rptParam.isIsshowsubrow4MatGroup() && rptParam.getMgFieldList() != null && !rptParam.getMgFieldList().isEmpty()) {
            sumFileds.addAll(rptParam.getMgFieldList());
        }
        return sumFileds.toArray(new String[0]);
    }

    public static String[] getSumFieldsNoPeriod(EstimateSumRptParam rptParam) {
        HashSet<String> sumFileds = new HashSet<String>(16);
        for (String keyCol : rptParam.getShowKeyCols().split(",")) {
            if ("period".equals(keyCol)) continue;
            sumFileds.add(keyCol);
        }
        if (rptParam.isIsshowsubrow4MatGroup() && rptParam.getMgFieldList() != null) {
            sumFileds.addAll(rptParam.getMgFieldList());
        }
        return sumFileds.toArray(new String[0]);
    }

    public static QFilter getPeriodOutFilter(QFilter q, EstimateSumRptParam rptParam) {
        q.and("bookdate", "<=", (Object)rptParam.getEndDate());
        q.and(QFilter.of((String)"period >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        q.and(QFilter.of((String)"period <= ?", (Object[])new Object[]{rptParam.getEndPeriod().getPkValue()}));
        q.and("isinitbill", "=", (Object)false);
        q.and("issplitcreate", "=", (Object)false);
        return q;
    }

    public static QFilter getPeriodInFilter(QFilter q, EstimateSumRptParam rptParam) {
        q.and("bookdate", "<=", (Object)rptParam.getEndDate());
        q.and("bookdate", ">=", (Object)rptParam.getStartDate());
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{rptParam.getEndPeriodNumber()}));
        return q;
    }

    public static QFilter getPeriodWFFilter(QFilter q, EstimateSumRptParam rptParam) {
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        q.and(QFilter.of((String)"writeoffperiod <= ?", (Object[])new Object[]{rptParam.getEndPeriod().getPkValue()}));
        return q;
    }

    public static QFilter getBeforePeriodOutFilter(QFilter q, EstimateSumRptParam rptParam, boolean wfEndPeriodZero) {
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period < ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        if (wfEndPeriodZero) {
            q.and(QFilter.of((String)"writeoffendperiod = ?", (Object[])new Object[]{0L}));
        } else {
            q.and(QFilter.of((String)"writeoffendperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        }
        return q;
    }

    public static QFilter getBeforePeriodInFilter(QFilter q, EstimateSumRptParam rptParam) {
        q.and("bookdate", "<", (Object)rptParam.getStartDate());
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period < ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        return q;
    }

    public static QFilter getBeforePeriodWFFilter(QFilter q, EstimateSumRptParam rptParam) {
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        return q;
    }

    public static QFilter getBeforePeriodWFFilter(QFilter q, EstimateSumRptParam rptParam, boolean wfEndPeriodZero) {
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod < ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        if (wfEndPeriodZero) {
            q.and(QFilter.of((String)"writeoffendperiod = ?", (Object[])new Object[]{0L}));
        } else {
            q.and(QFilter.of((String)"writeoffendperiod >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        }
        return q;
    }

    public static QFilter getInitFilter(QFilter q, EstimateSumRptParam rptParam) {
        q.and("bookdate", "<=", (Object)rptParam.getEndDate());
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)true);
        q.and(QFilter.of((String)"period >= ?", (Object[])new Object[]{rptParam.getStartPeriodId()}));
        q.and(QFilter.of((String)"period <= ?", (Object[])new Object[]{rptParam.getEndPeriod().getPkValue()}));
        return q;
    }

    public static QFilter getBaseFilter(EstimateSumRptParam rptParam, boolean isRecord, boolean isSale) {
        HashSet<Object> set;
        Set<Long> costAccountIdSet = rptParam.getCostAccountIdSet();
        Set<Long> warehsGroupSet = rptParam.getWarehsGroupSet();
        String ownerType = rptParam.getOwnertype();
        DynamicObjectCollection owner = rptParam.getOwner();
        DynamicObjectCollection customer = rptParam.getCustomer();
        DynamicObjectCollection supplier = rptParam.getSupplier();
        DynamicObjectCollection storageOrg = rptParam.getStorageOrg();
        DynamicObjectCollection warehouse = rptParam.getWarehouse();
        DynamicObjectCollection location = rptParam.getLocation();
        DynamicObjectCollection matCategory = rptParam.getMatcategory();
        DynamicObjectCollection materialFrom = rptParam.getMaterialFrom();
        DynamicObject materialTo = rptParam.getMaterialTo();
        String entryName = "entry";
        if (!isRecord) {
            entryName = "entryentity";
        }
        QFilter q = new QFilter("costaccount", "in", costAccountIdSet);
        if (!"".equals(ownerType)) {
            q.and(entryName + ".ownertype", "=", (Object)ownerType);
        }
        if (owner != null && !owner.isEmpty()) {
            set = new HashSet<Object>(8);
            for (DynamicObject info : owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".owner", "in", set);
        }
        if (customer != null && !customer.isEmpty()) {
            set = new HashSet(8);
            for (DynamicObject info : customer) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (isRecord) {
                q.and(entryName + ".balancecustomer", "in", set);
            } else {
                q.and("customer", "in", set);
            }
        }
        if (supplier != null && !supplier.isEmpty()) {
            set = new HashSet(8);
            for (DynamicObject info : supplier) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (isRecord) {
                q.and(entryName + ".balancesupplier", "in", set);
            } else {
                q.and("custsupplier", "in", set);
            }
        }
        if (storageOrg != null && !storageOrg.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (isRecord) {
                q.and("storageorgunit", "in", set);
            } else {
                q.and(entryName + ".storageorgunit", "in", set);
            }
        }
        if (!warehsGroupSet.isEmpty()) {
            q.and(entryName + ".warehouse.group", "in", warehsGroupSet);
        }
        if (warehouse != null && !warehouse.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".warehouse", "in", set);
        }
        if (location != null && !location.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : location) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".location", "in", set);
        }
        if (matCategory != null && !matCategory.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : matCategory) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entryName + ".stocktype", "in", set);
        }
        if (materialFrom != null && !materialFrom.isEmpty()) {
            if (materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject material : materialFrom) {
                    materialSet.add(material.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and(entryName + ".material.id", "in", materialSet);
            } else if (materialFrom.size() == 1) {
                q.and(entryName + ".material.number", ">=", (Object)((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (materialTo != null) {
            q.and(entryName + ".material.number", "<=", (Object)materialTo.getString("number"));
        }
        q.and("billstatus", "=", (Object)"C");
        if (isRecord) {
            Set notUpdBalBizType;
            if (rptParam.getDischargeType() != null) {
                q.and("dischargetype", "in", (Object)rptParam.getDischargeType());
            }
            if ((notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType()) != null && !notUpdBalBizType.isEmpty()) {
                q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
            }
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            HashSet<Object> bizObjectSet = new HashSet<Object>(16);
            if (isSale) {
                q.and("calbilltype", "=", (Object)"OUT");
                DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("outsplitebiztype");
                for (DynamicObject bizobject : bizobjects) {
                    bizObjectSet.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
                }
            } else {
                DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("purbiztype");
                DynamicObjectCollection ominBizobjects = setting.getDynamicObjectCollection("ominbiztype");
                bizobjects.addAll((Collection)ominBizobjects);
                for (DynamicObject bizobject : bizobjects) {
                    bizObjectSet.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
                }
            }
            q.and("bizentityobject", "in", bizObjectSet);
        } else {
            Set<Long> recordIdSet = EstimateSumRptHelper.getRecordSonIdSet(rptParam);
            if (recordIdSet.isEmpty()) {
                return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            }
            q.and(entryName + ".invbillid", "in", recordIdSet);
            q.and("biztype", "=", (Object)"A");
            q.and("createtype", "in", (Object)new String[]{"B", "U"});
            q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
            q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{rptParam.getEndPeriodNumber()}));
        }
        return q;
    }

    public static EstimateSumRptParam buildRptParam(IDataModel model) {
        String sumKey;
        String dischargeType;
        Set allFields = model.getDataEntityType().getAllFields().keySet();
        DynamicObject dataEntity = model.getDataEntity(true);
        EstimateSumRptParam rptParam = new EstimateSumRptParam();
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            rptParam.setCalOrgIdSet(calOrgIds);
        }
        DynamicObjectCollection costAccounts = new DynamicObjectCollection();
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        HashSet<Long> costaccountIdSet = new HashSet<Long>(costaccounts.size());
        for (DynamicObject costaccount : costaccounts) {
            DynamicObject costAccount = costaccount.getDynamicObject("fbasedataid");
            costaccountIdSet.add(costAccount.getLong("id"));
            costAccounts.add((Object)costAccount);
        }
        rptParam.setCostAccountIdSet(costaccountIdSet);
        DynamicObject startperiod = dataEntity.getDynamicObject("startperiod");
        rptParam.setStartPeriod(startperiod);
        rptParam.setStartPeriodId(startperiod.getLong("id"));
        rptParam.setStartPeriodNumber(startperiod.getInt("periodyear") * 100 + startperiod.getInt("periodnumber"));
        rptParam.setStartDate(startperiod.getDate("begindate"));
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        rptParam.setEndPeriod(endperiod);
        rptParam.setEndPeriodNumber(endperiod.getInt("periodyear") * 100 + endperiod.getInt("periodnumber"));
        rptParam.setEndDate(endperiod.getDate("enddate"));
        String ownerType = dataEntity.getString("ownertypehead");
        rptParam.setOwnertype(ownerType);
        if (StringUtils.isNotEmpty((String)ownerType)) {
            if ("bos_org".equals(ownerType)) {
                rptParam.setOwner(dataEntity.getDynamicObjectCollection("mulowner"));
            } else if ("bd_supplier".equals(ownerType)) {
                rptParam.setOwner(dataEntity.getDynamicObjectCollection("mulsupplierownerfrom"));
            } else if ("bd_customer".equals(ownerType)) {
                rptParam.setOwner(dataEntity.getDynamicObjectCollection("mulcustomerownerfrom"));
            }
        }
        if (allFields.contains("mulcustomer")) {
            rptParam.setCustomer(dataEntity.getDynamicObjectCollection("mulcustomer"));
        }
        if (allFields.contains("mulsupplier")) {
            rptParam.setSupplier(dataEntity.getDynamicObjectCollection("mulsupplier"));
        }
        rptParam.setStorageOrg(dataEntity.getDynamicObjectCollection("mulstorageorg"));
        rptParam.setWarehouse(dataEntity.getDynamicObjectCollection("mulwarehouse"));
        rptParam.setLocation(dataEntity.getDynamicObjectCollection("mullocation"));
        rptParam.setMaterialFrom(dataEntity.getDynamicObjectCollection("mulmaterial"));
        rptParam.setMaterialTo(dataEntity.getDynamicObject("materialto"));
        rptParam.setMatcategory(dataEntity.getDynamicObjectCollection("mulmatcategory"));
        DynamicObject materialgroupstandard = dataEntity.getDynamicObject("materialgroupstandard");
        rptParam.setMaterialgroupstandard(materialgroupstandard);
        DynamicObjectCollection mulmaterialgroup = dataEntity.getDynamicObjectCollection("mulmaterialgroup");
        rptParam.setMulmaterialgroup(mulmaterialgroup);
        rptParam.setLevel(0);
        if (allFields.contains("level")) {
            rptParam.setLevel(dataEntity.getInt("level"));
        }
        rptParam.setNotShowMaterialGroup(materialgroupstandard == null && mulmaterialgroup.isEmpty());
        if (allFields.contains("muldischargetype") && (dischargeType = dataEntity.getString("muldischargetype")) != null && !"".equals(CommonUtils.trimComma((String)dischargeType))) {
            rptParam.setDischargeType(CommonUtils.trimComma((String)dischargeType).split(","));
        }
        String colsStr = CommonUtils.trimComma((String)dataEntity.getString("showkeycols"));
        DynamicObjectCollection owner = dataEntity.getDynamicObjectCollection("mulowner");
        boolean isshowsubrow4MatGroup = EstimateSumRptHelper.isShowSubRow4MatGroup(colsStr);
        rptParam.setIsshowsubrow4MatGroup(isshowsubrow4MatGroup);
        StringBuilder showKeyColBuild = new StringBuilder(colsStr);
        showKeyColBuild.append(",materialnum");
        showKeyColBuild.append(",period");
        showKeyColBuild.append(",periodtype");
        showKeyColBuild.append(",currency");
        showKeyColBuild.append(",baseunit");
        showKeyColBuild.append(",precision");
        showKeyColBuild.append(",amtprecision");
        rptParam.setShowKeyCols(showKeyColBuild.toString());
        String[] showKeyCols = showKeyColBuild.toString().split(",");
        HashSet<String> showKeyColsSet = new HashSet<String>(16);
        for (String showKeyCol : showKeyCols) {
            if (StringUtils.isEmpty((String)showKeyCol)) continue;
            showKeyColsSet.add(showKeyCol);
        }
        rptParam.setShowKeyColsSet(showKeyColsSet);
        rptParam.setShowperiodrow(dataEntity.getBoolean("showperiodrow"));
        rptParam.setOnlyshowsumrow(dataEntity.getBoolean("onlyshowsumrow"));
        rptParam.setTopsumrow(dataEntity.getBoolean("topsumrow"));
        rptParam.setShowsumrow(dataEntity.getBoolean("showsumrow"));
        if (allFields.contains("containadjustbill")) {
            rptParam.setIscontainadjustbill(dataEntity.getBoolean("containadjustbill"));
        }
        if ((sumKey = dataEntity.getString("sumkeycols")) == null) {
            sumKey = "";
        }
        sumKey = CommonUtils.trimComma((String)sumKey);
        String[] sumKeyArray = sumKey.split(",");
        StringBuilder sumKeyBuilder = new StringBuilder();
        HashSet<String> sumKeySet = new HashSet<String>(16);
        for (String sumKeyString : sumKeyArray) {
            if ("".equals(sumKeyString)) continue;
            sumKeyBuilder.append(sumKeyString);
            sumKeyBuilder.append(',');
            sumKeySet.add(sumKeyString);
        }
        sumKey = CommonUtils.trimComma((String)sumKeyBuilder.toString());
        rptParam.setSumkeycols(sumKey);
        rptParam.setSumkeycolSet(sumKeySet);
        rptParam.setIsshowsubrow(!"".equals(sumKey));
        return rptParam;
    }

    public static void createBaseDataColumns(List<AbstractReportColumn> cols) {
        EstimateSumRptHelper.createBaseDataColumn(cols, EstimateSumConsts.GROUP_NAME, "group");
    }

    public static void createMatGoupColumns(EstimateSumRptParam rptParam, List<AbstractReportColumn> cols) {
        if (rptParam.isIsshowsubrow4MatGroup()) {
            int hierarchylevel = rptParam.getLevel();
            String mgIdField = "mgid";
            for (int i = 1; i <= hierarchylevel; ++i) {
                ReportColumn materialGroupId = new ReportColumn();
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_50", (String)"fi-cal-report", (Object[])new Object[0]), i);
                LocaleString locale_materialGroupNum = new LocaleString(msg);
                materialGroupId.setCaption(locale_materialGroupNum);
                materialGroupId.setWidth(width);
                materialGroupId.setFieldKey(mgIdField + i);
                materialGroupId.setFieldType("basedata");
                materialGroupId.setEntityId("bd_materialgroup");
                materialGroupId.setDisplayProp("number");
                ReportColumn materialGroupName = ReportColumn.createBaseDataPropColumn((String)("mgname" + i), (String)(mgIdField + i), (String)"name");
                String msg1 = String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_51", (String)"fi-cal-report", (Object[])new Object[0]), i);
                LocaleString locale_materialGroupName = new LocaleString(msg1);
                materialGroupName.setCaption(locale_materialGroupName);
                materialGroupName.setWidth(width);
                cols.add((AbstractReportColumn)materialGroupId);
                cols.add((AbstractReportColumn)materialGroupName);
            }
        }
    }

    public static void createDecimalColumns(List<AbstractReportColumn> cols, boolean isSale) {
        EstimateSumRptHelper.createDecimalColumn(cols, EstimateSumConsts.BEFORE_PERIOD_NAME, "beforeperiod");
        if (isSale) {
            EstimateSumRptHelper.createDecimalColumn(cols, EstimateSumConsts.PERIOD_OUT_NAME, "periodin");
        } else {
            EstimateSumRptHelper.createDecimalColumn(cols, EstimateSumConsts.PERIOD_IN_NAME, "periodin");
        }
        EstimateSumRptHelper.createDecimalColumn(cols, EstimateSumConsts.PERIOD_WF_NAME, "periodwriteoff");
        EstimateSumRptHelper.createDecimalColumn(cols, EstimateSumConsts.PERIOD_END_NAME, "periodend");
    }

    public static void createHideColumns(List<AbstractReportColumn> cols) {
        for (AbstractReportColumn abstractReportColumn : cols) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            ReportColumn column = (ReportColumn)abstractReportColumn;
            String columnName = column.createColumn().get("dataIndex").toString();
            HashSet<String> hideFields = new HashSet<String>(16);
            hideFields.add("beforeperiodqty");
            hideFields.add("beforeperiodamount");
            hideFields.add("periodinqty");
            hideFields.add("periodinamount");
            hideFields.add("periodwriteoffqty");
            hideFields.add("periodwriteoffamount");
            hideFields.add("periodendqty");
            hideFields.add("periodendamount");
            hideFields.add("periodtype");
            hideFields.add("precision");
            hideFields.add("amtprecision");
            hideFields.add("periodnotwriteoffqty");
            hideFields.add("periodnotwriteoffamount");
            hideFields.add("initqty");
            hideFields.add("initamount");
            if (!hideFields.contains(columnName)) continue;
            column.setHide(true);
        }
    }

    public static void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(EstimateSumConsts.QTY_NAME);
        qty.setWidth(EstimateSumConsts.WIDTH);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunit");
        ReportColumn price = new ReportColumn();
        price.setCaption(EstimateSumConsts.PRICE_NAME);
        price.setWidth(EstimateSumConsts.WIDTH);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currency");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(EstimateSumConsts.AMOUNT_NAME);
        amount.setWidth(EstimateSumConsts.WIDTH);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currency");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
    }

    public static void createBaseDataColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumn matGroup = new ReportColumn();
        matGroup.setCaption(groupName);
        matGroup.setFieldKey(fieldKey);
        matGroup.setFieldType("basedata");
        cols.add((AbstractReportColumn)matGroup);
    }

    public static boolean isShowSubRow4MatGroup(String colsStr) {
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(colsStr.split(",")));
        fieldSet.remove("");
        fieldSet.remove("costaccount");
        fieldSet.remove("calorg");
        fieldSet.remove("material");
        return fieldSet.contains("materialgroup") && fieldSet.size() == 1;
    }

    public static Set<Long> getRecordSonIdSet(EstimateSumRptParam rptParam) {
        HashSet<Long> costRecordAIdSet = new HashSet<Long>(16);
        QFilter recordQ = EstimateSumRptHelper.getBaseFilter(rptParam, true, false);
        recordQ.and("writeoffstatus", "=", (Object)"A");
        recordQ.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber >= ? ", (Object[])new Object[]{rptParam.getStartPeriodNumber()}));
        recordQ.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber <= ?", (Object[])new Object[]{rptParam.getEndPeriodNumber()}));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-record", (String)"cal_costrecord_subentity", (String)"id", (QFilter[])new QFilter[]{recordQ}, null);
        for (Row row : dataSet) {
            costRecordAIdSet.add(row.getLong("id"));
        }
        return costRecordAIdSet;
    }
}

