/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.formplugin;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.PrintHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptHelper;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;

public class StockEstimateSumRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(StockEstimateSumRptForm.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = RequestContext.get().getCurrUserId();
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockestimate_sumrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
        this.resetFilterGrid();
        this.rebuildSumKeyCols();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String sumkey;
        int endPeriodNumber;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        DynamicObjectCollection costaccountList = dataEntity.getDynamicObjectCollection("mulcostaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calOrgList == null || calOrgList.size() == 0 || costaccountList == null || costaccountList.size() == 0 || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        String colsStr = (String)this.getModel().getValue("showkeycols");
        if (StringUtils.isEmpty((String)colsStr)) {
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d26\u7c3f\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        if (startPeriodNumber > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"SalesEstimateGroupRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.getBoolean("onlyshowsumrow") && ((sumkey = dataEntity.getString("sumkeycols")) == null || "".equals(sumkey) || ",,".equals(sumkey))) {
            this.getModel().setValue("sumkeycols", (Object)",material,");
        }
        EstimateSumRptParam rptParam = EstimateSumRptHelper.buildRptParam(model);
        rptParam.setWarehsGroupSet(ReportUtil.getWarehsGroupSet((FilterInfo)this.getQueryParam().getFilter()));
        this.getQueryParam().getCustomParam().put(EstimateSumRptParam.class.getName(), rptParam);
        return super.verifyQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4CalOrg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if ("mulwarehouse".equals(key)) {
            ReportUtil.beforeF7Select4Warehouse((BeforeF7SelectEvent)e, (IDataModel)this.getModel(), (String)"mulcalorg");
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Mulcalorgowner(e);
        } else if ("materialgroupstandard".equals(key)) {
            this.beforeMaterialgroupstandard(e);
        } else if ("mulmaterialgroup".equals(key)) {
            this.beforeF7SelectMaterialGroup(e);
        } else if ("mulsupplier".equals(key)) {
            ReportUtil.beforeF7SelectMulSupplier((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockGatherReportBplatForm_3", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        QFilter q = ReportUtil.getCostAccountNextPeriodOf((DynamicObjectCollection)costaccountList);
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CalOrg(BeforeF7SelectEvent e) {
        Long userId = RequestContext.get().getCurrUserId();
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockestimate_sumrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeMaterialgroupstandard(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        if (calOrgList == null || calOrgList.isEmpty()) {
            return;
        }
        HashSet materialIdSet = new HashSet(16);
        for (DynamicObject calOrg : calOrgList) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
            materialIdSet.addAll(ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", materialIdSet));
    }

    private void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter.and(serviceResponse));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, "mulsupplier", "mulcalorg", "mulcostaccount", "startperiod", "endperiod", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "mulcustomer", "mulowner", "materialgroupstandard", "mulmaterialgroup");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("material".equals(key)) {
                    StockEstimateSumRptForm.this.hyperLinkMaterialNameClick(evt);
                }
            }
        });
    }

    private void hyperLinkMaterialNameClick(HyperLinkClickEvent evt) {
        String[] needSendToDetail;
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = this.getView().getQueryParam().getFilter().clone();
        DynamicObject row = evt.getRowData();
        String colsStr = filter.getString("showkeycols");
        String[] showKeyCols = colsStr.split(",");
        HashSet<String> showKeyColsSet = new HashSet<String>(16);
        for (String showKeyCol : showKeyCols) {
            if (StringUtils.isEmpty((String)showKeyCol)) continue;
            showKeyColsSet.add(showKeyCol);
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "owner")) {
            String ownerType = this.getModel().getDataEntity().getString("ownertypehead");
            DynamicObject info = row.getDynamicObject("owner");
            if ("bos_org".equals(ownerType)) {
                filter.getFilterItem("mulowner").setValue((Object)info);
            } else if ("bd_supplier".equals(ownerType)) {
                filter.getFilterItem("mulsupplierownerfrom").setValue((Object)info);
            } else if ("bd_customer".equals(ownerType)) {
                filter.getFilterItem("mulcustomerownerfrom").setValue((Object)info);
            }
            filter.getFilterItem("ownertypehead").setValue((Object)ownerType);
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "storageorgunit")) {
            filter.getFilterItem("mulstorageorg").setValue((Object)row.getDynamicObject("storageorgunit"));
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "warehousegroup")) {
            DynamicObject warehsgroup = row.getDynamicObject("warehousegroup");
            if (warehsgroup == null) {
                filter.addFilterItem("onlyqueryemptygroup", (Object)true);
            } else {
                filter.getFilterItem("mulwarehsgroup").setValue((Object)warehsgroup);
            }
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "warehouse")) {
            filter.getFilterItem("mulwarehouse").setValue((Object)row.getDynamicObject("warehouse"));
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "location") && row.getString("location") != null && StringUtils.isNotEmpty((String)row.getString("location").trim())) {
            filter.getFilterItem("mullocation").setValue((Object)row.getDynamicObject("location"));
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "supplier")) {
            filter.getFilterItem("mulsupplier").setValue((Object)row.getDynamicObject("supplier"));
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "lot") && row.getString("lot") != null && StringUtils.isNotEmpty((String)row.getString("lot").trim())) {
            filter.addFilterItem("lot", (Object)row.getString("lot"));
        }
        DynamicObject info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_material"));
        info.set("id", row.getDynamicObject("material").get("id"));
        DynamicObjectCollection coll = new DynamicObjectCollection();
        coll.add((Object)info);
        filter.getFilterItem("mulmaterial").setValue((Object)coll);
        filter.getFilterItem("materialto").setValue((Object)info);
        long periodid = row.getDynamicObject("period").getLong("id");
        filter.getFilterItem("startperiod").setValue((Object)periodid);
        filter.getFilterItem("endperiod").setValue((Object)periodid);
        DynamicObject costaccount = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_bd_costaccount"));
        costaccount.set("id", row.getDynamicObject("costaccount").get("id"));
        DynamicObjectCollection costaccountcoll = new DynamicObjectCollection();
        costaccountcoll.add((Object)costaccount);
        filter.getFilterItem("mulcostaccount").setValue((Object)costaccountcoll);
        DynamicObject calOrg = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
        calOrg.set("id", row.getDynamicObject("calorg").get("id"));
        DynamicObjectCollection calOrgcoll = new DynamicObjectCollection();
        calOrgcoll.add((Object)calOrg);
        filter.getFilterItem("mulcalorg").setValue((Object)calOrgcoll);
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "materialcategory")) {
            filter.getFilterItem("mulmatcategory").setValue((Object)row.getDynamicObject("materialcategory"));
        }
        queryParam.setFilter(filter);
        FilterGrid grid = (FilterGrid)this.getControl("commonfs");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)grid.getEntityNumber());
        ArrayList<String> groupKeys = new ArrayList<String>(Arrays.asList(showKeyCols));
        for (String needSend : needSendToDetail = new String[]{"tracknumber"}) {
            if (!groupKeys.contains(needSend)) continue;
            DynamicObject obj = row.getDynamicObject(needSend);
            SimpleFilterRow filterRow = new SimpleFilterRow();
            filterRow.setLogic("0");
            IDataEntityProperty pro = type.findProperty(needSend);
            if (pro instanceof FlexProp) continue;
            boolean isBaseData = pro instanceof BasedataProp;
            String string = needSend = isBaseData ? needSend + ".number" : needSend;
            if (obj == null) {
                filterRow.setFieldName(needSend);
                filterRow.setCompareType(this.getIsNull(pro));
            } else {
                filterRow.setFieldName(needSend);
                filterRow.setCompareType(this.getEqual(pro));
                ArrayList<FilterValue> vals = new ArrayList<FilterValue>(1);
                FilterValue fVal = new FilterValue();
                Object val = row.get(needSend);
                if (pro instanceof DateTimeProp && val instanceof Date) {
                    val = ((DateTimeProp)pro).getDateFormat().format((Date)val);
                }
                fVal.setValue(val);
                vals.add(fVal);
                filterRow.setValue(vals);
            }
            condition.getFilterRow().add(filterRow);
        }
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_stockestimate_dtl_rpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("commonfs", (Object)SerializationUtils.toJsonString((Object)condition));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Names) {
        BasedataEdit f7 = null;
        for (String f7Name : f7Names) {
            f7 = (BasedataEdit)this.getControl(f7Name);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulstorageorg".equals(key)) {
            this.mulStorageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.mulWarehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("showkeycols".equals(key)) {
            this.changedShowKeyCols(e);
            this.rebuildSumKeyCols();
        } else if ("sumkeycols".equals(key)) {
            this.changeSumKeyCols();
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        }
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if ("configuredcode.desc".equals(fieldName) || !this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("calorg");
        removedPros.add("ownertype");
        removedPros.add("owner");
        removedPros.add("customer");
        removedPros.add("supplier");
        removedPros.add("material");
        removedPros.add("materialnum");
        removedPros.add("storageorgunit");
        removedPros.add("warehouse");
        removedPros.add("warehousegroup");
        removedPros.add("location");
        removedPros.add("periodtype");
        removedPros.add("period");
        removedPros.add("blockflag");
        removedPros.add("writeoffstatus");
        removedPros.add("writeoffperiod");
        removedPros.add("baseunit");
        removedPros.add("currency");
        removedPros.add("precision");
        removedPros.add("amtprecision");
        removedPros.add("materialgroup");
        removedPros.add("materialcategory");
        return !removedPros.contains(split[0]);
    }

    private void changedShowKeyCols(PropertyChangedArgs e) {
        String colsStr = "";
        Object keyCols = this.getModel().getValue("showkeycols");
        HashSet<String> colsStrSet = new HashSet<String>(16);
        if (keyCols != null) {
            String[] colsStrs;
            colsStr = (String)keyCols;
            for (String col : colsStrs = colsStr.split(",")) {
                if (StringUtils.isEmpty((String)col)) continue;
                colsStrSet.add(col);
            }
        }
        StringBuilder sb = new StringBuilder(colsStr);
        if (!colsStrSet.contains("calorg")) {
            sb.append("calorg");
            sb.append(",");
        }
        if (!colsStrSet.contains("material")) {
            sb.append("material");
            sb.append(",");
        }
        if (!colsStrSet.contains("costaccount")) {
            sb.append("costaccount");
            sb.append(",");
        }
        if (colsStrSet.contains("warehousegroup") && !colsStrSet.contains("storageorgunit")) {
            sb.append("storageorgunit");
            sb.append(",");
        }
        if (colsStrSet.contains("warehouse")) {
            if (!colsStrSet.contains("warehousegroup")) {
                sb.append("warehousegroup");
                sb.append(",");
            }
            if (!sb.toString().contains("storageorgunit")) {
                sb.append("storageorgunit");
                sb.append(",");
            }
        }
        if (colsStrSet.contains("location")) {
            String nowSelectFields = sb.toString();
            if (!nowSelectFields.contains("warehouse,")) {
                sb.append("warehouse");
                sb.append(",");
            }
            if (!nowSelectFields.contains("warehousegroup")) {
                sb.append("warehousegroup");
                sb.append(",");
            }
            if (!nowSelectFields.contains("storageorgunit")) {
                sb.append("storageorgunit");
                sb.append(",");
            }
        }
        this.getModel().setValue("showkeycols", (Object)sb.toString());
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void mulWarehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void mulStorageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccounts) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        HashSet<Long> periodIds = new HashSet<Long>();
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            periodIds.add(period.getLong("id"));
        }
        if (periodIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long maxid = (Long)Collections.max(periodIds);
        Long minid = (Long)Collections.min(periodIds);
        this.getModel().setValue("startperiod", (Object)(periodIds.size() == 0 ? null : minid));
        this.getModel().setValue("endperiod", (Object)(periodIds.size() == 0 ? null : maxid));
    }

    private void calOrgChanged() {
        IDataModel model = this.getModel();
        model.setValue("mulstorageorg", null);
        model.setValue("mulowner", null);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            model.setValue("mulcostaccount", null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue("mulcostaccount", (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue("mulcostaccount", null);
            }
            model.setValue("ownertypehead", (Object)"bos_org");
        }
    }

    private void rebuildSumKeyCols() {
        String colsStr = (String)this.getModel().getValue("showkeycols");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (!StringUtils.isEmpty((String)colsStr)) {
            HashSet<String> colsSet = new HashSet<String>(Arrays.asList(colsStr.split(",")));
            colsSet.remove("");
            colsSet.remove("costaccount");
            colsSet.remove("calorg");
            colsSet.remove("ownertype");
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"cal_stockestimate_sum_col").getProperties();
            for (String col : colsSet) {
                if (col.isEmpty() || !properties.containsKey((Object)col)) continue;
                ComboItem item = null;
                item = "material".equals(col) ? new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5b58\u8d27", (String)"StockGatherReportBplatForm_1", (String)"fi-cal-report", (Object[])new Object[0])), col) : new ComboItem(((IDataEntityProperty)properties.get((Object)col)).getDisplayName(), col);
                items.add(item);
            }
            colsSet.remove("material");
            if (colsSet.contains("materialgroup")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"level"});
                if (colsSet.size() == 1) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"sumkeycols"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"sumkeycols"});
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"sumkeycols"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"level"});
            }
        }
        if (items.size() > 0) {
            ComboEdit sumkeycols = (ComboEdit)this.getControl("sumkeycols");
            sumkeycols.setComboItems(items);
        }
    }

    private void changeSumKeyCols() {
        String colsStr = "";
        Object keyCols = this.getModel().getValue("sumkeycols");
        if (keyCols != null) {
            colsStr = (String)keyCols;
        }
        StringBuilder sb = new StringBuilder(colsStr);
        if (colsStr.contains("warehousegroup") && !colsStr.contains("storageorgunit")) {
            sb.append("storageorgunit");
            sb.append(",");
        }
        if (colsStr.contains("warehouse")) {
            if (!colsStr.contains("warehousegroup")) {
                sb.append("warehousegroup");
                sb.append(",");
            }
            if (!sb.toString().contains("storageorgunit")) {
                sb.append("storageorgunit");
                sb.append(",");
            }
        }
        if (colsStr.contains("location")) {
            String nowSelectFields = sb.toString();
            if (!nowSelectFields.contains("warehouse,")) {
                sb.append("warehouse");
                sb.append(",");
            }
            if (!nowSelectFields.contains("warehousegroup")) {
                sb.append("warehousegroup");
                sb.append(",");
            }
            if (!nowSelectFields.contains("storageorgunit")) {
                sb.append("storageorgunit");
                sb.append(",");
            }
        }
        this.getModel().setValue("sumkeycols", (Object)sb.toString());
    }

    private String getIsNull(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSISNULL.getId();
        }
        return pro instanceof ItemClassTypeProp ? CompareTypeEnum.COMBOBOXISNULL.getId() : CompareTypeEnum.ISNULL.getId();
    }

    private String getEqual(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSEQUALS.getId();
        }
        return pro instanceof ItemClassTypeProp ? CompareTypeEnum.CHECKBOXEQUAL.getId() : CompareTypeEnum.EQUAL.getId();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("printview".equals(key)) {
            this.printOperation();
        }
    }

    private void printOperation() {
        try {
            String templeteId;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
            HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)this.getView().getEntityId(), (String)"4730fc9e000000ac");
            boolean hasAll = rs.hasAllOrgPerm();
            List hasPermOrgs = rs.getHasPermOrgs();
            if (this.getModel().getValue("mulcalorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"StockDetailRptFormPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            Object calOrg = this.getModel().getValue("mulcalorg");
            DynamicObjectCollection calOrgs = (DynamicObjectCollection)calOrg;
            HashSet<Long> orgs = new HashSet<Long>();
            for (Object calOrgDynamic : calOrgs) {
                orgs.add(calOrgDynamic == null ? 0L : calOrgDynamic.getDynamicObject("fbasedataid").getLong("id"));
            }
            HashSet<Long> noPermOrgIds = new HashSet<Long>(16);
            for (Long id : orgs) {
                if (hasAll || hasPermOrgs == null || hasPermOrgs.contains(id)) continue;
                noPermOrgIds.add(id);
                return;
            }
            if (noPermOrgIds.size() > 0) {
                logger.info("print user has no permission==>{}", noPermOrgIds);
                return;
            }
            ReportView rptFormView = (ReportView)this.getExportAllView();
            if (rptFormView == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
            int rowCount = listModel.getRowCount();
            if (rowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String formId = "cal_stockestimate_sumrpt";
            Object defaultTemplateId = PrintHelper.getDefaultTemplateId((String)formId);
            if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"StockDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String printName = formId + "_printsetting";
            String curPrintPattern = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)printName);
            Map printSetting = null;
            if (!StringUtils.isEmpty((String)curPrintPattern)) {
                printSetting = (Map)SerializationUtils.fromJsonString((String)curPrintPattern, Map.class);
            }
            if (defaultTemplateId == null && (printSetting == null || printSetting.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String string = printSetting == null || StringUtils.isEmpty((String)((String)printSetting.get("templateid"))) ? (defaultTemplateId == null ? null : defaultTemplateId.toString()) : (templeteId = (String)printSetting.get("templateid"));
            if (StringUtils.isEmpty((String)templeteId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            PrintWork work = new PrintWork();
            PrintTask task = new PrintTask();
            task.setTplId(templeteId);
            task.setPageId(listModel.getPageId());
            task.setFormId("cal_stockestimate_sumrpt");
            task.setPrintType("report");
            task.setPkIds(null);
            work.setTaskList(Collections.singletonList(task));
            work.setPrintLang(RequestContext.get().getLang().getLangTag());
            work.setExpType("pdf");
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
            String url = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
            url = String.format(url, prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            logger.error("StockEstimateSumRptFormPlugin printOperation", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u53ef\u80fd\u8d85\u65f6\u4e86\uff0c\u8bf7\u8bd5\u7740\u70b9\u4e0b\u5237\u65b0\u6309\u94ae\u3002", (String)"StockDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
    }

    public IFormView getExportAllView() {
        ReportQueryParam queryParam = this.getQueryParam();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        this.asyncQuery(queryParam, reportList, null);
        return reportList.getView();
    }

    private void asyncQuery(ReportQueryParam queryParam, ReportList reportList, String materialIds) {
        IReportCache var13 = ReportCacheManager.getInstance().getCache();
        var13.setReportQueryParam(this.getView().getPageId(), queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)reportList.getReportModel();
        reportModel.setPageId(this.getView().getPageId());
        reportList.setAsynQuery(true);
        reportList.submitTask(queryParam, (Object)materialIds);
    }
}

