/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.function;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;

public class MulPeriodGroupFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public MulPeriodGroupFunction(RowMeta rowMeta, EstimateSumRptParam reportParam) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        DataSet cur = this.createDataSet(iterable, this.rowMeta);
        cur = cur.orderBy(new String[]{"period"});
        BigDecimal periodendqty = null;
        BigDecimal periodendamount = null;
        BigDecimal initQty = null;
        BigDecimal initAmount = null;
        int periodEndQtyIdx = this.rowMeta.getFieldIndex("periodendqty");
        int periodInQtyIdx = this.rowMeta.getFieldIndex("periodinqty");
        int periodWFQtyIdx = this.rowMeta.getFieldIndex("periodwriteoffqty");
        int beforePDQtyIdx = this.rowMeta.getFieldIndex("beforeperiodqty");
        int initQtyIdx = this.rowMeta.getFieldIndex("initqty");
        int periodEndAmountIdx = this.rowMeta.getFieldIndex("periodendamount");
        int periodInAmountIdx = this.rowMeta.getFieldIndex("periodinamount");
        int periodWFAmountIdx = this.rowMeta.getFieldIndex("periodwriteoffamount");
        int beforePeriodAmountIdx = this.rowMeta.getFieldIndex("beforeperiodamount");
        int initAmountIdx = this.rowMeta.getFieldIndex("initamount");
        for (Row r : cur) {
            RowX rowX = this.getRowx(r);
            if (periodendqty == null) {
                periodendqty = rowX.getBigDecimal(beforePDQtyIdx).add(rowX.getBigDecimal(periodInQtyIdx)).subtract(rowX.getBigDecimal(periodWFQtyIdx));
            } else {
                rowX.set(beforePDQtyIdx, periodendqty);
                periodendqty = periodendqty.add(rowX.getBigDecimal(periodInQtyIdx)).subtract(rowX.getBigDecimal(periodWFQtyIdx));
            }
            rowX.set(periodEndQtyIdx, (Object)periodendqty);
            if (periodendamount == null) {
                periodendamount = rowX.getBigDecimal(beforePeriodAmountIdx).add(rowX.getBigDecimal(periodInAmountIdx)).subtract(rowX.getBigDecimal(periodWFAmountIdx));
            } else {
                rowX.set(beforePeriodAmountIdx, periodendamount);
                periodendamount = periodendamount.add(rowX.getBigDecimal(periodInAmountIdx)).subtract(rowX.getBigDecimal(periodWFAmountIdx));
            }
            rowX.set(periodEndAmountIdx, (Object)periodendamount);
            if (initQty == null || initQty.compareTo(BigDecimal.ZERO) == 0) {
                initQty = rowX.getBigDecimal(initQtyIdx);
            } else {
                initQty = initQty.add(rowX.getBigDecimal(initQtyIdx));
                rowX.set(initQtyIdx, (Object)initQty);
            }
            if (initAmount == null || initAmount.compareTo(BigDecimal.ZERO) == 0) {
                initAmount = rowX.getBigDecimal(initAmountIdx);
            } else {
                initAmount = initAmount.add(rowX.getBigDecimal(initAmountIdx));
                rowX.set(initAmountIdx, (Object)initAmount);
            }
            collector.collect(rowX);
        }
    }

    public DataSet createDataSet(Iterable<RowX> iterable, RowMeta rowMeta) {
        Algo algo = Algo.create((String)"kd.fi.cal.report.newreport.saleestimaterpt.function.MulPeriodGroupFunction");
        Iterator<RowX> funcIterator = iterable.iterator();
        return algo.createDataSet((Iterator)new RowXIterator(funcIterator), rowMeta);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }

    private static class RowXIterator
    implements Iterator<Object[]>,
    Serializable {
        private static final long serialVersionUID = -8990351274825611328L;
        private Iterator<RowX> iterable;

        RowXIterator(Iterator<RowX> iterable) {
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.iterable.hasNext();
        }

        @Override
        public Object[] next() {
            return this.iterable.next().values();
        }
    }
}

