/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptHelper;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.AddMaterialGroupTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.AddSumRowDataXTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.AfterUnionDataxTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.BeforePeriodDataxTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.CalPriceDataXTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.DoOrderDataSetTransfrom;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.SaleSumAllBolckDataXTransform;

public class SaleEstimateSumRptHandle
implements IReportDataHandle {
    private EstimateSumRptParam rptParam;

    public void setupCtx(ReportDataCtx ctx) {
        ctx.setSumKeyCols(null);
        ctx.setSumKeyCols4Count(null);
        this.rptParam = (EstimateSumRptParam)ctx.getParam(EstimateSumRptParam.class.getName());
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        ArrayList<SrcBlockConf> resultBlocks = new ArrayList<SrcBlockConf>(16);
        List fieldList = ctx.getReportConf().getBigTableColConf();
        BigTableColConf conf = new BigTableColConf();
        conf.setCol("blockflagValue");
        conf.setCalType("C");
        conf.setDataType((DataType)DataType.StringType);
        fieldList.add(conf);
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            if (!"cal_costrecord_subentity".equals(srcEntity)) continue;
            QFilter baseQ = EstimateSumRptHelper.getBaseFilter(this.rptParam, true, true);
            QFilter periodOutQ = EstimateSumRptHelper.getPeriodOutFilter(baseQ.copy(), this.rptParam);
            QFilter periodWFQ = EstimateSumRptHelper.getPeriodWFFilter(baseQ.copy(), this.rptParam);
            QFilter beforePeriodOutQ = EstimateSumRptHelper.getBeforePeriodOutFilter(baseQ.copy(), this.rptParam, false);
            QFilter beforePeriodOutWFEndZeroQ = EstimateSumRptHelper.getBeforePeriodOutFilter(baseQ.copy(), this.rptParam, true);
            QFilter beforePeriodWFQ = EstimateSumRptHelper.getBeforePeriodWFFilter(baseQ.copy(), this.rptParam, false);
            QFilter beforePeriodWFEndZeroQ = EstimateSumRptHelper.getBeforePeriodWFFilter(baseQ.copy(), this.rptParam, true);
            QFilter initQ = EstimateSumRptHelper.getInitFilter(baseQ.copy(), this.rptParam);
            this.addBlockConf(periodOutQ, "periodOut", blockConf, resultBlocks, ctx);
            this.addBlockConf(periodWFQ, "periodWF", blockConf, resultBlocks, ctx);
            this.addBlockConf(beforePeriodOutQ, "beforePDOut", blockConf, resultBlocks, ctx);
            this.addBlockConf(beforePeriodOutWFEndZeroQ, "beforePDOut", blockConf, resultBlocks, ctx);
            this.addBlockConf(beforePeriodWFQ, "beforePDWF", blockConf, resultBlocks, ctx);
            this.addBlockConf(beforePeriodWFEndZeroQ, "beforePDWF", blockConf, resultBlocks, ctx);
            this.addBlockConf(initQ, "periodInit", blockConf, resultBlocks, ctx);
        }
        ctx.getReportConf().setSrcBlockConf(resultBlocks);
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SaleSumAllBolckDataXTransform(this.rptParam));
        transCollector.add(new AddMaterialGroupTransform(this.rptParam, ctx));
        transCollector.add(new BeforePeriodDataxTransform(this.rptParam));
        transCollector.add(new AfterUnionDataxTransform(this.rptParam, ctx));
        transCollector.add(new AddSumRowDataXTransform(this.rptParam));
        transCollector.add(new CalPriceDataXTransform(this.rptParam));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DoOrderDataSetTransfrom(this.rptParam, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        for (AbstractReportColumn col : cols) {
            ReportColumn rptCol;
            if (!(col instanceof ReportColumn) || !(rptCol = (ReportColumn)col).getFieldKey().equals("material")) continue;
            rptCol.setHyperlink(true);
        }
        EstimateSumRptHelper.createDecimalColumns(cols, true);
        EstimateSumRptHelper.createHideColumns(cols);
        return cols;
    }

    private void addBlockConf(QFilter q, String blockFlag, SrcBlockConf blockConf, List<SrcBlockConf> resultBlocks, ReportDataCtx ctx) {
        SrcBlockConf srcBlockConf = new SrcBlockConf();
        srcBlockConf.setDefVals(blockConf.getDefVals());
        srcBlockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        srcBlockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        srcBlockConf.setSrcEntity(blockConf.getSrcEntity());
        srcBlockConf.setType(blockConf.getType());
        QFilter uniondataFs = srcBlockConf.getDataFs();
        if (uniondataFs != null) {
            q.and(uniondataFs);
        }
        srcBlockConf.setDataFs(q);
        List periodOutTransForm = srcBlockConf.getDataTransform();
        HashMap<String, String> repoColSrcColMap = new HashMap<String, String>(srcBlockConf.getRepoColFullSrcColMap());
        repoColSrcColMap.put("blockflagValue", String.format("'%s'", blockFlag));
        srcBlockConf.setRepoColFullSrcColMap(repoColSrcColMap);
        srcBlockConf.setAllowNotMatch(true);
        resultBlocks.add(srcBlockConf);
    }
}

