/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptHelper;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.AddMaterialGroupTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.AddSumRowDataXTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.AfterUnionDataxTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.AllBolckDataXTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.BeforePeriodDataxTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.CalPriceDataXTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.transform.DoOrderDataSetTransfrom;

public class StockEstimateSumRptHandle
implements IReportDataHandle {
    private EstimateSumRptParam rptParam;

    public void setupCtx(ReportDataCtx ctx) {
        ctx.setSumKeyCols(null);
        ctx.setSumKeyCols4Count(null);
        this.rptParam = (EstimateSumRptParam)ctx.getParam(EstimateSumRptParam.class.getName());
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        ArrayList<SrcBlockConf> resultBlocks = new ArrayList<SrcBlockConf>(16);
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            this.setMoreBlockField(srcEntity, blockConf);
            if ("cal_costrecord_subentity".equals(srcEntity)) {
                QFilter baseQ = EstimateSumRptHelper.getBaseFilter(this.rptParam, true, false);
                QFilter periodInQ = EstimateSumRptHelper.getPeriodInFilter(baseQ.copy(), this.rptParam);
                QFilter periodWFQ = EstimateSumRptHelper.getPeriodWFFilter(baseQ.copy(), this.rptParam);
                QFilter beforePeriodInQ = EstimateSumRptHelper.getBeforePeriodInFilter(baseQ.copy(), this.rptParam);
                QFilter beforePeriodWFQ = EstimateSumRptHelper.getBeforePeriodWFFilter(baseQ.copy(), this.rptParam);
                QFilter initQ = EstimateSumRptHelper.getInitFilter(baseQ.copy(), this.rptParam);
                this.addBlockConf(periodInQ, "periodOut", blockConf, resultBlocks, ctx);
                this.addBlockConf(periodWFQ, "periodWF", blockConf, resultBlocks, ctx);
                this.addBlockConf(beforePeriodInQ, "beforePDOut", blockConf, resultBlocks, ctx);
                this.addBlockConf(beforePeriodWFQ, "beforePDWF", blockConf, resultBlocks, ctx);
                this.addBlockConf(initQ, "periodInit", blockConf, resultBlocks, ctx);
                continue;
            }
            if (!"cal_costadjust_subentity".equals(srcEntity) && !"cal_stdcostdiffbill".equals(srcEntity) || !this.rptParam.Iscontainadjustbill()) continue;
            QFilter adjustQ = EstimateSumRptHelper.getBaseFilter(this.rptParam, false, false);
            this.addBlockConf(adjustQ, "adjustbill", blockConf, resultBlocks, ctx);
        }
        ctx.getReportConf().setSrcBlockConf(resultBlocks);
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new AddMaterialGroupTransform(this.rptParam, ctx));
        transCollector.add(new BeforePeriodDataxTransform(this.rptParam));
        transCollector.add(new AfterUnionDataxTransform(this.rptParam, ctx));
        transCollector.add(new AddSumRowDataXTransform(this.rptParam));
        transCollector.add(new CalPriceDataXTransform(this.rptParam));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DoOrderDataSetTransfrom(this.rptParam, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        for (AbstractReportColumn col : cols) {
            ReportColumn rptCol;
            if (!(col instanceof ReportColumn) || !(rptCol = (ReportColumn)col).getFieldKey().equals("material")) continue;
            rptCol.setHyperlink(true);
        }
        EstimateSumRptHelper.createMatGoupColumns(this.rptParam, cols);
        EstimateSumRptHelper.createDecimalColumns(cols, false);
        EstimateSumRptHelper.createHideColumns(cols);
        return cols;
    }

    private void addBlockConf(QFilter q, String blockFlag, SrcBlockConf blockConf, List<SrcBlockConf> resultBlocks, ReportDataCtx ctx) {
        SrcBlockConf srcBlockConf = new SrcBlockConf();
        srcBlockConf.setDefVals(blockConf.getDefVals());
        srcBlockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        srcBlockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        srcBlockConf.setSrcEntity(blockConf.getSrcEntity());
        srcBlockConf.setType(blockConf.getType());
        QFilter uniondataFs = srcBlockConf.getDataFs();
        if (uniondataFs != null) {
            q.and(uniondataFs);
        }
        srcBlockConf.setDataFs(q);
        List periodOutTransForm = srcBlockConf.getDataTransform();
        if (periodOutTransForm != null) {
            periodOutTransForm.add(new AllBolckDataXTransform(this.rptParam, blockFlag));
        }
        srcBlockConf.setAllowNotMatch(true);
        resultBlocks.add(srcBlockConf);
    }

    private void setMoreBlockField(String entityNum, SrcBlockConf blockConf) {
        String adjustSupplierName = "custsupplier";
        if ("cal_costadjust_subentity".equals(entityNum) || "cal_stdcostdiffbill".equals(entityNum)) {
            Map srcColMap = blockConf.getRepoColSrcColMap();
            srcColMap.put("supplier", "supplier");
            blockConf.setRepoColSrcColMap(srcColMap);
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.put("supplier", adjustSupplierName);
            blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        }
    }
}

