/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.estimatedtlrpt.EstimateDtlRptHelper;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;

public class AddMaterialGroupTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private EstimateSumRptParam reportParam;
    private String mgIdField = "mgid";

    public AddMaterialGroupTransform(EstimateSumRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        RowMeta rowMeta;
        if (this.reportParam.isNotShowMaterialGroup() && !this.reportParam.isIsshowsubrow4MatGroup()) {
            return srcData;
        }
        DataSet srcDs = EstimateDtlRptHelper.createDataSet(this.ctx, srcData);
        HashSet<Long> matIdSet = new HashSet<Long>(16);
        for (Row row : srcDs) {
            matIdSet.add(row.getLong("material"));
        }
        Object pkValue = 730148448254487552L;
        DynamicObject materialgroupstandard = this.reportParam.getMaterialgroupstandard();
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter groupFilter = new QFilter("standard", "=", pkValue);
        QFilter groupDtlFilter = groupFilter.copy();
        DynamicObjectCollection materialgroup = this.reportParam.getMulmaterialgroup();
        if (materialgroup != null && materialgroup.size() > 0) {
            groupDtlFilter.and(ReportUtil.getGroupFilter((DynamicObjectCollection)materialgroup, (boolean)false, (String)"group.longnumber"));
        }
        groupDtlFilter.and("material", "in", matIdSet);
        if (!this.reportParam.getShowKeyCols().contains("group") || this.reportParam.getLevel() == 0) {
            OrmInput input = new OrmInput("handleMaterialGroup", "bd_materialgroupdetail", "group,group.number as groupnumber,material,material.number as materialnumber,material.materialtype as materialtype", groupDtlFilter.toArray());
            DataSetX groupData = this.ctx.getCurrentJob().fromInput((Input)input);
            QFilter materialNumberFilter = this.getMaterialFromToFilter();
            if (materialNumberFilter != null) {
                String materialNumberFilterStr = materialNumberFilter.toString();
                groupData = groupData.filter(materialNumberFilterStr);
            }
            srcData = srcData.join(groupData).on("material", "material").select(srcData.getRowMeta().getFieldNames(), null);
            return srcData;
        }
        String splitSign = "!";
        HashMap<String, Long> mgMap = new HashMap<String, Long>(1024);
        DataSet mgdDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroupdetail", (String)"material,group.number,group.longnumber", (QFilter[])groupDtlFilter.toArray(), null);
        DataSet mgAllDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroup", (String)"id,number", (QFilter[])groupFilter.toArray(), null);
        for (Row row : mgAllDataSet) {
            mgMap.put(row.getString("number"), row.getLong("id"));
        }
        DataSet finalMgDataSet = null;
        int maxLevel = 0;
        for (Row row : mgdDataSet.copy()) {
            if (row.getString("group.longnumber") == null) continue;
            String[] longNums = row.getString("group.longnumber").split(splitSign);
            maxLevel = maxLevel > longNums.length ? maxLevel : longNums.length;
        }
        if (this.reportParam.getLevel() > maxLevel) {
            this.reportParam.setLevel(maxLevel);
        }
        ArrayList<String> mgFieldList = new ArrayList<String>(16);
        for (int i = 1; i <= this.reportParam.getLevel(); ++i) {
            String fieldName = this.mgIdField + i;
            rowMeta = new RowMeta(new Field[]{new Field("material", (DataType)DateType.LongType), new Field(fieldName, (DataType)DateType.LongType)});
            DataSetBuilder mgDataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
            for (Row row : mgdDataSet.copy()) {
                if (row.getString("group.longnumber") == null) continue;
                long materialId = row.getLong("material");
                String[] longNums = row.getString("group.longnumber").split(splitSign);
                String mgNumber = "";
                if (longNums.length >= i) {
                    mgNumber = longNums[i - 1];
                }
                Long mgId = (Long)mgMap.get(mgNumber);
                mgDataSetBuilder.append(new Object[]{materialId, mgId != null ? mgId : 0L});
            }
            DataSet mgDataSet = mgDataSetBuilder.build();
            finalMgDataSet = finalMgDataSet == null ? mgDataSet : finalMgDataSet.join(mgDataSet).on("material", "material").select(mgFieldList.toArray(new String[0]), new String[]{"material", fieldName}).finish();
            mgFieldList.add(fieldName);
        }
        if (finalMgDataSet == null) {
            ArrayList rowList = new ArrayList(16);
            Object[] obj = new Object[]{0L, 0L};
            rowMeta = new RowMeta(new Field[]{new Field("material", (DataType)DateType.LongType), new Field("mgid1", (DataType)DateType.LongType)});
            mgFieldList.add("mgid1");
            Algo algo = Algo.create((String)"AddMaterialGroupTransform-buildDS");
            finalMgDataSet = algo.createDataSet(rowList, rowMeta);
        }
        this.reportParam.setMgFieldList(mgFieldList);
        DataSetX mgDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(finalMgDataSet));
        srcData = srcData.join(mgDataSetX).on("material", "material").select(srcData.getRowMeta().getFieldNames(), mgFieldList.toArray(new String[0]));
        return srcData;
    }

    private QFilter getMaterialFromToFilter() {
        DynamicObjectCollection materialfrom = this.reportParam.getMaterialFrom();
        if (materialfrom != null) {
            if (materialfrom.size() == 0) {
                return null;
            }
            if (materialfrom.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : materialfrom) {
                    idSet.add(from.getDynamicObject("fbasedataid").get("number"));
                }
                return new QFilter("materialNumber", "in", idSet);
            }
            DynamicObject from = ((DynamicObject)materialfrom.get(0)).getDynamicObject("fbasedataid");
            DynamicObject to = this.reportParam.getMaterialTo();
            QFilter filter = new QFilter("materialNumber", ">=", from.get("number"));
            if (to != null) {
                filter.and("materialNumber", "<=", to.get("number"));
            }
            return filter;
        }
        DynamicObject to = this.reportParam.getMaterialTo();
        QFilter filter = null;
        if (to != null) {
            filter = new QFilter("materialNumber", "<=", to.get("number"));
        }
        return filter;
    }
}

