/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptHelper;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;
import kd.fi.cal.report.newreport.estimatesumrpt.function.PeriodSumRowGroupMapFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.SubSumRowGroupMapFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.SumRowGroupMapFunction;

public class AddSumRowDataXTransform
implements IDataXTransform {
    private EstimateSumRptParam rptParam;

    public AddSumRowDataXTransform(EstimateSumRptParam reportParam) {
        this.rptParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSetX subSumRow = null;
        if (this.rptParam.isIsshowsubrow4MatGroup()) {
            for (String mgField : this.rptParam.getMgFieldList()) {
                if (subSumRow == null) {
                    subSumRow = srcData.groupBy((mgField + ",period,costaccount," + this.rptParam.getSumkeycols()).split(",")).reduceGroup((GroupReduceFunction)new SubSumRowGroupMapFunction(srcData.getRowMeta(), this.rptParam, mgField));
                    continue;
                }
                subSumRow = subSumRow.union(srcData.groupBy((mgField + ",period,costaccount," + this.rptParam.getSumkeycols()).split(",")).reduceGroup((GroupReduceFunction)new SubSumRowGroupMapFunction(srcData.getRowMeta(), this.rptParam, mgField)));
            }
        } else if (this.rptParam.isIsshowsubrow()) {
            subSumRow = srcData.groupBy(("period,costaccount," + this.rptParam.getSumkeycols()).split(",")).reduceGroup((GroupReduceFunction)new SubSumRowGroupMapFunction(srcData.getRowMeta(), this.rptParam, null));
        }
        DataSetX periodSumRowSetX = srcData.groupBy(new String[]{"period", "costaccount"}).reduceGroup((GroupReduceFunction)new PeriodSumRowGroupMapFunction(srcData.getRowMeta()));
        DataSetX sumRowSetX = periodSumRowSetX.groupBy(new String[]{"costaccount"}).reduceGroup((GroupReduceFunction)new SumRowGroupMapFunction(periodSumRowSetX.getRowMeta()));
        ArrayList<Field> newfields = new ArrayList<Field>(16);
        ArrayList<Object> fieldsValues = new ArrayList<Object>(16);
        newfields.add(new Field("subrow", (DataType)DataType.BigDecimalType));
        newfields.add(new Field("periodrow", (DataType)DataType.BigDecimalType));
        newfields.add(new Field("sumrow", (DataType)DataType.BigDecimalType));
        newfields.add(new Field("linetype", (DataType)DataType.BigDecimalType));
        if (subSumRow != null) {
            subSumRow = subSumRow.addFields(newfields.toArray(new Field[0]), this.getFiledsValuesByRowType("subrow", fieldsValues).toArray());
        }
        srcData = srcData.addFields(newfields.toArray(new Field[0]), this.getFiledsValuesByRowType("row", fieldsValues).toArray());
        periodSumRowSetX = periodSumRowSetX.addFields(newfields.toArray(new Field[0]), this.getFiledsValuesByRowType("periodrow", fieldsValues).toArray());
        sumRowSetX = sumRowSetX.addFields(newfields.toArray(new Field[0]), this.getFiledsValuesByRowType("sumrow", fieldsValues).toArray());
        StringBuilder allFields = new StringBuilder();
        for (String field : EstimateSumRptHelper.getSumFields(this.rptParam)) {
            allFields.append(field);
            allFields.append(",");
        }
        allFields.append("beforeperiodqty,beforeperiodamount,periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount,periodendqty,periodendamount,subrow,periodrow,sumrow,linetype");
        String[] allSelectFields = allFields.toString().split(",");
        if (this.rptParam.isOnlyshowsumrow()) {
            srcData = periodSumRowSetX.select(allSelectFields).union(sumRowSetX.select(allSelectFields));
        } else {
            if (this.rptParam.isShowperiodrow()) {
                srcData = srcData.select(allSelectFields).union(periodSumRowSetX.select(allSelectFields));
            }
            if (this.rptParam.isShowsumrow()) {
                srcData = srcData.select(allSelectFields).union(sumRowSetX.select(allSelectFields));
            }
        }
        if (subSumRow != null) {
            srcData = srcData.select(allSelectFields).union(subSumRow.select(allSelectFields));
        }
        return srcData;
    }

    private List<Object> getFiledsValuesByRowType(String rowType, List<Object> fieldsValues) {
        fieldsValues.clear();
        if ("subrow".equals(rowType)) {
            fieldsValues.add(BigDecimal.ONE);
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ONE);
        } else if ("periodrow".equals(rowType)) {
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ONE);
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ONE);
        } else if ("sumrow".equals(rowType)) {
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ONE);
            fieldsValues.add(BigDecimal.ONE);
        } else {
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ZERO);
            fieldsValues.add(BigDecimal.ZERO);
        }
        return fieldsValues;
    }
}

