/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptHelper;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;
import kd.fi.cal.report.newreport.estimatesumrpt.function.AddInitRecordMapFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.DeleteZeroDataGroupFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.MulPeriodGroupFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.NullToZeroMapFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.SinglePeriodMapFunction;

public class AfterUnionDataxTransform
implements IDataXTransform {
    private EstimateSumRptParam rptParam;
    private ReportDataCtx ctx;
    private static String[] rightFileds = new String[]{"periodinqty", "periodinamount", "periodwriteoffqty", "periodwriteoffamount", "periodnotwriteoffqty", "periodnotwriteoffamount", "beforeperiodqty", "beforeperiodamount", "initqty", "initamount"};

    public AfterUnionDataxTransform(EstimateSumRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.rptParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSetX allPeriodSetX = this.getAllPeriodDataSetX();
        String[] dimWithOutPeriod = EstimateSumRptHelper.getSumFieldsNoPeriod(this.rptParam);
        DataSetX allDimSetx = srcData.groupBy(dimWithOutPeriod).sum("periodinqty");
        JoinDataSetX periodSetX = allDimSetx.leftJoin(allPeriodSetX).on("periodType", "periodType").select(dimWithOutPeriod, new String[]{"period"});
        JoinDataSetX joinSetX = periodSetX.leftJoin(srcData);
        for (String sumFields : EstimateSumRptHelper.getSumFields(this.rptParam)) {
            joinSetX.on(sumFields, sumFields);
        }
        srcData = joinSetX.select(EstimateSumRptHelper.getSumFields(this.rptParam), rightFileds);
        srcData = srcData.map((MapFunction)new NullToZeroMapFunction(srcData.getRowMeta(), rightFileds));
        ArrayList<Field> newfields = new ArrayList<Field>(16);
        ArrayList<BigDecimal> fieldsValues = new ArrayList<BigDecimal>(16);
        newfields.add(new Field("periodendqty", (DataType)DataType.BigDecimalType));
        fieldsValues.add(BigDecimal.ZERO);
        newfields.add(new Field("periodendamount", (DataType)DataType.BigDecimalType));
        fieldsValues.add(BigDecimal.ZERO);
        srcData = srcData.addFields(newfields.toArray(new Field[0]), fieldsValues.toArray());
        srcData = this.rptParam.getStartPeriodNumber() == this.rptParam.getEndPeriodNumber() ? srcData.map((MapFunction)new SinglePeriodMapFunction(srcData.getRowMeta())) : srcData.groupBy(this.ctx.getShowKeyCols().toArray(new String[0])).reduceGroup((GroupReduceFunction)new MulPeriodGroupFunction(srcData.getRowMeta(), this.rptParam));
        srcData = srcData.map((MapFunction)new AddInitRecordMapFunction(srcData.getRowMeta()));
        return srcData.reduceGroup((GroupReduceFunction)new DeleteZeroDataGroupFunction(srcData.getRowMeta()));
    }

    private DataSetX getAllPeriodDataSetX() {
        DataSet accountSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id as accountId,calpolicy.periodtype as periodType", (QFilter[])new QFilter("id", "in", this.rptParam.getCostAccountIdSet()).toArray(), null);
        HashSet<Long> periodTypeIdSet = new HashSet<Long>(16);
        for (Row account : accountSet) {
            periodTypeIdSet.add(account.getLong("periodType"));
        }
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.rptParam.getStartPeriodNumber()});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ?", (Object[])new Object[]{this.rptParam.getEndPeriodNumber()}));
        q.and("periodtype", "in", periodTypeIdSet);
        q.and("isadjustperiod", "=", (Object)false);
        OrmInput periodInput = new OrmInput(this.getClass().getName(), "bd_period", "id as period,periodtype", q.toArray());
        return this.ctx.getCurrentJob().fromInput((Input)periodInput);
    }

    private String getOrderCols(Set<String> keyColsSet) {
        StringBuilder orderCols = new StringBuilder("calorg");
        orderCols.append(",costaccount");
        orderCols.append(",material");
        if (keyColsSet.contains("owner")) {
            orderCols.append(",owner");
        }
        if (keyColsSet.contains("customer")) {
            orderCols.append(",customer");
        }
        if (keyColsSet.contains("storageorgunit")) {
            orderCols.append(",storageorgunit");
        }
        if (keyColsSet.contains("warehousegroup")) {
            orderCols.append(",warehousegroup");
        }
        if (keyColsSet.contains("warehouse")) {
            orderCols.append(",warehouse");
        }
        if (keyColsSet.contains("location")) {
            orderCols.append(",location");
        }
        if (keyColsSet.contains("lot")) {
            orderCols.append(",lot");
        }
        orderCols.append(",period");
        return orderCols.toString();
    }
}

