/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.transform;

import java.util.Arrays;
import java.util.HashSet;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;
import kd.fi.cal.report.newreport.estimatesumrpt.function.InitRecordMapFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.PeriodOutMapFunction;
import kd.fi.cal.report.newreport.estimatesumrpt.function.PeriodWFMapFunction;

public class AllBolckDataXTransform
implements IDataXTransform {
    private EstimateSumRptParam rptParam;
    private String blockFlag;

    public AllBolckDataXTransform(EstimateSumRptParam reportParam, String blockFlag) {
        this.rptParam = reportParam;
        this.blockFlag = blockFlag;
    }

    public DataSetX doTransform(DataSetX srcData) {
        RowMeta rowMeta = srcData.getRowMeta();
        boolean isDealProcess = false;
        HashSet<String> omInObjectSet = new HashSet<String>(16);
        HashSet<String> fields = new HashSet<String>(Arrays.asList(rowMeta.getFieldNames()));
        if (fields.contains("processcost") && fields.contains("bizentityobject")) {
            isDealProcess = true;
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection ominBizobjects = setting.getDynamicObjectCollection("ominbiztype");
            for (DynamicObject bizobject : ominBizobjects) {
                omInObjectSet.add((String)bizobject.getDynamicObject("fbasedataid").getPkValue());
            }
        }
        if ("periodOut".equals(this.blockFlag)) {
            srcData = srcData.map((MapFunction)new PeriodOutMapFunction(rowMeta, this.rptParam, this.blockFlag, isDealProcess, omInObjectSet));
        } else if ("periodWF".equals(this.blockFlag)) {
            srcData = srcData.map((MapFunction)new PeriodWFMapFunction(rowMeta, this.rptParam, this.blockFlag, isDealProcess, omInObjectSet));
        } else if ("beforePDOut".equals(this.blockFlag)) {
            srcData = srcData.map((MapFunction)new PeriodOutMapFunction(rowMeta, this.rptParam, this.blockFlag, isDealProcess, omInObjectSet));
        } else if ("beforePDWF".equals(this.blockFlag)) {
            srcData = srcData.map((MapFunction)new PeriodWFMapFunction(rowMeta, this.rptParam, this.blockFlag, isDealProcess, omInObjectSet));
        } else if ("periodInit".equals(this.blockFlag)) {
            srcData = srcData.map((MapFunction)new InitRecordMapFunction(rowMeta, this.rptParam, this.blockFlag, isDealProcess, omInObjectSet));
        } else if ("adjustbill".equals(this.blockFlag)) {
            srcData = srcData.map((MapFunction)new PeriodWFMapFunction(rowMeta, this.rptParam, this.blockFlag, isDealProcess, omInObjectSet));
        }
        return srcData;
    }
}

