/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.transform;

import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;

public class DealAllDataMapFunction
extends MapFunction {
    private static final long serialVersionUID = 5814858500979010282L;
    private final RowMeta rowMeta;
    private final EstimateSumRptParam reportParam;

    public DealAllDataMapFunction(RowMeta rowMeta, EstimateSumRptParam rptParam) {
        this.rowMeta = rowMeta;
        this.reportParam = rptParam;
    }

    public RowX map(RowX rowX) {
        int blockFlagIdx = this.rowMeta.getFieldIndex("blockflag");
        int blockFlagValueIdx = this.rowMeta.getFieldIndex("blockflagValue");
        rowX.set(blockFlagIdx, (Object)rowX.getString(blockFlagValueIdx));
        this.dealOut(rowX);
        this.dealWf(rowX);
        this.dealInit(rowX);
        return rowX;
    }

    private void dealInit(RowX rowX) {
        boolean isNotCurDeal;
        int baseQtyIdx = this.rowMeta.getFieldIndex("baseqty");
        int initQtyIdx = this.rowMeta.getFieldIndex("initqty");
        int actualAmountIdx = this.rowMeta.getFieldIndex("actualamount");
        int initAmountIdx = this.rowMeta.getFieldIndex("initamount");
        int blockFlagIdx = this.rowMeta.getFieldIndex("blockflag");
        String blockFlag = rowX.getString(blockFlagIdx);
        boolean bl = isNotCurDeal = !"periodInit".equals(blockFlag);
        if (isNotCurDeal) {
            return;
        }
        rowX.set(initQtyIdx, (Object)rowX.getBigDecimal(baseQtyIdx));
        rowX.set(initAmountIdx, (Object)rowX.getBigDecimal(actualAmountIdx));
    }

    private void dealWf(RowX rowX) {
        boolean isNotCurDeal;
        int baseQtyIdx = this.rowMeta.getFieldIndex("baseqty");
        int periodWFQtyIdx = this.rowMeta.getFieldIndex("periodwriteoffqty");
        int actualAmountIdx = this.rowMeta.getFieldIndex("actualamount");
        int periodInAmountIdx = this.rowMeta.getFieldIndex("periodinamount");
        int periodWFAmountIdx = this.rowMeta.getFieldIndex("periodwriteoffamount");
        int periodIdx = this.rowMeta.getFieldIndex("period");
        int wfPeriodIdx = this.rowMeta.getFieldIndex("writeoffperiod");
        int blockFlagIdx = this.rowMeta.getFieldIndex("blockflag");
        String blockFlag = rowX.getString(blockFlagIdx);
        boolean bl = isNotCurDeal = !"periodWF".equals(blockFlag) && !"beforePDWF".equals(blockFlag) && !"adjustbill".equals(blockFlag);
        if (isNotCurDeal) {
            return;
        }
        rowX.set(periodIdx, (Object)rowX.getLong(wfPeriodIdx));
        rowX.set(periodWFQtyIdx, (Object)rowX.getBigDecimal(baseQtyIdx));
        rowX.set(periodWFAmountIdx, (Object)rowX.getBigDecimal(actualAmountIdx));
        if ("adjustbill".equals(blockFlag)) {
            rowX.set(periodInAmountIdx, (Object)rowX.getBigDecimal(actualAmountIdx));
        }
        rowX.set(blockFlagIdx, (Object)blockFlag);
        if ("beforePDWF".equals(blockFlag)) {
            rowX.set(periodIdx, (Object)this.reportParam.getStartPeriodId());
        }
    }

    private void dealOut(RowX rowX) {
        boolean isNotCurDeal;
        int blockFlagIdx = this.rowMeta.getFieldIndex("blockflag");
        String blockFlag = rowX.getString(blockFlagIdx);
        boolean bl = isNotCurDeal = !"periodOut".equals(blockFlag) && !"beforePDOut".equals(blockFlag);
        if (isNotCurDeal) {
            return;
        }
        int baseQtyIdx = this.rowMeta.getFieldIndex("baseqty");
        int periodInQtyIdx = this.rowMeta.getFieldIndex("periodinqty");
        int actualAmountIdx = this.rowMeta.getFieldIndex("actualamount");
        int periodInAmountIdx = this.rowMeta.getFieldIndex("periodinamount");
        int periodIdx = this.rowMeta.getFieldIndex("period");
        rowX.set(periodInQtyIdx, (Object)rowX.getBigDecimal(baseQtyIdx));
        rowX.set(periodInAmountIdx, (Object)rowX.getBigDecimal(actualAmountIdx));
        if ("beforePDOut".equals(blockFlag)) {
            rowX.set(periodIdx, (Object)this.reportParam.getStartPeriodId());
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

