/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.estimatesumrpt.transform;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.estimatesumrpt.common.EstimateSumRptParam;

public class DoOrderDataSetTransfrom
implements IDataTransform {
    private EstimateSumRptParam rptParam;
    private ReportDataCtx ctx;

    public DoOrderDataSetTransfrom(EstimateSumRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.rptParam = reportParam;
    }

    public DataSet doTransform(DataSet dataSet) {
        dataSet = dataSet.orderBy(this.getOrderCols(this.rptParam.isTopsumrow(), this.rptParam.isIsshowsubrow()).split(","));
        return dataSet;
    }

    private String getOrderCols(boolean isTopSumRow, boolean isshowSubRow) {
        Set keyColsSet = this.ctx.getShowKeyCols();
        Set<String> sumColsSet = this.rptParam.getSumkeycolSet();
        StringBuilder orderCols = new StringBuilder("calorg");
        orderCols.append(",costaccount");
        if (isTopSumRow) {
            orderCols.append(",sumrow desc");
        } else {
            orderCols.append(",sumrow");
        }
        orderCols.append(",period");
        if (isTopSumRow) {
            orderCols.append(",periodrow desc");
        } else {
            orderCols.append(",periodrow");
        }
        if (this.rptParam.isIsshowsubrow4MatGroup()) {
            if (this.rptParam.getMgFieldList() != null) {
                for (String mgField : this.rptParam.getMgFieldList()) {
                    orderCols.append(",");
                    orderCols.append(mgField);
                }
            }
            if (isTopSumRow) {
                orderCols.append(",subrow desc");
            } else {
                orderCols.append(",subrow");
            }
            orderCols.append(",material");
            return orderCols.toString();
        }
        if (isshowSubRow) {
            if (sumColsSet.contains("material")) {
                orderCols.append(",material");
            }
            if (sumColsSet.contains("owner")) {
                orderCols.append(",owner");
            }
            if (sumColsSet.contains("customer")) {
                orderCols.append(",customer");
            }
            if (sumColsSet.contains("storageorgunit")) {
                orderCols.append(",storageorgunit");
            }
            if (sumColsSet.contains("warehousegroup")) {
                orderCols.append(",warehousegroup");
            }
            if (sumColsSet.contains("warehouse")) {
                orderCols.append(",warehouse");
            }
            if (sumColsSet.contains("location")) {
                orderCols.append(",location");
            }
            for (String sumCol : sumColsSet) {
                orderCols.append(',');
                orderCols.append(sumCol);
            }
            if (isTopSumRow) {
                orderCols.append(",subrow desc");
            } else {
                orderCols.append(",subrow");
            }
            return orderCols.toString();
        }
        orderCols.append(",material");
        if (keyColsSet.contains("owner")) {
            orderCols.append(",owner");
        }
        if (keyColsSet.contains("customer")) {
            orderCols.append(",customer");
        }
        if (keyColsSet.contains("storageorgunit")) {
            orderCols.append(",storageorgunit");
        }
        if (keyColsSet.contains("warehousegroup")) {
            orderCols.append(",warehousegroup");
        }
        if (keyColsSet.contains("warehouse")) {
            orderCols.append(",warehouse");
        }
        if (keyColsSet.contains("location")) {
            orderCols.append(",location");
        }
        if (keyColsSet.contains("lot")) {
            orderCols.append(",lot");
        }
        return orderCols.toString();
    }
}

