/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.invaccountrpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountConsts;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptParam;

public class InvAccountRptHelper {
    public static String getInvBillSelect(Map<String, String> balanceFieldMap, Map<String, String> repoColSrcColMap, Map<String, IDataEntityProperty> repoColFieldMap, String entryName, String type) {
        StringBuilder selectFiled = new StringBuilder();
        for (Map.Entry<String, String> repoColSrcCol : repoColSrcColMap.entrySet()) {
            String repoCol = repoColSrcCol.getKey();
            String balanceCol = repoColSrcCol.getValue();
            String invBillCol = null;
            if (balanceCol.contains(".")) {
                String fieldHead = balanceFieldMap.get(balanceCol.substring(0, balanceCol.indexOf(".")));
                invBillCol = fieldHead + balanceCol.substring(balanceCol.indexOf("."));
            } else {
                invBillCol = balanceFieldMap.get(balanceCol);
            }
            if (invBillCol != null) {
                selectFiled.append(invBillCol);
                selectFiled.append(" as ");
                selectFiled.append(repoCol);
                selectFiled.append(",");
                continue;
            }
            IDataEntityProperty filedProperty = repoColFieldMap.get(repoCol);
            if (filedProperty instanceof BasedataProp) {
                selectFiled.append("0l");
            } else if (filedProperty instanceof TextProp) {
                selectFiled.append("' '");
            } else if (filedProperty instanceof DecimalProp) {
                selectFiled.append("0.00");
            } else {
                selectFiled.append("null");
            }
            selectFiled.append(" as ");
            selectFiled.append(repoCol);
            selectFiled.append(',');
        }
        if ("IN".equals(type)) {
            String qtyInFields = balanceFieldMap.get("baseqty_in");
            if (qtyInFields == null) {
                selectFiled.append("0.00");
            } else {
                selectFiled.append(qtyInFields);
            }
            selectFiled.append(" as invinqty,0.00 as invoutqty");
        } else {
            selectFiled.append("0.00 as invinqty,");
            String qtyOutFields = balanceFieldMap.get("baseqty_out");
            if (qtyOutFields == null) {
                selectFiled.append("0.00");
            } else {
                selectFiled.append(qtyOutFields);
            }
            selectFiled.append(" as invoutqty");
        }
        selectFiled.append(',');
        selectFiled.append(entryName);
        selectFiled.append(".id as bizbillentryid");
        selectFiled.append(",billtype");
        selectFiled.append(",billno");
        selectFiled.append(",biztype");
        selectFiled.append(",id as bizbillid");
        selectFiled.append(",'");
        selectFiled.append(balanceFieldMap.get("bizentityobject"));
        selectFiled.append("' as bizentityobject");
        return CommonUtils.trimComma((String)selectFiled.toString());
    }

    public static QFilter getInvBillQ(QFilter billQ, Map<String, String> balanceFieldMap, InvAccountRptParam rptParam) {
        String orgField = balanceFieldMap.get("org");
        billQ.and("billstatus", "=", (Object)"C");
        billQ.and(orgField, "in", rptParam.getStorageOrgUnit());
        billQ.and("bookdate", "<=", (Object)rptParam.getEnddate());
        billQ.and("bookdate", ">=", (Object)rptParam.getPeriodBegindate());
        String ownerField = balanceFieldMap.get("owner");
        billQ.and(ownerField, "in", (Object)rptParam.getOwners());
        String ownerTypeField = balanceFieldMap.get("ownertype");
        billQ.and(ownerTypeField, "=", (Object)"bos_org");
        if (!rptParam.getWarehouse().isEmpty()) {
            String warehouseField = balanceFieldMap.get("warehouse");
            billQ.and(new QFilter(warehouseField, "in", rptParam.getWarehouse()));
        }
        if (!rptParam.getMaterialIds().isEmpty()) {
            String materialField = balanceFieldMap.get("material");
            billQ.and(new QFilter(materialField, "in", rptParam.getMaterialIds()));
        }
        return billQ;
    }

    public static QFilter getInvCalBalanceQ(InvAccountRptParam rptParam) {
        QFilter filter = new QFilter("org", "in", rptParam.getStorageOrgUnit());
        int period = 1;
        if (!rptParam.isIsinit()) {
            period = rptParam.getPeriodInt();
        }
        QFilter periodf = new QFilter("period", "<", (Object)period);
        periodf.and(new QFilter("endperiod", ">=", (Object)period));
        filter.and(periodf);
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("owner", "in", (Object)rptParam.getOwners()));
        if (!rptParam.getWarehouse().isEmpty()) {
            filter.and(new QFilter("warehouse", "in", rptParam.getWarehouse()));
        }
        if (!rptParam.getMaterialIds().isEmpty()) {
            filter.and(new QFilter("material", "in", rptParam.getMaterialIds()));
        }
        return filter;
    }

    public static QFilter getBalanceQFilter(InvAccountRptParam rptParam) {
        QFilter filter = new QFilter("storageorgunit", "in", rptParam.getStorageOrgUnit());
        QFilter periodf = new QFilter("period", "<", (Object)rptParam.getPeriodInt());
        periodf.and(new QFilter("endperiod", ">=", (Object)rptParam.getPeriodInt()));
        filter.and(periodf);
        filter.and(new QFilter("costaccount", "=", (Object)rptParam.getCostAccount()));
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("owner", "in", (Object)rptParam.getOwners()));
        if (!rptParam.getWarehouse().isEmpty()) {
            filter.and(new QFilter("warehouse", "in", rptParam.getWarehouse()));
        }
        if (!rptParam.getMaterialIds().isEmpty()) {
            filter.and(new QFilter("material", "in", rptParam.getMaterialIds()));
        }
        return filter;
    }

    public static List<QFilter> getRecordQFilter(InvAccountRptParam rptParam) {
        QFilter filter = new QFilter("storageorgunit", "in", rptParam.getStorageOrgUnit());
        filter.and(new QFilter("issplitcreate", "=", (Object)false));
        filter.and(new QFilter("isinitbill", "=", (Object)false));
        filter.and(new QFilter("costaccount", "=", (Object)rptParam.getCostAccount()));
        filter.and(new QFilter("entry.ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("entry.owner", "in", (Object)rptParam.getOwners()));
        filter.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        if (!rptParam.getWarehouse().isEmpty()) {
            filter.and(new QFilter("entry.warehouse", "in", rptParam.getWarehouse()));
        }
        if (!rptParam.getMaterialIds().isEmpty()) {
            filter.and(new QFilter("entry.material", "in", rptParam.getMaterialIds()));
        }
        filter.and("entry.entrystatus", "=", (Object)"C");
        if (rptParam.getPeriodBegindate() != null) {
            List filters = DateUtils.getDateSplitFilters((Date)rptParam.getPeriodBegindate(), (Date)rptParam.getEnddate(), (String)"bookdate");
            for (QFilter qFilter : filters) {
                qFilter.and(filter);
            }
            return filters;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filter.and(new QFilter("bookdate", "<=", (Object)rptParam.getEnddate()));
        filters.add(filter);
        return filters;
    }

    public static InvAccountRptParam buildRptParam(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        InvAccountRptParam rptParam = new InvAccountRptParam();
        Long accountId = (Long)dataEntity.getDynamicObject("costaccount").getPkValue();
        rptParam.setCostAccount(accountId);
        HashSet<Long> storageOrgUnit = new HashSet<Long>(16);
        for (Object item : dataEntity.getDynamicObjectCollection("mulstorageorg")) {
            storageOrgUnit.add(item.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Long> wareHouse = new HashSet<Long>(16);
        if (dataEntity.getDynamicObjectCollection("mulwarehouse") != null) {
            for (Object item : dataEntity.getDynamicObjectCollection("mulwarehouse")) {
                wareHouse.add(item.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        HashSet<Long> material = new HashSet<Long>(16);
        if (dataEntity.getDynamicObjectCollection("mulmaterial") != null) {
            for (DynamicObject item : dataEntity.getDynamicObjectCollection("mulmaterial")) {
                material.add(item.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        rptParam.setStorageOrgUnit(storageOrgUnit);
        rptParam.setWarehouse(wareHouse);
        rptParam.setMaterialIds(material);
        rptParam.setShowwarehs(dataEntity.getBoolean("showwarehs"));
        rptParam.setShowlocation(dataEntity.getBoolean("showlocation"));
        rptParam.setShowowner(dataEntity.getBoolean("showowner"));
        rptParam.setShowauxpty(dataEntity.getBoolean("showauxpty"));
        rptParam.setShowproject(dataEntity.getBoolean("showproject"));
        rptParam.setShowlot(dataEntity.getBoolean("showlot"));
        rptParam.setShowinvtype(dataEntity.getBoolean("showinvtype"));
        rptParam.setShowinvstatus(dataEntity.getBoolean("showinvstatus"));
        rptParam.setIsinit(dataEntity.getBoolean("isinit"));
        rptParam.setEnddate(DateUtils.getDayEndTime((Date)dataEntity.getDate("enddate")));
        DynamicObject periodDyc = rptParam.isIsinit() ? null : InvAccountRptHelper.getYearPeriodByDate(accountId, DateUtils.getDayStartTime((Date)rptParam.getEnddate()));
        rptParam.setPeriod(periodDyc);
        rptParam.setPeriodInt(periodDyc == null ? 1 : periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber"));
        rptParam.setPeriodBegindate(periodDyc == null ? null : periodDyc.getDate("begindate"));
        rptParam.setIsonlydiff(dataEntity.getBoolean("isonlydiff"));
        rptParam.setShowdetail(dataEntity.getBoolean("showdetail"));
        rptParam.setOwners(AccountingSysHelper.getOwners((Long)rptParam.getCostAccount()));
        String groupFields = InvAccountRptHelper.getGroupFields(rptParam);
        rptParam.setGroupFields(groupFields);
        rptParam.setGroupFieldSet(new HashSet<String>(Arrays.asList(groupFields.split(","))));
        return rptParam;
    }

    public static String getGroupFields(InvAccountRptParam rptParam) {
        StringBuilder sb = new StringBuilder(16);
        sb.append("storageorgunit,material");
        if (rptParam.isShowwarehs()) {
            sb.append(",warehouse");
        }
        if (rptParam.isShowlocation()) {
            sb.append(",location");
        }
        if (rptParam.isShowowner()) {
            sb.append(",ownertype,owner");
        }
        if (rptParam.isShowinvtype()) {
            sb.append(",invtype");
        }
        if (rptParam.isShowinvstatus()) {
            sb.append(",invstatus");
        }
        if (rptParam.isShowauxpty()) {
            sb.append(",assist");
        }
        if (rptParam.isShowproject()) {
            sb.append(",project");
        }
        if (rptParam.isShowlot()) {
            sb.append(",lot");
        }
        return CommonUtils.trimComma((String)sb.toString());
    }

    public static DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)false);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    public static void createHideColumns(List<AbstractReportColumn> cols, InvAccountRptParam rptParam) {
        HashSet<String> hideFields = new HashSet<String>(16);
        hideFields.add("linetype");
        hideFields.add("blockflag");
        hideFields.add("periodid");
        hideFields.add("calbeginqty");
        hideFields.add("calinqty");
        hideFields.add("caloutqty");
        hideFields.add("calendqty");
        hideFields.add("invbeginqty");
        hideFields.add("invinqty");
        hideFields.add("invoutqty");
        hideFields.add("invendqty");
        hideFields.add("begindiffqty");
        hideFields.add("indiffqty");
        hideFields.add("outdiffqty");
        hideFields.add("enddiffqty");
        hideFields.add("bizbillentryid");
        hideFields.add("bizbillid");
        hideFields.add("bizentityobject");
        hideFields.add("precision");
        if (!rptParam.isShowdetail()) {
            hideFields.add("billtype");
            hideFields.add("biztype");
            hideFields.add("billno");
        }
        if (!rptParam.isShowwarehs()) {
            hideFields.add("warehouse");
        }
        if (!rptParam.isShowlocation()) {
            hideFields.add("location");
        }
        if (!rptParam.isShowowner()) {
            hideFields.add("ownertype");
            hideFields.add("owner");
        }
        if (!rptParam.isShowinvtype()) {
            hideFields.add("invtype");
        }
        if (!rptParam.isShowinvstatus()) {
            hideFields.add("invstatus");
        }
        if (!rptParam.isShowauxpty()) {
            hideFields.add("assist");
        }
        if (!rptParam.isShowproject()) {
            hideFields.add("project");
        }
        if (!rptParam.isShowlot()) {
            hideFields.add("lot");
        }
        for (AbstractReportColumn abstractReportColumn : cols) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            ReportColumn column = (ReportColumn)abstractReportColumn;
            String columnName = column.createColumn().get("dataIndex").toString();
            if ("bizbillentryid".equals(columnName) || "bizbillid".equals(columnName)) {
                column.setFieldType("bigint");
            }
            if ("billno".equals(columnName)) {
                column.setHyperlink(true);
            }
            if (!hideFields.contains(columnName)) continue;
            column.setHide(true);
        }
    }

    public static void createDecimalColumns(List<AbstractReportColumn> cols, InvAccountRptParam rptParam) {
        if (!rptParam.isShowdetail()) {
            InvAccountRptHelper.createDecimalColumn(cols, InvAccountConsts.PERIOD_BEGIN_NAME, new String[]{"periodbegin", "calbeginqty", "invbeginqty", "begindiffqty"});
        }
        if (!rptParam.isIsinit()) {
            InvAccountRptHelper.createDecimalColumn(cols, InvAccountConsts.PERIOD_IN_NAME, new String[]{"periodin", "calinqty", "invinqty", "indiffqty"});
            InvAccountRptHelper.createDecimalColumn(cols, InvAccountConsts.PERIOD_OUT_NAME, new String[]{"periodout", "caloutqty", "invoutqty", "outdiffqty"});
            if (!rptParam.isShowdetail()) {
                InvAccountRptHelper.createDecimalColumn(cols, InvAccountConsts.PERIOD_END_NAME, new String[]{"periodend", "calendqty", "invendqty", "enddiffqty"});
            }
        }
    }

    public static void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String[] fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey[0]);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn calQty = new ReportColumn();
        calQty.setCaption(InvAccountConsts.CAL_NAME);
        calQty.setWidth(InvAccountConsts.WIDTH);
        calQty.setFieldKey(fieldKey[1]);
        calQty.setFieldType("qty");
        calQty.setMeasureUnitField("baseunit");
        ReportColumn invQty = new ReportColumn();
        invQty.setCaption(InvAccountConsts.INV_NAME);
        invQty.setWidth(InvAccountConsts.WIDTH);
        invQty.setFieldKey(fieldKey[2]);
        invQty.setFieldType("qty");
        invQty.setMeasureUnitField("baseunit");
        ReportColumn diffQty = new ReportColumn();
        diffQty.setCaption(InvAccountConsts.DIFF_NAME);
        diffQty.setWidth(InvAccountConsts.WIDTH);
        diffQty.setFieldKey(fieldKey[3]);
        diffQty.setFieldType("qty");
        diffQty.setMeasureUnitField("baseunit");
        groupCol.getChildren().add(calQty);
        groupCol.getChildren().add(invQty);
        groupCol.getChildren().add(diffQty);
    }
}

