/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.invaccountrpt.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptHelper;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptParam;

public class InvAccountRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_invaccount_newrpt");
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("cus_costaccount") != null && params.get("cus_orgid") != null) {
            this.getModel().setValue("costaccount", (Object)Long.valueOf(params.get("cus_costaccount").toString()));
            this.setStorageOrg(Long.valueOf(params.get("cus_orgid").toString()));
            this.resetFilterGrid();
        } else if (calOrgId != null && calOrgId != 0L) {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            }
            this.setStorageOrg(calOrgId);
            this.resetFilterGrid();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "mulstorageorg", "costaccount", "mulwarehouse", "mulmaterial", "mulwarehouse", "mulmaterial");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    DynamicObject row = evt.getRowData();
                    Long bizbillid = row.getLong("bizbillid");
                    if (bizbillid == null || bizbillid == 0L) {
                        return;
                    }
                    String bizEntityObject = row.getString("bizentityobject");
                    DynamicObject bizBill = QueryServiceHelper.queryOne((String)bizEntityObject, (String)"id", (QFilter[])new QFilter("id", "=", (Object)bizbillid).toArray());
                    if (bizBill == null) {
                        InvAccountRptForm.this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"InvAccountRptForm_0", (String)"fi-cal-report", (Object[])new Object[0]));
                        return;
                    }
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setPkId((Object)bizbillid);
                    showParameter.setFormId(bizEntityObject);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.VIEW);
                    InvAccountRptForm.this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        });
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if ("mulmaterial".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costAccount != null) {
                this.setStorageOrg(costAccount.getLong("calorg.id"));
            } else {
                this.getModel().setValue("mulstorageorg", null);
            }
        } else if ("mulstorageorg".equals(key)) {
            this.getModel().setValue("mulwarehouse", null);
        } else if ("isonlydiff".equals(key)) {
            if (((Boolean)this.getModel().getValue("isonlydiff")).booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"showdetail"});
            } else {
                this.getModel().setValue("showdetail", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"showdetail"});
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        Date endDate = (Date)this.getModel().getValue("enddate");
        this.getModel().setValue("enddate", (Object)(endDate == null ? null : DateUtils.getDayEndTime((Date)endDate)));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection storageOrg = (DynamicObjectCollection)this.getModel().getValue("mulstorageorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        Date endDate = (Date)this.getModel().getValue("enddate");
        Boolean isInit = (Boolean)this.getModel().getValue("isinit");
        if (storageOrg == null || storageOrg.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (!isInit.booleanValue() && endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCKAccountRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject periodDyc = ReportUtil.getYearPeriodByDate((Object)costAccount.getPkValue(), (Date)endDate);
        if (periodDyc == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"InvCKAccountRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int periodDycNum = periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
        int periodNum = ReportUtil.getBeginPeriod((DynamicObject)costAccount);
        if (periodNum > periodDycNum) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u5fc5\u987b\u5728\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u4e4b\u540e\u3002", (String)"InvCKAccountRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        InvAccountRptParam rptParam = InvAccountRptHelper.buildRptParam(this.getModel());
        this.getQueryParam().getCustomParam().put(InvAccountRptParam.class.getName(), rptParam);
        return super.verifyQuery(queryParam);
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            List storageOrgUnitByCalOrg = OrgHelper.getStorageOrgUnitByCalOrg((Long)costAccount.getLong("calorg.id"));
            if (storageOrgUnitByCalOrg != null && !storageOrgUnitByCalOrg.isEmpty()) {
                QFilter filter = new QFilter("id", "in", (Object)storageOrgUnitByCalOrg.toArray());
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"InvCKAccountRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List pemOrgs = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_invaccount_newrpt", (String)"47150e89000000ac");
        if (pemOrgs == null) {
            return;
        }
        QFilter filter = new QFilter("calorg", "in", (Object)pemOrgs.toArray());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    protected void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        QFilter filter = null;
        DynamicObjectCollection storageOrgDyc = (DynamicObjectCollection)this.getModel().getValue("mulstorageorg");
        if (storageOrgDyc == null || storageOrgDyc.isEmpty()) {
            filter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        } else {
            ArrayList orgIds = new ArrayList(storageOrgDyc.size());
            storageOrgDyc.forEach(item -> orgIds.add(item.get("fbasedataid_id")));
            List startWarehouseIds = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{orgIds});
            filter = new QFilter("id", "in", (Object)startWarehouseIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
    }

    private void setStorageOrg(Long calOrgId) {
        if (calOrgId == null || calOrgId == 0L) {
            return;
        }
        List storageOrgUnitByCalOrg = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
        if (storageOrgUnitByCalOrg != null && !storageOrgUnitByCalOrg.isEmpty()) {
            this.getModel().setValue("mulstorageorg", (Object)storageOrgUnitByCalOrg.toArray());
        }
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("assist");
        removedPros.add("storageorgunit");
        removedPros.add("warehouse");
        removedPros.add("material");
        removedPros.add("material");
        removedPros.add("ownertype");
        removedPros.add("periodid");
        removedPros.add("blockflag");
        return !removedPros.contains(split[0]);
    }
}

