/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.invaccountrpt.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptParam;

public class CalDetailDiffGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -3076112751336523072L;
    private RowMeta rowMeta;
    private InvAccountRptParam rptParam;

    public CalDetailDiffGroupFunction(RowMeta rowMeta, InvAccountRptParam rptParam) {
        this.rowMeta = rowMeta;
        this.rptParam = rptParam;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Long bizBillEntryId;
        HashMap<Long, RowX> bizBillEntryIdRowMap = new HashMap<Long, RowX>(16);
        HashMap<Long, HashMap<String, BigDecimal>> bizBillEntryQtyMap = new HashMap<Long, HashMap<String, BigDecimal>>(16);
        RowX sumRowX = new RowX(this.rowMeta.getFieldCount());
        HashMap<Integer, Object> sumRowFieldsMap = new HashMap<Integer, Object>(16);
        Set<String> groupFieldSet = this.rptParam.getGroupFieldSet();
        groupFieldSet.add("baseunit");
        groupFieldSet.add("materialnum");
        BigDecimal allCalInQty = BigDecimal.ZERO;
        BigDecimal allInvInQty = BigDecimal.ZERO;
        BigDecimal allCalOutQty = BigDecimal.ZERO;
        BigDecimal allInvOutQty = BigDecimal.ZERO;
        int sumrowIdx = this.rowMeta.getFieldIndex("sumrow");
        int lineTypeIdx = this.rowMeta.getFieldIndex("linetype");
        int bizbillentryIdIdx = this.rowMeta.getFieldIndex("bizbillentryid");
        int blockflagIdx = this.rowMeta.getFieldIndex("blockflag");
        int calinqtyIdx = this.rowMeta.getFieldIndex("calinqty");
        int invinqtyIdx = this.rowMeta.getFieldIndex("invinqty");
        int indiffqtyIdx = this.rowMeta.getFieldIndex("indiffqty");
        int caloutqtyIdx = this.rowMeta.getFieldIndex("caloutqty");
        int invoutqtyIdx = this.rowMeta.getFieldIndex("invoutqty");
        int outdiffqtyIdx = this.rowMeta.getFieldIndex("outdiffqty");
        int baseunitIdx = this.rowMeta.getFieldIndex("baseunit");
        int precisionIdx = this.rowMeta.getFieldIndex("precision");
        Long baseunitId = 0L;
        int precision = 0;
        for (RowX row : iterable) {
            Integer n = row.getInteger(precisionIdx);
            if (n != null && precision < n) {
                precision = n;
                baseunitId = row.getLong(baseunitIdx);
            }
            bizBillEntryId = row.getLong(bizbillentryIdIdx);
            String blockflag = row.getString(blockflagIdx);
            if (bizBillEntryIdRowMap.get(bizBillEntryId) == null) {
                bizBillEntryIdRowMap.put(bizBillEntryId, row);
            } else if (blockflag.contains("record")) {
                bizBillEntryIdRowMap.put(bizBillEntryId, row);
            }
            HashMap<String, BigDecimal> qtyMap = (HashMap<String, BigDecimal>)bizBillEntryQtyMap.get(bizBillEntryId);
            BigDecimal calInQty = row.getBigDecimal(calinqtyIdx);
            BigDecimal invInQty = row.getBigDecimal(invinqtyIdx);
            BigDecimal calOutQty = row.getBigDecimal(caloutqtyIdx);
            BigDecimal invOutQty = row.getBigDecimal(invoutqtyIdx);
            if (qtyMap == null) {
                qtyMap = new HashMap<String, BigDecimal>(16);
                qtyMap.put("calin", calInQty);
                qtyMap.put("invin", invInQty);
                qtyMap.put("calout", calOutQty);
                qtyMap.put("invout", invOutQty);
            } else {
                qtyMap.put("calin", ((BigDecimal)qtyMap.get("calin")).add(calInQty));
                qtyMap.put("invin", ((BigDecimal)qtyMap.get("invin")).add(invInQty));
                qtyMap.put("calout", ((BigDecimal)qtyMap.get("calout")).add(calOutQty));
                qtyMap.put("invout", ((BigDecimal)qtyMap.get("invout")).add(invOutQty));
            }
            bizBillEntryQtyMap.put(bizBillEntryId, qtyMap);
            for (String groupField : groupFieldSet) {
                Integer fieldIdx = this.rowMeta.getFieldIndex(groupField);
                if (sumRowFieldsMap.get(fieldIdx) != null) continue;
                sumRowFieldsMap.put(fieldIdx, row.get(fieldIdx.intValue()));
            }
            allCalInQty = allCalInQty.add(calInQty);
            allInvInQty = allInvInQty.add(invInQty);
            allCalOutQty = allCalOutQty.add(calOutQty);
            allInvOutQty = allInvOutQty.add(invOutQty);
        }
        if (allCalInQty.subtract(allInvInQty).compareTo(BigDecimal.ZERO) == 0 && allCalOutQty.subtract(allInvOutQty).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        for (String string : groupFieldSet) {
            Integer fieldIdx = this.rowMeta.getFieldIndex(string);
            if (sumRowFieldsMap.get(fieldIdx) == null) continue;
            sumRowX.set(fieldIdx.intValue(), sumRowFieldsMap.get(fieldIdx));
        }
        sumRowX.set(calinqtyIdx, (Object)allCalInQty);
        sumRowX.set(invinqtyIdx, (Object)allInvInQty);
        sumRowX.set(indiffqtyIdx, (Object)allCalInQty.subtract(allInvInQty));
        sumRowX.set(caloutqtyIdx, (Object)allCalOutQty);
        sumRowX.set(invoutqtyIdx, (Object)allInvOutQty);
        sumRowX.set(outdiffqtyIdx, (Object)allCalOutQty.subtract(allInvOutQty));
        sumRowX.set(lineTypeIdx, (Object)BigDecimal.ONE);
        sumRowX.set(sumrowIdx, (Object)BigDecimal.ZERO);
        sumRowX.set(baseunitIdx, (Object)baseunitId);
        sumRowX.set(precisionIdx, (Object)precision);
        collector.collect(sumRowX);
        for (Map.Entry entry : bizBillEntryQtyMap.entrySet()) {
            bizBillEntryId = (Long)entry.getKey();
            Map billQtyMap = (Map)entry.getValue();
            BigDecimal calInQty = (BigDecimal)billQtyMap.get("calin");
            BigDecimal invInQty = (BigDecimal)billQtyMap.get("invin");
            BigDecimal calOutQty = (BigDecimal)billQtyMap.get("calout");
            BigDecimal invOutQty = (BigDecimal)billQtyMap.get("invout");
            BigDecimal inDiffQty = calInQty.subtract(invInQty);
            BigDecimal outDiffQty = calOutQty.subtract(invOutQty);
            if (inDiffQty.compareTo(BigDecimal.ZERO) == 0 && outDiffQty.compareTo(BigDecimal.ZERO) == 0) continue;
            RowX bizBillRowX = (RowX)bizBillEntryIdRowMap.get(bizBillEntryId);
            bizBillRowX.set(calinqtyIdx, (Object)calInQty);
            bizBillRowX.set(invinqtyIdx, (Object)invInQty);
            bizBillRowX.set(indiffqtyIdx, (Object)inDiffQty);
            bizBillRowX.set(caloutqtyIdx, (Object)calOutQty);
            bizBillRowX.set(invoutqtyIdx, (Object)invOutQty);
            bizBillRowX.set(outdiffqtyIdx, (Object)outDiffQty);
            collector.collect(bizBillRowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

