/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.invaccountrpt.function;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptParam;

public class CalDiffGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -3076112751336523072L;
    private RowMeta rowMeta;
    private InvAccountRptParam rptParam;

    public CalDiffGroupFunction(RowMeta rowMeta, InvAccountRptParam rptParam) {
        this.rowMeta = rowMeta;
        this.rptParam = rptParam;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int precision;
        int calbeginqtyIdx = this.rowMeta.getFieldIndex("calbeginqty");
        int invbeginqtyIdx = this.rowMeta.getFieldIndex("invbeginqty");
        int begindiffqtyIdx = this.rowMeta.getFieldIndex("begindiffqty");
        int calinqtyIdx = this.rowMeta.getFieldIndex("calinqty");
        int invinqtyIdx = this.rowMeta.getFieldIndex("invinqty");
        int indiffqtyIdx = this.rowMeta.getFieldIndex("indiffqty");
        int caloutqtyIdx = this.rowMeta.getFieldIndex("caloutqty");
        int invoutqtyIdx = this.rowMeta.getFieldIndex("invoutqty");
        int outdiffqtyIdx = this.rowMeta.getFieldIndex("outdiffqty");
        int calendqtyIdx = this.rowMeta.getFieldIndex("calendqty");
        int invendqtyIdx = this.rowMeta.getFieldIndex("invendqty");
        int enddiffqtyIdx = this.rowMeta.getFieldIndex("enddiffqty");
        int baseunitIdx = this.rowMeta.getFieldIndex("baseunit");
        int precisionIdx = this.rowMeta.getFieldIndex("precision");
        Iterator<RowX> iterator = iterable.iterator();
        RowX firstRowX = iterator.next();
        BigDecimal calbeginqty = firstRowX.getBigDecimal(calbeginqtyIdx);
        BigDecimal invbeginqty = firstRowX.getBigDecimal(invbeginqtyIdx);
        BigDecimal calinqty = firstRowX.getBigDecimal(calinqtyIdx);
        BigDecimal invinqty = firstRowX.getBigDecimal(invinqtyIdx);
        BigDecimal caloutqty = firstRowX.getBigDecimal(caloutqtyIdx);
        BigDecimal invoutqty = firstRowX.getBigDecimal(invoutqtyIdx);
        long baseunitId = firstRowX.getLong(baseunitIdx) == null ? 0L : firstRowX.getLong(baseunitIdx);
        int n = precision = firstRowX.getInteger(precisionIdx) == null ? 0 : firstRowX.getInteger(precisionIdx);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            calbeginqty = calbeginqty.add(row.getBigDecimal(calbeginqtyIdx));
            invbeginqty = invbeginqty.add(row.getBigDecimal(invbeginqtyIdx));
            calinqty = calinqty.add(row.getBigDecimal(calinqtyIdx));
            invinqty = invinqty.add(row.getBigDecimal(invinqtyIdx));
            caloutqty = caloutqty.add(row.getBigDecimal(caloutqtyIdx));
            invoutqty = invoutqty.add(row.getBigDecimal(invoutqtyIdx));
            Integer rowPrecision = row.getInteger(precisionIdx);
            if (rowPrecision == null || precision >= rowPrecision) continue;
            precision = rowPrecision;
            baseunitId = row.getLong(baseunitIdx);
        }
        if (calbeginqty.compareTo(BigDecimal.ZERO) == 0 && invbeginqty.compareTo(BigDecimal.ZERO) == 0 && calinqty.compareTo(BigDecimal.ZERO) == 0 && invinqty.compareTo(BigDecimal.ZERO) == 0 && caloutqty.compareTo(BigDecimal.ZERO) == 0 && invoutqty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal beginDiffQty = calbeginqty.subtract(invbeginqty);
        firstRowX.set(calbeginqtyIdx, (Object)calbeginqty);
        firstRowX.set(invbeginqtyIdx, (Object)invbeginqty);
        firstRowX.set(begindiffqtyIdx, (Object)beginDiffQty);
        BigDecimal inDiffQty = calinqty.subtract(invinqty);
        firstRowX.set(calinqtyIdx, (Object)calinqty);
        firstRowX.set(invinqtyIdx, (Object)invinqty);
        firstRowX.set(indiffqtyIdx, (Object)inDiffQty);
        BigDecimal outDiffQty = caloutqty.subtract(invoutqty);
        firstRowX.set(caloutqtyIdx, (Object)caloutqty);
        firstRowX.set(invoutqtyIdx, (Object)invoutqty);
        firstRowX.set(outdiffqtyIdx, (Object)outDiffQty);
        BigDecimal calendqty = calbeginqty.add(calinqty).subtract(caloutqty);
        BigDecimal invendqty = invbeginqty.add(invinqty).subtract(invoutqty);
        BigDecimal endDiffQty = calendqty.subtract(invendqty);
        firstRowX.set(calendqtyIdx, (Object)calendqty);
        firstRowX.set(invendqtyIdx, (Object)invendqty);
        firstRowX.set(enddiffqtyIdx, (Object)endDiffQty);
        firstRowX.set(baseunitIdx, (Object)baseunitId);
        firstRowX.set(precisionIdx, (Object)precision);
        if (this.rptParam.isIsonlydiff() && beginDiffQty.compareTo(BigDecimal.ZERO) == 0 && inDiffQty.compareTo(BigDecimal.ZERO) == 0 && outDiffQty.compareTo(BigDecimal.ZERO) == 0 && endDiffQty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        collector.collect(firstRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

