/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.invaccountrpt.handle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptHelper;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptParam;
import kd.fi.cal.report.newreport.invaccountrpt.transform.AddInvBillDataXTransform;
import kd.fi.cal.report.newreport.invaccountrpt.transform.CalBalDataXTransform;
import kd.fi.cal.report.newreport.invaccountrpt.transform.CalDiffQtyDataXTransform;
import kd.fi.cal.report.newreport.invaccountrpt.transform.ResultDataTransform;

public class InvAccountRptHandle
implements IReportDataHandle {
    private InvAccountRptParam rptParam;
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Set<String> newBalDimFields = CalBalanceModelHelper.getDimField();
    private Set<String> otherBalDims = new HashSet<String>(16);
    private SrcBlockConf invBlockConf = null;

    public void setupCtx(ReportDataCtx ctx) {
        this.rptParam = (InvAccountRptParam)ctx.getParam(InvAccountRptParam.class.getName());
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
        if (!this.otherBalDims.isEmpty()) {
            for (String dim : this.otherBalDims) {
                repoColFilter.add(dim);
            }
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        ArrayList<SrcBlockConf> resultBlocks = new ArrayList<SrcBlockConf>(16);
        List<QFilter> recordQs = InvAccountRptHelper.getRecordQFilter(this.rptParam);
        QFilter balanceQ = InvAccountRptHelper.getBalanceQFilter(this.rptParam);
        QFilter invCalBalanceQ = InvAccountRptHelper.getInvCalBalanceQ(this.rptParam);
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            if ("im_cal_periodbalance".equals(srcEntity)) {
                this.invBlockConf = blockConf;
            }
            if ("cal_costrecord_subentity".equals(srcEntity) && !this.rptParam.isIsinit()) {
                for (QFilter recordQ : recordQs) {
                    this.addBlockConf(recordQ.copy(), null, blockConf, resultBlocks);
                }
                continue;
            }
            if ("cal_balance".equals(srcEntity) && !this.isNewBalance && !this.rptParam.isShowdetail()) {
                this.addBlockConf(balanceQ, null, blockConf, resultBlocks);
                continue;
            }
            if ("cal_bal".equals(srcEntity) && this.isNewBalance && !this.rptParam.isShowdetail()) {
                this.addNewBalDimCols(ctx, blockConf);
                this.addBlockConf(balanceQ, new CalBalDataXTransform(ctx, this.otherBalDims), blockConf, resultBlocks);
                continue;
            }
            if (!"im_cal_periodbalance".equals(srcEntity) || this.rptParam.isShowdetail()) continue;
            this.addBlockConf(invCalBalanceQ, null, blockConf, resultBlocks);
        }
        ctx.getReportConf().setSrcBlockConf(resultBlocks);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        if (!this.rptParam.isIsinit()) {
            transCollector.add(new AddInvBillDataXTransform(this.rptParam, ctx, this.invBlockConf));
        }
        transCollector.add(new CalDiffQtyDataXTransform(this.rptParam, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ResultDataTransform(this.rptParam));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        InvAccountRptHelper.createHideColumns(cols, this.rptParam);
        InvAccountRptHelper.createDecimalColumns(cols, this.rptParam);
        return cols;
    }

    private void addBlockConf(QFilter q, IDataXTransform transForm, SrcBlockConf blockConf, List<SrcBlockConf> resultBlocks) {
        SrcBlockConf srcBlockConf = new SrcBlockConf();
        srcBlockConf.setDefVals(blockConf.getDefVals());
        srcBlockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        srcBlockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        srcBlockConf.setSrcEntity(blockConf.getSrcEntity());
        srcBlockConf.setType(blockConf.getType());
        QFilter uniondataFs = blockConf.getDataFs();
        if (uniondataFs != null) {
            q.and(uniondataFs);
        }
        srcBlockConf.setDataFs(q);
        List dataTransForm = srcBlockConf.getDataTransform();
        if (dataTransForm != null && transForm != null) {
            dataTransForm.add(transForm);
        }
        srcBlockConf.setAllowNotMatch(true);
        resultBlocks.add(srcBlockConf);
    }

    private void addNewBalDimCols(ReportDataCtx ctx, SrcBlockConf blockConf) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        for (String dim : this.newBalDimFields) {
            if (allKeyColsA.contains(dim) || allKeyColsB.contains(dim) || allKeyColsC.contains(dim)) continue;
            this.otherBalDims.add(dim);
        }
        Map srcColMap = blockConf.getRepoColSrcColMap();
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        if (!this.otherBalDims.isEmpty()) {
            for (String dim : this.otherBalDims) {
                srcColMap.put(dim, dim);
                repoColFullSrcColMap.put(dim, dim);
            }
        }
        blockConf.setRepoColSrcColMap(srcColMap);
        blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
    }
}

