/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.invaccountrpt.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.datatype.UnknownType;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptHelper;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptParam;

public class AddInvBillDataXTransform
implements IDataXTransform {
    private InvAccountRptParam rptParam;
    private ReportDataCtx ctx;
    private Map<String, String> repoColSrcColMap = null;
    private SrcBlockConf invBlockConf = null;

    public AddInvBillDataXTransform(InvAccountRptParam rptParam, ReportDataCtx ctx, SrcBlockConf invBlockConf) {
        this.rptParam = rptParam;
        this.ctx = ctx;
        this.invBlockConf = invBlockConf;
    }

    public DataSetX doTransform(DataSetX srcData) {
        this.repoColSrcColMap = this.invBlockConf.getRepoColSrcColMap();
        if (this.repoColSrcColMap == null || this.repoColSrcColMap.isEmpty()) {
            return srcData;
        }
        BalanceUpdateRuleReader balanceRuleReader = new BalanceUpdateRuleReader();
        List ruleElements = BalanceUpdateRuleReader.loadRulesByBalance((String)"im_cal_periodbalance");
        if (ruleElements.isEmpty()) {
            return srcData;
        }
        ArrayList<BalanceUpdateRuleElement> inElements = new ArrayList<BalanceUpdateRuleElement>(16);
        ArrayList<BalanceUpdateRuleElement> outElements = new ArrayList<BalanceUpdateRuleElement>(16);
        for (BalanceUpdateRuleElement element : ruleElements) {
            if (element.getCustStatus().equals("2")) continue;
            if (element.getPeriodQtyType().equals("2")) {
                inElements.add(element);
                continue;
            }
            if (!element.getPeriodQtyType().equals("3")) continue;
            outElements.add(element);
        }
        List<OrmInput> invBillIOs = new ArrayList<OrmInput>(16);
        invBillIOs = this.addInvBillDataInput(inElements, invBillIOs, "IN");
        if ((invBillIOs = this.addInvBillDataInput(outElements, invBillIOs, "OUT")).isEmpty()) {
            return srcData;
        }
        DataSetX invBillDataSetX = this.ctx.getCurrentJob().fromInput((Input[])invBillIOs.toArray(new OrmInput[0]));
        RowMeta srcRowMeta = srcData.getRowMeta();
        RowMeta invBillRowMeta = invBillDataSetX.getRowMeta();
        HashSet<String> srcDataFieldList = new HashSet<String>(Arrays.asList(srcRowMeta.getFieldNames()));
        HashSet<String> invBillDataFieldList = new HashSet<String>(Arrays.asList(invBillRowMeta.getFieldNames()));
        for (String field : invBillDataFieldList) {
            DataType fieldDataType = invBillRowMeta.getField(field).getDataType();
            if (!(fieldDataType instanceof UnknownType)) continue;
            DataType srcFiledDataType = srcRowMeta.getField(field).getDataType();
            invBillDataSetX.getRowMeta().getField(field).setDataType(srcFiledDataType);
        }
        srcDataFieldList.removeAll(invBillDataFieldList);
        if (!srcDataFieldList.isEmpty()) {
            ArrayList<Field> newfields = new ArrayList<Field>(16);
            ArrayList<Object> fieldsValues = new ArrayList<Object>(16);
            for (String fieldName : srcDataFieldList) {
                Field field = srcData.getRowMeta().getField(fieldName);
                DataType fieldType = field.getDataType();
                newfields.add(new Field(fieldName, fieldType));
                if (fieldType instanceof BigDecimalType) {
                    fieldsValues.add(BigDecimal.ZERO);
                    continue;
                }
                if (fieldType instanceof LongType) {
                    fieldsValues.add(0L);
                    continue;
                }
                if (fieldType instanceof StringType) {
                    fieldsValues.add("");
                    continue;
                }
                fieldsValues.add(null);
            }
            invBillDataSetX = invBillDataSetX.addFields(newfields.toArray(new Field[0]), fieldsValues.toArray());
        }
        srcData = srcData.union(invBillDataSetX.select(srcData.getRowMeta().getFieldNames()));
        return srcData;
    }

    private List<OrmInput> addInvBillDataInput(List<BalanceUpdateRuleElement> elements, List<OrmInput> invBillIOs, String type) {
        for (BalanceUpdateRuleElement element : elements) {
            String invBillEntityNumber = element.getSourceEntityNumber();
            HashMap<String, String> balanceFieldMap = new HashMap<String, String>(16);
            MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)invBillEntityNumber);
            String entryName = "";
            for (BalanceFieldMapItem item : element.getFieldMapPolicy().getBalanceFieldMapItems()) {
                IDataEntityProperty fieldProperty;
                String targetFieldName = item.getTargetField();
                String sourceFieldName = item.getSourceField();
                if (sourceFieldName.contains(".")) {
                    sourceFieldName = sourceFieldName.split("\\.")[0];
                }
                if ((fieldProperty = billEntity.findProperty(sourceFieldName)) == null) continue;
                String newFieldName = null;
                if (fieldProperty.getParent() instanceof EntryType) {
                    if (fieldProperty.getParent().getParent() instanceof EntryType) {
                        entryName = fieldProperty.getParent().getParent().getName() + "." + fieldProperty.getParent().getName();
                        newFieldName = entryName + "." + item.getSourceField();
                    } else {
                        entryName = fieldProperty.getParent().getName();
                        newFieldName = entryName + "." + item.getSourceField();
                    }
                } else {
                    newFieldName = item.getSourceField();
                }
                balanceFieldMap.put(item.getTargetField(), newFieldName);
            }
            balanceFieldMap.put("bizentityobject", element.getSourceEntityNumber());
            MainEntityType repoColEntity = MetadataServiceHelper.getDataEntityType((String)"cal_invaccount_cols");
            Map repoColFieldMap = repoColEntity.getFields();
            String selectFields = InvAccountRptHelper.getInvBillSelect(balanceFieldMap, this.repoColSrcColMap, repoColFieldMap, entryName, type);
            FilterCondition filterCondition = element.getDfPolicy().getBalanceCondition().getFilterCondition();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)invBillEntityNumber);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter billQ = filterBuilder.getQFilter();
            billQ = InvAccountRptHelper.getInvBillQ(billQ, balanceFieldMap, this.rptParam);
            if (this.ctx.getCommonFs() != null) {
                QFilter billcommonQ = this.ctx.getCommonFs().copy();
                QfilterFunction Qfunc = new QfilterFunction(balanceFieldMap, this.repoColSrcColMap);
                if ((billcommonQ = billcommonQ.trans((Function)Qfunc)) != null) {
                    billQ.and(billcommonQ);
                }
            }
            if (invBillEntityNumber.contains("im_mdc_")) {
                billQ.and("billtype.billformid.number", "=", (Object)invBillEntityNumber);
            }
            OrmInput input = new OrmInput(this.getClass().getName(), invBillEntityNumber, selectFields, billQ.toArray());
            invBillIOs.add(input);
        }
        return invBillIOs;
    }

    private static class QfilterFunction
    implements Function<QFilter, QFilter> {
        Map<String, String> repoColSrcColMap;
        Map<String, String> balanceFieldMap;

        public QfilterFunction(Map<String, String> balanceFieldMap, Map<String, String> repoColSrcColMap) {
            this.balanceFieldMap = balanceFieldMap;
            this.repoColSrcColMap = repoColSrcColMap;
        }

        @Override
        public QFilter apply(QFilter f) {
            String repoCol = f.getProperty();
            CharSequence[] splitCols = repoCol.split("\\.");
            String balanceFiled = this.repoColSrcColMap.get(splitCols[0]);
            if (balanceFiled == null) {
                return new QFilter("1", "=", (Object)1);
            }
            String invBillField = this.balanceFieldMap.get(balanceFiled);
            if (invBillField == null) {
                return new QFilter("1", "=", (Object)1);
            }
            splitCols[0] = invBillField;
            f.__setProperty(String.join((CharSequence)".", splitCols));
            return f;
        }
    }
}

