/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.invaccountrpt.transform;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cal.report.newreport.invaccountrpt.InvAccountRptParam;

public class AddSumRowGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -3076112751336523072L;
    private RowMeta rowMeta;
    private InvAccountRptParam rptParam;

    public AddSumRowGroupFunction(RowMeta rowMeta, InvAccountRptParam rptParam) {
        this.rowMeta = rowMeta;
        this.rptParam = rptParam;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX sumRowX = new RowX(this.rowMeta.getFieldCount());
        int sumrowIdx = this.rowMeta.getFieldIndex("sumrow");
        int materialNumIdx = this.rowMeta.getFieldIndex("materialnum");
        int lineTypeIdx = this.rowMeta.getFieldIndex("linetype");
        int baseunitIdx = this.rowMeta.getFieldIndex("baseunit");
        int precisionIdx = this.rowMeta.getFieldIndex("precision");
        int calbeginqtyIdx = this.rowMeta.getFieldIndex("calbeginqty");
        int invbeginqtyIdx = this.rowMeta.getFieldIndex("invbeginqty");
        int begindiffqtyIdx = this.rowMeta.getFieldIndex("begindiffqty");
        int calinqtyIdx = this.rowMeta.getFieldIndex("calinqty");
        int invinqtyIdx = this.rowMeta.getFieldIndex("invinqty");
        int indiffqtyIdx = this.rowMeta.getFieldIndex("indiffqty");
        int caloutqtyIdx = this.rowMeta.getFieldIndex("caloutqty");
        int invoutqtyIdx = this.rowMeta.getFieldIndex("invoutqty");
        int outdiffqtyIdx = this.rowMeta.getFieldIndex("outdiffqty");
        int calendqtyIdx = this.rowMeta.getFieldIndex("calendqty");
        int invendqtyIdx = this.rowMeta.getFieldIndex("invendqty");
        int enddiffqtyIdx = this.rowMeta.getFieldIndex("enddiffqty");
        Iterator<RowX> iterator = iterable.iterator();
        Long baseunitId = 0L;
        int precision = 0;
        BigDecimal calbeginqty = BigDecimal.ZERO;
        BigDecimal invbeginqty = BigDecimal.ZERO;
        BigDecimal beginDiffQty = BigDecimal.ZERO;
        BigDecimal calinqty = BigDecimal.ZERO;
        BigDecimal invinqty = BigDecimal.ZERO;
        BigDecimal inDiffQty = BigDecimal.ZERO;
        BigDecimal caloutqty = BigDecimal.ZERO;
        BigDecimal invoutqty = BigDecimal.ZERO;
        BigDecimal outDiffQty = BigDecimal.ZERO;
        BigDecimal calendqty = BigDecimal.ZERO;
        BigDecimal invendqty = BigDecimal.ZERO;
        BigDecimal endDiffQty = BigDecimal.ZERO;
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            if (this.rptParam.isShowdetail() && row.getBigDecimal(lineTypeIdx).compareTo(BigDecimal.ONE) != 0) continue;
            Integer rowPrecision = row.getInteger(precisionIdx);
            if (rowPrecision != null && precision < rowPrecision) {
                precision = rowPrecision;
                baseunitId = row.getLong(baseunitIdx);
            }
            calbeginqty = calbeginqty.add(row.getBigDecimal(calbeginqtyIdx) == null ? BigDecimal.ZERO : row.getBigDecimal(calbeginqtyIdx));
            invbeginqty = invbeginqty.add(row.getBigDecimal(invbeginqtyIdx) == null ? BigDecimal.ZERO : row.getBigDecimal(invbeginqtyIdx));
            beginDiffQty = beginDiffQty.add(row.getBigDecimal(begindiffqtyIdx) == null ? BigDecimal.ZERO : row.getBigDecimal(begindiffqtyIdx));
            calinqty = calinqty.add(row.getBigDecimal(calinqtyIdx));
            invinqty = invinqty.add(row.getBigDecimal(invinqtyIdx));
            inDiffQty = inDiffQty.add(row.getBigDecimal(indiffqtyIdx));
            caloutqty = caloutqty.add(row.getBigDecimal(caloutqtyIdx));
            invoutqty = invoutqty.add(row.getBigDecimal(invoutqtyIdx));
            outDiffQty = outDiffQty.add(row.getBigDecimal(outdiffqtyIdx));
            calendqty = calendqty.add(row.getBigDecimal(calendqtyIdx) == null ? BigDecimal.ZERO : row.getBigDecimal(calendqtyIdx));
            invendqty = invendqty.add(row.getBigDecimal(invendqtyIdx) == null ? BigDecimal.ZERO : row.getBigDecimal(invendqtyIdx));
            endDiffQty = endDiffQty.add(row.getBigDecimal(enddiffqtyIdx) == null ? BigDecimal.ZERO : row.getBigDecimal(enddiffqtyIdx));
        }
        sumRowX.set(sumrowIdx, (Object)BigDecimal.ONE);
        sumRowX.set(calbeginqtyIdx, (Object)calbeginqty);
        sumRowX.set(invbeginqtyIdx, (Object)invbeginqty);
        sumRowX.set(begindiffqtyIdx, (Object)beginDiffQty);
        sumRowX.set(calinqtyIdx, (Object)calinqty);
        sumRowX.set(invinqtyIdx, (Object)invinqty);
        sumRowX.set(indiffqtyIdx, (Object)inDiffQty);
        sumRowX.set(caloutqtyIdx, (Object)caloutqty);
        sumRowX.set(invoutqtyIdx, (Object)invoutqty);
        sumRowX.set(outdiffqtyIdx, (Object)outDiffQty);
        sumRowX.set(calendqtyIdx, (Object)calendqty);
        sumRowX.set(invendqtyIdx, (Object)invendqty);
        sumRowX.set(enddiffqtyIdx, (Object)endDiffQty);
        sumRowX.set(baseunitIdx, (Object)baseunitId);
        sumRowX.set(materialNumIdx, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_45", (String)"fi-cal-report", (Object[])new Object[0]));
        sumRowX.set(lineTypeIdx, (Object)BigDecimal.ONE);
        collector.collect(sumRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

