/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;
import kd.fi.cal.report.newreport.stockagelrpt.function.CalrangeCopyGroupFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.CostInfoGroupReduceFunction;

public class StockAgeReportUtil {
    private static final String COSTADJUST = "costadjust";
    private static final String COSTRECORD = "costrecord";
    private static final String BALANCE = "balance";
    private static final int BATCH_SIZE = 500000;

    public static boolean hasGroupByName(Set<String> showKeyCols, String keyName) {
        boolean hasGroupName = false;
        if (showKeyCols != null && showKeyCols.size() > 0 && !StringUtils.isBlank((String)keyName) && showKeyCols.contains(keyName)) {
            hasGroupName = true;
        }
        return hasGroupName;
    }

    public static String getCommonGroupBy(boolean isHashStor, Set<String> showKeyCols) {
        StringBuilder select = new StringBuilder();
        HashSet<String> groupStr = new HashSet<String>(16);
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "owner")) {
            groupStr.add("owner");
            groupStr.add("ownertype");
            showKeyCols.add("ownertype");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") || isHashStor) {
            groupStr.add("storageorg");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") && !isHashStor) {
                groupStr.add("storageorg");
            }
            groupStr.add("group");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
            if (!(StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") || StockAgeReportUtil.hasGroupByName(showKeyCols, "group") || isHashStor)) {
                groupStr.add("storageorg");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
                groupStr.add("group");
            }
            groupStr.add("warehouse");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "location")) {
            if (!(StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") || StockAgeReportUtil.hasGroupByName(showKeyCols, "group") || StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse") || isHashStor)) {
                groupStr.add("storageorg");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "group") && !StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
                groupStr.add("group");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
                groupStr.add("warehouse");
            }
            groupStr.add("location");
        }
        groupStr.addAll(showKeyCols);
        for (String group : groupStr) {
            select.append(group);
            select.append(",");
        }
        return select.substring(0, select.length() - 1);
    }

    public static DataSet createDataSet(ReportDataCtx ctx, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        ctx.getCurrentJob().commit(60, TimeUnit.MINUTES);
        return ctx.getCurrentJob().readDataSet(resultId);
    }

    public static DataSet createDataSet(JobSession session, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        session.commit(60, TimeUnit.MINUTES);
        return session.readDataSet(resultId);
    }

    public static QFilter buildCommonFilter(String formType, StockAgeReportBplatParam reportParam) {
        DynamicObjectCollection filter_tracknumber;
        HashSet<Object> set;
        HashSet<Object> set2;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (Object materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                if (BALANCE.equals(formType)) {
                    q.and("material.id", "in", materialSet);
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.id", "in", materialSet);
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.id", "in", materialSet);
                }
            } else if (reportParam.getMaterialFrom().size() == 1) {
                if (BALANCE.equals(formType)) {
                    q.and("material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
                }
            }
        }
        if (reportParam.getMaterialTo() != null) {
            if (BALANCE.equals(formType)) {
                q.and("material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
            }
        }
        if (StringUtils.isNotEmpty((String)reportParam.getOwnertype())) {
            String entry = "";
            if (COSTRECORD.equals(formType)) {
                entry = "entry.";
            } else if (COSTADJUST.equals(formType)) {
                entry = "entryentity.";
            }
            q.and(entry + "ownertype", "=", (Object)reportParam.getOwnertype());
            if (reportParam.getOwner() != null && reportParam.getOwner().size() > 0) {
                set2 = new HashSet<Object>();
                for (DynamicObject info : reportParam.getOwner()) {
                    set2.add(info.getDynamicObject("fbasedataid").getPkValue());
                }
                q.and(entry + "owner", "in", set2);
            }
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            set = new HashSet<Object>();
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (COSTADJUST.equals(formType)) {
                q.and("entryentity.storageorgunit", "in", set);
            } else {
                q.and("storageorgunit", "in", set);
            }
        }
        if (!reportParam.getWarehsGroupSet().isEmpty()) {
            if (BALANCE.equals(formType)) {
                q.and("warehouse.group", "in", reportParam.getWarehsGroupSet());
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.warehouse.group", "in", reportParam.getWarehsGroupSet());
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.warehouse.group", "in", reportParam.getWarehsGroupSet());
            }
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet();
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("warehouse", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.warehouse", "in", set);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.warehouse", "in", set);
            }
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet();
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("location", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.location", "in", set);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.location", "in", set);
            }
        }
        if ((filter_tracknumber = reportParam.getMultracknumber()) != null && filter_tracknumber.size() > 0) {
            set2 = new HashSet();
            for (DynamicObject info : filter_tracknumber) {
                set2.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("tracknumber", "in", set2);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.tracknumber", "in", set2);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.tracknumber", "in", set2);
            }
        }
        return q;
    }

    public static QFilter getCostAdjustFilter(StockAgeReportBplatParam reportParam) {
        QFilter q = StockAgeReportUtil.buildCommonFilter(COSTADJUST, reportParam);
        q.and("calorg", "in", reportParam.getCalOrgIdSet());
        q.and("billstatus", "=", (Object)BillStatus.C);
        q.and("entryentity.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        return q;
    }

    public static QFilter buildFilterOnlyMaterial(String formType, StockAgeReportBplatParam reportParam) {
        String filter_ownertype;
        DynamicObject filter_materialTo;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalOrgIdSet());
        DynamicObjectCollection filter_materialFrom = reportParam.getMaterialFrom();
        if (filter_materialFrom != null && filter_materialFrom.size() > 0) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                if (BALANCE.equals(formType)) {
                    q.and("material.id", "in", materialSet);
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.id", "in", materialSet);
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.id", "in", materialSet);
                }
            } else if (filter_materialFrom.size() == 1) {
                if (BALANCE.equals(formType)) {
                    q.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
                }
            }
        }
        if ((filter_materialTo = reportParam.getMaterialTo()) != null) {
            if (BALANCE.equals(formType)) {
                q.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.material.number", "<=", (Object)filter_materialTo.getString("number"));
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.material.number", "<=", (Object)filter_materialTo.getString("number"));
            }
        }
        if (StringUtils.isNotEmpty((String)(filter_ownertype = reportParam.getOwnertype()))) {
            String entry = "";
            if (COSTRECORD.equals(formType)) {
                entry = "entry.";
            } else if (COSTADJUST.equals(formType)) {
                entry = "entryentity.";
            }
            q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        }
        return q;
    }

    public static QFilter buildShowDataFilter(String formType, StockAgeReportBplatParam reportParam) {
        DynamicObjectCollection filter_location;
        DynamicObjectCollection filter_warehouse;
        Set<Long> warehsGroupSet;
        DynamicObjectCollection filter_storageOrg;
        DynamicObjectCollection filter_owner;
        String filter_ownertype;
        DynamicObject filter_materialTo;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalOrgIdSet());
        DynamicObjectCollection filter_materialFrom = reportParam.getMaterialFrom();
        if (filter_materialFrom != null && filter_materialFrom.size() > 0) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                if (BALANCE.equals(formType)) {
                    q.and("material.id", "in", materialSet);
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.id", "in", materialSet);
                }
            } else if (filter_materialFrom.size() == 1) {
                if (BALANCE.equals(formType)) {
                    q.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
                }
            }
        }
        if ((filter_materialTo = reportParam.getMaterialTo()) != null) {
            if (BALANCE.equals(formType)) {
                q.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.material.number", "<=", (Object)filter_materialTo.getString("number"));
            }
        }
        if (StringUtils.isNotEmpty((String)(filter_ownertype = reportParam.getOwnertype()))) {
            String entry = "";
            if (COSTRECORD.equals(formType)) {
                entry = "entry.";
            }
            q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        }
        if ((filter_owner = reportParam.getOwner()) != null && filter_owner.size() > 0) {
            HashSet<Object> set = new HashSet<Object>();
            for (Iterator info : filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("owner", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.owner", "in", set);
            }
        }
        if ((filter_storageOrg = reportParam.getStorageOrg()) != null && filter_storageOrg.size() > 0) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("storageorgunit", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("storageorgunit", "in", set);
            }
        }
        if (!(warehsGroupSet = reportParam.getWarehsGroupSet()).isEmpty()) {
            if (BALANCE.equals(formType)) {
                q.and("warehouse.group", "in", warehsGroupSet);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.warehouse.group", "in", warehsGroupSet);
            }
        }
        if ((filter_warehouse = reportParam.getWarehouse()) != null && filter_warehouse.size() > 0) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("warehouse", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.warehouse", "in", set);
            }
        }
        if ((filter_location = reportParam.getLocation()) != null && filter_location.size() > 0) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : filter_location) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("location", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.location", "in", set);
            }
        }
        return q;
    }

    public static JoinDataSetX getTargetJoinDataSet(JoinDataSetX joinDataSet, Set<String> showKeyCols, StockAgeReportBplatParam reportParam, boolean isNeedFilterFields) {
        HashSet<String> JoinDataSetOnFields = new HashSet<String>(16);
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "owner")) {
            JoinDataSetOnFields.add("owner");
            JoinDataSetOnFields.add("ownertype");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg")) {
            JoinDataSetOnFields.add("storageorg");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg")) {
                JoinDataSetOnFields.add("storageorg");
            }
            JoinDataSetOnFields.add("group");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") && !StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
                JoinDataSetOnFields.add("storageorg");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
                JoinDataSetOnFields.add("group");
            }
            JoinDataSetOnFields.add("warehouse");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "location")) {
            if (!(StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") || StockAgeReportUtil.hasGroupByName(showKeyCols, "group") || StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse"))) {
                JoinDataSetOnFields.add("storageorg");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "group") && !StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
                JoinDataSetOnFields.add("group");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
                JoinDataSetOnFields.add("warehouse");
            }
            JoinDataSetOnFields.add("location");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "lot")) {
            JoinDataSetOnFields.add("lot");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "assist")) {
            JoinDataSetOnFields.add("assist");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "tracknumber")) {
            JoinDataSetOnFields.add("tracknumber");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "project")) {
            JoinDataSetOnFields.add("project");
        }
        JoinDataSetOnFields.addAll(showKeyCols);
        for (String name : JoinDataSetOnFields) {
            if (StringUtils.isEmpty((String)name)) continue;
            joinDataSet = joinDataSet.on(name, name);
        }
        if (isNeedFilterFields && !StringUtils.isEmpty((String)reportParam.getFilterFields())) {
            for (String name : reportParam.getFilterFields().split(",")) {
                joinDataSet = joinDataSet.on(name, name);
            }
        }
        return joinDataSet;
    }

    public static String getFilterfields(Set<String> showKeyCols, StockAgeReportBplatParam stockAgeReportBplatParam) {
        StringBuilder fields = new StringBuilder();
        DynamicObjectCollection filter_owner = stockAgeReportBplatParam.getOwner();
        if (showKeyCols != null) {
            DynamicObjectCollection filter_location;
            DynamicObjectCollection filter_warehouse;
            Set<Long> warehsGroupSet;
            DynamicObjectCollection filter_storageOrg;
            if (filter_owner != null && filter_owner.size() > 0 && !StockAgeReportUtil.hasGroupByName(showKeyCols, "owner")) {
                fields.append("owner");
                fields.append(',');
                showKeyCols.add("owner");
            }
            if (!((filter_storageOrg = stockAgeReportBplatParam.getStorageOrg()) == null || filter_storageOrg.size() <= 0 || StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") || StockAgeReportUtil.hasGroupByName(showKeyCols, "group") || StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse") || StockAgeReportUtil.hasGroupByName(showKeyCols, "location"))) {
                fields.append("storageorg");
                fields.append(',');
                showKeyCols.add("storageorg");
            }
            if (!((warehsGroupSet = stockAgeReportBplatParam.getWarehsGroupSet()).isEmpty() || StockAgeReportUtil.hasGroupByName(showKeyCols, "group") || StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse") || StockAgeReportUtil.hasGroupByName(showKeyCols, "location"))) {
                fields.append("group");
                fields.append(',');
                showKeyCols.add("group");
            }
            if ((filter_warehouse = stockAgeReportBplatParam.getWarehouse()) != null && filter_warehouse.size() > 0 && !StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse") && !StockAgeReportUtil.hasGroupByName(showKeyCols, "location")) {
                fields.append("warehouse");
                fields.append(',');
                showKeyCols.add("warehouse");
            }
            if ((filter_location = stockAgeReportBplatParam.getLocation()) != null && filter_location.size() > 0 && !StockAgeReportUtil.hasGroupByName(showKeyCols, "location")) {
                fields.append("location");
                fields.append(',');
                showKeyCols.add("location");
            }
        }
        if (fields.length() > 0) {
            return CommonUtils.trimComma((String)fields.toString());
        }
        return null;
    }

    public static String getNoStatisticalFilterStr(StockAgeReportBplatParam reportParam) {
        String nostatistical = reportParam.getNostatistical();
        StringBuilder filterStr = new StringBuilder("1=1");
        if (nostatistical != null && !nostatistical.isEmpty()) {
            String[] nostatisticalArray = nostatistical.split(",");
            for (int i = 0; i < nostatisticalArray.length; ++i) {
                String tmp = nostatisticalArray[i];
                String[] tmps = tmp.split(":");
                if (tmps.length <= 0) continue;
                String billTypeId = tmps[0];
                filterStr.append(" and ( billtype <> ").append(billTypeId);
                if (tmps.length > 1) {
                    long biztypeId = Long.parseLong(tmps[1]);
                    filterStr.append(" or biztype <> ").append(biztypeId);
                    if (tmps.length > 2) {
                        long invschemeId = Long.parseLong(tmps[2]);
                        filterStr.append(" or invscheme <> ").append(invschemeId);
                    }
                }
                filterStr.append(')');
            }
        }
        return filterStr.toString();
    }

    public static List<QFilter> getBalanceHeadFilters(List<QFilter> headFilters) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stock_age_col_repo");
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>(16);
        if (headFilters != null) {
            for (QFilter q : headFilters) {
                String property = q.getProperty();
                IDataEntityProperty p = entityType.findProperty(property);
                if (null == p) continue;
                if (p instanceof BasedataProp) {
                    String field = ((BasedataProp)p).getDisplayProp();
                    property = property + "." + field;
                }
                q.__setProperty(property);
                List nests = q.getNests(true);
                for (QFilter.QFilterNest net : nests) {
                    QFilter netFilter = net.getFilter();
                    StockAgeReportUtil.rebuildBalanceHeadFilter(netFilter, entityType);
                }
                newHeadFilters.add(q);
            }
        }
        return newHeadFilters;
    }

    private static void rebuildBalanceHeadFilter(QFilter filter, MainEntityType entityType) {
        String property = filter.getProperty();
        IDataEntityProperty p = entityType.findProperty(property);
        if (null == p) {
            return;
        }
        if ("materialnumber".equals(property)) {
            property = "material.number";
        } else if ("materialmodel".equals(property)) {
            property = "material.modelnum";
        } else if (p instanceof BasedataProp) {
            String field = ((BasedataProp)p).getDisplayProp();
            property = property + "." + field;
        }
        filter.__setProperty(property);
    }

    public static boolean isAllContainDifferFalseCalOrg(StockAgeReportBplatParam reportParam) {
        Set<Long> differFalseCalOrgIdSet = reportParam.getContainDifferFalseCalOrgIdSet();
        return null == differFalseCalOrgIdSet || differFalseCalOrgIdSet.isEmpty();
    }

    public static List<Set<Long>> getBatchIdList(Set<Long> ids) {
        ArrayList<Set<Long>> balIdsArray = new ArrayList<Set<Long>>(16);
        HashSet<Long> balIds = null;
        long index = 0L;
        for (Long id : ids) {
            if (index % 500000L == 0L) {
                balIds = new HashSet<Long>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }

    public static DataSetX getIntervalRangeDataSet(DataSetX rangeCostRecordSet, int sumDay, int prevDay, Set<String> groupUnionStrSet, StockAgeReportBplatParam reportParam) {
        HashSet<String> divGroupUninonStrs = new HashSet<String>(groupUnionStrSet);
        divGroupUninonStrs.add("dividebasisvalue");
        divGroupUninonStrs.add("caldimensionvalue");
        divGroupUninonStrs.add("caldimension");
        divGroupUninonStrs.add("dividebasis");
        boolean isAllContainDifferFalseCalOrg = StockAgeReportUtil.isAllContainDifferFalseCalOrg(reportParam);
        if (!isAllContainDifferFalseCalOrg) {
            divGroupUninonStrs.add("materialstandkeycol");
        }
        Date endRangeDate = StockAgeReportUtil.getTargetDateBySubDay(reportParam.getEndDate(), prevDay);
        Date startRangeDate = StockAgeReportUtil.getTargetDateBySubDay(reportParam.getEndDate(), sumDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String filterStr = "date(year(bookdate),month(bookdate),day(bookdate)) <= date(year(%1$s),month(%1$s),day(%1$s))  and date(year(bookdate),month(bookdate),day(bookdate)) >=  date(year(%2$s),month(%2$s),day(%2$s))";
        String endDateStr = "to_date('" + sdf.format(endRangeDate) + "','yyyy-MM-dd')";
        String startDateStr = "to_date('" + sdf.format(startRangeDate) + "','yyyy-MM-dd')";
        filterStr = String.format(filterStr, endDateStr, startDateStr);
        String[] groupStrs = StockAgeReportUtil.getCommonGroupBy(true, divGroupUninonStrs).split(",");
        rangeCostRecordSet = rangeCostRecordSet.filter(filterStr);
        rangeCostRecordSet = rangeCostRecordSet.groupBy(groupStrs).sum("baseqty").sum("standardamount").sum("standardbaseqty").sum("actualqty").sum("actualamount");
        return rangeCostRecordSet;
    }

    public static Date getTargetDateBySubDay(Date endDate, int sumIntervalDay) {
        long endDateTime = endDate.getTime();
        long endPeriodDateTime = endDateTime - 86400000L * (long)sumIntervalDay;
        return new Date(endPeriodDateTime);
    }

    public static DataSetX getStandardPriceDataSetX(StockAgeReportBplatParam reportParam, ReportDataCtx ctx) {
        QFilter orgFilter = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        QFilter baseFilter = new QFilter("bizstatus", "=", (Object)"1");
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)reportParam.getEndDate());
        timeFilter.and("invaliddate", ">", (Object)reportParam.getEndDate());
        OrmInput billIO = new OrmInput(StockAgeReportUtil.class.getName(), "cal_bd_costtypeorg", "storageorgunit.id as storageorgunit,costtype.id as costtype", new QFilter[]{orgFilter, baseFilter, timeFilter});
        DataSetX costTypeOrgsX = ctx.getCurrentJob().fromInput((Input)billIO);
        ArrayList<Field> newcopyfields = new ArrayList<Field>(16);
        ArrayList<String> newcopyvalues = new ArrayList<String>(16);
        newcopyfields.add(new Field("newcopy", (DataType)DataType.StringType));
        newcopyvalues.add("0");
        costTypeOrgsX = costTypeOrgsX.addFields(newcopyfields.toArray(new Field[0]), newcopyvalues.toArray());
        costTypeOrgsX = costTypeOrgsX.reduceGroup((GroupReduceFunction)new CalrangeCopyGroupFunction(costTypeOrgsX.getRowMeta(), 1));
        DataSetX costTypeOrgsX1 = costTypeOrgsX.filter("newcopy = '0'");
        DataSetX costTypeOrgsX2 = costTypeOrgsX.filter("newcopy = '1'");
        HashSet<Long> costTypeIds = new HashSet<Long>(16);
        costTypeIds.add(1L);
        DataSet costTypeOrgs = StockAgeReportUtil.createDataSet(ctx, costTypeOrgsX2);
        for (Row costTypeOrg : costTypeOrgs) {
            costTypeIds.add(costTypeOrg.getLong("costtype"));
        }
        QFilter q = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        q.and("effectdate", "<=", (Object)reportParam.getEndDate());
        q.and("expdate", ">=", (Object)reportParam.getEndDate());
        q.and("costtype", "in", costTypeIds);
        q.and("status", "=", (Object)"C");
        String field = "costtype.id as costtype,keycol,effectdate,material.id as material,entryentity.standardcost as standardprice,entryentity.element as element,entryentity.subelement as subelement";
        OrmInput costInfobillIO = new OrmInput(StockAgeReportUtil.class.getName(), "cad_matcostinfo", field, new QFilter[]{q});
        DataSetX costInfoSet = ctx.getCurrentJob().fromInput((Input)costInfobillIO);
        JoinDataSetX joinDataSet = costInfoSet.leftJoin(costTypeOrgsX1).on("costtype", "costtype");
        costInfoSet = joinDataSet.select(costInfoSet.getRowMeta().getFieldNames(), new String[]{"storageorgunit"}).filter("storageorgunit is not null");
        costInfoSet = costInfoSet.groupBy(new String[]{"storageorgunit", "material", "effectdate", "costtype", "keycol"}).sum("standardprice");
        costInfoSet = costInfoSet.groupBy(new String[]{"storageorgunit", "material", "costtype", "keycol"}).reduceGroup((GroupReduceFunction)new CostInfoGroupReduceFunction(costInfoSet.getRowMeta()));
        return costInfoSet;
    }

    public static DataSetX getIntervalRangeDiffDataSet(DataSetX rangestdcostdiffSet, int sumDay, int prevDay, Set<String> groupUnionStrSet, StockAgeReportBplatParam reportParam) {
        HashSet<String> divGroupUninonStrs = new HashSet<String>(groupUnionStrSet);
        divGroupUninonStrs.add("dividebasisvalue");
        divGroupUninonStrs.add("caldimensionvalue");
        divGroupUninonStrs.add("caldimension");
        divGroupUninonStrs.add("dividebasis");
        boolean isAllContainDifferFalseCalOrg = StockAgeReportUtil.isAllContainDifferFalseCalOrg(reportParam);
        if (!isAllContainDifferFalseCalOrg) {
            divGroupUninonStrs.add("materialstandkeycol");
        }
        Date endRangeDate = StockAgeReportUtil.getTargetDateBySubDay(reportParam.getEndDate(), prevDay);
        Date startRangeDate = StockAgeReportUtil.getTargetDateBySubDay(reportParam.getEndDate(), sumDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String filterStr = "date(year(bookdate),month(bookdate),day(bookdate)) <= date(year(%1$s),month(%1$s),day(%1$s))  and date(year(bookdate),month(bookdate),day(bookdate)) >=  date(year(%2$s),month(%2$s),day(%2$s))";
        String endDateStr = "to_date('" + sdf.format(endRangeDate) + "','yyyy-MM-dd')";
        String startDateStr = "to_date('" + sdf.format(startRangeDate) + "','yyyy-MM-dd')";
        filterStr = String.format(filterStr, endDateStr, startDateStr);
        String[] groupStrs = StockAgeReportUtil.getCommonGroupBy(true, divGroupUninonStrs).split(",");
        Set<Long> differTrueCalOrgIdSet = reportParam.getContainDifferTrueCalOrgIdSet();
        QFilter qFilter = new QFilter("calorg", "in", differTrueCalOrgIdSet);
        String costAdjustField = StockAgeReportUtil.getCommonGroupBy(true, divGroupUninonStrs) + ",baseqty,actualamount,standardamount";
        rangestdcostdiffSet = rangestdcostdiffSet.filter(filterStr).groupBy(groupStrs).sum("baseqty").sum("standardamount").sum("actualamount");
        rangestdcostdiffSet = rangestdcostdiffSet.select(costAdjustField.split(","));
        rangestdcostdiffSet = rangestdcostdiffSet.filter(qFilter.toString());
        return rangestdcostdiffSet;
    }

    private static Object getDefaultVal(RowX row, String fieldAlias, RowMeta rowMeta) {
        int index = rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public static void setNoUpdateCalFields(RowMeta rowMeta, RowX rowX) {
        JSONObject jsonObject;
        String noUpdateCalFields = rowX.getString(rowMeta.getFieldIndex("noupdatecalfields"));
        if (StringUtils.isNotEmpty((String)noUpdateCalFields) && (jsonObject = JSON.parseObject((String)noUpdateCalFields)) != null) {
            JSONArray noupdateFields = jsonObject.getJSONArray("setnull");
            for (Object noupdateField : noupdateFields) {
                String field;
                if (noupdateField == null || rowMeta.getFieldIndex(field = noupdateField.toString(), Boolean.FALSE.booleanValue()) < 0) continue;
                rowX.set(rowMeta.getFieldIndex(field), StockAgeReportUtil.getDefaultVal(rowX, field, rowMeta));
            }
        }
    }
}

