/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.dataxtransform;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class AddSumClassGroupFieldDataTransform
implements IDataTransform {
    private StockAgeReportBplatParam reportParam;

    public AddSumClassGroupFieldDataTransform(StockAgeReportBplatParam reportParam) {
        this.reportParam = reportParam;
    }

    public DataSet doTransform(DataSet dataSet) {
        StringBuilder select = new StringBuilder();
        String sumString = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockAgeRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
        select.append("costaccount,calorg,0l as materialgroup,currency,baseqty,amount,");
        String groupStr = "costaccount,calorg,currency";
        GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(groupStr.split(","));
        groupbyDataSet = groupbyDataSet.sum("baseqty").sum("amount");
        String[] intervalDays = this.reportParam.getIntervalDays();
        for (int i = 0; i < intervalDays.length; ++i) {
            String prefixField = "range" + i;
            String qtyField = prefixField + "qty";
            String amountField = prefixField + "amount";
            select.append(qtyField);
            select.append(',');
            select.append(amountField);
            select.append(',');
            groupbyDataSet = groupbyDataSet.sum(qtyField).sum(amountField);
        }
        select.append('\'');
        select.append(sumString);
        select.append("' as materialnumber");
        DataSet sumRowDataSet = groupbyDataSet.finish().select(select.toString());
        dataSet = dataSet.addField("' '", "materialnumber").addField("0", "orderinex");
        dataSet = dataSet.addField("0", "linetype").union(sumRowDataSet.addField("1", "orderinex").addField("1", "linetype"));
        dataSet = this.reportParam.isMaterialClassSum() ? dataSet.orderBy(new String[]{"costaccount", "calorg", "orderinex", "materialgroup desc"}) : dataSet.orderBy(new String[]{"costaccount", "calorg", "orderinex"});
        return dataSet;
    }
}

