/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.dataxtransform;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportUtil;
import kd.fi.cal.report.newreport.stockagelrpt.function.CalBalPerPeriodEndMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.CostInfoGroupReduceFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.SetMulFactoryFlagMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.StandardCostPriceMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.StandardpriceMapFunction;

public class CalBalPerPeriodEndFieldDataxTransform
implements IDataXTransform {
    private StockAgeReportBplatParam reportParam;
    private ReportDataCtx ctx;

    public CalBalPerPeriodEndFieldDataxTransform(StockAgeReportBplatParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX calBalanceSet) {
        ArrayList<Field> calbilltypefields = new ArrayList<Field>(16);
        ArrayList<String> calbilltypevalues = new ArrayList<String>(16);
        calbilltypefields.add(new Field("calbilltype", (DataType)DataType.StringType));
        calbilltypevalues.add("IN");
        calBalanceSet = calBalanceSet.addFields(calbilltypefields.toArray(new Field[0]), calbilltypevalues.toArray());
        String[] fieldNames = calBalanceSet.getRowMeta().getFieldNames();
        ArrayList<String> fieldNameList = new ArrayList<String>(Arrays.asList(fieldNames));
        fieldNameList.remove("periodendqty");
        fieldNameList.remove("periodendstandardcost");
        fieldNameList.remove("periodendcostdiff");
        fieldNameList.remove("periodendactualcost");
        fieldNameList.remove("baseqty");
        fieldNameList.remove("actualamount");
        fieldNameList.remove("standardbaseqty");
        fieldNameList.remove("actualqty");
        fieldNameList.remove("standardamount");
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        calBalanceSet = balCompress ? calBalanceSet.groupBy(fieldNameList.toArray(new String[0])).sum("periodendqty").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodendactualcost").sum("baseqty").sum("actualamount").sum("standardbaseqty").sum("actualqty").sum("standardamount") : calBalanceSet.groupBy(fieldNameList.toArray(new String[0])).max("periodendqty").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodendactualcost").sum("baseqty").sum("actualamount").sum("standardbaseqty").sum("actualqty").sum("standardamount");
        calBalanceSet = calBalanceSet.map((MapFunction)new CalBalPerPeriodEndMapFunction(calBalanceSet.getRowMeta(), this.reportParam));
        boolean isAllContainDifferFalseCalOrg = StockAgeReportUtil.isAllContainDifferFalseCalOrg(this.reportParam);
        if (!isAllContainDifferFalseCalOrg) {
            ArrayList<Field> materialstandkeycolfields = new ArrayList<Field>(16);
            ArrayList<String> materialstandkeycolvalues = new ArrayList<String>(16);
            materialstandkeycolfields.add(new Field("materialstandkeycol", (DataType)DataType.StringType));
            materialstandkeycolvalues.add("1");
            calBalanceSet = calBalanceSet.addFields(materialstandkeycolfields.toArray(new Field[0]), materialstandkeycolvalues.toArray());
            calBalanceSet = calBalanceSet.map((MapFunction)new StandardCostPriceMapFunction(calBalanceSet.getRowMeta(), this.reportParam));
            QFilter orgFilter = new QFilter("costaccount", "in", this.reportParam.getCostaccountIdSet());
            orgFilter.and("calorg", "in", this.reportParam.getCalOrgIdSet());
            QFilter baseFilter = new QFilter("bizstatus", "=", (Object)"1");
            QFilter timeFilter = new QFilter("effectdate", "<=", (Object)this.reportParam.getEndDate());
            timeFilter.and("invaliddate", ">", (Object)this.reportParam.getEndDate());
            OrmInput input = new OrmInput(this.getClass().getName(), "cal_bd_costtypeorg", "storageorgunit.id as storageorgunit,costtype.id as costtype", new QFilter[]{orgFilter, baseFilter, timeFilter});
            DataSetX costtypeDataSetX = this.ctx.getCurrentJob().fromInput((Input)input);
            QFilter q = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            q.and("effectdate", "<=", (Object)this.reportParam.getEndDate());
            q.and("expdate", ">=", (Object)this.reportParam.getEndDate());
            if (this.reportParam.getBalanceCostTypeIds() != null && this.reportParam.getBalanceCostTypeIds().size() > 0) {
                q.and("costtype", "in", this.reportParam.getBalanceCostTypeIds());
            }
            q.and("status", "=", (Object)"C");
            String field = "costtype.id as costtype,keycol,effectdate,material.id as material,entryentity.standardcost as standardprice,entryentity.element as element,entryentity.subelement as subelement";
            OrmInput matcostInput = new OrmInput(this.getClass().getName(), "cad_matcostinfo", field, q.toArray());
            DataSetX matcostDataSetX = this.ctx.getCurrentJob().fromInput((Input)matcostInput);
            JoinDataSetX joinDataSetx = matcostDataSetX.leftJoin(costtypeDataSetX).on("costtype", "costtype");
            matcostDataSetX = joinDataSetx.select(matcostDataSetX.getRowMeta().getFieldNames(), new String[]{"storageorgunit"}).filter("storageorgunit is not null");
            matcostDataSetX = matcostDataSetX.groupBy(new String[]{"storageorgunit", "material", "effectdate", "costtype", "keycol"}).sum("standardprice");
            matcostDataSetX = matcostDataSetX.groupBy(new String[]{"storageorgunit", "material", "costtype", "keycol"}).reduceGroup((GroupReduceFunction)new CostInfoGroupReduceFunction(matcostDataSetX.getRowMeta()));
            ArrayList<Field> fields = new ArrayList<Field>(16);
            ArrayList<Integer> values = new ArrayList<Integer>(16);
            fields.add(new Field("multifactoryaccount", (DataType)DataType.IntegerType));
            values.add(0);
            calBalanceSet = calBalanceSet.addFields(fields.toArray(new Field[0]), values.toArray());
            calBalanceSet = calBalanceSet.map((MapFunction)new SetMulFactoryFlagMapFunction(calBalanceSet.getRowMeta(), this.reportParam));
            DataSetX mulFactoryDataSetX = calBalanceSet.filter("multifactoryaccount = 1");
            DataSetX unMulFactoryDataSetX = calBalanceSet.filter("multifactoryaccount = 0");
            mulFactoryDataSetX = mulFactoryDataSetX.leftJoin(matcostDataSetX).on("materialstandkeycol", "keycol").on("material", "material").on("storageorg", "storageorgunit").select(mulFactoryDataSetX.getRowMeta().getFieldNames(), "standardprice".split(","));
            unMulFactoryDataSetX = unMulFactoryDataSetX.leftJoin(matcostDataSetX).on("materialstandkeycol", "keycol").on("material", "material").select(unMulFactoryDataSetX.getRowMeta().getFieldNames(), "standardprice".split(","));
            calBalanceSet = mulFactoryDataSetX.union(unMulFactoryDataSetX);
            calBalanceSet = calBalanceSet.map((MapFunction)new StandardpriceMapFunction(calBalanceSet.getRowMeta(), this.reportParam));
        }
        return calBalanceSet;
    }
}

