/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.dataxtransform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportUtil;
import kd.fi.cal.report.newreport.stockagelrpt.function.CalActualpriceReduceGroupFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.CalRangeJudgeHasFieldMapFuction;
import kd.fi.cal.report.newreport.stockagelrpt.function.CalrangeAmountGroupReduceFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.CalrangeAmountMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.CalrangeCopyGroupFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.DealDataAmtPrecisonMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.DealTranBillSrcTgtReduceGroupFunc;
import kd.fi.cal.report.newreport.stockagelrpt.function.HasBaseqtyAmountMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.HasRangePrefixFieldMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.LastShowQtyAmountMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.MoreXDayFieldMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.NewDealCalRangeMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.RangeAmountCalMapFunction;
import kd.fi.cal.report.newreport.stockagelrpt.function.StandardpriceMapFunction;

public class NewBuildSumDataxTransform
implements IDataXTransform {
    private static String[] calrangeGroupNames = new String[]{"material", "baseunit", "calrange", "dividebasisvalue", "caldimensionvalue", "caldimension", "dividebasis"};
    private StockAgeReportBplatParam reportParam;
    private ReportDataCtx ctx;
    private Set<Long> notUpdBalBizType;
    private static final String[] TRANS_ENTITIE = new String[]{"im_transdirbill", "im_transoutbill", "im_transinbill"};

    public NewBuildSumDataxTransform(StockAgeReportBplatParam reportParam, ReportDataCtx ctx, Set<Long> notUpdBalBizType) {
        this.reportParam = reportParam;
        this.ctx = ctx;
        this.notUpdBalBizType = notUpdBalBizType;
    }

    public DataSetX doTransform(DataSetX srcData) {
        String prefixField;
        int i;
        Set<Long> differFalseCalOrgIdSet;
        QFilter qFilter;
        QFilter qFilter2;
        DynamicObjectCollection filter_location;
        DynamicObjectCollection filter_warehouse;
        Set<Long> warehsGroupSet;
        DynamicObjectCollection filter_storageOrg;
        String[] groupUnionStrs;
        Set<Long> mulCategoryIdSet = this.reportParam.getMulCategoryIdSet();
        if (Arrays.asList(srcData.getRowMeta().getFieldNames()).contains("materialcategory") && mulCategoryIdSet != null && !mulCategoryIdSet.isEmpty()) {
            QFilter filter = new QFilter("materialcategory", "in", mulCategoryIdSet);
            srcData = srcData.filter(filter.toString());
        }
        srcData = srcData.map((MapFunction)new DealDataAmtPrecisonMapFunction(srcData.getRowMeta(), null));
        HashSet<String> groupUnionStrSet = new HashSet<String>(16);
        groupUnionStrSet.addAll(this.reportParam.getShowKeyColsSet());
        groupUnionStrSet.add("calrange");
        groupUnionStrSet.add("materialnumber");
        groupUnionStrSet.add("materialmodel");
        groupUnionStrSet.add("baseunit");
        groupUnionStrSet.add("currency");
        groupUnionStrSet.add("amtprecision");
        String groupUnionStr = StockAgeReportUtil.getCommonGroupBy(false, groupUnionStrSet);
        String filterFields = this.reportParam.getFilterFields();
        if (!StringUtils.isEmpty((String)filterFields)) {
            groupUnionStr = groupUnionStr + "," + filterFields;
        }
        Set<String> groupUnUnionStrSet = this.reportParam.getGroupUnUnionStrSet();
        groupUnUnionStrSet.remove("unionflag");
        groupUnUnionStrSet.remove("datatype");
        boolean isAllContainDifferFalseCalOrg = StockAgeReportUtil.isAllContainDifferFalseCalOrg(this.reportParam);
        if (!isAllContainDifferFalseCalOrg) {
            groupUnUnionStrSet.add("materialstandkeycol");
        }
        StringBuilder groupUnUnionSb = new StringBuilder();
        for (String groupUnUnion : groupUnUnionStrSet) {
            groupUnUnionSb.append(groupUnUnion);
            groupUnUnionSb.append(",");
        }
        String groupUnUnionStr = groupUnUnionSb.substring(0, groupUnUnionSb.length() - 1);
        DataSetX calrangeDataSet = srcData.filter("unionflag =2");
        Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        for (String groupUnionS : groupUnionStrs = groupUnionStr.split(",")) {
            if (StringUtils.isEmpty((String)groupUnionS)) continue;
            allKeyCols.add(groupUnionS);
        }
        allKeyCols.add("dividebasisvalue");
        allKeyCols.add("caldimensionvalue");
        allKeyCols.add("caldimension");
        allKeyCols.add("dividebasis");
        allKeyCols.add("assist");
        allKeyCols.add("configuredcode");
        allKeyCols.add("accounttype");
        StringBuilder allKeySb = new StringBuilder();
        if (allKeyCols != null && allKeyCols.size() > 0) {
            for (String allKey : allKeyCols) {
                if (StringUtils.isEmpty((String)allKey)) continue;
                allKeySb.append(allKey);
                allKeySb.append(",");
            }
        }
        String allKeyGroupStr = allKeySb.substring(0, allKeySb.length() - 1);
        calrangeDataSet = calrangeDataSet.groupBy(allKeyGroupStr.split(",")).sum("baseqty").sum("actualqty").sum("actualamount").sum("standardamount");
        DataSetX rangeCostRecordSetT = srcData.filter("unionflag =0 and datatype='cal_costrecord_subentity'");
        rangeCostRecordSetT = rangeCostRecordSetT.groupBy(groupUnUnionStr.split(",")).sum("baseqty").sum("actualqty").sum("actualamount").sum("standardamount").sum("standardbaseqty");
        DataSetX rangeInitBillSet = srcData.filter("unionflag =0 and datatype='cal_initbill'");
        rangeInitBillSet = rangeInitBillSet.groupBy(groupUnUnionStr.split(",")).sum("baseqty").sum("actualqty").sum("actualamount").sum("standardamount").sum("standardbaseqty");
        DataSetX rangestdcostdiffSet = srcData.filter("unionflag =0 and datatype='cal_stdcostdiffbill'");
        rangestdcostdiffSet = rangestdcostdiffSet.groupBy(groupUnUnionStr.split(",")).sum("baseqty").sum("actualqty").sum("actualamount").sum("standardamount").sum("standardbaseqty");
        calrangeDataSet = calrangeDataSet.map((MapFunction)new NewDealCalRangeMapFunction(calrangeDataSet.getRowMeta(), this.reportParam));
        QFilter standDataQf = new QFilter("accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        DataSetX standDataSetX = calrangeDataSet.filter(standDataQf.toString());
        QFilter unStandDataQf = new QFilter("accounttype", "!=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        DataSetX unStandDataSetX = calrangeDataSet.filter(unStandDataQf.toString());
        DataSetX newCalrangeDataSetX = null;
        standDataSetX = standDataSetX.groupBy(new String[]{"caldimensionvalue"}).reduceGroup((GroupReduceFunction)new CalActualpriceReduceGroupFunction(standDataSetX.getRowMeta()));
        unStandDataSetX = unStandDataSetX.groupBy(calrangeGroupNames).reduceGroup((GroupReduceFunction)new CalActualpriceReduceGroupFunction(unStandDataSetX.getRowMeta()));
        newCalrangeDataSetX = standDataSetX.union(unStandDataSetX);
        groupUnionStr = groupUnionStr + ",dividebasisvalue,caldimensionvalue,caldimension,dividebasis";
        ArrayList<Field> newcopyfields = new ArrayList<Field>(16);
        ArrayList<String> newcopyvalues = new ArrayList<String>(16);
        newcopyfields.add(new Field("newcopy", (DataType)DataType.StringType));
        newcopyvalues.add("0");
        newCalrangeDataSetX = newCalrangeDataSetX.addFields(newcopyfields.toArray(new Field[0]), newcopyvalues.toArray());
        newCalrangeDataSetX = newCalrangeDataSetX.reduceGroup((GroupReduceFunction)new CalrangeCopyGroupFunction(newCalrangeDataSetX.getRowMeta(), 1));
        DataSetX calrangeDataSet2 = newCalrangeDataSetX.filter("newcopy = '1'");
        ArrayList<Field> calrangeamountfields = new ArrayList<Field>(16);
        ArrayList<BigDecimal> calrangeamountvalues = new ArrayList<BigDecimal>(16);
        calrangeamountfields.add(new Field("calrangeamount", (DataType)DataType.BigDecimalType));
        calrangeamountvalues.add(BigDecimal.ZERO);
        calrangeDataSet2 = calrangeDataSet2.addFields(calrangeamountfields.toArray(new Field[0]), calrangeamountvalues.toArray());
        calrangeDataSet2 = calrangeDataSet2.map((MapFunction)new CalrangeAmountMapFunction(calrangeDataSet2.getRowMeta()));
        DataSetX standDataSetX2 = calrangeDataSet2.filter(standDataQf.toString());
        standDataSetX2 = standDataSetX2.groupBy(new String[]{"caldimensionvalue"}).reduceGroup((GroupReduceFunction)new CalrangeAmountGroupReduceFunction(calrangeDataSet2.getRowMeta()));
        DataSetX unStandDataSetX2 = calrangeDataSet2.filter(unStandDataQf.toString());
        unStandDataSetX2 = unStandDataSetX2.groupBy(calrangeGroupNames).reduceGroup((GroupReduceFunction)new CalrangeAmountGroupReduceFunction(calrangeDataSet2.getRowMeta()));
        calrangeDataSet2 = standDataSetX2.union(unStandDataSetX2);
        if (this.reportParam.getCommonFilter() != null) {
            DataSetX lastShowDataSetX = srcData.filter("unionflag =3");
            lastShowDataSetX = lastShowDataSetX.groupBy(allKeyGroupStr.split(",")).sum("baseqty").sum("actualamount").sum("standardamount");
            lastShowDataSetX = lastShowDataSetX.map((MapFunction)new NewDealCalRangeMapFunction(lastShowDataSetX.getRowMeta(), this.reportParam));
            ArrayList<Field> lastshowfields = new ArrayList<Field>(16);
            ArrayList<Object> lastshowvalues = new ArrayList<Object>(16);
            lastshowfields.add(new Field("lastshow", (DataType)DataType.IntegerType));
            lastshowvalues.add(0);
            calrangeDataSet2 = calrangeDataSet2.addFields(lastshowfields.toArray(new Field[0]), lastshowvalues.toArray());
            lastshowfields.add(new Field("actualqty", (DataType)DataType.BigDecimalType));
            lastshowvalues.add(BigDecimal.ZERO);
            lastshowfields.add(new Field("actualprice", (DataType)DataType.BigDecimalType));
            lastshowvalues.add(BigDecimal.ZERO);
            lastshowfields.add(new Field("oldallamount", (DataType)DataType.BigDecimalType));
            lastshowvalues.add(BigDecimal.ZERO);
            lastshowfields.add(new Field("newcopy", (DataType)DataType.StringType));
            lastshowvalues.add("0");
            lastshowfields.add(new Field("calrangeamount", (DataType)DataType.BigDecimalType));
            lastshowvalues.add(BigDecimal.ZERO);
            lastShowDataSetX = lastShowDataSetX.addFields(lastshowfields.toArray(new Field[0]), lastshowvalues.toArray());
            lastShowDataSetX = lastShowDataSetX.map((MapFunction)new LastShowQtyAmountMapFunction(lastShowDataSetX.getRowMeta(), this.reportParam));
            lastShowDataSetX = lastShowDataSetX.select(calrangeDataSet2.getRowMeta().getFieldNames());
            String[] groupStrs = groupUnionStr.split(",");
            HashSet<String> groupStrSet = new HashSet<String>(16);
            for (String groupStr : groupStrs) {
                if (StringUtils.isEmpty((String)groupStr)) continue;
                groupStrSet.add(groupStr);
            }
            groupStrSet.add(this.reportParam.getCommonFilter().getProperty().split("\\.")[0]);
            List list = this.reportParam.getCommonFilter().getNests(false);
            if (list != null && list.size() > 0) {
                for (QFilter.QFilterNest nest : list) {
                    String property = nest.getFilter().getProperty();
                    if (StringUtils.isEmpty((String)property)) continue;
                    String[] propertys = property.split("\\.");
                    groupStrSet.add(propertys[0]);
                }
            }
            StringBuilder groupStrSb = new StringBuilder();
            for (String groups : groupStrSet) {
                if (StringUtils.isEmpty((String)groups)) continue;
                groupStrSb.append(groups);
                groupStrSb.append(",");
            }
            String groupStr = groupStrSb.substring(0, groupStrSb.length() - 1);
            calrangeDataSet2 = calrangeDataSet2.union(lastShowDataSetX).groupBy(groupStr.split(",")).sum("baseqty").sum("actualamount").sum("standardamount").sum("actualqty").sum("actualprice").sum("oldallamount").sum("calrangeamount").max("lastshow");
            calrangeDataSet2 = calrangeDataSet2.filter("lastshow = 1");
        }
        calrangeDataSet2 = calrangeDataSet2.groupBy(groupUnionStr.split(",")).sum("baseqty").sum("calrangeamount").sum("actualamount").sum("standardamount");
        calrangeDataSet2 = calrangeDataSet2.filter("baseqty <> 0");
        calrangeDataSet2 = calrangeDataSet2.map((MapFunction)new DealDataAmtPrecisonMapFunction(calrangeDataSet2.getRowMeta(), "calrangeamount"));
        calrangeDataSet2 = calrangeDataSet2.groupBy(groupUnionStr.split(",")).sum("baseqty").sum("actualamount").sum("standardamount");
        QFilter q = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection filter_owner = this.reportParam.getOwner();
        if (filter_owner != null && filter_owner.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(16);
            for (Iterator info : filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("owner", "in", set);
        }
        if ((filter_storageOrg = this.reportParam.getStorageOrg()) != null && filter_storageOrg.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(16);
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("storageorg", "in", set);
        }
        if (!(warehsGroupSet = this.reportParam.getWarehsGroupSet()).isEmpty()) {
            q.and("group", "in", warehsGroupSet);
        }
        if ((filter_warehouse = this.reportParam.getWarehouse()) != null && filter_warehouse.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(16);
            for (Iterator info : filter_warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if ((filter_location = this.reportParam.getLocation()) != null && filter_location.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(16);
            for (DynamicObject info : filter_location) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("location", "in", set);
        }
        calrangeDataSet2 = calrangeDataSet2.filter(q.toString());
        calrangeDataSet2 = calrangeDataSet2.groupBy(StockAgeReportUtil.getCommonGroupBy(false, groupUnionStrSet).split(",")).sum("baseqty").sum("actualamount").sum("standardamount");
        calrangeDataSet2 = calrangeDataSet2.map((MapFunction)new DealDataAmtPrecisonMapFunction(calrangeDataSet2.getRowMeta(), "actualamount"));
        calrangeDataSet2 = calrangeDataSet2.select((StockAgeReportUtil.getCommonGroupBy(false, groupUnionStrSet) + ",baseqty,actualamount,standardamount").split(","));
        QFilter commonFilter = StockAgeReportUtil.buildShowDataFilter("costrecord", this.reportParam);
        commonFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        commonFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
        commonFilter.and("biztype", "not in", this.notUpdBalBizType);
        commonFilter.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        commonFilter.and("billstatus", "=", (Object)"C");
        QFilter unUnionQfilter = new QFilter("bookdate", "<=", (Object)this.reportParam.getEndDate());
        unUnionQfilter.and("bookdate", ">=", (Object)this.reportParam.getIntervalStartDate());
        if (this.reportParam.getMaterialIds() != null && this.reportParam.getMaterialIds().size() > 0) {
            unUnionQfilter.and("entry.material", "in", this.reportParam.getMaterialIds());
        }
        unUnionQfilter.and(commonFilter);
        if (mulCategoryIdSet != null && !mulCategoryIdSet.isEmpty()) {
            unUnionQfilter.and("entry.stocktype", "in", mulCategoryIdSet);
        }
        unUnionQfilter.and("bizentityobject", "in", (Object)TRANS_ENTITIE);
        String costRecordSelects = "transtype,entry.bizbillentryid as bizbillentryid,entry.material as material,entry.warehouse.group as warehousegroup,entry.warehouse as warehouse,entry.location as location,entry.owner as owner,costaccount,entry.calrange as calrange,bizentityobject,calbilltype,billtype,biztype,invscheme,case when bizentityobject='im_transdirbill' then entry.bizbillentryid when bizentityobject='im_transinbill' then entry.srcbillentryid when bizentityobject='im_transoutbill' then entry.bizbillentryid else 0L end as srcbizbillentryid,billno";
        RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord", costRecordSelects);
        rowMeta.getField("srcbizbillentryid").setDataType((DataType)DataType.LongType);
        OrmInput rangeCostRecordSetbillIO = new OrmInput(this.getClass().getName(), "cal_costrecord", costRecordSelects, new QFilter[]{unUnionQfilter}, rowMeta);
        DataSetX calrangeDataSetTran = this.ctx.getCurrentJob().fromInput((Input)rangeCostRecordSetbillIO);
        String filterStr = StockAgeReportUtil.getNoStatisticalFilterStr(this.reportParam);
        DataSetX transBillSet = calrangeDataSetTran.filter(filterStr);
        transBillSet = transBillSet.groupBy(new String[]{"srcbizbillentryid"}).reduceGroup((GroupReduceFunction)new DealTranBillSrcTgtReduceGroupFunc(transBillSet.getRowMeta()));
        String transdirFields = "transtype,ingroup,outgroup,inwarehouse,outwarehouse,inlocation,outlocation,inowner,outowner,outcostaccount,outcalrange,billno";
        String[] rangeFields = rangeCostRecordSetT.getRowMeta().getFieldNames();
        rangeCostRecordSetT = rangeCostRecordSetT.leftJoin(transBillSet).on("bizbillentryid", "bizbillentryid").on("material", "material").on("calbilltype", "calbilltype").select(rangeFields, transdirFields.split(","));
        String filterString = null;
        if (StockAgeReportUtil.hasGroupByName(groupUnionStrSet, "location")) {
            filterString = "(inlocation = null and outlocation <> null) or (inlocation <> null and outlocation = null) or (inlocation = null and outlocation = null and (inwarehouse = null or outwarehouse = null or (inwarehouse <> null and outwarehouse <> null and inwarehouse <> outwarehouse))) or (inlocation <> null and outlocation <> null and inlocation <> outlocation)";
        } else if (StockAgeReportUtil.hasGroupByName(groupUnionStrSet, "warehouse")) {
            filterString = "inwarehouse = null or outwarehouse = null or (inwarehouse <> null and outwarehouse <> null and inwarehouse <> outwarehouse)";
        } else if (StockAgeReportUtil.hasGroupByName(groupUnionStrSet, "group")) {
            filterString = "transtype <> 'A' or ingroup = null or outgroup = null or (ingroup <> null and outgroup <> null and ingroup <> outgroup)";
        } else if (StockAgeReportUtil.hasGroupByName(groupUnionStrSet, "storageorg")) {
            filterString = "transtype <> 'A'";
        } else if (StockAgeReportUtil.hasGroupByName(groupUnionStrSet, "owner")) {
            filterString = "inowner = null or outowner = null or (inowner <> null and outowner <> null and inowner <> outowner)";
        } else if (StockAgeReportUtil.hasGroupByName(groupUnionStrSet, "material")) {
            filterString = "costaccount = null or outcostaccount = null or  (costaccount <> outcostaccount)";
        }
        if (filterString != null) {
            String calrangeFilterString = " or (calrange <> null and outcalrange <> null and calrange <> outcalrange)";
            rangeCostRecordSetT = rangeCostRecordSetT.filter(filterString + calrangeFilterString);
        }
        if (!StockAgeReportUtil.hasGroupByName(groupUnionStrSet, "location")) {
            rangeCostRecordSetT = rangeCostRecordSetT.filter("billtype <> 757727698490869760");
        }
        String unionSelect = groupUnUnionStr + ",baseqty,standardamount,standardbaseqty,actualqty,actualamount";
        rangeCostRecordSetT = rangeCostRecordSetT.select(unionSelect.split(",")).union(rangeInitBillSet.select(unionSelect.split(",")));
        rangeCostRecordSetT = rangeCostRecordSetT.map((MapFunction)new NewDealCalRangeMapFunction(rangeCostRecordSetT.getRowMeta(), this.reportParam));
        String[] intervalDays = this.reportParam.getIntervalDays();
        StringBuilder leftFields = new StringBuilder(StockAgeReportUtil.getCommonGroupBy(false, groupUnionStrSet)).append(",baseqty,standardamount,actualamount,hasbaseqty,hasstandardamount,hasactualamount");
        ArrayList<Field> hasfields = new ArrayList<Field>(16);
        ArrayList<BigDecimal> hasvalues = new ArrayList<BigDecimal>(16);
        hasfields.add(new Field("hasbaseqty", (DataType)DataType.BigDecimalType));
        hasvalues.add(BigDecimal.ZERO);
        hasfields.add(new Field("hasstandardamount", (DataType)DataType.BigDecimalType));
        hasvalues.add(BigDecimal.ZERO);
        hasfields.add(new Field("hasactualamount", (DataType)DataType.BigDecimalType));
        hasvalues.add(BigDecimal.ZERO);
        calrangeDataSet2 = calrangeDataSet2.addFields(hasfields.toArray(new Field[0]), hasvalues.toArray());
        calrangeDataSet2 = calrangeDataSet2.map((MapFunction)new HasBaseqtyAmountMapFunction(calrangeDataSet2.getRowMeta()));
        int sumDay = 0;
        int prevDay = 0;
        DataSetX intervalAllDataSet = null;
        StringBuilder commonrangesb = new StringBuilder();
        for (int i2 = 0; i2 < intervalDays.length - 1; ++i2) {
            int intervalDay = Integer.parseInt(intervalDays[i2]);
            DataSetX copyRangeCostRecordSet = rangeCostRecordSetT;
            DataSetX intervalSet = StockAgeReportUtil.getIntervalRangeDataSet(copyRangeCostRecordSet, sumDay += intervalDay, prevDay, groupUnionStrSet, this.reportParam);
            String prefixField2 = "range" + i2;
            commonrangesb.append(prefixField2);
            commonrangesb.append("qty");
            commonrangesb.append(",");
            commonrangesb.append(prefixField2);
            commonrangesb.append("standardamount");
            commonrangesb.append(",");
            commonrangesb.append(prefixField2);
            commonrangesb.append("actualamount");
            commonrangesb.append(",");
            ArrayList<Field> hasRangefields = new ArrayList<Field>(16);
            ArrayList<Integer> hasRangevalues = new ArrayList<Integer>(16);
            hasRangefields.add(new Field("rangeflag", (DataType)DataType.IntegerType));
            hasRangevalues.add(i2);
            if (intervalSet == null) continue;
            intervalSet = intervalSet.addFields(hasRangefields.toArray(new Field[0]), hasRangevalues.toArray());
            prevDay = sumDay;
            intervalAllDataSet = null == intervalAllDataSet ? intervalSet : intervalAllDataSet.union(intervalSet);
        }
        if (null == intervalAllDataSet) {
            return srcData;
        }
        HashSet<String> divGroupUninonStrs = new HashSet<String>(groupUnionStrSet);
        divGroupUninonStrs.add("dividebasisvalue");
        divGroupUninonStrs.add("caldimensionvalue");
        divGroupUninonStrs.add("caldimension");
        divGroupUninonStrs.add("dividebasis");
        if (!isAllContainDifferFalseCalOrg) {
            divGroupUninonStrs.add("materialstandkeycol");
        }
        if (!isAllContainDifferFalseCalOrg) {
            Set<Long> multifactoryFalseCalOrgIdSet;
            DataSetX rangeCostRecordSetMulFacTrue = null;
            DataSetX rangeCostRecordSetMulFacFalse = null;
            Set<Long> multifactoryTrueCalOrgIdSet = this.reportParam.getMultifactoryTrueCalOrgIdSet();
            if (multifactoryTrueCalOrgIdSet != null && multifactoryTrueCalOrgIdSet.size() > 0) {
                qFilter2 = new QFilter("calorg", "in", multifactoryTrueCalOrgIdSet);
                rangeCostRecordSetMulFacTrue = intervalAllDataSet.filter(qFilter2.toString());
            }
            if ((multifactoryFalseCalOrgIdSet = this.reportParam.getMultifactoryFalseCalOrgIdSet()) != null && multifactoryFalseCalOrgIdSet.size() > 0) {
                qFilter = new QFilter("calorg", "in", multifactoryFalseCalOrgIdSet);
                rangeCostRecordSetMulFacFalse = intervalAllDataSet.filter(qFilter.toString());
            }
            DataSetX costInfoSet = StockAgeReportUtil.getStandardPriceDataSetX(this.reportParam, this.ctx);
            if (rangeCostRecordSetMulFacTrue != null) {
                rangeCostRecordSetMulFacTrue = rangeCostRecordSetMulFacTrue.leftJoin(costInfoSet).on("materialstandkeycol", "keycol").on("material", "material").on("storageorg", "storageorgunit").select(intervalAllDataSet.getRowMeta().getFieldNames(), "standardprice".split(","));
            }
            if (rangeCostRecordSetMulFacFalse != null) {
                rangeCostRecordSetMulFacFalse = rangeCostRecordSetMulFacFalse.leftJoin(costInfoSet).on("materialstandkeycol", "keycol").on("material", "material").select(intervalAllDataSet.getRowMeta().getFieldNames(), "standardprice".split(","));
            }
            if (rangeCostRecordSetMulFacFalse != null && rangeCostRecordSetMulFacTrue != null) {
                intervalAllDataSet = rangeCostRecordSetMulFacFalse.union(rangeCostRecordSetMulFacTrue);
            } else if (null == rangeCostRecordSetMulFacTrue && rangeCostRecordSetMulFacFalse != null) {
                intervalAllDataSet = rangeCostRecordSetMulFacFalse;
            } else if (null == rangeCostRecordSetMulFacFalse && rangeCostRecordSetMulFacTrue != null) {
                intervalAllDataSet = rangeCostRecordSetMulFacTrue;
            }
        }
        DataSetX rangeCostRecordSetDifferTrue = null;
        DataSetX rangeCostRecordSetDifferFalse = null;
        Set<Long> differTrueCalOrgIdSet = this.reportParam.getContainDifferTrueCalOrgIdSet();
        if (differTrueCalOrgIdSet != null && differTrueCalOrgIdSet.size() > 0) {
            qFilter2 = new QFilter("calorg", "in", differTrueCalOrgIdSet);
            rangeCostRecordSetDifferTrue = intervalAllDataSet.filter(qFilter2.toString());
            String finalField = StockAgeReportUtil.getCommonGroupBy(true, divGroupUninonStrs) + ",baseqty,actualqty,standardamount,actualamount,rangeflag";
            rangeCostRecordSetDifferTrue = rangeCostRecordSetDifferTrue.select(finalField.split(","));
        }
        if ((differFalseCalOrgIdSet = this.reportParam.getContainDifferFalseCalOrgIdSet()) != null && differFalseCalOrgIdSet.size() > 0) {
            qFilter = new QFilter("calorg", "in", differFalseCalOrgIdSet);
            rangeCostRecordSetDifferFalse = intervalAllDataSet.filter(qFilter.toString());
            rangeCostRecordSetDifferFalse = rangeCostRecordSetDifferFalse.map((MapFunction)new StandardpriceMapFunction(rangeCostRecordSetDifferFalse.getRowMeta(), this.reportParam));
            String finalField = StockAgeReportUtil.getCommonGroupBy(true, divGroupUninonStrs) + ",baseqty,actualqty,standardamount,actualamount,rangeflag";
            rangeCostRecordSetDifferFalse = rangeCostRecordSetDifferFalse.select(finalField.split(","));
        }
        if (rangeCostRecordSetDifferTrue != null && rangeCostRecordSetDifferFalse != null) {
            intervalAllDataSet = rangeCostRecordSetDifferTrue.union(rangeCostRecordSetDifferFalse);
        } else if (null == rangeCostRecordSetDifferTrue && rangeCostRecordSetDifferFalse != null) {
            intervalAllDataSet = rangeCostRecordSetDifferFalse;
        } else if (null == rangeCostRecordSetDifferFalse && rangeCostRecordSetDifferTrue != null) {
            intervalAllDataSet = rangeCostRecordSetDifferTrue;
        }
        String[] groupStrs = (StockAgeReportUtil.getCommonGroupBy(true, divGroupUninonStrs) + ",rangeflag").split(",");
        intervalAllDataSet = intervalAllDataSet.groupBy(groupStrs).sum("baseqty").sum("actualqty").sum("standardamount").sum("actualamount");
        DataSetX calrangeDataSet1 = newCalrangeDataSetX.filter("newcopy = '0'");
        DataSetX rangeStandDataSetX = calrangeDataSet1.filter(standDataQf.toString());
        DataSetX rangeUnStandDataSetX = calrangeDataSet1.filter(unStandDataQf.toString());
        rangeUnStandDataSetX = rangeUnStandDataSetX.groupBy("material,baseunit,calrange,dividebasisvalue,caldimensionvalue,caldimension,dividebasis,newcopy".split(",")).max("actualprice").select("material,baseunit,calrange,dividebasisvalue,caldimensionvalue,caldimension,dividebasis,actualprice,newcopy".split(","));
        String[] fieldNames = intervalAllDataSet.getRowMeta().getFieldNames();
        rangeStandDataSetX = rangeStandDataSetX.groupBy("caldimensionvalue".split(",")).max("actualprice").select("caldimensionvalue,actualprice".split(","));
        intervalAllDataSet = intervalAllDataSet.leftJoin(rangeUnStandDataSetX).on("material", "material").on("baseunit", "baseunit").on("calrange", "calrange").on("dividebasisvalue", "dividebasisvalue").on("caldimensionvalue", "caldimensionvalue").on("caldimension", "caldimension").on("dividebasis", "dividebasis").select(intervalAllDataSet.getRowMeta().getFieldNames(), new String[]{"actualprice"});
        DataSetX intervalAllDataSet3 = intervalAllDataSet.filter("actualprice == null");
        DataSetX intervalAllDataSet1 = intervalAllDataSet.filter("actualprice != null");
        JoinDataSetX intervalAllDataSet2 = intervalAllDataSet3.leftJoin(rangeStandDataSetX).on("caldimensionvalue", "caldimensionvalue").select(fieldNames, new String[]{"actualprice"});
        intervalAllDataSet = intervalAllDataSet1.union((DataSetX)intervalAllDataSet2);
        intervalAllDataSet = intervalAllDataSet.map((MapFunction)new RangeAmountCalMapFunction(intervalAllDataSet.getRowMeta()));
        intervalAllDataSet = intervalAllDataSet.select((StockAgeReportUtil.getCommonGroupBy(true, divGroupUninonStrs) + ",baseqty,actualamount,standardamount,rangeflag").split(","));
        String[] totalGroupStrs = (StockAgeReportUtil.getCommonGroupBy(false, groupUnionStrSet) + ",rangeflag").split(",");
        DataSetX intervalRangeDataSet = intervalAllDataSet.groupBy(totalGroupStrs).sum("baseqty").sum("actualamount").sum("standardamount");
        intervalRangeDataSet = intervalRangeDataSet.map((MapFunction)new DealDataAmtPrecisonMapFunction(intervalRangeDataSet.getRowMeta(), "actualamount"));
        for (int i3 = 0; i3 < intervalDays.length - 1; ++i3) {
            String prefixField3 = "range" + i3;
            ArrayList<Field> hasRangefields = new ArrayList<Field>(16);
            ArrayList<BigDecimal> hasRangevalues = new ArrayList<BigDecimal>(16);
            hasRangefields.add(new Field(prefixField3 + "qty", (DataType)DataType.BigDecimalType));
            hasRangevalues.add(BigDecimal.ZERO);
            hasRangefields.add(new Field(prefixField3 + "standardamount", (DataType)DataType.BigDecimalType));
            hasRangevalues.add(BigDecimal.ZERO);
            hasRangefields.add(new Field(prefixField3 + "actualamount", (DataType)DataType.BigDecimalType));
            hasRangevalues.add(BigDecimal.ZERO);
            intervalRangeDataSet = intervalRangeDataSet.addFields(hasRangefields.toArray(new Field[0]), hasRangevalues.toArray());
        }
        intervalRangeDataSet = intervalRangeDataSet.map((MapFunction)new HasRangePrefixFieldMapFunction(intervalRangeDataSet.getRowMeta()));
        JoinDataSetX joinDataSetT = calrangeDataSet2.leftJoin(intervalRangeDataSet);
        joinDataSetT = StockAgeReportUtil.getTargetJoinDataSet(joinDataSetT, groupUnionStrSet, this.reportParam, false);
        calrangeDataSet2 = joinDataSetT.select(leftFields.toString().split(","), commonrangesb.toString().split(","));
        calrangeDataSet2 = calrangeDataSet2.filter("baseqty <> 0");
        calrangeDataSet2 = calrangeDataSet2.groupBy(StockAgeReportUtil.getCommonGroupBy(false, groupUnionStrSet).split(",")).max("baseqty").max("actualamount").max("standardamount").max("hasbaseqty").max("hasstandardamount").max("hasactualamount");
        for (i = 0; i < intervalDays.length - 1; ++i) {
            prefixField = "range" + i;
            calrangeDataSet2 = calrangeDataSet2.sum(prefixField + "qty").sum(prefixField + "standardamount").sum(prefixField + "actualamount");
        }
        for (i = 0; i < intervalDays.length - 1; ++i) {
            prefixField = "range" + i;
            calrangeDataSet2 = calrangeDataSet2.map((MapFunction)new CalRangeJudgeHasFieldMapFuction(calrangeDataSet2.getRowMeta(), prefixField));
        }
        String prefixField4 = "range" + (intervalDays.length - 1);
        ArrayList<Field> hasMoreXDayfields = new ArrayList<Field>(16);
        ArrayList<BigDecimal> hasMoreXDayvalues = new ArrayList<BigDecimal>(16);
        hasMoreXDayfields.add(new Field(prefixField4 + "qty", (DataType)DataType.BigDecimalType));
        hasMoreXDayvalues.add(BigDecimal.ZERO);
        hasMoreXDayfields.add(new Field(prefixField4 + "standardamount", (DataType)DataType.BigDecimalType));
        hasMoreXDayvalues.add(BigDecimal.ZERO);
        hasMoreXDayfields.add(new Field(prefixField4 + "actualamount", (DataType)DataType.BigDecimalType));
        hasMoreXDayvalues.add(BigDecimal.ZERO);
        hasMoreXDayfields.add(new Field("amount", (DataType)DataType.BigDecimalType));
        hasMoreXDayvalues.add(BigDecimal.ZERO);
        for (int i4 = 0; i4 < intervalDays.length; ++i4) {
            String amountField = "range" + i4 + "amount";
            hasMoreXDayfields.add(new Field(amountField, (DataType)DataType.BigDecimalType));
            hasMoreXDayvalues.add(BigDecimal.ZERO);
        }
        calrangeDataSet2 = calrangeDataSet2.addFields(hasMoreXDayfields.toArray(new Field[0]), hasMoreXDayvalues.toArray());
        calrangeDataSet2 = calrangeDataSet2.map((MapFunction)new MoreXDayFieldMapFunction(calrangeDataSet2.getRowMeta(), prefixField4, intervalDays.length - 1));
        DynamicObject materialgroupstandard = this.reportParam.getMaterialgroupstandard();
        DynamicObjectCollection mulmaterialgroup = this.reportParam.getMulmaterialgroup();
        if (this.reportParam.isOnlyShowSumRow() || this.reportParam.isMaterialClassSum() || materialgroupstandard != null || mulmaterialgroup != null && !mulmaterialgroup.isEmpty()) {
            DynamicObjectCollection materialgroup;
            Object pkValue = 730148448254487552L;
            if (materialgroupstandard != null) {
                pkValue = materialgroupstandard.getPkValue();
            }
            QFilter classqf = new QFilter("standard", "=", pkValue);
            if (this.reportParam.getMaterialIds() != null && this.reportParam.getMaterialIds().size() > 0) {
                classqf.and("material.id", "in", this.reportParam.getMaterialIds());
            }
            if ((materialgroup = this.reportParam.getMulmaterialgroup()) != null && materialgroup.size() > 0) {
                classqf.and(kd.fi.cal.common.util.ReportUtil.getGroupFilter((DynamicObjectCollection)materialgroup, (boolean)false, (String)"group.longnumber"));
            }
            OrmInput costInfobillIO = new OrmInput(this.getClass().getName(), "bd_materialgroupdetail", "standard,group as materialgroup,group.number as groupnumber,material,material.number as materialnumber", new QFilter[]{classqf});
            DataSetX classifiedMaterialDataSet = this.ctx.getCurrentJob().fromInput((Input)costInfobillIO);
            String[] leftField = calrangeDataSet2.getRowMeta().getFieldNames();
            JoinDataSetX resultDataSet = calrangeDataSet2.join(classifiedMaterialDataSet).on("material", "material").select(leftField, new String[]{"materialgroup"});
            if (this.reportParam.isMaterialClassSum()) {
                resultDataSet = resultDataSet.orderBy(new String[]{"materialgroup desc"});
            }
            if (this.reportParam.isOnlyShowSumRow()) {
                String groupStr = "costaccount,calorg,materialgroup,currency";
                resultDataSet = resultDataSet.groupBy(groupStr.split(",")).sum("baseqty").sum("amount");
                for (int i5 = 0; i5 < intervalDays.length; ++i5) {
                    String prefixField1 = "range" + i5;
                    String qtyField = prefixField1 + "qty";
                    String amountField = prefixField1 + "amount";
                    resultDataSet = resultDataSet.sum(qtyField).sum(amountField);
                }
            }
            return resultDataSet;
        }
        return calrangeDataSet2;
    }
}

