/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.config.client.util.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportUtil;

public class StockAgeReportBplatForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static String INVAGEGROUP = "invagegroup";
    private static String INTERVALDAYS = "intervaldays";
    private static String ENDDATE = "enddate";
    private static String BILLTYPEENTRY = "billtypeentry";
    private static String BIZTYPEENTRY = "biztypeentry";
    private static String INVSCHEMEENTRY = "invschemeentry";
    private static String ENTRYONE = "entry1";
    private static String ENTRYTWO = "entry2";
    private static long CHANGEBILLId = 721675267608688640L;
    private static long BATCHCHANGEID = 688869647461968896L;
    private static long INVSTATUSCHANGEID = 688869765229636608L;
    private static long INDEXCHANGE = 726537661078051840L;
    private static long UNITCHANGE = 726537973494979584L;
    private static long OTHERCHANGE = 688869896687512576L;
    private static final Log logger = LogFactory.getLog(StockAgeReportBplatForm.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "mulowner", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", BIZTYPEENTRY, INVSCHEMEENTRY, "multracknum", "materialgroupstandard", "mulmaterialgroup", "mulmaterial", "materialto");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Owner(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e, this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if (BIZTYPEENTRY.equals(key)) {
            this.beforeF7BiztypeEntry(e, rowIndex);
        } else if (INVSCHEMEENTRY.equals(key)) {
            this.beforeF7InvschemeEntry(e, rowIndex);
        } else if ("materialgroupstandard".equals(key)) {
            this.beforeMaterialgroupstandard(e);
        } else if ("mulmaterialgroup".equals(key)) {
            this.beforeF7SelectMaterialGroup(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4NewMulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e, (String)"mulcalorg");
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeMaterialgroupstandard(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            return;
        }
        HashSet materialIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
            materialIdSet.addAll(ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", materialIdSet));
    }

    private void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        if (orgIds.isEmpty()) {
            params.put("isShowAllNoOrg", "true");
            formShowParameter.setCustomParams(params);
        } else {
            params.put("useOrgs", orgIds);
            formShowParameter.setCustomParams(params);
        }
        formShowParameter.getListFilterParameter().getQFilters().add(qFilter.and(serviceResponse));
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue("mulstorageorg");
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet warehouseIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg.getDynamicObject("fbasedataid"));
            warehouseIdSet.addAll(set);
        }
        if (warehouseIdSet.size() > 0) {
            q = new QFilter("id", "in", warehouseIdSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)model.getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stock_age_newrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8d27\u4e3b", (String)"StockGatherRptQueryPlugin_38", (String)"fi-cal-report", (Object[])new Object[0]));
    }

    private void beforeF7BiztypeEntry(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue(BILLTYPEENTRY, rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billentity.billform", "=", (Object)billTypeEntity.getString("billformid.number"));
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<Object> idList = new ArrayList<Object>(bizTypes.size());
        for (DynamicObject bizType : bizTypes) {
            idList.add(bizType.get("id"));
        }
        QFilter idf = new QFilter("id", "in", idList);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(idf.toArray()));
    }

    private void beforeF7InvschemeEntry(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue(BILLTYPEENTRY, rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        DynamicObject bizTypeEntity = (DynamicObject)this.getModel().getValue(BIZTYPEENTRY, rowIndex);
        if (null == bizTypeEntity) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"StockAgeRptFormPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billform", "=", (Object)billTypeEntity.getString("billformid.number"));
        qFilter.and("bitypeentry.biztype", "=", bizTypeEntity.getPkValue());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.toArray()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if (INTERVALDAYS.equals(key)) {
            this.intervalDaysChanged(rowIndex, oldValue, newValue);
        } else if (BILLTYPEENTRY.equals(key)) {
            this.billTypeEntryChanged(rowIndex);
        } else if (BIZTYPEENTRY.equals(key)) {
            this.bizTypeEntryChanged(rowIndex);
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("showkeycols".equals(key)) {
            this.changedShowKeyCols(e);
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        }
    }

    private void changedShowKeyCols(PropertyChangedArgs e) {
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String hasCostMatCal = null;
        if (StringUtils.isEmpty((String)colsStr)) {
            colsStr = "calorg,costaccount,material";
            hasCostMatCal = "material";
        }
        String[] colsStrs = colsStr.split(",");
        HashSet<String> colsStrSet = new HashSet<String>(16);
        StringBuilder sb = new StringBuilder();
        for (String col : colsStrs) {
            if (StringUtils.isEmpty((String)col)) continue;
            sb.append(col);
            sb.append(",");
            colsStrSet.add(col);
        }
        if (!colsStrSet.contains("calorg")) {
            sb.append("calorg");
            sb.append(",");
            hasCostMatCal = "calorg";
        }
        if (!colsStrSet.contains("material")) {
            sb.append("material");
            sb.append(",");
            hasCostMatCal = "material";
        }
        if (!colsStrSet.contains("costaccount")) {
            sb.append("costaccount");
            sb.append(",");
            hasCostMatCal = "costaccount";
        }
        colsStr = sb.toString();
        if (hasCostMatCal != null) {
            this.getModel().setValue("showkeycols", (Object)colsStr);
        }
    }

    private void calOrgChanged() {
        this.getModel().setValue("mulstorageorg", null);
        this.getModel().setValue("mulowner", null);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            this.getModel().setValue("mulcostaccount", null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue("mulcostaccount", (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue("mulcostaccount", null);
            }
            this.getModel().setValue("ownertypehead", (Object)"bos_org");
        }
    }

    private void bizTypeEntryChanged(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(INVSCHEMEENTRY, null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(INVSCHEMEENTRY, rowIndex);
    }

    private void billTypeEntryChanged(int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(BIZTYPEENTRY, null, rowIndex);
        this.getModel().setValue(INVSCHEMEENTRY, null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(BIZTYPEENTRY, rowIndex);
        this.getView().updateView(INVSCHEMEENTRY, rowIndex);
    }

    private void intervalDaysChanged(int rowIndex, Object oldValue, Object newValue) {
        IReportView view = this.getView();
        if ((Integer)newValue == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u95f4\u9694\u5929\u6570\u3002", (String)"StockAgeRptFormPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(INTERVALDAYS, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(INTERVALDAYS, rowIndex);
            return;
        }
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
        if (entry2Entity == null || entry2Entity.isEmpty()) {
            return;
        }
        int size = entry2Entity.size();
        int sum = 0;
        for (int i = 0; i < size; ++i) {
            int day = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS);
            if (i == rowIndex) {
                sum += ((Integer)newValue).intValue();
                continue;
            }
            sum += day;
        }
        if (sum > 36500) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u95f4\u9694\u5929\u6570\u7d2f\u8ba1\u4e0d\u80fd\u5927\u4e8e36500\u5929\u3002", (String)"StockAgeRptFormPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue(INTERVALDAYS, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(INTERVALDAYS, rowIndex);
            return;
        }
        String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"StockAgeRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
        String secondString = sbFirst.substring(1, 2);
        String fourString = sbFirst.substring(sbFirst.length() - 1);
        if (sbFirst.toLowerCase().contains("to")) {
            StringBuffer sb = new StringBuffer(sbFirst.trim());
            sbFirst = sb.toString();
            secondString = "to";
            fourString = sbFirst.substring(sbFirst.indexOf("X ") + 2);
        }
        String sbSuffix = null;
        if (rowIndex == size - 1) {
            if (size == 2 && ((DynamicObject)entry2Entity.get(1)).getInt(INTERVALDAYS) != 0) {
                view.invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("entry2");
                size = entry2Entity.size();
            } else if (size != 2) {
                view.invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("entry2");
                size = entry2Entity.size();
            }
        }
        for (int i = 0; i < size; ++i) {
            String lastValue;
            int invagegroup = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS);
            if (i == 0) {
                if (sbFirst == null) continue;
                sbFirst = sbFirst.replaceAll("X", String.valueOf(invagegroup - 1));
                this.getModel().setValue(INVAGEGROUP, (Object)sbFirst, i);
                sbSuffix = sbFirst;
                continue;
            }
            if (i != size - 1) {
                lastValue = null;
                if (sbSuffix != null) {
                    lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                }
                String tmp = null;
                if (lastValue != null) {
                    tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invagegroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invagegroup) + fourString;
                }
                this.getModel().setValue(INVAGEGROUP, tmp, i);
                sbSuffix = tmp;
                continue;
            }
            lastValue = null;
            if (sbSuffix != null) {
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
            }
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]), (lastValue == null ? 0 : Integer.parseInt(lastValue)) + 1);
            this.getModel().setValue(INVAGEGROUP, (Object)msg, i);
            sbSuffix = msg;
        }
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("localcurrency", null);
            return;
        }
        HashSet<Object> calpolicyIdSet = new HashSet<Object>();
        for (DynamicObject costaccount : costaccounts) {
            calpolicyIdSet.add(costaccount.getDynamicObject("fbasedataid").getDynamicObject("calpolicy").getPkValue());
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicyIdSet)});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stock_age_newrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
        this.initDate();
        this.initInvageGroup();
        this.setNoStatisticalFilter();
        this.resetFilterGrid();
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("calorg");
        removedPros.add("calrange");
        removedPros.add("baseunit");
        removedPros.add("year");
        removedPros.add("month");
        removedPros.add("material");
        removedPros.add("owner");
        removedPros.add("storageorg");
        removedPros.add("location");
        removedPros.add("warehouse");
        removedPros.add("group");
        removedPros.add("materialnumber");
        removedPros.add("materialmodel");
        removedPros.add("ownertype");
        removedPros.add("assist");
        removedPros.add("periodendcostdiff");
        removedPros.add("accounttype");
        removedPros.add("billtype");
        removedPros.add("bizdate");
        removedPros.add("bookdate");
        removedPros.add("audittime");
        removedPros.add("billno");
        removedPros.add("currency");
        removedPros.add("period");
        removedPros.add("endperiod");
        removedPros.add("invscheme");
        removedPros.add("bizbillentryid");
        removedPros.add("createtype");
        removedPros.add("biztype");
        removedPros.add("adjustamt");
        removedPros.add("calbilltype");
        removedPros.add("difftype");
        removedPros.add("periodendqty");
        removedPros.add("periodendactualcost");
        removedPros.add("periodendstandardcost");
        removedPros.add("standardcost");
        removedPros.add("projectname");
        removedPros.add("invstatus");
        removedPros.add("invtype");
        removedPros.add("unionflag");
        removedPros.add("datatype");
        removedPros.add("amtprecision");
        removedPros.add("biztypestr");
        removedPros.add("dividebasisvalue");
        removedPros.add("caldimensionvalue");
        removedPros.add("caldimension");
        removedPros.add("dividebasis");
        removedPros.add("materialcategory");
        return !removedPros.contains(split[0]);
    }

    private void initDate() {
        this.getModel().setValue("enddate", (Object)DateUtils.getCurrentSystemDate());
    }

    private void initInvageGroup() {
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{INVAGEGROUP});
        this.getModel().setValue(INVAGEGROUP, (Object)ResManager.loadKDString((String)"0\u523030\u5929", (String)"StockAgeRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]), 0);
        this.getModel().setValue(INVAGEGROUP, (Object)ResManager.loadKDString((String)"31\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]), 1);
        this.getModel().setValue(INTERVALDAYS, (Object)31, 0);
        this.getModel().setValue(INTERVALDAYS, null, 1);
    }

    private void setNoStatisticalFilter() {
        IDataModel model = this.getModel();
        this.getModel().getEntryEntity("entry1").addNew();
        this.getModel().getEntryEntity("entry1").addNew();
        this.getModel().getEntryEntity("entry1").addNew();
        this.getModel().getEntryEntity("entry1").addNew();
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 0);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 1);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 2);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 3);
        model.setValue("billtypeentry", (Object)CHANGEBILLId, 4);
        model.setValue("biztypeentry", (Object)BATCHCHANGEID, 0);
        model.setValue("biztypeentry", (Object)INVSTATUSCHANGEID, 1);
        model.setValue("biztypeentry", (Object)INDEXCHANGE, 2);
        model.setValue("biztypeentry", (Object)UNITCHANGE, 3);
        model.setValue("biztypeentry", (Object)OTHERCHANGE, 4);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("entry2".equals(e.getEntryProp().getName())) {
            int rowIndex = this.getModel().getEntryRowCount("entry2") - 1;
            String prefixString = (String)this.getModel().getValue(INVAGEGROUP, rowIndex - 1);
            if (StringUtils.isEmpty((String)prefixString)) {
                return;
            }
            String lastValue = null;
            lastValue = prefixString.contains("days") ? prefixString.substring(prefixString.indexOf("to") + 1, prefixString.indexOf("days")).trim() : prefixString.substring(prefixString.indexOf(ResManager.loadKDString((String)"\u5230", (String)"StockAgeRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0])) + 1, prefixString.indexOf(ResManager.loadKDString((String)"\u5929", (String)"StockAgeRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0])));
            Integer prefixRowIntervaldaysValue = (Integer)this.getModel().getValue(INTERVALDAYS, rowIndex - 1);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{INVAGEGROUP});
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]), Integer.parseInt(lastValue) + prefixRowIntervaldaysValue);
            this.getModel().setValue(INVAGEGROUP, (Object)msg, rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("entry1".equals(e.getEntryProp().getName())) {
            DynamicObjectCollection entry1Entity = this.getModel().getEntryEntity("entry1");
            int reffectedRows = e.getRowIndexs().length;
            if (entry1Entity.size() == reffectedRows) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u5982\u82e5\u8981\u5220\u9664\uff0c\u8bf7\u624b\u5de5\u5220\u9664\u8be5\u884c\u6570\u636e\u3002", (String)"StockAgeRptFormPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]));
            }
        }
        if ("entry2".equals(e.getEntryProp().getName())) {
            int[] rowIndexs = e.getRowIndexs();
            if (rowIndexs.length != 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e00\u6b21\u6027\u5220\u9664\u591a\u884c\uff0c\u8bf7\u4e00\u884c\u884c\u5220\u9664\u3002", (String)"StockAgeRptFormPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]));
            }
            if (rowIndexs[0] == 0 || rowIndexs[0] == 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u548c\u7b2c\u4e8c\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"StockAgeRptFormPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]));
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("entry2".equals(e.getEntryProp().getName())) {
            String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"StockAgeRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            String secondString = sbFirst.substring(1, 2);
            String fourString = sbFirst.substring(sbFirst.length() - 1);
            if (sbFirst.toLowerCase().contains("to")) {
                secondString = "to";
                StringBuffer sb = new StringBuffer(sbFirst.trim());
                sbFirst = sb.toString();
                fourString = sbFirst.substring(sbFirst.indexOf("X ") + 2);
            }
            String sbSuffix = null;
            DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
            if (entry2Entity == null || entry2Entity.isEmpty()) {
                return;
            }
            int size = entry2Entity.size();
            for (int i = 0; i < size; ++i) {
                String lastValue;
                int invagegroup = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS);
                if (i == 0) {
                    if (sbFirst != null) {
                        sbFirst = sbFirst.replaceAll("X", String.valueOf(invagegroup - 1));
                    }
                    this.getModel().setValue(INVAGEGROUP, (Object)sbFirst, i);
                    sbSuffix = sbFirst;
                    continue;
                }
                if (i == size - 1) {
                    lastValue = null;
                    if (sbSuffix != null) {
                        lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                        String msg = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"StockAgeRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]), Integer.parseInt(lastValue) + 1);
                        this.getModel().setValue(INVAGEGROUP, (Object)msg, i);
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue(INTERVALDAYS, null, i);
                    this.getModel().endInit();
                    this.getView().updateView(INTERVALDAYS, i);
                    continue;
                }
                lastValue = null;
                if (sbSuffix == null) continue;
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                String tmp = null;
                tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invagegroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invagegroup) + fourString;
                this.getModel().setValue(INVAGEGROUP, (Object)tmp, i);
                sbSuffix = tmp;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        this.addNoStatisticalBillParams(queryParam);
        this.setSbIntervalDays(queryParam);
        return this.verifyBeforeQuery(queryParam);
    }

    private boolean verifyBeforeQuery(ReportQueryParam queryParam) {
        String[] intervalDays;
        FilterInfo filter = queryParam.getFilter();
        Date enddate = (Date)filter.getValue(ENDDATE);
        if (enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u622a\u6b62\u65e5\u671f\u3002", (String)"StockAgeRptFormPlugin_15", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (calOrgList == null || calOrgList.size() == 0 || costaccountList == null || costaccountList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        QFilter q = new QFilter("entry.costaccount.id", "in", costaccountIdSet);
        DynamicObjectCollection systemctlObj = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.startperiod as startperiod,entry.startperiod.begindate as begindate,entry.costaccount.id as costaccountid", (QFilter[])new QFilter[]{q});
        if (systemctlObj == null || systemctlObj.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockAgeRptFormPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashMap<Long, Date> startperiodDate = new HashMap<Long, Date>(16);
        HashSet<Long> periodIds = new HashSet<Long>();
        HashMap<Long, Long> costAccountstartperiod = new HashMap<Long, Long>(16);
        for (DynamicObject systemctl : systemctlObj) {
            Long startperiodId = systemctl.getLong("startperiod");
            Date begindate = systemctl.getDate("begindate");
            Long costaccountid = systemctl.getLong("costaccountid");
            startperiodDate.put(startperiodId, begindate);
            costAccountstartperiod.put(startperiodId, costaccountid);
            periodIds.add(startperiodId);
        }
        Long maxid = (Long)Collections.max(periodIds);
        Long maxStartperiodcostAccountId = (Long)costAccountstartperiod.get(maxid);
        Date beginDate = (Date)startperiodDate.get(maxid);
        if (beginDate.compareTo(enddate) > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String msg = String.format(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u9700\u8981\u5927\u4e8e\u7b49\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f%1$s\u3002", (String)"StockAgeRptFormPlugin_16", (String)"fi-cal-report", (Object[])new Object[0]), sdf.format(beginDate));
            this.getView().showTipNotification(msg);
            return false;
        }
        String intervalDayStr = queryParam.getFilter().getString("intervaldays");
        if (StringUtils.isNotEmpty((String)intervalDayStr) && (intervalDays = intervalDayStr.split(",")) != null && intervalDays.length > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5141\u8bb8\u67e5\u8be2\u6700\u591a20\u4e2a\u8d26\u9f84\u5206\u7ec4\u3002", (String)"StockAgeRptFormPlugin_26", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        StockAgeReportBplatParam stockAgeReportBplatParam = this.buildStockAgeSumReportParam(dataEntity, queryParam.getFilter(), maxStartperiodcostAccountId);
        List headFilters = queryParam.getFilter().getHeadFilters();
        List<QFilter> balanceHeadFilters = StockAgeReportUtil.getBalanceHeadFilters(headFilters);
        stockAgeReportBplatParam.setBalanceHeadFilters(balanceHeadFilters);
        this.getQueryParam().getCustomParam().put(StockAgeReportBplatParam.class.getName(), stockAgeReportBplatParam);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private StockAgeReportBplatParam buildStockAgeSumReportParam(DynamicObject dataEntity, FilterInfo filterInfo, Long maxStartperiodcostAccountId) {
        StockAgeReportBplatParam stockAgeReportBplatParam = new StockAgeReportBplatParam();
        DynamicObjectCollection costAccounts = new DynamicObjectCollection();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        for (DynamicObject costaccount : costaccounts) {
            DynamicObject costAccount = costaccount.getDynamicObject("fbasedataid");
            costaccountIdSet.add(costAccount.getLong("id"));
            costAccounts.add((Object)costAccount);
        }
        stockAgeReportBplatParam.setCostaccountIdSet(costaccountIdSet);
        HashMap<Long, Long> costAccountCurrencyMap = new HashMap<Long, Long>(16);
        HashMap<Long, Integer> currencyAmtprecisionMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Long> costAccountDividebasisMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy.currency,calpolicy,dividebasis", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        HashSet<Long> calpolicyIdSet = new HashSet<Long>();
        for (Object costAccount : costAccountInfoS) {
            costAccountCurrencyMap.put(costAccount.getLong("id"), costAccount.getLong("calpolicy.currency"));
            calpolicyIdSet.add(costAccount.getLong("calpolicy"));
            costAccountDividebasisMap.put(costAccount.getLong("id"), costAccount.getLong("dividebasis"));
        }
        stockAgeReportBplatParam.setCostAccountCurrencyMap(costAccountCurrencyMap);
        stockAgeReportBplatParam.setCostAccountDividebasisMap(costAccountDividebasisMap);
        DynamicObjectCollection calpolicys = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency,currency.amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicyIdSet)});
        for (DynamicObject calpolicy : calpolicys) {
            Long currencyId = calpolicy.getLong("currency");
            Integer currencyAmtprecision = calpolicy.getInt("currency.amtprecision");
            currencyAmtprecisionMap.put(currencyId, currencyAmtprecision);
        }
        DynamicObject localcurrency = dataEntity.getDynamicObject("localcurrency");
        if (localcurrency == null && calpolicys != null && !calpolicys.isEmpty()) {
            this.getModel().setValue("localcurrency", ((DynamicObject)calpolicys.get(0)).get("currency"));
        }
        stockAgeReportBplatParam.setCurrencyAmtprecisionMap(currencyAmtprecisionMap);
        int amtprecision = 2;
        localcurrency = dataEntity.getDynamicObject("localcurrency");
        if (localcurrency != null) {
            amtprecision = localcurrency.getInt("amtprecision");
        }
        stockAgeReportBplatParam.setAmountPrecision(amtprecision);
        stockAgeReportBplatParam.setLocalcurrency(localcurrency);
        DynamicObjectCollection filter_ownerFrom = null;
        String filter_ownertype = dataEntity.getString("ownertypehead");
        stockAgeReportBplatParam.setOwnertype(filter_ownertype);
        if (StringUtils.isNotEmpty((String)filter_ownertype)) {
            if ("bos_org".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        stockAgeReportBplatParam.setOwner(filter_ownerFrom);
        DynamicObjectCollection filter_storageOrg = dataEntity.getDynamicObjectCollection("mulstorageorg");
        stockAgeReportBplatParam.setStorageOrg(filter_storageOrg);
        DynamicObjectCollection filter_warehouse = dataEntity.getDynamicObjectCollection("mulwarehouse");
        stockAgeReportBplatParam.setWarehouse(filter_warehouse);
        DynamicObjectCollection filter_location = dataEntity.getDynamicObjectCollection("mullocation");
        stockAgeReportBplatParam.setLocation(filter_location);
        DynamicObjectCollection filter_materialFrom = dataEntity.getDynamicObjectCollection("mulmaterial");
        stockAgeReportBplatParam.setMaterialFrom(filter_materialFrom);
        DynamicObject filter_materialTo = dataEntity.getDynamicObject("materialto");
        stockAgeReportBplatParam.setMaterialTo(filter_materialTo);
        DynamicObjectCollection filter_multrackNumber = dataEntity.getDynamicObjectCollection("multracknum");
        stockAgeReportBplatParam.setMultracknumber(filter_multrackNumber);
        boolean onlyshowsumrow = dataEntity.getBoolean("onlyshowsumrow");
        stockAgeReportBplatParam.setOnlyShowSumRow(onlyshowsumrow);
        boolean materialclasssum = dataEntity.getBoolean("materialclasssum");
        stockAgeReportBplatParam.setMaterialClassSum(materialclasssum);
        Date endDate = dataEntity.getDate("enddate");
        String intervalDayStr = filterInfo.getString("intervaldays");
        String[] intervalDays = intervalDayStr.split(",");
        stockAgeReportBplatParam.setIntervalDays(intervalDays);
        Long costAccountId = 0L;
        DynamicObject currentPeriod = null;
        if (costaccounts.size() == 1) {
            costAccountId = ((DynamicObject)costaccounts.get(0)).getDynamicObject("fbasedataid").getLong("id");
            currentPeriod = PeriodHelper.getPeriodByDate((Date)endDate, (Long)costAccountId);
        } else {
            currentPeriod = PeriodHelper.getPeriodByDate((Date)endDate, (Long)maxStartperiodcostAccountId);
        }
        int startPeriod = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
        stockAgeReportBplatParam.setStartPeriod(startPeriod);
        Date startDate = currentPeriod.getDate("begindate");
        stockAgeReportBplatParam.setStartDate(startDate);
        endDate = DateUtils.getDayEndTime((Date)endDate);
        stockAgeReportBplatParam.setEndDate(endDate);
        int sumIntervalDay = 0;
        for (int i = 0; i < intervalDays.length; ++i) {
            sumIntervalDay += Integer.parseInt(intervalDays[i]);
        }
        Date intervalStartDate = this.getTargetDateBySubDay(endDate, sumIntervalDay);
        stockAgeReportBplatParam.setIntervalStartDate(intervalStartDate);
        HashMap<Long, Boolean> containDiffermap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> multifactoryaccountmap = new HashMap<Long, Boolean>(16);
        DynamicObjectCollection calorgs = dataEntity.getDynamicObjectCollection("mulcalorg");
        HashSet<Long> containDifferTrueCalOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> containDifferFalseCalOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> multifactoryTrueCalOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> multifactoryFalseCalOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> calOrgIdSet = new HashSet<Long>(16);
        HashMap<Long, String> calorgdiffcolMap = new HashMap<Long, String>(16);
        for (DynamicObject calorg : calorgs) {
            Long calorgId = calorg.getDynamicObject("fbasedataid").getLong("id");
            calOrgIdSet.add(calorgId);
            Object diffalloccols = ParamsHelper.getAppParam((long)calorgId, (String)"diffalloccols");
            String diffAllocDims = null;
            if (diffalloccols == null) {
                diffAllocDims = "calorg,costaccount,material";
                calorgdiffcolMap.put(calorgId, diffAllocDims);
            } else {
                diffAllocDims = (ParamsHelper.getAppParam((long)calorgId, (String)"diffalloccols").toString() + "costaccount,material").substring(1);
                if (StringUtils.isNotEmpty((String)diffAllocDims)) {
                    diffAllocDims = diffAllocDims.replace("storageorgunit", "storageorg");
                    calorgdiffcolMap.put(calorgId, diffAllocDims);
                }
            }
            boolean isContainDiffer = (Boolean)ParamsHelper.getAppParam((long)calorgId, (String)"iscontaindiffer");
            containDiffermap.put(calorgId, isContainDiffer);
            if (isContainDiffer) {
                containDifferTrueCalOrgIdSet.add(calorgId);
            } else {
                containDifferFalseCalOrgIdSet.add(calorgId);
            }
            boolean multifactoryaccountFlag = ParamsHelper.getMultifactoryaccountByCalOrg((Long)calorgId);
            if (multifactoryaccountFlag) {
                multifactoryTrueCalOrgIdSet.add(calorgId);
            } else {
                multifactoryFalseCalOrgIdSet.add(calorgId);
            }
            multifactoryaccountmap.put(calorgId, multifactoryaccountFlag);
        }
        stockAgeReportBplatParam.setCalorgdiffcolMap(calorgdiffcolMap);
        stockAgeReportBplatParam.setCalOrgIdSet(calOrgIdSet);
        stockAgeReportBplatParam.setMultifactoryaccountmap(multifactoryaccountmap);
        stockAgeReportBplatParam.setContainDiffermap(containDiffermap);
        stockAgeReportBplatParam.setContainDifferTrueCalOrgIdSet(containDifferTrueCalOrgIdSet);
        stockAgeReportBplatParam.setContainDifferFalseCalOrgIdSet(containDifferFalseCalOrgIdSet);
        stockAgeReportBplatParam.setMultifactoryTrueCalOrgIdSet(multifactoryTrueCalOrgIdSet);
        stockAgeReportBplatParam.setMultifactoryFalseCalOrgIdSet(multifactoryFalseCalOrgIdSet);
        String nostatistical = filterInfo.getString("nostatistical");
        stockAgeReportBplatParam.setNostatistical(nostatistical);
        QFilter orgFilter = new QFilter("costaccount", "in", costaccountIdSet);
        orgFilter.and("calorg", "in", calOrgIdSet);
        QFilter baseFilter = new QFilter("bizstatus", "=", (Object)"1");
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)endDate);
        timeFilter.and("invaliddate", ">", (Object)endDate);
        DataSet costTypeOrgs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_costtypeorg", (String)"costtype.id as costtype,costaccount,calorg,storageorgunit", (QFilter[])new QFilter[]{orgFilter, baseFilter, timeFilter}, null);
        HashSet<Long> costTypeIds = new HashSet<Long>(16);
        costTypeIds.add(1L);
        HashSet<Long> hasMultifactoryOrg = new HashSet<Long>(16);
        HashMap<String, Long> orgCostTypeMap = new HashMap<String, Long>(16);
        for (Row costTypeOrg : costTypeOrgs.copy()) {
            void var57_67;
            costTypeIds.add(costTypeOrg.getLong("costtype"));
            Long costaccountid = costTypeOrg.getLong("costaccount");
            Long calorgid = costTypeOrg.getLong("calorg");
            boolean multifactoryaccountFlag = ParamsHelper.getMultifactoryaccountByCalOrg((Long)calorgid);
            String string = calorgid + "_" + costaccountid;
            if (multifactoryaccountFlag) {
                Long storageorgunitid = costTypeOrg.getLong("storageorgunit");
                String string2 = string + "_" + storageorgunitid;
                hasMultifactoryOrg.add(calorgid);
            }
            orgCostTypeMap.put((String)var57_67, costTypeOrg.getLong("costtype"));
        }
        stockAgeReportBplatParam.setBalanceCostTypeIds(costTypeIds);
        stockAgeReportBplatParam.setHasMultifactoryOrg(hasMultifactoryOrg);
        stockAgeReportBplatParam.setOrgCostTypeMap(orgCostTypeMap);
        StringBuffer sbInvageGroup = null;
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
        if (entry2Entity != null && !entry2Entity.isEmpty()) {
            int size = entry2Entity.size();
            if (((DynamicObject)entry2Entity.get(0)).getInt(INTERVALDAYS) != 0) {
                sbInvageGroup = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    String ageGroup = ((DynamicObject)entry2Entity.get(i)).getString(INVAGEGROUP) + ",";
                    sbInvageGroup.append(ageGroup);
                }
                sbInvageGroup = sbInvageGroup.delete(sbInvageGroup.lastIndexOf(","), sbInvageGroup.length());
            }
        }
        stockAgeReportBplatParam.setSbInvageGroup(sbInvageGroup);
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String[] showKeyCols = colsStr.split(",");
        HashSet<String> showKeyColsSet = new HashSet<String>(16);
        for (String showKeyCol : showKeyCols) {
            if (StringUtils.isEmpty((String)showKeyCol)) continue;
            showKeyColsSet.add(showKeyCol);
        }
        stockAgeReportBplatParam.setShowKeyColsSet(showKeyColsSet);
        Set set = ReportUtil.getWarehsGroupSet((FilterInfo)filterInfo);
        stockAgeReportBplatParam.setWarehsGroupSet(set);
        DynamicObject materialgroupstandard = dataEntity.getDynamicObject("materialgroupstandard");
        stockAgeReportBplatParam.setMaterialgroupstandard(materialgroupstandard);
        DynamicObjectCollection mulmaterialgroup = dataEntity.getDynamicObjectCollection("mulmaterialgroup");
        stockAgeReportBplatParam.setMulmaterialgroup(mulmaterialgroup);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stock_age_col_repo");
        HashMap<String, IDataEntityProperty> dataEntityPropertyMap = new HashMap<String, IDataEntityProperty>();
        for (String showKeyCol : showKeyColsSet) {
            if (StringUtils.isEmpty((String)showKeyCol)) continue;
            IDataEntityProperty property = entityType.findProperty(showKeyCol);
            dataEntityPropertyMap.put(showKeyCol, property);
        }
        stockAgeReportBplatParam.setDataEntityPropertyMap(dataEntityPropertyMap);
        Set<Long> emptyRangeIdsSet = this.getEmptyEntryRangeIds(costaccountIdSet);
        stockAgeReportBplatParam.setEmptyRangeIdsSet(emptyRangeIdsSet);
        HashMap<Long, String> dividebasisMap = new HashMap<Long, String>(16);
        DynamicObjectCollection dividebasisInfoS = QueryServiceHelper.query((String)"cal_bd_dividebasis", (String)"id,dividebasis", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        for (DynamicObject dividebasis : dividebasisInfoS) {
            String dividebasisStr = dividebasis.getString("dividebasis").replace("storageorgunit", "storageorg");
            dividebasisMap.put(dividebasis.getLong("id"), dividebasisStr);
        }
        stockAgeReportBplatParam.setDividebasisMap(dividebasisMap);
        HashMap<Long, String> caldimensionMap = new HashMap<Long, String>(16);
        DynamicObjectCollection caldimensionInfoS = QueryServiceHelper.query((String)"cal_bd_caldimension", (String)"id,caldimension", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        for (DynamicObject caldimension : caldimensionInfoS) {
            caldimensionMap.put(caldimension.getLong("id"), caldimension.getString("caldimension"));
        }
        stockAgeReportBplatParam.setCaldimensionMap(caldimensionMap);
        if (!containDifferFalseCalOrgIdSet.isEmpty()) {
            QFilter q = StockAgeReportUtil.buildFilterOnlyMaterial("balance", stockAgeReportBplatParam);
            q.and("period", "<=", (Object)stockAgeReportBplatParam.getStartPeriod());
            q.and("endperiod", ">", (Object)stockAgeReportBplatParam.getStartPeriod());
            q.and("invtype.isforwardamount", "=", (Object)Boolean.TRUE);
            HashMap<Long, ArrayList<Long>> costTypeMaterials = new HashMap<Long, ArrayList<Long>>(16);
            String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
            DataSet calBalanceSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balanceEntity, (String)"material,costaccount,calorg,storageorgunit", (QFilter[])new QFilter[]{q}, null);
            for (Object row : calBalanceSet) {
                Long costType;
                Long l = row.getLong("material");
                Long costaccountid = row.getLong("costaccount");
                Long calorgid = row.getLong("calorg");
                String orgKey = calorgid + "_" + costaccountid;
                if (hasMultifactoryOrg.contains(calorgid)) {
                    Long storageorgunitid = row.getLong("storageorgunit");
                    orgKey = orgKey + "_" + storageorgunitid;
                }
                if ((costType = (Long)orgCostTypeMap.get(orgKey)) == null || costType == 0L) continue;
                ArrayList<Long> params = (ArrayList<Long>)costTypeMaterials.get(costType);
                if (null == params || params.size() == 0) {
                    params = new ArrayList<Long>(16);
                    params.add(l);
                    costTypeMaterials.put(costType, params);
                    continue;
                }
                params.add(l);
            }
            HashMap<String, String> materialDimensionMap = new HashMap<String, String>(16);
            if (!costTypeMaterials.isEmpty()) {
                for (Map.Entry entry : costTypeMaterials.entrySet()) {
                    Map resultsMap = null;
                    try {
                        resultsMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"MatCostInfoPriceService", (String)"getMaterialDimension", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                    }
                    catch (Exception e) {
                        WriteLogHelper.writeErrorLog((Log)logger, (Throwable)e);
                    }
                    if (resultsMap == null || resultsMap.isEmpty()) continue;
                    for (Map.Entry result : resultsMap.entrySet()) {
                        Long materialid = (Long)result.getKey();
                        String costTypeKey = entry.getKey() + "_" + materialid;
                        materialDimensionMap.put(costTypeKey, (String)result.getValue());
                    }
                }
            }
            stockAgeReportBplatParam.setMaterialDimensionMap(materialDimensionMap);
        }
        DynamicObjectCollection mulmatcategory = dataEntity.getDynamicObjectCollection("mulmatcategory");
        DynamicObjectCollection matCategory = new DynamicObjectCollection();
        HashSet<Long> mulCategoryIdSet = new HashSet<Long>(16);
        for (DynamicObject matcategory : mulmatcategory) {
            matCategory.add((Object)matcategory.getDynamicObject("fbasedataid"));
            Long matcategoryId = matcategory.getDynamicObject("fbasedataid").getLong("id");
            mulCategoryIdSet.add(matcategoryId);
        }
        stockAgeReportBplatParam.setMatcategory(matCategory);
        stockAgeReportBplatParam.setMulCategoryIdSet(mulCategoryIdSet);
        return stockAgeReportBplatParam;
    }

    private Date getTargetDateBySubDay(Date endDate, int sumIntervalDay) {
        long endDateTime = endDate.getTime();
        long endPeriodDateTime = endDateTime - 86400000L * (long)sumIntervalDay;
        return new Date(endPeriodDateTime);
    }

    private void addNoStatisticalBillParams(ReportQueryParam queryParam) {
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry1");
        if (entry2Entity != null && !entry2Entity.isEmpty()) {
            int size = entry2Entity.size();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                DynamicObject billtypeentry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("billtypeentry");
                DynamicObject biztypeentry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("biztypeentry");
                DynamicObject invschemeentry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("invschemeentry");
                StringBuilder billInvScheme = new StringBuilder();
                if (billtypeentry != null) {
                    Long billtypeId = (Long)billtypeentry.getPkValue();
                    billInvScheme.append(billtypeId);
                    if (biztypeentry != null) {
                        Long biztypeentryId = (Long)biztypeentry.getPkValue();
                        billInvScheme.append(":");
                        billInvScheme.append(biztypeentryId);
                    }
                    if (invschemeentry != null) {
                        Long invschemeId = (Long)invschemeentry.getPkValue();
                        billInvScheme.append(":");
                        billInvScheme.append(invschemeId);
                    }
                }
                sb.append((CharSequence)billInvScheme);
                sb.append(",");
            }
            String string = sb.toString();
            if (string.isEmpty()) {
                return;
            }
            queryParam.getFilter().addFilterItem("nostatistical", (Object)string.substring(0, string.lastIndexOf(44)));
        }
    }

    private void setSbIntervalDays(ReportQueryParam queryParam) {
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
        if (entry2Entity != null && !entry2Entity.isEmpty()) {
            int size = entry2Entity.size();
            if (((DynamicObject)entry2Entity.get(0)).getInt(INTERVALDAYS) != 0) {
                StringBuffer sbIntervaldays = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    String intervalStr = ((DynamicObject)entry2Entity.get(i)).getInt(INTERVALDAYS) + ",";
                    sbIntervaldays.append(intervalStr);
                }
                sbIntervaldays = sbIntervaldays.delete(sbIntervaldays.lastIndexOf(","), sbIntervaldays.length());
                queryParam.getFilter().addFilterItem(INTERVALDAYS, (Object)sbIntervaldays.toString());
            }
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryOne = scheme.getDynamicObjectCollection(ENTRYONE);
        DynamicObjectCollection entryTwo = scheme.getDynamicObjectCollection(ENTRYTWO);
        if (entryOne == null || entryOne.size() == 0 || entryTwo == null || entryTwo.size() == 0) {
            return;
        }
        dataModel.deleteEntryData(ENTRYONE);
        dataModel.deleteEntryData(ENTRYTWO);
        dataModel.batchCreateNewEntryRow(ENTRYONE, entryOne.size());
        dataModel.batchCreateNewEntryRow(ENTRYTWO, entryTwo.size());
        this.setF7Filter(dataModel, entryOne, BILLTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, BIZTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, INVSCHEMEENTRY);
        this.setBasicFilter(dataModel, entryTwo, INVAGEGROUP);
        this.setBasicFilter(dataModel, entryTwo, INTERVALDAYS);
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryOne = dataModel.getEntryEntity(ENTRYONE);
        DynamicObjectCollection entryTwo = dataModel.getEntryEntity(ENTRYTWO);
        this.setF7Filter(dataModel, entryOne, BILLTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, BIZTYPEENTRY);
        this.setF7Filter(dataModel, entryOne, INVSCHEMEENTRY);
        this.setBasicFilter(dataModel, entryTwo, INVAGEGROUP);
        this.setBasicFilter(dataModel, entryTwo, INTERVALDAYS);
    }

    private void setF7Filter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            DynamicObject billTypeObj = entryObj.getDynamicObject(entryField);
            if (billTypeObj == null) continue;
            Long billType = billTypeObj.getLong("id");
            dataModel.setValue(entryField, (Object)billType, i);
        }
    }

    private void setBasicFilter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            Object entryFieldObj = entryObj.get(entryField);
            if (entryFieldObj == null) continue;
            dataModel.setValue(entryField, entryFieldObj, i);
        }
    }

    private Set<Long> getEmptyEntryRangeIds(Set<Long> costAccountIdSet) {
        QFilter filter = new QFilter("costaccount", "in", costAccountIdSet);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        return emptyEntryRangeIds;
    }
}

