/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class AddSumClassGroupFieldReduceGroupFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private StockAgeReportBplatParam reportParam;
    private String sumString;

    public AddSumClassGroupFieldReduceGroupFunc(RowMeta rowMeta, StockAgeReportBplatParam reportParam, String sumString) {
        this.rowMeta = rowMeta;
        this.reportParam = reportParam;
        this.sumString = sumString;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int amountIndex;
        int calorgIndex;
        int costaccountIndex;
        Iterator<RowX> iterator = iterable.iterator();
        Long costaccount = 0L;
        Long calorg = 0L;
        Long currency = 0L;
        BigDecimal toatalbaseqty = BigDecimal.ZERO;
        BigDecimal toatalamount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> qtyAmountMap = new HashMap<String, BigDecimal>(16);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
            costaccount = row.getLong(costaccountIndex);
            calorgIndex = this.rowMeta.getFieldIndex("calorg");
            calorg = row.getLong(calorgIndex);
            int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
            BigDecimal baseqty = row.getBigDecimal(baseqtyIndex);
            toatalbaseqty = toatalbaseqty.add(baseqty);
            amountIndex = this.rowMeta.getFieldIndex("amount");
            BigDecimal amount = row.getBigDecimal(amountIndex);
            toatalamount = toatalamount.add(amount);
            int currencyIndex = this.rowMeta.getFieldIndex("currency");
            currency = row.getLong(currencyIndex);
            String[] intervalDays = this.reportParam.getIntervalDays();
            for (int i = 0; i < intervalDays.length; ++i) {
                BigDecimal mapamount;
                BigDecimal mapqty;
                String prefixField = "range" + i;
                String qtyField = prefixField + "qty";
                int qtyFieldIndex = this.rowMeta.getFieldIndex(qtyField);
                BigDecimal qtyFieldnumber = row.getBigDecimal(qtyFieldIndex);
                if (null == qtyFieldnumber) {
                    qtyFieldnumber = BigDecimal.ZERO;
                }
                if (null == (mapqty = (BigDecimal)qtyAmountMap.get(qtyField))) {
                    mapqty = qtyFieldnumber;
                    qtyAmountMap.put(qtyField, mapqty);
                } else {
                    mapqty = mapqty.add(qtyFieldnumber);
                    qtyAmountMap.put(qtyField, mapqty);
                }
                String amountField = prefixField + "amount";
                int amountFieldIndex = this.rowMeta.getFieldIndex(amountField);
                BigDecimal amountFieldNumber = row.getBigDecimal(amountFieldIndex);
                if (null == amountFieldNumber) {
                    amountFieldNumber = BigDecimal.ZERO;
                }
                if (null == (mapamount = (BigDecimal)qtyAmountMap.get(amountField))) {
                    mapamount = amountFieldNumber;
                    qtyAmountMap.put(amountField, mapamount);
                    continue;
                }
                mapamount = mapamount.add(amountFieldNumber);
                qtyAmountMap.put(amountField, mapamount);
            }
            collector.collect(row);
        }
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        newRow.set(costaccountIndex, (Object)costaccount);
        calorgIndex = this.rowMeta.getFieldIndex("calorg");
        newRow.set(calorgIndex, (Object)calorg);
        int materialnumberIndex = this.rowMeta.getFieldIndex("materialnumber");
        newRow.set(materialnumberIndex, (Object)this.sumString);
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        newRow.set(baseqtyIndex, (Object)toatalbaseqty);
        amountIndex = this.rowMeta.getFieldIndex("amount");
        newRow.set(amountIndex, (Object)toatalamount);
        int currencyIndex = this.rowMeta.getFieldIndex("currency");
        newRow.set(currencyIndex, (Object)currency);
        for (int i = 0; i < this.reportParam.getIntervalDays().length; ++i) {
            String prefixField = "range" + i;
            String qtyField = prefixField + "qty";
            String amountField = prefixField + "amount";
            int qtyFieldIndex = this.rowMeta.getFieldIndex(qtyField);
            newRow.set(qtyFieldIndex, qtyAmountMap.get(qtyField));
            int amountFieldIndex = this.rowMeta.getFieldIndex(amountField);
            newRow.set(amountFieldIndex, qtyAmountMap.get(amountField));
        }
        int orderinexIndex = this.rowMeta.getFieldIndex("orderinex");
        newRow.set(orderinexIndex, (Object)"1");
        int linetypeIndex = this.rowMeta.getFieldIndex("linetype");
        newRow.set(linetypeIndex, (Object)"1");
        int materialgroupIndex = this.rowMeta.getFieldIndex("materialgroup");
        newRow.set(materialgroupIndex, (Object)0L);
        collector.collect(newRow);
    }
}

