/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportUtil;

public class AddSumUnClassGroupFieldReduceGroupFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private StockAgeReportBplatParam reportParam;
    private String sumString;

    public AddSumUnClassGroupFieldReduceGroupFunc(RowMeta rowMeta, StockAgeReportBplatParam reportParam, String sumString) {
        this.rowMeta = rowMeta;
        this.reportParam = reportParam;
        this.sumString = sumString;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        Long costaccount = 0L;
        Long calorg = 0L;
        Long currency = 0L;
        BigDecimal toatalbaseqty = BigDecimal.ZERO;
        BigDecimal toatalamount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> qtyAmountMap = new HashMap<String, BigDecimal>(16);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
            costaccount = row.getLong(costaccountIndex);
            int calorgIndex = this.rowMeta.getFieldIndex("calorg");
            calorg = row.getLong(calorgIndex);
            int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
            BigDecimal baseqty = row.getBigDecimal(baseqtyIndex);
            toatalbaseqty = toatalbaseqty.add(baseqty);
            int amountIndex = this.rowMeta.getFieldIndex("amount");
            BigDecimal amount = row.getBigDecimal(amountIndex);
            toatalamount = toatalamount.add(amount);
            int currencyIndex = this.rowMeta.getFieldIndex("currency");
            currency = row.getLong(currencyIndex);
            String[] intervalDays = this.reportParam.getIntervalDays();
            for (int i = 0; i < intervalDays.length; ++i) {
                BigDecimal mapamount;
                BigDecimal mapqty;
                String prefixField = "range" + i;
                String qtyField = prefixField + "qty";
                int qtyFieldIndex = this.rowMeta.getFieldIndex(qtyField);
                BigDecimal qtyFieldnumber = row.getBigDecimal(qtyFieldIndex);
                if (null == qtyFieldnumber) {
                    qtyFieldnumber = BigDecimal.ZERO;
                }
                if (null == (mapqty = (BigDecimal)qtyAmountMap.get(qtyField))) {
                    mapqty = qtyFieldnumber;
                    qtyAmountMap.put(qtyField, mapqty);
                } else {
                    mapqty = mapqty.add(qtyFieldnumber);
                    qtyAmountMap.put(qtyField, mapqty);
                }
                String amountField = prefixField + "amount";
                int amountFieldIndex = this.rowMeta.getFieldIndex(amountField);
                BigDecimal amountFieldNumber = row.getBigDecimal(amountFieldIndex);
                if (null == amountFieldNumber) {
                    amountFieldNumber = BigDecimal.ZERO;
                }
                if (null == (mapamount = (BigDecimal)qtyAmountMap.get(amountField))) {
                    mapamount = amountFieldNumber;
                    qtyAmountMap.put(amountField, mapamount);
                    continue;
                }
                mapamount = mapamount.add(amountFieldNumber);
                qtyAmountMap.put(amountField, mapamount);
            }
            collector.collect(row);
        }
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        Set<String> showKeyCols = this.reportParam.getShowKeyColsSet();
        HashSet<String> showSumRowKeyCols = new HashSet<String>(16);
        showSumRowKeyCols.addAll(showKeyCols);
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        newRow.set(costaccountIndex, (Object)costaccount);
        int calorgIndex = this.rowMeta.getFieldIndex("calorg");
        newRow.set(calorgIndex, (Object)calorg);
        showSumRowKeyCols.remove("costaccount");
        showSumRowKeyCols.remove("calorg");
        int materialIndex = this.rowMeta.getFieldIndex("material");
        newRow.set(materialIndex, (Object)0L);
        showSumRowKeyCols.remove("material");
        int materialnumberIndex = this.rowMeta.getFieldIndex("materialnumber");
        newRow.set(materialnumberIndex, (Object)this.sumString);
        showSumRowKeyCols.remove("materialnumber");
        int baseunitIndex = this.rowMeta.getFieldIndex("baseunit");
        newRow.set(baseunitIndex, (Object)0L);
        showSumRowKeyCols.remove("baseunit");
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "owner")) {
            int ownerIndex = this.rowMeta.getFieldIndex("owner");
            newRow.set(ownerIndex, (Object)0L);
            showSumRowKeyCols.remove("owner");
            int ownertypeIndex = this.rowMeta.getFieldIndex("ownertype");
            newRow.set(ownertypeIndex, (Object)" ");
            showSumRowKeyCols.remove("ownertype");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg")) {
            int storageorgIndex = this.rowMeta.getFieldIndex("storageorg");
            newRow.set(storageorgIndex, (Object)0L);
            showSumRowKeyCols.remove("storageorg");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg")) {
                int storageorgIndex = this.rowMeta.getFieldIndex("storageorg");
                newRow.set(storageorgIndex, (Object)0L);
                showSumRowKeyCols.remove("storageorg");
            }
            int groupIndex = this.rowMeta.getFieldIndex("group");
            newRow.set(groupIndex, (Object)0L);
            showSumRowKeyCols.remove("group");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") && !StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
                int storageorgIndex = this.rowMeta.getFieldIndex("storageorg");
                newRow.set(storageorgIndex, (Object)0L);
                showSumRowKeyCols.remove("storageorg");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "group")) {
                int groupIndex = this.rowMeta.getFieldIndex("group");
                newRow.set(groupIndex, (Object)0L);
                showSumRowKeyCols.remove("group");
            }
            int warehouseIndex = this.rowMeta.getFieldIndex("warehouse");
            newRow.set(warehouseIndex, (Object)0L);
            showSumRowKeyCols.remove("warehouse");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "location")) {
            if (!(StockAgeReportUtil.hasGroupByName(showKeyCols, "storageorg") || StockAgeReportUtil.hasGroupByName(showKeyCols, "group") || StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse"))) {
                int storageorgIndex = this.rowMeta.getFieldIndex("storageorg");
                newRow.set(storageorgIndex, (Object)0L);
                showSumRowKeyCols.remove("storageorg");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "group") && !StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
                int groupIndex = this.rowMeta.getFieldIndex("group");
                newRow.set(groupIndex, (Object)0L);
                showSumRowKeyCols.remove("group");
            }
            if (!StockAgeReportUtil.hasGroupByName(showKeyCols, "warehouse")) {
                int warehouseIndex = this.rowMeta.getFieldIndex("warehouse");
                newRow.set(warehouseIndex, (Object)0L);
                showSumRowKeyCols.remove("warehouse");
            }
            int locationIndex = this.rowMeta.getFieldIndex("location");
            newRow.set(locationIndex, (Object)0L);
            showSumRowKeyCols.remove("location");
        }
        if (StockAgeReportUtil.hasGroupByName(showKeyCols, "assist")) {
            int assistIndex = this.rowMeta.getFieldIndex("assist");
            newRow.set(assistIndex, (Object)0L);
            showSumRowKeyCols.remove("assist");
        }
        int calrangeIndex = this.rowMeta.getFieldIndex("calrange");
        newRow.set(calrangeIndex, (Object)0L);
        showSumRowKeyCols.remove("calrange");
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        newRow.set(baseqtyIndex, (Object)toatalbaseqty);
        int amountIndex = this.rowMeta.getFieldIndex("amount");
        newRow.set(amountIndex, (Object)toatalamount);
        showSumRowKeyCols.remove("baseqty");
        showSumRowKeyCols.remove("amount");
        int currencyIndex = this.rowMeta.getFieldIndex("currency");
        newRow.set(currencyIndex, (Object)currency);
        showSumRowKeyCols.remove("currency");
        int materialmodelIndex = this.rowMeta.getFieldIndex("materialmodel");
        newRow.set(materialmodelIndex, (Object)" ");
        showSumRowKeyCols.remove("materialmodel");
        int amtprecisionIndex = this.rowMeta.getFieldIndex("amtprecision");
        newRow.set(amtprecisionIndex, (Object)0);
        showSumRowKeyCols.remove("amtprecision");
        if (showSumRowKeyCols != null && showSumRowKeyCols.size() > 0) {
            Map<String, IDataEntityProperty> dataTypeMap = this.reportParam.getDataEntityPropertyMap();
            for (String showKeyCol : showSumRowKeyCols) {
                IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
                int showKeyColIndex = this.rowMeta.getFieldIndex(showKeyCol);
                if (dataProperty != null) {
                    if (dataProperty instanceof BasedataProp) {
                        newRow.set(showKeyColIndex, (Object)0L);
                        continue;
                    }
                    if (!(dataProperty instanceof TextProp)) continue;
                    newRow.set(showKeyColIndex, (Object)" ");
                    continue;
                }
                newRow.set(showKeyColIndex, (Object)0L);
            }
        }
        for (int i = 0; i < this.reportParam.getIntervalDays().length; ++i) {
            String prefixField = "range" + i;
            String qtyField = prefixField + "qty";
            String amountField = prefixField + "amount";
            int qtyFieldIndex = this.rowMeta.getFieldIndex(qtyField);
            newRow.set(qtyFieldIndex, qtyAmountMap.get(qtyField));
            int amountFieldIndex = this.rowMeta.getFieldIndex(amountField);
            newRow.set(amountFieldIndex, qtyAmountMap.get(amountField));
        }
        int orderinexIndex = this.rowMeta.getFieldIndex("orderinex");
        newRow.set(orderinexIndex, (Object)"1");
        int linetypeIndex = this.rowMeta.getFieldIndex("linetype");
        newRow.set(linetypeIndex, (Object)"1");
        collector.collect(newRow);
    }
}

