/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class CalActualpriceReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private RowMeta resultMeta;

    public CalActualpriceReduceGroupFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.resultMeta = this.buildResultMeta();
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        BigDecimal toatalactualqty = BigDecimal.ZERO;
        BigDecimal toatalactualamount = BigDecimal.ZERO;
        HashSet<RowX> resultRowSet = new HashSet<RowX>(16);
        while (iterator.hasNext()) {
            int baseqtyIndex;
            RowX rowX = iterator.next();
            BigDecimal baseqty = rowX.getBigDecimal(baseqtyIndex = this.rowMeta.getFieldIndex("baseqty"));
            if (null == baseqty) {
                baseqty = BigDecimal.ZERO;
            }
            toatalactualqty = toatalactualqty.add(baseqty);
            int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
            BigDecimal actualamount = rowX.getBigDecimal(actualamountIndex);
            int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
            BigDecimal standardamount = rowX.getBigDecimal(standardamountIndex);
            if (null == actualamount) {
                actualamount = BigDecimal.ZERO;
            }
            if (null == standardamount) {
                standardamount = BigDecimal.ZERO;
            }
            toatalactualamount = toatalactualamount.add(actualamount).add(standardamount);
            resultRowSet.add(rowX);
        }
        BigDecimal actualprice = BigDecimal.ZERO;
        actualprice = null == toatalactualqty || toatalactualqty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : toatalactualamount.divide(toatalactualqty, 10, 4);
        for (RowX rowX : resultRowSet) {
            RowX newRowX = this.createResultRow(rowX, this.resultMeta, actualprice, toatalactualamount);
            collector.collect(newRowX);
        }
    }

    private RowMeta buildResultMeta() {
        Field[] srcFields = this.rowMeta.getFields();
        ArrayList<Field> resultFieldList = new ArrayList<Field>(10);
        for (Field srcField : srcFields) {
            resultFieldList.add(srcField);
        }
        Field actualprice = new Field("actualprice", (DataType)DataType.BigDecimalType);
        resultFieldList.add(actualprice);
        Field oldallamount = new Field("oldallamount", (DataType)DataType.BigDecimalType);
        resultFieldList.add(oldallamount);
        return new RowMeta(resultFieldList.toArray(new Field[resultFieldList.size()]));
    }

    private RowX createResultRow(RowX srcRow, RowMeta resultMeta, BigDecimal actualprice, BigDecimal toatalactualamount) {
        Field[] fields = resultMeta.getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = "actualprice".equals(fields[i].getName()) ? actualprice : ("standardamount".equals(fields[i].getName()) ? BigDecimal.ZERO : ("oldallamount".equals(fields[i].getName()) ? toatalactualamount : srcRow.get(this.rowMeta.getFieldIndex(fields[i].getName()))));
        }
        return new RowX(values);
    }
}

