/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class CalBalancePerPeriodEndMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<Long, Boolean> containDiffermap;
    private Map<Long, Long> costAccountCurrencyMap;
    private StockAgeReportBplatParam reportParam;
    private Map<Long, Integer> currencyAmtprecisionMap;

    public CalBalancePerPeriodEndMapFunction(RowMeta rowMeta, StockAgeReportBplatParam reportParam) {
        this.rowMeta = rowMeta;
        this.containDiffermap = reportParam.getContainDiffermap();
        this.costAccountCurrencyMap = reportParam.getCostAccountCurrencyMap();
        this.reportParam = reportParam;
        this.currencyAmtprecisionMap = reportParam.getCurrencyAmtprecisionMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int calorgIndex = this.rowMeta.getFieldIndex("calorg");
        Long calorgId = rowX.getLong(calorgIndex);
        boolean isContainDiffer = false;
        if (this.containDiffermap.containsKey(calorgId)) {
            isContainDiffer = this.containDiffermap.get(calorgId);
        }
        int accounttypeIndex = this.rowMeta.getFieldIndex("accounttype");
        String accounttype = rowX.getString(accounttypeIndex);
        int periodendstandardcostIndex = this.rowMeta.getFieldIndex("periodendstandardcost");
        int periodendcostdiffIndex = this.rowMeta.getFieldIndex("periodendcostdiff");
        int periodendactualcostIndex = this.rowMeta.getFieldIndex("periodendactualcost");
        int periodendqtyIndex = this.rowMeta.getFieldIndex("periodendqty");
        int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
        int standardbaseqtyIndex = this.rowMeta.getFieldIndex("standardbaseqty");
        int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
        int actualqtyIndex = this.rowMeta.getFieldIndex("actualqty");
        BigDecimal periodendstandardcost = rowX.getBigDecimal(periodendstandardcostIndex);
        if (isContainDiffer) {
            BigDecimal periodendcostdiff = rowX.getBigDecimal(periodendcostdiffIndex);
            if ("D".equals(accounttype)) {
                rowX.set(standardamountIndex, (Object)periodendstandardcost.add(periodendcostdiff));
            } else {
                rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
            }
        } else if ("D".equals(accounttype)) {
            rowX.set(standardamountIndex, (Object)periodendstandardcost);
        } else {
            rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
        }
        BigDecimal periodendqty = rowX.getBigDecimal(periodendqtyIndex);
        BigDecimal periodendactualcost = rowX.getBigDecimal(periodendactualcostIndex);
        if (!"D".equals(accounttype)) {
            rowX.set(standardbaseqtyIndex, (Object)BigDecimal.ZERO);
            rowX.set(actualamountIndex, (Object)periodendactualcost);
            rowX.set(actualqtyIndex, (Object)periodendqty);
        } else {
            rowX.set(standardbaseqtyIndex, (Object)periodendqty);
            rowX.set(actualamountIndex, (Object)BigDecimal.ZERO);
            rowX.set(actualqtyIndex, (Object)BigDecimal.ZERO);
        }
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        rowX.set(baseqtyIndex, (Object)periodendqty);
        int unionflagIndex = this.rowMeta.getFieldIndex("unionflag");
        rowX.set(unionflagIndex, (Object)1);
        int datatypeIndex = this.rowMeta.getFieldIndex("datatype");
        rowX.set(datatypeIndex, (Object)"cal_balance");
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        Long costaccountId = rowX.getLong(costaccountIndex);
        Long currencyId = this.costAccountCurrencyMap.get(costaccountId);
        int currencyIndex = this.rowMeta.getFieldIndex("currency");
        if (currencyId != null) {
            rowX.set(currencyIndex, (Object)currencyId);
        } else {
            currencyId = this.reportParam.getLocalcurrency().getLong("id");
            rowX.set(currencyIndex, (Object)currencyId);
        }
        int amtprecisionIndex = this.rowMeta.getFieldIndex("amtprecision");
        Integer amtprecision = this.currencyAmtprecisionMap.get(currencyId);
        if (amtprecision != null) {
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        } else {
            amtprecision = this.reportParam.getAmountPrecision();
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        }
        return rowX;
    }
}

