/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportUtil;

public class CalInitBillFieldMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<Long, Boolean> containDiffermap;
    private Map<Long, Long> costAccountCurrencyMap;
    private StockAgeReportBplatParam reportParam;
    private Map<Long, Integer> currencyAmtprecisionMap;

    public CalInitBillFieldMapFunction(RowMeta rowMeta, StockAgeReportBplatParam reportParam) {
        this.rowMeta = rowMeta;
        this.containDiffermap = reportParam.getContainDiffermap();
        this.costAccountCurrencyMap = reportParam.getCostAccountCurrencyMap();
        this.reportParam = reportParam;
        this.currencyAmtprecisionMap = reportParam.getCurrencyAmtprecisionMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        StockAgeReportUtil.setNoUpdateCalFields(this.rowMeta, rowX);
        int calorgIndex = this.rowMeta.getFieldIndex("calorg");
        Long calorgId = rowX.getLong(calorgIndex);
        boolean isContainDiffer = false;
        if (this.containDiffermap.containsKey(calorgId)) {
            isContainDiffer = this.containDiffermap.get(calorgId);
        }
        int accounttypeIndex = this.rowMeta.getFieldIndex("accounttype");
        String accounttype = rowX.getString(accounttypeIndex);
        int actualqtyIndex = this.rowMeta.getFieldIndex("actualqty");
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        BigDecimal baseqty = rowX.getBigDecimal(baseqtyIndex);
        if (!"D".equals(accounttype)) {
            rowX.set(actualqtyIndex, (Object)baseqty);
        } else {
            rowX.set(actualqtyIndex, (Object)BigDecimal.ZERO);
        }
        int amountIndex = this.rowMeta.getFieldIndex("standardcost");
        BigDecimal amount = rowX.getBigDecimal(amountIndex);
        int costdiffIndex = this.rowMeta.getFieldIndex("periodendcostdiff");
        BigDecimal costdiff = rowX.getBigDecimal(costdiffIndex);
        int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
        int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
        if (isContainDiffer) {
            if ("D".equals(accounttype)) {
                rowX.set(standardamountIndex, (Object)amount.add(costdiff));
                rowX.set(actualamountIndex, (Object)BigDecimal.ZERO);
            } else {
                rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
                rowX.set(actualamountIndex, (Object)amount.add(costdiff));
            }
        } else if ("D".equals(accounttype)) {
            rowX.set(standardamountIndex, (Object)amount);
            rowX.set(actualamountIndex, (Object)BigDecimal.ZERO);
        } else {
            rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
            rowX.set(actualamountIndex, (Object)amount);
        }
        int standardbaseqtyIndex = this.rowMeta.getFieldIndex("standardbaseqty");
        if ("D".equals(accounttype)) {
            rowX.set(standardbaseqtyIndex, (Object)baseqty);
        } else {
            rowX.set(standardbaseqtyIndex, (Object)BigDecimal.ZERO);
        }
        int unionflagIndex = this.rowMeta.getFieldIndex("unionflag");
        rowX.set(unionflagIndex, (Object)0);
        int datatypeIndex = this.rowMeta.getFieldIndex("datatype");
        rowX.set(datatypeIndex, (Object)"cal_initbill");
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        Long costaccountId = rowX.getLong(costaccountIndex);
        Long currencyId = this.costAccountCurrencyMap.get(costaccountId);
        int currencyIndex = this.rowMeta.getFieldIndex("currency");
        if (currencyId != null) {
            rowX.set(currencyIndex, (Object)currencyId);
        } else {
            currencyId = this.reportParam.getLocalcurrency().getLong("id");
            rowX.set(currencyIndex, (Object)currencyId);
        }
        int amtprecisionIndex = this.rowMeta.getFieldIndex("amtprecision");
        Integer amtprecision = this.currencyAmtprecisionMap.get(currencyId);
        if (amtprecision != null) {
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        } else {
            amtprecision = this.reportParam.getAmountPrecision();
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        }
        return rowX;
    }
}

