/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class CalrangeAmountMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public CalrangeAmountMapFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        BigDecimal baseqty = rowX.getBigDecimal(baseqtyIndex);
        int actualpriceIndex = this.rowMeta.getFieldIndex("actualprice");
        BigDecimal actualprice = rowX.getBigDecimal(actualpriceIndex);
        int calrangeamountIndex = this.rowMeta.getFieldIndex("calrangeamount");
        int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
        int amtprecisionIndex = this.rowMeta.getFieldIndex("amtprecision");
        int amtprecision = rowX.getInteger(amtprecisionIndex);
        BigDecimal mount = baseqty.multiply(actualprice).setScale(amtprecision, RoundingMode.HALF_UP);
        rowX.set(calrangeamountIndex, (Object)mount);
        rowX.set(actualamountIndex, (Object)mount);
        return rowX;
    }
}

