/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class CostAdjustBillFieldUnUnionMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<Long, Boolean> containDiffermap;
    private Map<Long, Long> costAccountCurrencyMap;
    private StockAgeReportBplatParam reportParam;
    private Map<Long, Integer> currencyAmtprecisionMap;

    public CostAdjustBillFieldUnUnionMapFunction(RowMeta rowMeta, StockAgeReportBplatParam reportParam) {
        this.rowMeta = rowMeta;
        this.containDiffermap = reportParam.getContainDiffermap();
        this.costAccountCurrencyMap = reportParam.getCostAccountCurrencyMap();
        this.reportParam = reportParam;
        this.currencyAmtprecisionMap = reportParam.getCurrencyAmtprecisionMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int calorgIndex = this.rowMeta.getFieldIndex("calorg");
        Long calorgId = rowX.getLong(calorgIndex);
        boolean isContainDiffer = false;
        if (this.containDiffermap.containsKey(calorgId)) {
            isContainDiffer = this.containDiffermap.get(calorgId);
        }
        int biztypeIndex = this.rowMeta.getFieldIndex("biztypestr");
        String biztype = rowX.getString(biztypeIndex);
        int difftypeIndex = this.rowMeta.getFieldIndex("difftype");
        String difftype = rowX.getString(difftypeIndex);
        int accounttypeIndex = this.rowMeta.getFieldIndex("accounttype");
        String accounttype = rowX.getString(accounttypeIndex);
        int createtypeIndex = this.rowMeta.getFieldIndex("createtype");
        String createtype = rowX.getString(createtypeIndex);
        int adjustamtIndex = this.rowMeta.getFieldIndex("adjustamt");
        BigDecimal adjustamt = rowX.getBigDecimal(adjustamtIndex);
        int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
        if (isContainDiffer) {
            if ("A".equals(biztype) && !"B".equals(difftype) && !"C1".equals(createtype) && "D".equals(accounttype)) {
                rowX.set(standardamountIndex, (Object)adjustamt);
            } else if ("B".equals(biztype) && !"B".equals(difftype) && !"C1".equals(createtype) && "D".equals(accounttype)) {
                rowX.set(standardamountIndex, (Object)adjustamt.negate());
            } else {
                rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
            }
        } else {
            rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
        }
        int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
        if ("A".equals(biztype) && !"M".equals(difftype) && !"C1".equals(createtype) && !"D".equals(accounttype)) {
            rowX.set(actualamountIndex, (Object)adjustamt);
        } else if ("B".equals(biztype) && !"M".equals(difftype) && !"C1".equals(createtype) && !"D".equals(accounttype)) {
            rowX.set(actualamountIndex, (Object)adjustamt.negate());
        } else {
            rowX.set(actualamountIndex, (Object)BigDecimal.ZERO);
        }
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        rowX.set(baseqtyIndex, (Object)BigDecimal.ZERO);
        int unionflagIndex = this.rowMeta.getFieldIndex("unionflag");
        rowX.set(unionflagIndex, (Object)0);
        int datatypeIndex = this.rowMeta.getFieldIndex("datatype");
        rowX.set(datatypeIndex, (Object)"cal_costadjustbill");
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        Long costaccountId = rowX.getLong(costaccountIndex);
        Long currencyId = this.costAccountCurrencyMap.get(costaccountId);
        int currencyIndex = this.rowMeta.getFieldIndex("currency");
        if (currencyId != null) {
            rowX.set(currencyIndex, (Object)currencyId);
        } else {
            currencyId = this.reportParam.getLocalcurrency().getLong("id");
            rowX.set(currencyIndex, (Object)currencyId);
        }
        int amtprecisionIndex = this.rowMeta.getFieldIndex("amtprecision");
        Integer amtprecision = this.currencyAmtprecisionMap.get(currencyId);
        if (amtprecision != null) {
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        } else {
            amtprecision = this.reportParam.getAmountPrecision();
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        }
        return rowX;
    }
}

