/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class CostInfoGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public CostInfoGroupReduceFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        HashMap<String, RowX> resultRowMap = new HashMap<String, RowX>();
        for (RowX rowX : rows) {
            int storageorgunitIndex = this.rowMeta.getFieldIndex("storageorgunit");
            Long storageorgunit = rowX.getLong(storageorgunitIndex);
            int materialIndex = this.rowMeta.getFieldIndex("material");
            Long materialId = rowX.getLong(materialIndex);
            int effectdateIndex = this.rowMeta.getFieldIndex("effectdate");
            Date effectdate = rowX.getDate(effectdateIndex);
            String key = storageorgunit + "_" + materialId;
            RowX result = (RowX)resultRowMap.get(key);
            if (null == result) {
                resultRowMap.put(key, rowX);
                continue;
            }
            int effectdateIndext = this.rowMeta.getFieldIndex("effectdate");
            Date effectdatet = result.getDate(effectdateIndext);
            if (effectdate.getTime() < effectdatet.getTime()) continue;
            resultRowMap.put(key, rowX);
        }
        for (Map.Entry mapEntry : resultRowMap.entrySet()) {
            out.collect((RowX)mapEntry.getValue());
        }
    }
}

