/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;

public class DealTranBillSrcTgtReduceGroupFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private RowMeta resultMeta;

    public DealTranBillSrcTgtReduceGroupFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.resultMeta = this.buildResultMeta();
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowMeta resultRowMeta = this.getResultRowMeta();
        int transTypeIndex = resultRowMeta.getFieldIndex("transtype");
        int inGroupIndex = resultRowMeta.getFieldIndex("ingroup");
        int inWarehouseIndex = resultRowMeta.getFieldIndex("inwarehouse");
        int inLocationIndex = resultRowMeta.getFieldIndex("inlocation");
        int inOwnerIndex = resultRowMeta.getFieldIndex("inowner");
        int bizBillEntryidIndex = resultRowMeta.getFieldIndex("bizbillentryid");
        int materialIndex = resultRowMeta.getFieldIndex("material");
        int calBillTypeIndex = resultRowMeta.getFieldIndex("calbilltype");
        int billNoIndex = resultRowMeta.getFieldIndex("billno");
        int outGroupIndex = resultRowMeta.getFieldIndex("outgroup");
        int outWarehouseIndex = resultRowMeta.getFieldIndex("outwarehouse");
        int outLocationIndex = resultRowMeta.getFieldIndex("outlocation");
        int outOwnerIndex = resultRowMeta.getFieldIndex("outowner");
        int outCostAcctIndex = resultRowMeta.getFieldIndex("outcostaccount");
        int outcalrangeIndex = resultRowMeta.getFieldIndex("outcalrange");
        Iterator<RowX> iter = iterable.iterator();
        HashMap<Long, RowX> inBizBillEntryIdRowMap = new HashMap<Long, RowX>(16);
        HashMap<Long, RowX> outBizBillEntryIdSrcRowMap = new HashMap<Long, RowX>(16);
        HashMap<Long, RowX> outSrcBizBillEntryIdSrcRowMap = new HashMap<Long, RowX>(16);
        while (iter.hasNext()) {
            RowX srcRow = iter.next();
            String calBillType = srcRow.getString(this.rowMeta.getFieldIndex("calbilltype"));
            boolean isInCalBill = "IN".equals(calBillType);
            Long bizBillEntryId = srcRow.getLong(this.rowMeta.getFieldIndex("bizbillentryid"));
            Long srcBizBillEntryId = srcRow.getLong(this.rowMeta.getFieldIndex("srcbizbillentryid"));
            if (isInCalBill) {
                inBizBillEntryIdRowMap.put(bizBillEntryId, srcRow);
                continue;
            }
            outBizBillEntryIdSrcRowMap.put(bizBillEntryId, srcRow);
            outSrcBizBillEntryIdSrcRowMap.put(srcBizBillEntryId, srcRow);
        }
        for (Map.Entry entry : inBizBillEntryIdRowMap.entrySet()) {
            String transType;
            Object[] newRow;
            Long inBizBillEntryId = (Long)entry.getKey();
            RowX tgtInRow = (RowX)entry.getValue();
            RowX srcOutRow = (RowX)outBizBillEntryIdSrcRowMap.get(inBizBillEntryId);
            if (srcOutRow == null) {
                Long srcBizBillEntryId = tgtInRow.getLong(this.rowMeta.getFieldIndex("srcbizbillentryid"));
                srcOutRow = (RowX)outSrcBizBillEntryIdSrcRowMap.get(srcBizBillEntryId);
            } else {
                newRow = new Object[resultRowMeta.getFieldCount()];
                newRow[transTypeIndex] = srcOutRow.getString(this.rowMeta.getFieldIndex("transtype"));
                newRow[inGroupIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("warehousegroup"));
                newRow[inWarehouseIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("warehouse"));
                newRow[inLocationIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("location"));
                newRow[inOwnerIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("owner"));
                newRow[bizBillEntryidIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("bizbillentryid"));
                newRow[materialIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("material"));
                newRow[calBillTypeIndex] = srcOutRow.getString(this.rowMeta.getFieldIndex("calbilltype"));
                newRow[billNoIndex] = srcOutRow.getString(this.rowMeta.getFieldIndex("billno"));
                newRow[outGroupIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("warehousegroup"));
                newRow[outWarehouseIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("warehouse"));
                newRow[outLocationIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("location"));
                newRow[outOwnerIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("owner"));
                newRow[outCostAcctIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("costaccount"));
                newRow[outcalrangeIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("calrange"));
                transType = (String)newRow[resultRowMeta.getFieldIndex("transtype")];
                if (StringUtils.isNotEmpty((CharSequence)transType)) {
                    collector.collect(new RowX(newRow));
                }
            }
            newRow = new Object[resultRowMeta.getFieldCount()];
            if (srcOutRow != null) {
                newRow[transTypeIndex] = tgtInRow.getString(this.rowMeta.getFieldIndex("transtype"));
                newRow[inGroupIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("warehousegroup"));
                newRow[inWarehouseIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("warehouse"));
                newRow[inLocationIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("location"));
                newRow[inOwnerIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("owner"));
                newRow[bizBillEntryidIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("bizbillentryid"));
                newRow[materialIndex] = tgtInRow.getLong(this.rowMeta.getFieldIndex("material"));
                newRow[calBillTypeIndex] = tgtInRow.getString(this.rowMeta.getFieldIndex("calbilltype"));
                newRow[billNoIndex] = tgtInRow.getString(this.rowMeta.getFieldIndex("billno"));
                newRow[outGroupIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("warehousegroup"));
                newRow[outWarehouseIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("warehouse"));
                newRow[outLocationIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("location"));
                newRow[outOwnerIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("owner"));
                newRow[outCostAcctIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("costaccount"));
                newRow[outcalrangeIndex] = srcOutRow.getLong(this.rowMeta.getFieldIndex("calrange"));
            }
            if (!StringUtils.isNotEmpty((CharSequence)(transType = (String)newRow[resultRowMeta.getFieldIndex("transtype")]))) continue;
            collector.collect(new RowX(newRow));
        }
    }

    private RowMeta buildResultMeta() {
        Field[] fields = new Field[]{new Field("transtype", (DataType)DataType.StringType), new Field("ingroup", (DataType)DataType.LongType), new Field("outgroup", (DataType)DataType.LongType), new Field("inwarehouse", (DataType)DataType.LongType), new Field("outwarehouse", (DataType)DataType.LongType), new Field("inlocation", (DataType)DataType.LongType), new Field("outlocation", (DataType)DataType.LongType), new Field("inowner", (DataType)DataType.LongType), new Field("outowner", (DataType)DataType.LongType), new Field("outcostaccount", (DataType)DataType.LongType), new Field("outcalrange", (DataType)DataType.LongType), new Field("bizbillentryid", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("calbilltype", (DataType)DataType.StringType), new Field("billno", (DataType)DataType.StringType)};
        return new RowMeta(fields);
    }
}

