/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class HasRangePrefixFieldMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public HasRangePrefixFieldMapFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int rangeflagIndex = this.rowMeta.getFieldIndex("rangeflag");
        Integer rangeflag = rowX.getInteger(rangeflagIndex);
        if (rangeflag != null) {
            String prefixField = "range" + rangeflag;
            int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
            int rangeqtyIndex = this.rowMeta.getFieldIndex(prefixField + "qty");
            int rangestandardamountIndex = this.rowMeta.getFieldIndex(prefixField + "standardamount");
            int rangeactualamountIndex = this.rowMeta.getFieldIndex(prefixField + "actualamount");
            BigDecimal baseqty = rowX.getBigDecimal(baseqtyIndex);
            int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
            BigDecimal standardamount = rowX.getBigDecimal(standardamountIndex);
            int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
            BigDecimal actualamount = rowX.getBigDecimal(actualamountIndex);
            rowX.set(rangeqtyIndex, (Object)baseqty);
            rowX.set(rangestandardamountIndex, (Object)standardamount);
            rowX.set(rangeactualamountIndex, (Object)actualamount);
        }
        return rowX;
    }
}

