/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class LastShowQtyAmountMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<Long, Long> costAccountCurrencyMap;
    private StockAgeReportBplatParam reportParam;
    private Map<Long, Integer> currencyAmtprecisionMap;

    public LastShowQtyAmountMapFunction(RowMeta rowMeta, StockAgeReportBplatParam reportParam) {
        this.rowMeta = rowMeta;
        this.costAccountCurrencyMap = reportParam.getCostAccountCurrencyMap();
        this.reportParam = reportParam;
        this.currencyAmtprecisionMap = reportParam.getCurrencyAmtprecisionMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        rowX.set(baseqtyIndex, (Object)BigDecimal.ZERO);
        int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
        rowX.set(actualamountIndex, (Object)BigDecimal.ZERO);
        int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
        rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
        int lastshowIndex = this.rowMeta.getFieldIndex("lastshow");
        rowX.set(lastshowIndex, (Object)1);
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        Long costaccountId = rowX.getLong(costaccountIndex);
        Long currencyId = this.costAccountCurrencyMap.get(costaccountId);
        int currencyIndex = this.rowMeta.getFieldIndex("currency");
        if (currencyId != null) {
            rowX.set(currencyIndex, (Object)currencyId);
        } else {
            currencyId = this.reportParam.getLocalcurrency().getLong("id");
            rowX.set(currencyIndex, (Object)currencyId);
        }
        int amtprecisionIndex = this.rowMeta.getFieldIndex("amtprecision");
        Integer amtprecision = this.currencyAmtprecisionMap.get(currencyId);
        if (amtprecision != null) {
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        } else {
            amtprecision = this.reportParam.getAmountPrecision();
            rowX.set(amtprecisionIndex, (Object)amtprecision);
        }
        return rowX;
    }
}

